/***************************************************************************
                          cuyo.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* 1 bedeutet, dass manche Signale abgefangen werden, um die Log-Datei
   abzuspeichern. */
#define signale_fangen 0



#include <cstdlib>
#include <cstdio>

#if signale_fangen
#include <csignal>
#endif

#include <SDL.h>

#include "cuyointl.h"
#include "sound.h"
#include "aufnahme.h"
#include "prefsdaten.h"
#include "kiplayer.h"
#include "spielfeld.h"
#include "fehler.h"
#include "global.h"

#include "ui.h"

#include "ui2cuyo.h"
#include "cuyo.h"

/* # Zeitschritte, die nach der Zeitbonus-Animation noch gewartet wird */
#define nachbonus_wartezeit 50




namespace Cuyo {

/*************************** Private Variablen **************************/
/* (stehen nicht in der .h-Datei) */

/***** Debug-Variablen *****/
/* Es gibt auerdem noch die globale Variable gDebug; */
bool mEinzelschritt;
bool mZeitlupe;
int mZaehlerZeitlupe;
bool mRueberReihenTest;
bool mAbspielen;
bool mSchnellvorlauf;



/** Das Bild, das angezeigt wird, whrend das Spiel auf Pause steht. */
Bilddatei * mPauseBild;


/** Die beiden Spielfelder... */
Spielfeld* mSpielfeld[max_spielerzahl];

/** Computer-Spieler. */
KIPlayer * mKI;



/***** Zustandsvariablen *****/

/** global-Modus (Spielerbergreifend). */
enum global_modus {
  gmodus_kein_spiel,
  gmodus_spiel_start, // wie gmodus_spiel, aber Text muss noch gelscht werden
  gmodus_spiel,
  /* die folgenden beiden Modi bedeuten beide, dass das 
     Spiel (der Level) zu Ende geht, aber dass wir noch warten, bis
     die letzten Animationen fertig abgelaufen sind */
  gmodus_warte_verloren,   // ... weil ein Spieler tot ist
  gmodus_warte_gewonnen, // ... weil der Level fertig ist
  gmodus_bonus_animation, // Zeit-Bonus bekommen...
  gmodus_bonus_warte, 	  // Nach dem Zeit-Bonus noch ein bisschen warten
  gmodus_ende_warte  // Kurz vor gmodus_kein_spiel: Benutzer darf noch
              // seine Punkte bewundern. Wenn er eine Taste drueckt, geht's
	      // Zurueck ins Menue.
} mGModus;


/** True, wenn das Spiel auf Pause steht */
bool mPause;


/** true, wenn das Spiel grad nicht weitergehen soll, sondern auf einen
    Tastendruck gewartet wird. */
bool mWarteAufTaste;
/* Wenn > 0, wird hchstens so lange auf Taste gewartet */
int mWarteTimeout;

/** Hier wird reingespeichert,
    welche Version (zuletzt) auf der Kommandozeile stand.
    Achtung! Das passiert schon vor Cuyo::init(), also vor der
    Lebenszeit von Cuyo, wenn Cuyo eine htte. */
Version mKommandoZeilenVersion;

/** Die Versionen, die ber die Kommandozeile bergeben wurden,
    und die wir nicht anders verwalten. */
Version mZusatzVersionen;
Str mSprache;
int mSchwierig;
int mLevelpack;
/** Ein oder zwei Spieler? (Hat auch beim Spielen gegen die KI den Wert 2,
    und *nicht* spz_ki) */
int mSpielerZahl;
/** Falls zwei Spieler: Gegen Computer? */
bool mGegenKI;

/** Aktuelle Level-Nummer; enthlt, wenn grade kein Spiel luft, die Nummer
    vom Level zum weiterspielen. Ist (wenn kein Spiel luft) 0, wenn es
    keine vorige Level-Nummer gibt */
int mLevelNr;
/** (Interner) Name des aktuellen Levels. Enthlt, wenn grade kein Spiel
    luft, den Namen vom Level zum weiterspielen. Ist (wenn kein Spiel
    luft) "", wenn es keine vorige Level-Nummer gibt*/
//Str mIntLevelName;
int mPunkte[max_spielerzahl];
/** Wird nur whrend der Zeitbonus-Animation gebraucht... */
int mZeitBonus;




/*************************** Private Methoden **************************/
/* (stehen nicht in der .h-Datei) */


/** tut alles, was beim Starten eines Levels
    getan werden muss; liefert false, wenn es
    den Level gar nicht mehr gibt. Throwt bei Fehler. */
bool startLevel();
/** tut alles, was beim Stoppen eines Levels
    getan werden muss (ohne Animation, d. h. entweder
    ist die Animation schon vorbei oder es gibt halt keine). */
void stopLevel();
/** Setzt die Punktzahl fr Spieler sp */
void setPunkte(int sp, int pu);
/** Gibt die Fehlermeldung bestehend aus t und fe aus:
    Sowohl als Text im Cuyo-Fenster
    (bei anz_sp vielen Spielern) als auch auf stderr. 
    mitLog wird an fe.getText() weitergegeben. (D. h.: soll
    ggf. die Send-Log-Meldung ausgegeben werden?) */
void printFehler(int anz_sp, Str t, const Fehler & fe,
                       bool mitLog = false);


/** Macht einen Schritt der Hetzrand-kommt-am-Ende-runter-Animation. */
void bonusAnimationSchritt();
/** Unterfunktion von zeitSchritt();
    Hier passiert die eigentliche Arbeit. */
void zeitSchrittIntern();

/** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
void stopSpiel(bool noch_anzeigen = false);
/** Die Haupt-Spielschritt-Routine, whrend das Spiel luft.
    Ruft alle anderen spielschritt()-Routinen auf. */
void spielSchritt();
/** Wird von startLevel() und von spielSchritt() aufgerufen. Lsst
    smtliche Blops animieren. */
void animiere();

Version berechneVersion();

/* bernimmt die Dinge, die durch version spezifiziert werden.
   Alles andere bleibt beim alten,
   bis auf da der alte Wert von mZusatzVersionen verlorengeht.  */
void setzeVersion(const Version & version);



/** Liefert den Namen und Pfad der Prefs-Datei zurck
    ($HOME/.cuyo) */
Str getPrefsName();
/** Liefert den Namen und Pfad der Log-Datei zurck
    ($HOME/cuyo.log) */
Str getLogName();


void signaleAn();
void signaleAus();



/** Startet das Spiel fr die eingestellte Spielerzahl und mit dem
    angegebenen Level */
void startSpiel(int level) {
  CASSERT(mGModus == gmodus_kein_spiel);

  ld->ladLevelConf(ldteil_summary,false,berechneVersion());

  mLevelNr = level;

  /* Damit der Level nicht schon beim Start angehalten ist oder schnell
     luft */
  mEinzelschritt = false;
  mSchnellvorlauf = false;

  for (int i = 0; i < max_spielerzahl; i++)
    setPunkte(i, 0);

  try {
    if (!startLevel())
      throw Fehler(_("There are no (more?) (working?) levels."));

  } catch (Fehler f) {
    fprintf(stderr, "%s\n", f.getText().data());
    for (int i = 0; i < mSpielerZahl; i++)	
      mSpielfeld[i]->setText(f.getText(), true);

    /* Sicherheitshalber...: */
    stopSpiel();

    return;
  }
}




/** tut alles, was beim Starten eines Levels
    getan werden muss; liefert false, wenn es
    den Level gar nicht mehr gibt. Throwt bei Fehler. */
bool startLevel() {

  /* So viele Level gibt's doch gar nicht */
  if (mLevelNr > ld->getLevelAnz())
    return false;

  /* Fr "Loading level" */
  ld->setSchriftFarbe(Color(80, 80, 80));

  /* Level-Daten laden */
  for (int i = 0; i < mSpielerZahl; i++) {
    mSpielfeld[i]->ladeLevelModus();
    mSpielfeld[i]->setText(_sprintf(_("Score: %d\n\nLoading Level %d...\n\n"),
	      mPunkte[i], mLevelNr));
  }
  /* "Loading Level" gleich anzeigen: */
  UI::sofortAllesAnzeigen();

  ld->ladLevel(mLevelNr);
  
  for (int i = 0; i < max_spielerzahl; i++) {
    /* Punkte-Anzeige muss geupdatet werden: Zu Level passende Farbe.
       (Etwas gepfuscht) */
    setPunkte(i, mPunkte[i]);
  }
	
  /* Aufnehmen / Abspielen starten */
  Aufnahme::init(mAbspielen, getSpielerModus());

  /***** Allen Leuten erzhlen, dass jetzt ein Level anfngt. *****/
  
  /* Fr den Global-Blop... */
  ld->startLevel();

  /* Hier ist die Stelle, wo wir darauf gucken, wie viele Spieler mitspielen;
     nur fr so viele Spieler wird das Spiel wirklich gestartet */
  for (int i = 0; i < mSpielerZahl; i++) {

    mSpielfeld[i]->startLevel();
    Str PlatzAnzahlFormat;
    if (ld->mPlatzAnzahlMin == ld->mPlatzAnzahlMax)
      if (ld->mPlatzAnzahlMin == 1)
        PlatzAnzahlFormat=_sprintf(_("1 blop explodes"));
      else
        PlatzAnzahlFormat=_sprintf(_("%d blops explode"),ld->mPlatzAnzahlMin);
    else
      if (ld->mPlatzAnzahlAndere)
	PlatzAnzahlFormat=_sprintf(_("between %d and %d blops explode"),
				  ld->mPlatzAnzahlMin,ld->mPlatzAnzahlMax);
      else
	PlatzAnzahlFormat=_sprintf(_("%d or %d blops explode"),
				  ld->mPlatzAnzahlMin,ld->mPlatzAnzahlMax);
    mSpielfeld[i]->setText(_sprintf(_("Score: %d\n\n"
                "Level %d\n%s\nby %s\n\n"
                "%s\n%s\n"
		"%s\n\n"
		"Space = Start"),
	    mPunkte[i],
	    mLevelNr, ld->mLevelName.data(), ld->mLevelAutor.data(),
	    PlatzAnzahlFormat.data(),
	    ld->mGrasBeiKettenreaktion ? "Chain reaction necessary\n" : "",
	    ld->mBeschreibung.data()));
  }
  
  /* Alle Blops einmal animieren, damit sie wissen, wie sie aussehen.
     Dabei werden auch die ganzen Init-Events verschickt. */
  animiere();

  /* Auch die KI mchte wissen, wenn ein neuer Level anfngt. */
  if (mGegenKI)
    mKI->startLevel();


  Sound::setMusic(ld->mMusik);
	
  mGModus = gmodus_spiel_start;
  mPause = false;
  mWarteAufTaste = true;
  mWarteTimeout = 0;
  return true;
}



/** tut alles, was beim Stoppen eines Levels
    getan werden muss (ohne Animation, d. h. entweder
    ist die Animation schon vorbei oder es gibt halt keine). */
void stopLevel() {
			
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->stopLevel();
}




/** Setzt die Punktzahl fr Spieler sp */
void setPunkte(int sp, int pu){
  mPunkte[sp] = pu;
  UI::setPunkte(sp, pu);
}












/** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
void stopSpiel(bool noch_anzeigen/* = false*/) {
  /* Evtl. wird stopSpiel() aufgerufen, wenn das Spiel noch gar nicht
     richtig fertig gestartet wurde; dann wurde mGModus vielleicht noch
     nicht gesetzt, aber es soll trotzdem was gestoppt werden... */
  /*if (mGModus == gmodus_kein_spiel)
    return;*/

  stopLevel();

  if (noch_anzeigen) {
    mGModus = gmodus_ende_warte;
    mWarteAufTaste = true;
  } else {
    mGModus = gmodus_kein_spiel;
    UI::stopSpiel();
  }
}










/** Die Haupt-Spielschritt-Routine, whrend das Spiel luft.
    Ruft alle anderen spielschritt()-Routinen auf. */
void spielSchritt() {

  /* Den Schritt aufnehmen bzw. abspielen. Beim Abspielen werden
     hier auch ggf. Tastendrcke abgespielt. */
  Aufnahme::recSchritt(mSpielfeld);

  /*** Die einzelnen Teile eines Spielschritts ausfhren: ***/

  /* Who will be the one killing me for this #define? */
  /* Answer: The first one to try
       for (int i=1; i<=10; i++)
         ALLE_SPIELER->do_stuff(i);
  */
#define ALLE_SPIELER for (int i = 0; i < mSpielerZahl; i++) mSpielfeld[i]

  //fprintf(stderr, "A\n");

  /* ggf. Message blinken lassen */
  ALLE_SPIELER->blinkeMessage();

  /* Hetzrand runterbewegen; evtl. sterben */
  ALLE_SPIELER->bewegeHetzrand();

  /* Evtl. zufllige Graue an die Spieler senden. (Blops werden nicht
     erzeugt; es wird nur gespeichert, dass das noch Graue auf das
     ankommen warten. */
  ALLE_SPIELER->zufallsGraue();

  Blop::beginGleichzeitig();
  ALLE_SPIELER->fallSchritt();
  Blop::endGleichzeitig();

  /* Reihen hin/her. (In einer Gleichzeit, fr evtl. auftretende events.) */
  Blop::beginGleichzeitig();
  ALLE_SPIELER->rueberReihenSchritt();
  Blop::endGleichzeitig();

  /* Neue explosionen testen. Da inzwischen vielleicht neue Blops
     entstanden sind und alle einen event bekommen, erst mal fehlende
     init-Events senden. Sollte in Zukunft automatisch am Anfang
     jeder Gleichzeit passieren. */
  Blop::sendeFehlendeInitEvents();
  Blop::beginGleichzeitig();
  ALLE_SPIELER->testeFlopp();
  Blop::endGleichzeitig();

  //fprintf(stderr, "B\n");

  /* Rest vom normalen Spielschritt */
  Blop::beginGleichzeitig();
  ALLE_SPIELER->spielSchritt();
  Blop::endGleichzeitig();

  //fprintf(stderr, "C\n");

#undef ALLE_SPIELER

  /* Animationen und Grafik-Ausgabe */
  animiere();



  /* Ggf. auch einen Spielschritt fr die KI */
  if (mGegenKI)
    mKI->spielSchritt();



  if (mGModus == gmodus_spiel) {
    /* Nur wenn das Spiel wirklich noch luft (und nicht nur darauf gewartet
       wird, das wir beenden knnen: Testen, ob wir gewonnen haben */

    /* Wurde grade das restliche Gras vernichtet? */
    for (int i = 0; i < mSpielerZahl; i++)
      if (mSpielfeld[i]->istGrasDa())
        goto noch_gras_da;
      
    /* Dann warten wir jetzt nur noch auf einen guten Moment zum beenden. */
    mGModus = gmodus_warte_gewonnen;
      
noch_gras_da:;
  } else {
    /* Nur wenn das Spiel kurz davor ist, beendet zu werden:
       Checken, obs jetzt wirklich beendet werden kann. */
    
    CASSERT(mGModus == gmodus_warte_gewonnen ||
            mGModus == gmodus_warte_verloren);
    /* Spiel (Level) soll beendet werden; aber sind auch beide
       Spieler bereit? */
			
    bool bereit = true;
    for (int i = 0; i < mSpielerZahl; i++)
      if (!mSpielfeld[i]->bereitZumStoppen())
	bereit = false;

    if (bereit) {
      /* OK, alle bereit. */
			
      /* Gewonnen oder verloren? */
      if (mGModus == gmodus_warte_gewonnen) {

        Sound::playSample(sample_levelwin,so_global);
				
	/* Hier darf noch nicht stopLevel() aufgerufen werden, weil sonst
	   das Spielfeld nicht mehr angezeigt wird */
	
	/* Gewonnen. Level als gewonnen abspeichern. Aber nicht im
	   Debug-Modus. */
	if (!gDebug)
	  PrefsDaten::schreibGewonnenenLevel(mSpielerZahl > 1, mLevelNr);
				
	/* Jetzt kommt die Zeitbonus-Animation */
	mGModus = gmodus_bonus_animation;
				
	/* Noch keine Bonus-Punkte */
	mZeitBonus = 0;
      } else {
        Sound::playSample(sample_levelloose, so_global);

	/* Spiel zu Ende weil verloren */
	stopSpiel(true);
				
	for (int i = 0; i < mSpielerZahl; i++)
	  mSpielfeld[i]->setText(_sprintf(
            _("Game over\n\nScore: %d\n\n"), mPunkte[i]));
      }
					
    }	// Ende: if bereit
  } // Ende: if warten, bis alle fr's Spielende bereit sind


}  // spielSchritt()




/** Macht einen Schritt der Hetzrand-kommt-am-Ende-runter-Animation. */
void bonusAnimationSchritt() {
  /* Hetzrand runterrutschen lassen */
  bool ba_fertig = true; // "= true" nur um eine Warnung zu ersparen

  mZeitBonus += punkte_fuer_zeitbonus;

  for (int i = 0; i < mSpielerZahl; i++) {

    /* Neuen Text (mit neuer Punkt-Zahl) schreiben */
    mSpielfeld[i]->setText(_sprintf(
              _("Level %s complete!\n\nTime Bonus: %d\nScore: %d\n\n "),
	      ld->mLevelName.data(), mZeitBonus, mPunkte[i]));

    /* Rand runterrutschen lassen */		
    ba_fertig = mSpielfeld[i]->bonusSchritt();

    /* Punkte bekommen */
    setPunkte(i, mPunkte[i] + punkte_fuer_zeitbonus);
  }

  /* Unten angekommen? (Sollte bei beiden Spielern gleichzeitig passieren) */
  if (ba_fertig) {
    mGModus = gmodus_bonus_warte;

    for (int i = 0; i < mSpielerZahl; i++) {
      mSpielfeld[i]->setText(_sprintf(
              _("Level %s complete!\n\nTime Bonus: %d\nScore: %d\n\nSpace = Continue"),
	      ld->mLevelName.data(), mZeitBonus, mPunkte[i]));
    }

    mWarteAufTaste = true;
    /* Kein Warte-Timeout mehr. Einfach Leertaste drcken */
    //mWarteTimeout = nachbonus_wartezeit;
  } // Ende: if Bonus-Animation fertig
}


/** Unterfunktion von zeitSchritt();
    Hier passiert die eigentliche Arbeit. */
void zeitSchrittIntern() {

  /* Whrend Pause luft das Spiel nicht weiter */
  if (mPause)
    return;
  
  /* Warten wir grad drauf, dass der Benutzer eine Taste drckt? */
  if (mWarteAufTaste) {

    if (mWarteTimeout) {
      /* Wir warten nicht beliebig lang */
      mWarteTimeout--;
      if (mWarteTimeout)
	return;
			
      /* Zu lange gewartet. Jetzt reicht's! */
      mWarteAufTaste = false;
    } else
      return;
  }
  
  /* Einzelschritt-Modus. Nach diesem Schritt gleich wieder auf
     Tastendruck warten. */
  if (mEinzelschritt) {
    mWarteAufTaste = true;
  }
  
  
  if (mGModus == gmodus_ende_warte) {
    /* Spieler hat sich seine Punkte (oder was auch immer sont)
       fertig angeschaut. Jetzt koennen wir zurueck ins Menue */
    mGModus = gmodus_kein_spiel;
    UI::stopSpiel();
    return;
  }

  if (mGModus == gmodus_bonus_warte) {
    /* Wir haben grade ein bisschen gewartet, damit der Benutzer seine
       Level-Endpunkte bewundern kann. Jetzt geht's weiter mit dem nchsten
       Level... */
			
    /* Alten Level stoppen (ist vermutlich nicht wirklich ntig) */
    stopLevel();
 		
    /* neuer Level */
    
    mLevelNr++;
    try {
      if (!startLevel()) {
        /* Es gibt gar keine Level mehr; also Spiel beenden */
        stopSpiel(true);
        for (int i = 0; i < mSpielerZahl; i++) {
          mSpielfeld[i]->setText(
            _sprintf(mSpielerZahl == 2 && mPunkte[i] > mPunkte[1-i] ? 
                _("***\nYou won even a bit more!!!\n\nScore: %d\n***\n\n") :
                _("***\nYou won!!!\n\nScore: %d\n***\n\n")  ,
	      mPunkte[i]));
        }
        mLevelNr = 0; // Jetzt kann man nicht mehr Restart last level
      }
    } catch (Fehler fe) {
      printFehler(mSpielerZahl, _("Could not start level:\n"), fe);
      stopSpiel();
    }
    return;
  } 	
	
  /* Spiel grade erst gestartet? Dann Texte lschen */
  if (mGModus == gmodus_spiel_start) {
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText("");
    mGModus = gmodus_spiel;
  }

  CASSERT(mGModus == gmodus_bonus_animation || mGModus == gmodus_spiel ||
          mGModus == gmodus_warte_gewonnen || mGModus == gmodus_warte_verloren);


  /* Ok, hier kommt der eigentliche Spielschritt... */
  if (mGModus == gmodus_bonus_animation) {
    /* ... Spielschritt Bonusanimation */
    bonusAnimationSchritt() ;

  } else {
    /* ... normaler Spielschritt */
    

    /* Evtl. Signale abfangen, um die Logdatei abspeichern zu knnen. */
    signaleAn();
    
    try {
      /* Hier findet das eigentliches Spiel statt */
      spielSchritt();
      
    } catch (Fehler fe) {
      signaleAus();
      bool log_gespeichert = false;

      try {
        Aufnahme::speichern(getLogName());
	log_gespeichert = true;
      } catch (Fehler) {}

      /* Im Debug-Modus soll das Spielfeld weiter angezeigt werden,
         wenn ein Fehler whrend des Spiels passiert. */
      stopSpiel(gDebug);
      
      /* Wenn das Speichern der log-Datei geklappt hat, soll ggf.
         die "send log to..."-Meldung ausgegeben werden. */
      printFehler(mSpielerZahl, _("Error during the game:\n"), fe,
                  log_gespeichert);
      return;
    }
    	      
    signaleAus();
  }



}


/** Wird von startLevel() und von zeitSchritt() aufgerufen. Lsst
    smtliche Blops animieren. */
void animiere() {

  /* Vielleicht htten gerne einige Blops noch ein Init-Event... */
  Blop::sendeFehlendeInitEvents();

  /* Erst mal das globale Blop ausfhren. */
  ld->spielSchritt();
  
  /* Jetzt alle anderen... in *einer* Gleichzeit */
  Blop::beginGleichzeitig();
  
  /* Alle Grafiken lschen */
  Blop::lazyInitStapel();
  
  /* Die eigentliche Animation */
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->animiere();
    
  Blop::endGleichzeitig();
}



/**  */
void neuePunkte(bool reSp, int pt){
  if (reSp) setPunkte(1, mPunkte[1] + pt);
  else setPunkte(0, mPunkte[0] + pt);
}



/** wird aufgerufen, wenn ein Spieler tot ist */
void spielerTot() {
  mGModus = gmodus_warte_verloren;
}





/* reSp sendet g Graue an den anderen Spieler */
void sendeGraue(bool reSp, int g) {
  mSpielfeld[!reSp]->empfangeGraue(g);
}


/** reSp bittet den anderen Spieler um eine Reihe. Er selbst
    hat Hhe h. Antwort ist eine der Konstanten bewege_reihe_xxx */
int bitteUmReihe(bool reSp, int h) {
  return mSpielfeld[!reSp]->bitteUmReihe(h);
}


/** reSp will einen Stein vom anderen Spieler (rberreihe) */
void willStein(bool reSp, Blop & s) {
  mSpielfeld[!reSp]->gebStein(s);
}





/** Liefert den Namen und Pfad der Log-Datei zurck
    ($HOME/cuyo.log) */
Str getLogName() {
  char * ho = getenv("HOME");
  if (!ho) {
    /* Unter Windows zum Beispiel... */
    fprintf(stderr, _("Warning: Env-Variable $HOME not found. Using the current cirectory for cuyo.log"));
    return "cuyo.log";
  }
  if (ho[strlen(ho) - 1] == '/')
    return Str(ho) + "cuyo.log";
  else
    return Str(ho) + "/cuyo.log";
}



/** Gibt die Fehlermeldung bestehend aus t und fe aus:
    Sowohl als Text im Cuyo-Fenster
    (bei anz_sp vielen Spielern) als auch auf stderr. 
    mitLog wird an fe.getText() weitergegeben. (D. h.: soll
    ggf. die Send-Log-Meldung ausgegeben werden?) */
void printFehler(int anz_sp, Str t, const Fehler & fe,
                       bool mitLog /*= false*/) {
  t += fe.getText(mitLog);
  fprintf(stderr, "%s\n", t.data());
  for (int i = 0; i < anz_sp; i++) {
    /* zweites true = Kleine Schrift... */
    mSpielfeld[i]->setText(t, true);
  }
}






#if signale_fangen

void signalHandler(int s) {
  try {
    Aufnahme::speichern(getLogName());
    /* send_log_string ist in fehler.h definiert. */
    fprintf(stderr, "%s\n", send_log_string);
  } catch (Fehler) {}
  
  /* Braucht man das? Geht das? */
  raise(s);
}


void signaleAn() {
  /*{
    struct sigaction act; 
    act.sa_handler = speicherFehler;
    act.sa_mask = 0;
    act.sa_flags = SA_ONESHOT;
    sigaction(SIGSEGV, &act, 0);
  }*/
  signal(SIGILL, signalHandler);  // illegal instruction
  signal(SIGSEGV, signalHandler); // segmentation fault
  signal(SIGFPE, signalHandler);  // floating point exception
}

void signaleAus() {
  signal(SIGILL, SIG_DFL);  // illegal instruction
  signal(SIGSEGV, SIG_DFL); // segmentation fault
  signal(SIGFPE, SIG_DFL);  // floating point exception
}

#else
void signaleAn() {
}

void signaleAus() {
}
#endif



/********************** public Methoden (fr das Spiel) **********************/
/* (stehen in cuyo.h) */









/** liefert true, wenn das Spiel normal luft, false
		wenn das Spiel am zuende gehen ist */
bool getSpielLaeuft() {
  CASSERT(mGModus != gmodus_kein_spiel);
  return mGModus == gmodus_spiel;
}


/** liefert true, wenn das Spiel gepaust ist. */
bool getSpielPause() {
  return mPause;
}


/** Liefert die Anzahl der Mitspieler zurck. */
int getSpielerZahl() {
  return mSpielerZahl;
}


/** Liefert das Pause-Bildchen zurck */
Bilddatei * getPauseBild() {
  return mPauseBild;
}


/** Liefert true, wenn debug-Rberreihen-Test aktiv ist */
bool getRueberReihenTest() {
  return mRueberReihenTest;
}


/** Liefert ein Spielfeld zurck. */
Spielfeld * getSpielfeld(bool reSp) {
  return mSpielfeld[reSp];
}




/*********************** public Methoden frs ui **************************/
/* (stehen in ui2cuyo.h) */


void init() {
  mEinzelschritt = false;
  mZeitlupe = false;
  mZaehlerZeitlupe = 0;
  mRueberReihenTest = 0;
  mAbspielen = 0;
  mSchnellvorlauf = 0;
  mPauseBild = 0;
  mZusatzVersionen = Version();
  mSprache = "";
  mSchwierig = Version::gSchwierig.suchMerkmal("");
  mSpielerZahl = 1;
  mLevelpack = Version::gLevelpack.suchMerkmal("main");
  CASSERT(mLevelpack>=0);

  /* Jetzt gehen auf der Kommandozeile spezifizierte Versionen ein. */
  setzeVersion(mKommandoZeilenVersion);
    
  /* Hier findet das parsen statt. (Fehler werden im try-catch-Block
     der main()-Routine ausgegeben.) Das LevelDaten-Objekt weist
     sich selber der globalen Variable ld zu. */
  new LevelDaten(berechneVersion());
  

  for (int i = 0; i < max_spielerzahl; i++) {
    /* Spielfeld erzeugen */
    mSpielfeld[i] = new Spielfeld(i > 0); // (i > 0) = rechter Spieler
  }

  /* Pause-Bild laden */
  mPauseBild = new Bilddatei();
  mPauseBild->laden("pause.xpm");

  /* KI-Spieler erzeugen */
  mKI = new KIPlayer(mSpielfeld[1]);

  setSpielerModus(1); // Sollte erst nach Erzeugen der Mens aufgerufen werden...

  /* Damit Weiterspielen grad nicht geht. */
  mLevelNr = 0;
		
  mGModus = gmodus_kein_spiel;
	
  mWarteAufTaste = false;
}

void destroy(){
  delete ld;
  delete mKI;
}



void setPause(bool pause) {
  mPause = pause;
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->setUpdateAlles();
  UI::nachEventAllesAnzeigen();
}


/** Ein key-Event halt... (Kmmert sich um alle Tasten,
    die whrend des Spiels so gedrckt werden...). */
void keyEvent(const SDL_keysym & taste) {

  if (mPause) {
    switch (taste.sym) {
      case SDLK_ESCAPE:
        stopSpiel();
        UI::nachEventAllesAnzeigen();
	break;
      case ' ':
      case SDLK_RETURN:
      case SDLK_KP_ENTER:
        setPause(false);
	break;
      default:
        break;
    }
    return;
  }


  if (taste.sym == SDLK_ESCAPE) {
    /* Auf Pause schalten */
    setPause(true);
    return;
  }

  if (mWarteAufTaste) {
    if (taste.sym == ' ' || taste.sym == SDLK_RETURN ||
        taste.sym == SDLK_KP_ENTER) {
      mWarteAufTaste = false;
      mWarteTimeout = 0;
      return;
    }
    
  } else if (mGModus == gmodus_spiel) {
    int sp, t;
    if (PrefsDaten::getTaste(taste.sym, sp, t)) {
      /* Im 1-Spieler-Modus und im KI-Modus alle Tastendrcke an
	 Spieler 1 senden: */
      if (mSpielerZahl == 1 || mGegenKI) sp = 0;

      Aufnahme::recTaste(sp, t);
      mSpielfeld[sp]->taste(t);
      return;
    }
  } // if spiel luft
  
  
  /* Event noch nicht verarbeitet. Dann vielleicht debug? */
}

  
/** Eine Taste wurde gedrueckt, von der das ui befunden hat, dass
    es sich um eine debug-Taste handeln koennte.
    Liefert false zurueck, wenn der Debug-Modus gar nicht aktiv ist. */
bool debugKeyEvent(const SDL_keysym & taste) {
  if (!gDebug)
    return false;

  char buch = taste.sym;
  if ((taste.mod & KMOD_SHIFT) && buch >= 'a' && buch <= 'z')
    buch = buch - 'a' + 'A';

  if (buch == 'b') {
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->empfangeGraue(1);
    fprintf(stderr, "Debug: Bekomme Graue\n");
    
  } else if (buch == 'e') {
    mEinzelschritt = !mEinzelschritt;
    fprintf(stderr, "Debug: Einzelschritt = %d\n", mEinzelschritt);
    if (!mEinzelschritt) {
      /* Nicht noch ein letztes Mal auf Taste warten... */
      mWarteAufTaste = false;
    }
    
  } else if (buch == 'L') {
    if (mGModus == gmodus_kein_spiel) {
      fprintf(stderr, "Debug: Logdatei laden\n");
      Aufnahme::laden(getLogName());
      setSpielerModus(Aufnahme::getSpielerModus());
      Str lna = Aufnahme::getLevelName();
      mLevelNr = ld->getLevelNr(lna);

      fprintf(stderr, "Level %s (%d)\n",
	      lna.data(), mLevelNr);
      fprintf(stderr, "Zum Abspielen im Hauptmenu r drcken.\n");
      mAbspielen = true;
    } else
      fprintf(stderr, "Debug: *Nicht* Logdatei laden whrend Spiel luft.\n");
    
  } else if (buch == 'l') {
    mAbspielen = !mAbspielen;
    fprintf(stderr, "Debug: Log abspielen = %d\n", mAbspielen);
    
  } else if (buch == 'g') {
    /* Hoffentlich darf man gModus einfach so ndern... */

    if (mGModus == gmodus_spiel) {
      mGModus = gmodus_warte_gewonnen;
      fprintf(stderr, "Debug: Gewinnen\n");
    }
    
  } else if (buch == 'h') {
    fprintf(stderr, "Debug: Hilfe (Alle Tasten mit alt)\n");
    fprintf(stderr, "  b: Bekomme Graue\n");
    fprintf(stderr, "  e: Einzelschrittmodus an/aus\n");
    fprintf(stderr, "  g: Gewinnen\n");
    fprintf(stderr, "  h: Hilfe\n");
    fprintf(stderr, "  L: Log laden\n");
    fprintf(stderr, "  l: Log abspielen an/aus\n");
    //fprintf(stderr, "  n: Neue Animationen testen\n");
    fprintf(stderr, "  r: Reload levelconf\n");
    fprintf(stderr, "  S: Log speichern\n");
    fprintf(stderr, "  t: Test Rber-Reihe an/aus\n");
    fprintf(stderr, "  v: Schnellvorlauf an/aus\n");
    fprintf(stderr, "  z: Zeitlupe an/aus\n");
    
  } else if (buch == 'r') {
    if (mGModus == gmodus_kein_spiel) {
      fprintf(stderr, "Debug: Reload levelconf\n");
      try {
   	ld->ladLevelConf(ldteil_summary,true,berechneVersion());
      } catch (Fehler fe) {
	printFehler(2, "Could not reload the level description file:\n",
	            fe);
      }
    } else
      fprintf(stderr, "Debug: *Nicht* reload levelconf whrend Spiel luft.\n");
      
  } else if (buch == 'S') {
    fprintf(stderr, "Debug: Logdatei speichern\n");
    Aufnahme::speichern(getLogName());
    
  } else if (buch == 't') {
    mRueberReihenTest = !mRueberReihenTest;
    fprintf(stderr, "Debug: Test Rber-Reihe = %d\n", mRueberReihenTest);
    
  } else if (buch == 'v') {
    mSchnellvorlauf = !mSchnellvorlauf;
    fprintf(stderr, "Debug: Schnellvorlauf = %d\n", mSchnellvorlauf);
    
  } else if (buch == 'z') {
    mZeitlupe = !mZeitlupe;
    fprintf(stderr, "Debug: Zeitlupe = %d\n", mZeitlupe);
  }
  
  return true;
}



/*
fr xtrace:
extern "C" {
int XInternAtom(Display *display, char *atom_name, int only_if_exists);
}
*/



/** Die Haupt-Zeitschritt-Routine. Wird direkt
    vom ui aufgerufen. Ruft alle spielschritt()-Routinen u.. auf. */
void zeitSchritt() {
  CASSERT(mGModus != gmodus_kein_spiel);

/*
fr xtrace:
 XInternAtom(qt_xdisplay(),"zeitschritt A",1);
*/

  /* Zeitlupen-Debug-Modus? */
  if (mZeitlupe) {
    mZaehlerZeitlupe++;
    if (mZaehlerZeitlupe == 5)
      mZaehlerZeitlupe = 0;
    else
      return;
  }

  if (mSchnellvorlauf) {
    for (int i = 0; i < 3; i++)
      if (mGModus != gmodus_kein_spiel) zeitSchrittIntern();
  } else {
    zeitSchrittIntern();
  }

  /* Brauche kein UI::allesAnzeigen(); darum kuemmert sich das spiel-Blatt selbst */
}  // zeitSchritt()




/** Spielfeld neu malen. Wird vom ui aufgerufen. */
void malSpielfeld(int sp) {
  mSpielfeld[sp]->malUpdateAlles();
}



int getSpielerModus() {
  if (mGegenKI)
    return spielermodus_computer;
  else
    return mSpielerZahl;
}

/** Setzt #Spieler, KI-Modus; gemerkte Level-Nummer wird auf 0
    zurueckgesetzt. Vorbedingung: Es luft grad kein Spiel. */
void setSpielerModus(int spm) {
  CASSERT(mGModus==gmodus_kein_spiel);
  if (spm == spielermodus_computer) {
    mGegenKI = true;
    mSpielerZahl = 2;
  } else {
    mGegenKI = false;
    mSpielerZahl = spm;
  }
  
  mLevelNr = 0;
}


/** Der int ist der Index in Version::mLevelpack bzw Version::mSchwierig */
void setLevelpack(int i) {
  mLevelpack = i;
  
  /* Levelpack gendert => aktuelle Level-Nummer wird ungltig. */
  mLevelNr = 0;
}

int getLevelpack() {return mLevelpack;}

void setSchwierig(int i) {
  mSchwierig = i;

  /* Schwierigkeit gendert => aktuelle Level-Nummer wird ungltig. */
  mLevelNr = 0;
}

int getSchwierig() {return mSchwierig;}


/* Liefert Nr. des zuletzt gespielten Levels (oder 0) */
int getLetzterLevel() {
  return mLevelNr;
}



/** Schreibt eine Liste aller auswhlbaren Level nach levnamen;
    levnamen sollte vorher leer sein.
    In def wird ein default fur den naechsten zu spielenden Level
    zurckgeliefert. */
void getMoeglicheLevel(std::vector<Str> & levnamen,
                                   int & def) {
  ld->ladLevelConf(ldteil_summary,false,berechneVersion());
  PrefsDaten::getMoeglicheLevel(mSpielerZahl == 2, levnamen, def);
  if (mLevelNr != 0)
    def = mLevelNr;
}


Version berechneVersion() {
  Version ret = mZusatzVersionen;
  ret.nochEinMerkmal(mSpielerZahl==1 ? "1" : "2");
  if (mSprache != "")
    ret.nochEinMerkmal(mSprache);
  if (Version::gSchwierig.mMerkmale[mSchwierig] != "")
    ret.nochEinMerkmal(Version::gSchwierig.mMerkmale[mSchwierig]);
  ret.nochEinMerkmal(Version::gLevelpack.mMerkmale[mLevelpack]);
  return ret;
}


/* bernimmt die Dinge, die durch version spezifiziert werden.
   Alles andere bleibt beim alten,
   bis auf da der alte Wert von mZusatzVersionen verlorengeht.  */
void setzeVersion(const Version & version) {
  mZusatzVersionen = version;

  /* Achtung! Jetzt enthlt mZusatzVersionen erstmal zu viel.
     Aber der berschu wird gleich rausgelscht. */

  try {
    mSpielerZahl = (
      mZusatzVersionen.extractMerkmal(dimaa_numspieler,
				      (mSpielerZahl==1 ? "1" : "2"))
        == "1"
      ? 1 : 2);
    mSprache = mZusatzVersionen.extractMerkmal(dima_sprache,mSprache);
    mSchwierig = mZusatzVersionen.extractMerkmal(Version::gSchwierig,
						 mSchwierig);
    mLevelpack = mZusatzVersionen.extractMerkmal(Version::gLevelpack,
						 mLevelpack);
  }
  catch(Str konflikt) {throw Fehler(_("Conflicting versions %s"),
					 konflikt.data());}
}


}

