//! Expose all known instructions as Rust `struct`s; this is generated in
//! `build.rs`.
//!
//! See also: [`Inst`], an `enum` containing all these instructions.

use crate::Fixed;
use crate::api::{AsReg, CodeSink, RegisterVisitor, Registers, TrapCode};
use crate::evex::EvexPrefix;
use crate::features::{AvailableFeatures, Feature, Features};
use crate::gpr::{self, Gpr, Size};
use crate::imm::{Extension, Imm8, Imm16, Imm32, Imm64, Simm8, Simm32};
use crate::mem::{Amode, GprMem, XmmMem};
use crate::rex::RexPrefix;
use crate::vex::VexPrefix;
use crate::xmm::{self, Xmm};

// Include code generated by the `meta` crate.
include!(concat!(env!("OUT_DIR"), "/assembler.rs"));

/// A macro listing all available CPU features.
///
/// This is generated from the `dsl::Feature` enumeration defined in the `meta`
/// crate. It makes it easier to generate code based on the available features.
///
/// ```
/// # use cranelift_assembler_x64::{AvailableFeatures, Fixed, for_each_feature, Imm8, inst, Registers};
/// // Tell the assembler the type of registers we're using; we can always
/// // encode a HW register as a `u8` (e.g., `eax = 0`).
/// pub struct Regs;
/// impl Registers for Regs {
///     type ReadGpr = u8;
///     type ReadWriteGpr = u8;
///     type WriteGpr = u8;
///     type ReadXmm = u8;
///     type ReadWriteXmm = u8;
///     type WriteXmm = u8;
/// }
///
/// // Define a target that says all CPU features are available.
/// macro_rules! return_true { ($($f:ident)+) => { $(fn $f(&self) -> bool { true })+ }; }
/// struct AllFeatures;
/// impl AvailableFeatures for AllFeatures {
///     for_each_feature!(return_true);
/// }
///
/// // Define a target that says no CPU features are available.
/// macro_rules! return_false { ($($f:ident)+) => { $(fn $f(&self) -> bool { false })+ }; }
/// struct NoFeatures;
/// impl AvailableFeatures for NoFeatures {
///     for_each_feature!(return_false);
/// }
///
/// let rax: u8 = 0;
/// let and = inst::andb_i::<Regs>::new(Fixed(rax), Imm8::new(0b10101010));
///
/// assert!(and.is_available(&AllFeatures));
/// assert!(!and.is_available(&NoFeatures));
/// ```
#[doc(inline)]
pub use for_each_feature;
