# Si fcc phase

units           metal
boundary        p p p

atom_style      atomic
lattice         sc 2.612
region          box block 0 1 0 1 0 1
create_box              1 box
create_atoms    1 box

pair_style      meam/sw/spline
pair_coeff      * * Si.b.meam.sw.spline Si
mass            * 28.085

variable        cohesive_energy equal pe/atoms
variable        atmVol equal vol/atoms
variable        aLatt equal (vol/atoms)^0.3333333333

run                     0

print           "===================================================="
print           "Calculated cohesive energy: ${cohesive_energy} eV/atom"
print           "Reference cohesive energy:  -4.337 eV/atom"
print           "Atomic volume               ${atmVol} A^3"
print           "Lattice constant            ${aLatt} A"
print           "Reference lattice constant  2.612 A"
print           "===================================================="


#dump           1 all custom 1 sc.dump id type x y z fx fy fz
#run            0


