/*
 * misc_utils.h
 */
#ifndef MISC_UTILS_H
#define MISC_UTILS_H

#include "../config.h"
#include "common.h"

#include <stdio.h>
#include <string>

#define STDIN    0
#define STDOUT   1
#define STDERR   2

std::string &ltrim(std::string &s, const std::string what=" ");
std::string &trim(std::string &s, const std::string what=" ");
std::string &rtrim(std::string &s, const std::string what=" ");

enum MiscUtils 
{
    MISC_OK,
    MISC_NOT_DIR,
    MISC_NOT_WRITABLE,
    MISC_DOES_NOT_EXISTS
};

typedef struct
{
    GtkWidget *menu_item;
    const CommonEncoderType encoding_type;
    const char *encoder;
    const char *plugin;
    const char *description;
    int available;
    const char *bitrate_op;
    const char *user_vbr_op;
    const char *vbr_qual_op;
    const char *high_qual_op;
    const char *crc_op;
} EncoderPlugins;

typedef struct
{
    GtkWidget *menu_item;
    const int bitrate;
} EncoderBitrates;

static EncoderPlugins encoder_plugins[] =
{
    { NULL, MP2,  "toolame",    "ripperX_plugin-toolame",      "Toolame layer 2 encoder",       0, "-b",        "",            "-v",          "",            "-e"   },
    { NULL, MP2,  "twolame",    "ripperX_plugin-twolame",      "Twolame layer 2 encoder",       0, "-b",        "-v",          "-V",          "",            "-p"   },
    { NULL, MP3,  "encode ",    "ripperX_plugin-encode",       "ISO Encoder v2",                0, "-b",        "",            "",            "",            "-e"   },
    { NULL, MP3,  "8hz-mp3 ",   "ripperX_plugin-8hz-mp3",      "8hz-mp3 Encoder",               0, "-b",        "",            "",            "",            ""     },
    { NULL, MP3,  "lame",       "ripperX_plugin-lame",         "Lame MP3 Encoder",              0, "-b",        "--nohist -v", "-V",          "-q 0",        "-p"   },
    { NULL, MP3,  "gogo",       "ripperX_plugin-gogo",         "GoGo MP3 Encoder",              0, "-b",        "-v 4",        "",            "",            ""     },
    { NULL, MP3,  "bladeenc",   "ripperX_plugin-bladeenc",     "BladeEnc MP3 Encoder",          0, "-br",       "",            "",            "",            "-crc" },
    { NULL, MP3,  "xingmp3enc", "ripperX_plugin-xingmp3enc",   "Xingmp3enc MP3 Encoder",        0, "-B",        "",            "-V",          "",            ""     },
    { NULL, MP3,  "l3enc",      "ripperX_plugin-l3enc",        "FHG MP3 Encoder (l3enc v2.72)", 0, "-br",       "",            "",            "-hq",         "-crc" },
    { NULL, MP3,  "mp3enc",     "ripperX_plugin-mp3enc",       "FHG MP3 Encoder (mp3enc 3.1)",  0, "-br",       "",            "",            "-qual 9",     "-crc" },
    { NULL, OGG,  "oggenc",     "ripperX_plugin-oggenc",       "OggVorbis encoder",             0, "-b",        "",            "-q",          "",            ""     },
    { NULL, FLAC, "flac",       "ripperX_plugin-flac",         "FLAC encoder",                  0, "",          "",            "",            "",            ""     },
    { NULL, MUSE, "mppenc",     "ripperX_plugin-musepack",     "Musepack Encoder SV7",          0, "",          "",            "--quality",   "",            ""     },
    { NULL, MUSE, "mpcenc",     "ripperX_plugin-musepack",     "Musepack Encoder SV8",          0, "",          "",            "--quality",   "",            ""     },
    { NULL, OPUS, "opusenc",    "ripperX_plugin-opus",         "Opus Encoder",                  0, "--bitrate", "",            "",            "",            ""     },
};

static const int encoder_plugins_count = sizeof(encoder_plugins) / sizeof(encoder_plugins[0]);


char *get_string_piece(FILE *file, int delim);
char *get_ascii_file(FILE *file);
FILE *socket_init(const std::string& server, short int port);
std::string int2str(int integer);

int execute_using_shell(const std::string& command) ;
int parse_rx_format_string(std::string& target,
                           const std::string& format,
                           int track_no, const std::string& artist, const std::string& album,
                           const std::string& year, const std::string& song);
// track_no starts from 0
// %% %
// %a Artist
// %v album (Volume)
// %y Year
// %s Song

char *length_to_readable(unsigned length);
char *time_to_readable(time_t sec);
char *construct_file_name(const char *path, const char *name);
char *expand_tilde(char *path);
std::string file_name_without_path(const std::string& src);
std::string file_path_without_name(const std::string& src);
void auto_append_extension(char *src, int type);
std::string get_default_track_title(const int track);
//void remove_non_ascii_chars(char *src);
void string_copy(const std::string& in, char *out, const int size);
void replace_string_in_place(std::string &subject, const std::string& search, const std::string &replace);

long check_free_space(const std::string& dir);
int check_dir(const std::string& dir);
int create_dir(const std::string& path);
int is_found(const std::string& plugin);
int create_filenames_from_format(_main_data *main_data);
int create_file_names_for_track(_main_data *main_data, const int track, std::string& wfp,
	std::string& efp, CommonEncoderType type);
CommonEncoderType get_type_for_encoding_file();
void get_track_title(std::string& dest, _main_data *main_data, int tno);
void put_track_title(const std::string& src, _main_data *main_data, int tno);

void set_plugins_path();
std::vector<CommonEncoderType> get_encoding_types();
int get_type_index_for_encoding_file();
void set_type_index_for_encoding_file(int saved_type_index);
void load_enabled_encoder_types();

EncoderPlugins *get_encoder_plugins();
void load_plugins_state();
int has_plugin_available(CommonEncoderType type);

#endif
