
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest C++ Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
#pragma once

#include <azure/core/case_insensitive_containers.hpp>
#include <azure/core/context.hpp>
#include <azure/core/datetime.hpp>
#include <azure/core/etag.hpp>
#include <azure/core/http/http.hpp>
#include <azure/core/internal/http/pipeline.hpp>
#include <azure/core/io/body_stream.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/response.hpp>
#include <azure/core/url.hpp>
#include <azure/storage/blobs/dll_import_export.hpp>
#include <azure/storage/common/storage_common.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <type_traits>
#include <vector>

namespace Azure { namespace Storage { namespace Blobs {
  namespace _detail {
    /**
     * The version used for the operations to Azure storage services.
     */
    constexpr static const char* ApiVersion = "2022-11-02";
  } // namespace _detail
  namespace Models {
    /**
     * @brief The algorithm used to produce the encryption key hash. Currently, the only accepted
     * value is "AES256". Must be provided if the x-ms-encryption-key header is provided.
     */
    class EncryptionAlgorithmType final {
    public:
      /** Constructs a new EncryptionAlgorithmType instance */
      EncryptionAlgorithmType() = default;
      /** Constructs a new EncryptionAlgorithmType from a string. */
      explicit EncryptionAlgorithmType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another EncryptionAlgorithmType. */
      bool operator==(const EncryptionAlgorithmType& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another EncryptionAlgorithmType. */
      bool operator!=(const EncryptionAlgorithmType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type EncryptionAlgorithmType: Aes256 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static EncryptionAlgorithmType Aes256;

    private:
      std::string m_value;
    };
    /**
     * @brief Extensible enum used to specify how the service should look for a block ID.
     */
    class BlockType final {
    public:
      /** Constructs a new BlockType instance */
      BlockType() = default;
      /** Constructs a new BlockType from a string. */
      explicit BlockType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlockType. */
      bool operator==(const BlockType& other) const { return m_value == other.m_value; }
      /** Compares with another BlockType. */
      bool operator!=(const BlockType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlockType: Committed */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockType Committed;
      /** Constant value of type BlockType: Uncommitted */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockType Uncommitted;
      /** Constant value of type BlockType: Latest */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockType Latest;

    private:
      std::string m_value;
    };
    /**
     * @brief The retention policy which determines how long the associated data should persist.
     */
    struct RetentionPolicy final
    {
      /**
       * Indicates whether a retention policy is enabled for the storage service.
       */
      bool IsEnabled = bool();
      /**
       * Indicates the number of days that metrics or logging or soft-deleted data should be
       * retained. All data older than this value will be deleted.
       */
      Nullable<int32_t> Days;
    };
    /**
     * @brief Azure Analytics Logging settings.
     */
    struct AnalyticsLogging final
    {
      /**
       * The version of Storage Analytics to configure.
       */
      std::string Version;
      /**
       * Indicates whether all delete requests should be logged.
       */
      bool Delete = bool();
      /**
       * Indicates whether all read requests should be logged.
       */
      bool Read = bool();
      /**
       * Indicates whether all write requests should be logged.
       */
      bool Write = bool();
      /**
       * The retention policy which determines how long the associated data should persist.
       */
      Models::RetentionPolicy RetentionPolicy;
    };
    /**
     * @brief A summary of request statistics grouped by API in hour or minute aggregates for blobs.
     */
    struct Metrics final
    {
      /**
       * The version of Storage Analytics to configure.
       */
      std::string Version;
      /**
       * Indicates whether metrics are enabled for the Blob service.
       */
      bool IsEnabled = bool();
      /**
       * Indicates whether metrics should generate summary statistics for called API operations.
       */
      Nullable<bool> IncludeApis;
      /**
       * The retention policy which determines how long the associated data should persist.
       */
      Models::RetentionPolicy RetentionPolicy;
    };
    /**
     * @brief CORS is an HTTP feature that enables a web application running under one domain to
     * access resources in another domain. Web browsers implement a security restriction known as
     * same-origin policy that prevents a web page from calling APIs in a different domain; CORS
     * provides a secure way to allow one domain (the origin domain) to call APIs in another domain.
     */
    struct CorsRule final
    {
      /**
       * The origin domains that are permitted to make a request against the storage service via
       * CORS. The origin domain is the domain from which the request originates. Note that the
       * origin must be an exact case-sensitive match with the origin that the user age sends to the
       * service. You can also use the wildcard character '*' to allow all origin domains to make
       * requests via CORS.
       */
      std::string AllowedOrigins;
      /**
       * The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma
       * separated).
       */
      std::string AllowedMethods;
      /**
       * The request headers that the origin domain may specify on the CORS request.
       */
      std::string AllowedHeaders;
      /**
       * The response headers that may be sent in the response to the CORS request and exposed by
       * the browser to the request issuer.
       */
      std::string ExposedHeaders;
      /**
       * The maximum amount time that a browser should cache the preflight OPTIONS request.
       */
      int32_t MaxAgeInSeconds = int32_t();
    };
    /**
     * @brief The properties that enable an account to host a static website.
     */
    struct StaticWebsite final
    {
      /**
       * Indicates whether this account is hosting a static website.
       */
      bool IsEnabled = bool();
      /**
       * The default name of the index page under each directory.
       */
      Nullable<std::string> IndexDocument;
      /**
       * The absolute path of the custom 404 page.
       */
      Nullable<std::string> ErrorDocument404Path;
      /**
       * Absolute path of the default index page.
       */
      Nullable<std::string> DefaultIndexDocumentPath;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobServiceClient::SetProperties.
     */
    struct SetServicePropertiesResult final
    {
    };
    /**
     * @brief Storage Service Properties.
     */
    struct BlobServiceProperties final
    {
      /**
       * Azure Analytics Logging settings.
       */
      AnalyticsLogging Logging;
      /**
       * A summary of request statistics grouped by API in hour or minute aggregates for blobs.
       */
      Metrics HourMetrics;
      /**
       * A summary of request statistics grouped by API in hour or minute aggregates for blobs.
       */
      Metrics MinuteMetrics;
      /**
       * The set of CORS rules.
       */
      std::vector<CorsRule> Cors;
      /**
       * The default version to use for requests to the Blob service if an incoming request's
       * version is not specified. Possible values include version 2008-10-27 and all more recent
       * versions.
       */
      Nullable<std::string> DefaultServiceVersion;
      /**
       * The retention policy which determines how long the associated data should persist.
       */
      RetentionPolicy DeleteRetentionPolicy;
      /**
       * The properties that enable an account to host a static website.
       */
      Models::StaticWebsite StaticWebsite;
    };
    /**
     * @brief The status of the secondary location.
     */
    class GeoReplicationStatus final {
    public:
      /** Constructs a new GeoReplicationStatus instance */
      GeoReplicationStatus() = default;
      /** Constructs a new GeoReplicationStatus from a string. */
      explicit GeoReplicationStatus(std::string value) : m_value(std::move(value)) {}
      /** Compares with another GeoReplicationStatus. */
      bool operator==(const GeoReplicationStatus& other) const { return m_value == other.m_value; }
      /** Compares with another GeoReplicationStatus. */
      bool operator!=(const GeoReplicationStatus& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type GeoReplicationStatus: Live */
      AZ_STORAGE_BLOBS_DLLEXPORT const static GeoReplicationStatus Live;
      /** Constant value of type GeoReplicationStatus: Bootstrap */
      AZ_STORAGE_BLOBS_DLLEXPORT const static GeoReplicationStatus Bootstrap;
      /** Constant value of type GeoReplicationStatus: Unavailable */
      AZ_STORAGE_BLOBS_DLLEXPORT const static GeoReplicationStatus Unavailable;

    private:
      std::string m_value;
    };
    /**
     * @brief Geo-Replication information for the Secondary Storage Service.
     */
    struct GeoReplication final
    {
      /**
       * The status of the secondary location.
       */
      GeoReplicationStatus Status;
      /**
       * A GMT date/time value, to the second. All primary writes preceding this value are
       * guaranteed to be available for read operations at the secondary. Primary writes after this
       * point in time may or may not be available for reads.
       */
      Nullable<DateTime> LastSyncedOn;
    };
    /**
     * @brief Stats for the storage service.
     */
    struct ServiceStatistics final
    {
      /**
       * Geo-Replication information for the Secondary Storage Service.
       */
      Models::GeoReplication GeoReplication;
    };
    /**
     * @brief The current lease status of the blob.
     */
    class LeaseStatus final {
    public:
      /** Constructs a new LeaseStatus instance */
      LeaseStatus() = default;
      /** Constructs a new LeaseStatus from a string. */
      explicit LeaseStatus(std::string value) : m_value(std::move(value)) {}
      /** Compares with another LeaseStatus. */
      bool operator==(const LeaseStatus& other) const { return m_value == other.m_value; }
      /** Compares with another LeaseStatus. */
      bool operator!=(const LeaseStatus& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type LeaseStatus: Locked */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseStatus Locked;
      /** Constant value of type LeaseStatus: Unlocked */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseStatus Unlocked;

    private:
      std::string m_value;
    };
    /**
     * @brief The current lease state of the blob.
     */
    class LeaseState final {
    public:
      /** Constructs a new LeaseState instance */
      LeaseState() = default;
      /** Constructs a new LeaseState from a string. */
      explicit LeaseState(std::string value) : m_value(std::move(value)) {}
      /** Compares with another LeaseState. */
      bool operator==(const LeaseState& other) const { return m_value == other.m_value; }
      /** Compares with another LeaseState. */
      bool operator!=(const LeaseState& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type LeaseState: Available */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseState Available;
      /** Constant value of type LeaseState: Leased */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseState Leased;
      /** Constant value of type LeaseState: Expired */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseState Expired;
      /** Constant value of type LeaseState: Breaking */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseState Breaking;
      /** Constant value of type LeaseState: Broken */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseState Broken;

    private:
      std::string m_value;
    };
    /**
     * @brief When a blob is leased, specifies whether the lease is of infinite or fixed duration.
     */
    class LeaseDurationType final {
    public:
      /** Constructs a new LeaseDurationType instance */
      LeaseDurationType() = default;
      /** Constructs a new LeaseDurationType from a string. */
      explicit LeaseDurationType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another LeaseDurationType. */
      bool operator==(const LeaseDurationType& other) const { return m_value == other.m_value; }
      /** Compares with another LeaseDurationType. */
      bool operator!=(const LeaseDurationType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type LeaseDurationType: Infinite */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseDurationType Infinite;
      /** Constant value of type LeaseDurationType: Fixed */
      AZ_STORAGE_BLOBS_DLLEXPORT const static LeaseDurationType Fixed;

    private:
      std::string m_value;
    };
    /**
     * @brief Specifies whether data in the container may be accessed publicly and the level of
     * access.
     */
    class PublicAccessType final {
    public:
      /** Constructs a new PublicAccessType instance */
      PublicAccessType() = default;
      /** Constructs a new PublicAccessType from a string. */
      explicit PublicAccessType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another PublicAccessType. */
      bool operator==(const PublicAccessType& other) const { return m_value == other.m_value; }
      /** Compares with another PublicAccessType. */
      bool operator!=(const PublicAccessType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type PublicAccessType: BlobContainer */
      AZ_STORAGE_BLOBS_DLLEXPORT const static PublicAccessType BlobContainer;
      /** Constant value of type PublicAccessType: Blob */
      AZ_STORAGE_BLOBS_DLLEXPORT const static PublicAccessType Blob;
      /** Constant value of type PublicAccessType: None */
      AZ_STORAGE_BLOBS_DLLEXPORT const static PublicAccessType None;

    private:
      std::string m_value;
    };
    /**
     * @brief Properties of a container.
     */
    struct BlobContainerItemDetails final
    {
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * The current lease status of the blob.
       */
      Models::LeaseStatus LeaseStatus;
      /**
       * The current lease state of the blob.
       */
      Models::LeaseState LeaseState;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * Specifies whether data in the container may be accessed publicly and the level of access.
       */
      PublicAccessType AccessType;
      /**
       * Indicates whether the container has an immutability policy set on it.
       */
      bool HasImmutabilityPolicy = bool();
      /**
       * Indicates whether the container has a legal hold.
       */
      bool HasLegalHold = bool();
      /**
       * The default encryption scope for the container.
       */
      std::string DefaultEncryptionScope = "$account-encryption-key";
      /**
       * Indicates whether the container's default encryption scope can be overriden.
       */
      bool PreventEncryptionScopeOverride = false;
      /**
       * Data and time at which this container was deleted. Only valid when this container was
       * deleted.
       */
      Nullable<DateTime> DeletedOn;
      /**
       * Remaining days before this container will be permanently deleted. Only valid when this
       * container was deleted.
       */
      Nullable<int32_t> RemainingRetentionDays;
      /**
       * Indicates if version level worm is enabled on this container.
       */
      bool HasImmutableStorageWithVersioning = false;
      /**
       * A set of name-value pairs associated with this blob or blob container.
       */
      Core::CaseInsensitiveMap Metadata;
    };
    /**
     * @brief An Azure Storage container.
     */
    struct BlobContainerItem final
    {
      /**
       * Blob container name.
       */
      std::string Name;
      /**
       * Indicates whether this container was deleted.
       */
      bool IsDeleted = bool();
      /**
       * Version ID of a deleted container.
       */
      Nullable<std::string> VersionId;
      /**
       * Properties of a container.
       */
      BlobContainerItemDetails Details;
    };
    /**
     * @brief Include this parameter to specify that the container's metadata be returned as part of
     * the response body.
     */
    enum class ListBlobContainersIncludeFlags
    {
      None = 0,
      Metadata = 1,
      Deleted = 2,
      System = 4,
    };
    inline ListBlobContainersIncludeFlags operator|(
        ListBlobContainersIncludeFlags lhs,
        ListBlobContainersIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListBlobContainersIncludeFlags>;
      return static_cast<ListBlobContainersIncludeFlags>(
          static_cast<type>(lhs) | static_cast<type>(rhs));
    }
    inline ListBlobContainersIncludeFlags& operator|=(
        ListBlobContainersIncludeFlags& lhs,
        ListBlobContainersIncludeFlags rhs)
    {
      lhs = lhs | rhs;
      return lhs;
    }
    inline ListBlobContainersIncludeFlags operator&(
        ListBlobContainersIncludeFlags lhs,
        ListBlobContainersIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListBlobContainersIncludeFlags>;
      return static_cast<ListBlobContainersIncludeFlags>(
          static_cast<type>(lhs) & static_cast<type>(rhs));
    }
    inline ListBlobContainersIncludeFlags& operator&=(
        ListBlobContainersIncludeFlags& lhs,
        ListBlobContainersIncludeFlags rhs)
    {
      lhs = lhs & rhs;
      return lhs;
    }
    namespace _detail {
      /**
       * @brief An enumeration of containers.
       */
      struct ListBlobContainersResult final
      {
        std::string ServiceEndpoint;
        std::string Prefix;
        Nullable<std::string> ContinuationToken;
        /**
         * Array of BlobContainerItem.
         */
        std::vector<BlobContainerItem> Items;
      };
      /**
       * @brief Key information.
       */
      struct KeyInfo final
      {
        /**
         * The date-time the key is active in ISO 8601 UTC time.
         */
        std::string Start;
        /**
         * The date-time the key expires in ISO 8601 UTC time.
         */
        std::string Expiry;
      };
    } // namespace _detail
    /**
     * @brief A user delegation key.
     */
    struct UserDelegationKey final
    {
      /**
       * The Azure Active Directory object ID in GUID format.
       */
      std::string SignedObjectId;
      /**
       * The Azure Active Directory tenant ID in GUID format.
       */
      std::string SignedTenantId;
      /**
       * The date-time the key is active.
       */
      DateTime SignedStartsOn;
      /**
       * The date-time the key expires.
       */
      DateTime SignedExpiresOn;
      /**
       * Abbreviation of the Azure Storage service that accepts the key.
       */
      std::string SignedService;
      /**
       * The service version that created the key.
       */
      std::string SignedVersion;
      /**
       * The key as a base64 string.
       */
      std::string Value;
    };
    /**
     * @brief Identifies the sku name of the account.
     */
    class SkuName final {
    public:
      /** Constructs a new SkuName instance */
      SkuName() = default;
      /** Constructs a new SkuName from a string. */
      explicit SkuName(std::string value) : m_value(std::move(value)) {}
      /** Compares with another SkuName. */
      bool operator==(const SkuName& other) const { return m_value == other.m_value; }
      /** Compares with another SkuName. */
      bool operator!=(const SkuName& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type SkuName: StandardLrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardLrs;
      /** Constant value of type SkuName: StandardGrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardGrs;
      /** Constant value of type SkuName: StandardRagrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardRagrs;
      /** Constant value of type SkuName: StandardZrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardZrs;
      /** Constant value of type SkuName: PremiumLrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName PremiumLrs;
      /** Constant value of type SkuName: PremiumZrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName PremiumZrs;
      /** Constant value of type SkuName: StandardGzrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardGzrs;
      /** Constant value of type SkuName: StandardRagzrs */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SkuName StandardRagzrs;

    private:
      std::string m_value;
    };
    /**
     * @brief Identifies the account kind.
     */
    class AccountKind final {
    public:
      /** Constructs a new AccountKind instance */
      AccountKind() = default;
      /** Constructs a new AccountKind from a string. */
      explicit AccountKind(std::string value) : m_value(std::move(value)) {}
      /** Compares with another AccountKind. */
      bool operator==(const AccountKind& other) const { return m_value == other.m_value; }
      /** Compares with another AccountKind. */
      bool operator!=(const AccountKind& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type AccountKind: Storage */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccountKind Storage;
      /** Constant value of type AccountKind: BlobStorage */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccountKind BlobStorage;
      /** Constant value of type AccountKind: StorageV2 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccountKind StorageV2;
      /** Constant value of type AccountKind: FileStorage */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccountKind FileStorage;
      /** Constant value of type AccountKind: BlockBlobStorage */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccountKind BlockBlobStorage;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobServiceClient::GetAccountInfo.
     */
    struct AccountInfo final
    {
      /**
       * Identifies the sku name of the account.
       */
      Models::SkuName SkuName;
      /**
       * Identifies the account kind.
       */
      Models::AccountKind AccountKind;
      /**
       * Version 2019-07-07 and newer. Indicates if the account has a hierarchical namespace
       * enabled.
       */
      bool IsHierarchicalNamespaceEnabled = bool();
    };
    /**
     * @brief Blob info from a Filter Blobs API call.
     */
    struct TaggedBlobItem final
    {
      /**
       * Blob name.
       */
      std::string BlobName;
      /**
       * Blob container name.
       */
      std::string BlobContainerName;
      /**
       * User-defined tags for this blob.
       */
      std::map<std::string, std::string> Tags;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::Create.
     */
    struct CreateBlobContainerResult final
    {
      /**
       * Indicates if the container was successfully created by this operation.
       */
      bool Created = true;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::GetProperties.
     */
    struct BlobContainerProperties final
    {
      /**
       * A set of name-value pair associated with this blob container.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * Lease state of the blob.
       */
      Models::LeaseState LeaseState;
      /**
       * The current lease status of the blob.
       */
      Models::LeaseStatus LeaseStatus;
      /**
       * Indicated whether data in the container may be accessed publicly and the level of access.
       */
      PublicAccessType AccessType = PublicAccessType::None;
      /**
       * Indicates whether the container has an immutability policy set on it.
       */
      bool HasImmutabilityPolicy = bool();
      /**
       * Indicates whether the container has a legal hold.
       */
      bool HasLegalHold = bool();
      /**
       * The default encryption scope for the container.
       */
      std::string DefaultEncryptionScope = "$account-encryption-key";
      /**
       * Indicates whether the container's default encryption scope can be overriden.
       */
      bool PreventEncryptionScopeOverride = false;
      /**
       * Indicates whether version level worm is enabled on a container.
       */
      bool HasImmutableStorageWithVersioning = false;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::Delete.
     */
    struct DeleteBlobContainerResult final
    {
      /**
       * Indicates if the container was successfully deleted by this operation.
       */
      bool Deleted = true;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::SetMetadata.
     */
    struct SetBlobContainerMetadataResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
    };
    /**
     * @brief Signed identifier.
     */
    struct SignedIdentifier final
    {
      /**
       * A unique id.
       */
      std::string Id;
      /**
       * The date-time the policy is active.
       */
      Nullable<DateTime> StartsOn;
      /**
       * The date-time the policy expires.
       */
      Nullable<DateTime> ExpiresOn;
      /**
       * The permissions for the acl policy.
       */
      std::string Permissions;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::GetAccessPolicy.
     */
    struct BlobContainerAccessPolicy final
    {
      /**
       * A collection of signed identifiers.
       */
      std::vector<SignedIdentifier> SignedIdentifiers;
      /**
       * Indicated whether data in the container may be accessed publicly and the level of access.
       */
      PublicAccessType AccessType = PublicAccessType::None;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::SetAccessPolicy.
     */
    struct SetBlobContainerAccessPolicyResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::Undelete.
       */
      struct UndeleteBlobContainerResult final
      {
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::Rename.
       */
      struct RenameBlobContainerResult final
      {
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::SubmitBatch.
       */
      struct SubmitBatchResult final
      {
        std::unique_ptr<Core::IO::BodyStream> BodyStream;
        /**
         * The media type of the body of the response. For batch requests, this is multipart/mixed;
         * boundary=batchresponse_GUID.
         */
        std::string ContentType;
      };
      /**
       * @brief The result of a Filter Blobs API call.
       */
      struct FindBlobsByTagsResult final
      {
        std::string ServiceEndpoint;
        /**
         * Array of TaggedBlobItem.
         */
        std::vector<TaggedBlobItem> Items;
        Nullable<std::string> ContinuationToken;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::AcquireLease.
       */
      struct AcquireBlobContainerLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a container's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::ReleaseLease.
       */
      struct ReleaseBlobContainerLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::RenewLease.
       */
      struct RenewBlobContainerLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a container's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::BreakLease.
       */
      struct BreakBlobContainerLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * Approximate time remaining in the lease period, in seconds.
         */
        int32_t LeaseTime = int32_t();
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobContainerClient::ChangeLease.
       */
      struct ChangeBlobContainerLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a container's lease.
         */
        std::string LeaseId;
      };
      struct BlobName final
      {
        /**
         * Indicates if the blob name is encoded.
         */
        bool Encoded = bool();
        /**
         * The name of the blob.
         */
        std::string Content;
      };
    } // namespace _detail
    /**
     * @brief Status of the copy operation.
     */
    class CopyStatus final {
    public:
      /** Constructs a new CopyStatus instance */
      CopyStatus() = default;
      /** Constructs a new CopyStatus from a string. */
      explicit CopyStatus(std::string value) : m_value(std::move(value)) {}
      /** Compares with another CopyStatus. */
      bool operator==(const CopyStatus& other) const { return m_value == other.m_value; }
      /** Compares with another CopyStatus. */
      bool operator!=(const CopyStatus& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type CopyStatus: Pending */
      AZ_STORAGE_BLOBS_DLLEXPORT const static CopyStatus Pending;
      /** Constant value of type CopyStatus: Success */
      AZ_STORAGE_BLOBS_DLLEXPORT const static CopyStatus Success;
      /** Constant value of type CopyStatus: Aborted */
      AZ_STORAGE_BLOBS_DLLEXPORT const static CopyStatus Aborted;
      /** Constant value of type CopyStatus: Failed */
      AZ_STORAGE_BLOBS_DLLEXPORT const static CopyStatus Failed;

    private:
      std::string m_value;
    };
    /**
     * @brief Optional. Indicates the tier to be set on the blob.
     */
    class AccessTier final {
    public:
      /** Constructs a new AccessTier instance */
      AccessTier() = default;
      /** Constructs a new AccessTier from a string. */
      explicit AccessTier(std::string value) : m_value(std::move(value)) {}
      /** Compares with another AccessTier. */
      bool operator==(const AccessTier& other) const { return m_value == other.m_value; }
      /** Compares with another AccessTier. */
      bool operator!=(const AccessTier& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type AccessTier: P1 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P1;
      /** Constant value of type AccessTier: P2 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P2;
      /** Constant value of type AccessTier: P3 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P3;
      /** Constant value of type AccessTier: P4 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P4;
      /** Constant value of type AccessTier: P6 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P6;
      /** Constant value of type AccessTier: P10 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P10;
      /** Constant value of type AccessTier: P15 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P15;
      /** Constant value of type AccessTier: P20 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P20;
      /** Constant value of type AccessTier: P30 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P30;
      /** Constant value of type AccessTier: P40 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P40;
      /** Constant value of type AccessTier: P50 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P50;
      /** Constant value of type AccessTier: P60 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P60;
      /** Constant value of type AccessTier: P70 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P70;
      /** Constant value of type AccessTier: P80 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier P80;
      /** Constant value of type AccessTier: Hot */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier Hot;
      /** Constant value of type AccessTier: Cool */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier Cool;
      /** Constant value of type AccessTier: Archive */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier Archive;
      /** Constant value of type AccessTier: Premium */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier Premium;
      /** Constant value of type AccessTier: Cold */
      AZ_STORAGE_BLOBS_DLLEXPORT const static AccessTier Cold;

    private:
      std::string m_value;
    };
    /**
     * @brief For blob storage LRS accounts, valid values are
     * rehydrate-pending-to-hot/rehydrate-pending-to-cool. If the blob is being rehydrated and is
     * not complete then this value indicates that rehydrate is pending and also tells the
     * destination tier.
     */
    class ArchiveStatus final {
    public:
      /** Constructs a new ArchiveStatus instance */
      ArchiveStatus() = default;
      /** Constructs a new ArchiveStatus from a string. */
      explicit ArchiveStatus(std::string value) : m_value(std::move(value)) {}
      /** Compares with another ArchiveStatus. */
      bool operator==(const ArchiveStatus& other) const { return m_value == other.m_value; }
      /** Compares with another ArchiveStatus. */
      bool operator!=(const ArchiveStatus& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type ArchiveStatus: RehydratePendingToHot */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ArchiveStatus RehydratePendingToHot;
      /** Constant value of type ArchiveStatus: RehydratePendingToCool */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ArchiveStatus RehydratePendingToCool;
      /** Constant value of type ArchiveStatus: RehydratePendingToCold */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ArchiveStatus RehydratePendingToCold;

    private:
      std::string m_value;
    };
    /**
     * @brief Optional: Indicates the priority with which to rehydrate an archived blob.
     */
    class RehydratePriority final {
    public:
      /** Constructs a new RehydratePriority instance */
      RehydratePriority() = default;
      /** Constructs a new RehydratePriority from a string. */
      explicit RehydratePriority(std::string value) : m_value(std::move(value)) {}
      /** Compares with another RehydratePriority. */
      bool operator==(const RehydratePriority& other) const { return m_value == other.m_value; }
      /** Compares with another RehydratePriority. */
      bool operator!=(const RehydratePriority& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type RehydratePriority: High */
      AZ_STORAGE_BLOBS_DLLEXPORT const static RehydratePriority High;
      /** Constant value of type RehydratePriority: Standard */
      AZ_STORAGE_BLOBS_DLLEXPORT const static RehydratePriority Standard;

    private:
      std::string m_value;
    };
    /**
     * @brief Standard HTTP properties supported by containers and blobs.
     */
    struct BlobHttpHeaders final
    {
      /**
       * MIME content type of the blob.
       */
      std::string ContentType;
      /**
       * Specifies which content encodings have been applied to the blob.
       */
      std::string ContentEncoding;
      /**
       * Specifies the natural languages used by this blob.
       */
      std::string ContentLanguage;
      /**
       * Hash of the blob content.
       */
      Storage::ContentHash ContentHash;
      /**
       * Conveys additional information about how to process the resource payload, and also can be
       * used to attach additional metadata.
       */
      std::string ContentDisposition;
      /**
       * Specifies directives for caching mechanisms.
       */
      std::string CacheControl;
    };
    /**
     * @brief The replication status of blob with the given policy and rule identifiers.
     */
    class ObjectReplicationStatus final {
    public:
      /** Constructs a new ObjectReplicationStatus instance */
      ObjectReplicationStatus() = default;
      /** Constructs a new ObjectReplicationStatus from a string. */
      explicit ObjectReplicationStatus(std::string value) : m_value(std::move(value)) {}
      /** Compares with another ObjectReplicationStatus. */
      bool operator==(const ObjectReplicationStatus& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another ObjectReplicationStatus. */
      bool operator!=(const ObjectReplicationStatus& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type ObjectReplicationStatus: Complete */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ObjectReplicationStatus Complete;
      /** Constant value of type ObjectReplicationStatus: Failed */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ObjectReplicationStatus Failed;

    private:
      std::string m_value;
    };
    /**
     * @brief Contains the object replication rule ID and replication status of a blob.
     */
    struct ObjectReplicationRule final
    {
      /**
       * Object replication rule ID.
       */
      std::string RuleId;
      /**
       * Object replication status.
       */
      ObjectReplicationStatus ReplicationStatus;
    };
    /**
     * @brief Contains object replication policy ID and the respective list of
     * #Azure::Storage::Blobs::Models::ObjectReplicationRule s. This is used when retrieving the
     * object replication properties on the source blob.
     */
    struct ObjectReplicationPolicy final
    {
      /**
       * Object replication policy ID.
       */
      std::string PolicyId;
      /**
       * The Rule IDs and respective replication status that are under the policy ID.
       */
      std::vector<ObjectReplicationRule> Rules;
    };
    /**
     * @brief Specifies the immutability policy mode to set on the blob.
     */
    class BlobImmutabilityPolicyMode final {
    public:
      /** Constructs a new BlobImmutabilityPolicyMode instance */
      BlobImmutabilityPolicyMode() = default;
      /** Constructs a new BlobImmutabilityPolicyMode from a string. */
      explicit BlobImmutabilityPolicyMode(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlobImmutabilityPolicyMode. */
      bool operator==(const BlobImmutabilityPolicyMode& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another BlobImmutabilityPolicyMode. */
      bool operator!=(const BlobImmutabilityPolicyMode& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlobImmutabilityPolicyMode: Unlocked */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobImmutabilityPolicyMode Unlocked;
      /** Constant value of type BlobImmutabilityPolicyMode: Locked */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobImmutabilityPolicyMode Locked;

    private:
      std::string m_value;
    };
    /**
     * @brief Immutability policy associated with the blob.
     */
    struct BlobImmutabilityPolicy final
    {
      /**
       * The date until which the blob can be protected from being modified or deleted.
       */
      DateTime ExpiresOn;
      /**
       * Specifies the immutability policy mode set on the blob.
       */
      BlobImmutabilityPolicyMode PolicyMode;
    };
    /**
     * @brief Properties of a blob.
     */
    struct BlobItemDetails final
    {
      /**
       * The date and time at which the blob was created.
       */
      DateTime CreatedOn;
      /**
       * The date and time the blob was last modified.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * The current sequence number for a page blob.
       */
      Nullable<int64_t> SequenceNumber;
      /**
       * The current lease status of the blob.
       */
      Models::LeaseStatus LeaseStatus;
      /**
       * The current lease state of the blob.
       */
      Models::LeaseState LeaseState;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * String identifier for this copy operation. Use with Get Blob Properties to check the status
       * of this copy operation, or pass to Abort Copy Blob to abort a pending copy.
       */
      Nullable<std::string> CopyId;
      /**
       * Status of the copy operation.
       */
      Nullable<Models::CopyStatus> CopyStatus;
      /**
       * URL up to 2 KB in length that specifies the source blob or file used in the last attempted
       * Copy Blob operation where this blob was the destination blob. This header does not appear
       * if this blob has never been the destination in a Copy Blob operation, or if this blob has
       * been modified after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or
       * Put Block List.
       */
      Nullable<std::string> CopySource;
      /**
       * Contains the number of bytes copied and the total bytes in the source in the last attempted
       * Copy Blob operation where this blob was the destination blob. Can show between 0 and
       * Content-Length bytes copied. This header does not appear if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<std::string> CopyProgress;
      /**
       * Conclusion time of the last attempted Copy Blob operation where this blob was the
       * destination blob. This value can specify the time of a completed, aborted, or failed copy
       * attempt. This header does not appear if a copy is pending, if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<DateTime> CopyCompletedOn;
      /**
       * Only appears when x-ms-copy-status is failed or pending. Describes the cause of the last
       * fatal or non-fatal copy operation failure. This header does not appear if this blob has
       * never been the destination in a Copy Blob operation, or if this blob has been modified
       * after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or Put Block
       * List.
       */
      Nullable<std::string> CopyStatusDescription;
      /**
       * The value of this header is set to true if the blob data and application metadata are
       * completely encrypted using the specified algorithm. Otherwise, the value is set to false
       * (when the blob is unencrypted, or if only parts of the blob/application metadata are
       * encrypted).
       */
      bool IsServerEncrypted = bool();
      /**
       * Included if the blob is incremental copy blob.
       */
      Nullable<bool> IsIncrementalCopy;
      /**
       * Included if the blob is incremental copy blob or incremental copy snapshot, if
       * x-ms-copy-status is success. Snapshot time of the last successful incremental copy snapshot
       * for this blob.
       */
      Nullable<std::string> IncrementalCopyDestinationSnapshot;
      /**
       * Data and time at which this blob was deleted. Only valid when this blob was deleted.
       */
      Nullable<DateTime> DeletedOn;
      /**
       * Remaining days before this blob will be permanently deleted. Only valid when this blob was
       * deleted.
       */
      Nullable<int32_t> RemainingRetentionDays;
      /**
       * The tier of page blob on a premium storage account or tier of block blob on blob storage or
       * general purpose v2 account.
       */
      Nullable<Models::AccessTier> AccessTier;
      /**
       * True if the access tier is not explicitly set on the blob.
       */
      Nullable<bool> IsAccessTierInferred;
      /**
       * For blob storage LRS accounts, valid values are
       * rehydrate-pending-to-hot/rehydrate-pending-to-cool. If the blob is being rehydrated and is
       * not complete then this value indicates that rehydrate is pending and also tells the
       * destination tier.
       */
      Nullable<Models::ArchiveStatus> ArchiveStatus;
      /**
       * SHA-256 hash of the encryption key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * The name of the encryption scope under which the blob is encrypted.
       */
      Nullable<std::string> EncryptionScope;
      /**
       * The time the tier was changed on the object. This is only returned if the tier on the block
       * blob was ever set.
       */
      Nullable<DateTime> AccessTierChangedOn;
      /**
       * The time this blob will expire.
       */
      Nullable<DateTime> ExpiresOn;
      /**
       * If this blob has been sealed.
       */
      Nullable<bool> IsSealed;
      /**
       * If an object is in rehydrate pending state then this header is returned with priority of
       * rehydrate. Valid values are High and Standard.
       */
      Nullable<Models::RehydratePriority> RehydratePriority;
      /**
       * UTC date/time value generated by the service that indicates the time at which the blob was
       * last read or written to.
       */
      Nullable<DateTime> LastAccessedOn;
      /**
       * Indicates whether the blob has a legal hold.
       */
      bool HasLegalHold = false;
      /**
       * Standard HTTP properties supported by containers and blobs.
       */
      BlobHttpHeaders HttpHeaders;
      /**
       * A set of name-value pairs associated with this blob or blob container.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * User-defined tags for this blob.
       */
      std::map<std::string, std::string> Tags;
      /**
       * Array of ObjectReplicationPolicy.
       */
      std::vector<ObjectReplicationPolicy> ObjectReplicationSourceProperties;
      /**
       * Immutability policy associated with the blob.
       */
      Nullable<BlobImmutabilityPolicy> ImmutabilityPolicy;
    };
    /**
     * @brief Type of the blob.
     */
    class BlobType final {
    public:
      /** Constructs a new BlobType instance */
      BlobType() = default;
      /** Constructs a new BlobType from a string. */
      explicit BlobType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlobType. */
      bool operator==(const BlobType& other) const { return m_value == other.m_value; }
      /** Compares with another BlobType. */
      bool operator!=(const BlobType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlobType: BlockBlob */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobType BlockBlob;
      /** Constant value of type BlobType: PageBlob */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobType PageBlob;
      /** Constant value of type BlobType: AppendBlob */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobType AppendBlob;

    private:
      std::string m_value;
    };
    namespace _detail {
      /**
       * @brief An Azure Storage blob.
       */
      struct BlobItem final
      {
        /**
         * Blob name.
         */
        BlobName Name;
        /**
         * Indicates whether this blob was deleted.
         */
        bool IsDeleted = bool();
        /**
         * A string value that uniquely identifies a blob snapshot.
         */
        std::string Snapshot;
        /**
         * A string value that uniquely identifies a blob version.
         */
        Nullable<std::string> VersionId;
        /**
         * Indicates if this is the current version of the blob.
         */
        Nullable<bool> IsCurrentVersion;
        /**
         * Properties of a blob.
         */
        BlobItemDetails Details;
        /**
         * Indicates that this root blob has been deleted, but it has versions that are active.
         */
        Nullable<bool> HasVersionsOnly;
        /**
         * Size in bytes.
         */
        int64_t BlobSize = int64_t();
        /**
         * Type of the blob.
         */
        Models::BlobType BlobType;
        /**
         * The deletion ID associated with the deleted path.
         */
        Nullable<std::string> DeletionId;
      };
    } // namespace _detail
    /**
     * @brief Include this parameter to specify one or more datasets to include in the response.
     */
    enum class ListBlobsIncludeFlags
    {
      None = 0,
      Copy = 1,
      Deleted = 2,
      Metadata = 4,
      Snapshots = 8,
      UncomittedBlobs = 16,
      Versions = 32,
      Tags = 64,
      ImmutabilityPolicy = 128,
      LegalHold = 256,
      DeletedWithVersions = 512,
    };
    inline ListBlobsIncludeFlags operator|(ListBlobsIncludeFlags lhs, ListBlobsIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListBlobsIncludeFlags>;
      return static_cast<ListBlobsIncludeFlags>(static_cast<type>(lhs) | static_cast<type>(rhs));
    }
    inline ListBlobsIncludeFlags& operator|=(ListBlobsIncludeFlags& lhs, ListBlobsIncludeFlags rhs)
    {
      lhs = lhs | rhs;
      return lhs;
    }
    inline ListBlobsIncludeFlags operator&(ListBlobsIncludeFlags lhs, ListBlobsIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListBlobsIncludeFlags>;
      return static_cast<ListBlobsIncludeFlags>(static_cast<type>(lhs) & static_cast<type>(rhs));
    }
    inline ListBlobsIncludeFlags& operator&=(ListBlobsIncludeFlags& lhs, ListBlobsIncludeFlags rhs)
    {
      lhs = lhs & rhs;
      return lhs;
    }
    namespace _detail {
      /**
       * @brief An enumeration of blobs.
       */
      struct ListBlobsResult final
      {
        std::string ServiceEndpoint;
        std::string BlobContainerName;
        std::string Prefix;
        Nullable<std::string> ContinuationToken;
        /**
         * Array of BlobItem.
         */
        std::vector<BlobItem> Items;
      };
      /**
       * @brief An enumeration of blobs.
       */
      struct ListBlobsByHierarchyResult final
      {
        std::string ServiceEndpoint;
        std::string BlobContainerName;
        std::string Prefix;
        std::string Delimiter;
        Nullable<std::string> ContinuationToken;
        /**
         * Array of BlobItem.
         */
        std::vector<BlobItem> Items;
        /**
         * Array of BlobName.
         */
        std::vector<BlobName> BlobPrefixes;
      };
    } // namespace _detail
    /**
     * @brief Detailed information of the downloaded blob.
     */
    struct DownloadBlobDetails final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The date and time at which the blob was created.
       */
      DateTime CreatedOn;
      /**
       * The time this blob will expire.
       */
      Nullable<DateTime> ExpiresOn;
      /**
       * UTC date/time value generated by the service that indicates the time at which the blob was
       * last read or written to.
       */
      Nullable<DateTime> LastAccessedOn;
      /**
       * Standard HTTP properties supported by containers and blobs.
       */
      BlobHttpHeaders HttpHeaders;
      /**
       * A set of name-value pairs associated with this blob or blob container.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * The current sequence number for a page blob.
       */
      Nullable<int64_t> SequenceNumber;
      /**
       * The number of committed blocks present in the blob.
       */
      Nullable<int32_t> CommittedBlockCount;
      /**
       * If the blob has been sealed. This value is null for block blobs or page blobs.
       */
      Nullable<bool> IsSealed;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * The current lease state of the blob.
       */
      Nullable<Models::LeaseState> LeaseState;
      /**
       * The current lease status of the blob.
       */
      Nullable<Models::LeaseStatus> LeaseStatus;
      /**
       * True if the blob data and metadata are completely encrypted using the specified algorithm.
       * Otherwise, the value is set to false (when the blob is unencrypted, or if only parts of the
       * blob/application metadata are encrypted).
       */
      bool IsServerEncrypted = bool();
      /**
       * SHA-256 hash of the encryption key used to encrypt the blob data and metadata.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Name of the encryption scope used to encrypt the blob data and metadata.
       */
      Nullable<std::string> EncryptionScope;
      /**
       * Only valid when Object Replication is enabled and current blob is the destination.
       */
      Nullable<std::string> ObjectReplicationDestinationPolicyId;
      /**
       * Only valid when Object Replication is enabled and current blob is the source.
       */
      std::vector<ObjectReplicationPolicy> ObjectReplicationSourceProperties;
      /**
       * The number of tags associated with the blob.
       */
      Nullable<int32_t> TagCount;
      /**
       * String identifier for this copy operation. Use with Get Blob Properties to check the status
       * of this copy operation, or pass to Abort Copy Blob to abort a pending copy.
       */
      Nullable<std::string> CopyId;
      /**
       * URL up to 2 KB in length that specifies the source blob or file used in the last attempted
       * Copy Blob operation where this blob was the destination blob. This header does not appear
       * if this blob has never been the destination in a Copy Blob operation, or if this blob has
       * been modified after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or
       * Put Block List.
       */
      Nullable<std::string> CopySource;
      /**
       * Status of the copy operation.
       */
      Nullable<Models::CopyStatus> CopyStatus;
      /**
       * Only appears when x-ms-copy-status is failed or pending. Describes the cause of the last
       * fatal or non-fatal copy operation failure. This header does not appear if this blob has
       * never been the destination in a Copy Blob operation, or if this blob has been modified
       * after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or Put Block
       * List.
       */
      Nullable<std::string> CopyStatusDescription;
      /**
       * Contains the number of bytes copied and the total bytes in the source in the last attempted
       * Copy Blob operation where this blob was the destination blob. Can show between 0 and
       * Content-Length bytes copied. This header does not appear if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<std::string> CopyProgress;
      /**
       * Conclusion time of the last attempted Copy Blob operation where this blob was the
       * destination blob. This value can specify the time of a completed, aborted, or failed copy
       * attempt. This header does not appear if a copy is pending, if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<DateTime> CopyCompletedOn;
      /**
       * A string value returned by the service that uniquely identifies the blob version.
       */
      Nullable<std::string> VersionId;
      /**
       * Indicates whether version of this blob is the current version.
       */
      Nullable<bool> IsCurrentVersion;
      /**
       * Immutability policy associated with the blob.
       */
      Nullable<BlobImmutabilityPolicy> ImmutabilityPolicy;
      /**
       * Indicates whether the blob has a legal hold.
       */
      bool HasLegalHold = false;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::Download.
     */
    struct DownloadBlobResult final
    {
      /**
       * Detailed information of the downloaded blob.
       */
      DownloadBlobDetails Details;
      /**
       * Size of the blob in bytes.
       */
      int64_t BlobSize = int64_t();
      /**
       * Indicates the range of bytes returned.
       */
      Core::Http::HttpRange ContentRange;
      /**
       * CRC64 or MD5 hash for the downloaded range of data.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * Content of the blob or blob range.
       */
      std::unique_ptr<Core::IO::BodyStream> BodyStream;
      /**
       * The blob's type.
       */
      Models::BlobType BlobType;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::GetProperties.
     */
    struct BlobProperties final
    {
      /**
       * Array of ObjectReplicationPolicy.
       */
      std::vector<ObjectReplicationPolicy> ObjectReplicationSourceProperties;
      /**
       * Immutability policy associated with the blob.
       */
      Nullable<BlobImmutabilityPolicy> ImmutabilityPolicy;
      /**
       * Standard HTTP properties supported by containers and blobs.
       */
      BlobHttpHeaders HttpHeaders;
      /**
       * Returns the date and time the blob was last modified. Any operation that modifies the blob,
       * including an update of the blob's metadata or properties, changes the last-modified time of
       * the blob.
       */
      DateTime LastModified;
      /**
       * Returns the date and time the blob was created.
       */
      DateTime CreatedOn;
      /**
       * A set of name-value pair associated with this blob.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * Optional. Only valid when Object Replication is enabled for the storage container and on
       * the destination blob of the replication.
       */
      Nullable<std::string> ObjectReplicationDestinationPolicyId;
      /**
       * The blob's type.
       */
      Models::BlobType BlobType;
      /**
       * Conclusion time of the last attempted Copy Blob operation where this blob was the
       * destination blob. This value can specify the time of a completed, aborted, or failed copy
       * attempt. This header does not appear if a copy is pending, if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<DateTime> CopyCompletedOn;
      /**
       * Only appears when x-ms-copy-status is failed or pending. Describes the cause of the last
       * fatal or non-fatal copy operation failure. This header does not appear if this blob has
       * never been the destination in a Copy Blob operation, or if this blob has been modified
       * after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or Put Block
       * List.
       */
      Nullable<std::string> CopyStatusDescription;
      /**
       * String identifier for this copy operation. Use with Get Blob Properties to check the status
       * of this copy operation, or pass to Abort Copy Blob to abort a pending copy.
       */
      Nullable<std::string> CopyId;
      /**
       * Contains the number of bytes copied and the total bytes in the source in the last attempted
       * Copy Blob operation where this blob was the destination blob. Can show between 0 and
       * Content-Length bytes copied. This header does not appear if this blob has never been the
       * destination in a Copy Blob operation, or if this blob has been modified after a concluded
       * Copy Blob operation using Set Blob Properties, Put Blob, or Put Block List.
       */
      Nullable<std::string> CopyProgress;
      /**
       * URL up to 2 KB in length that specifies the source blob or file used in the last attempted
       * Copy Blob operation where this blob was the destination blob. This header does not appear
       * if this blob has never been the destination in a Copy Blob operation, or if this blob has
       * been modified after a concluded Copy Blob operation using Set Blob Properties, Put Blob, or
       * Put Block List.
       */
      Nullable<std::string> CopySource;
      /**
       * State of the copy operation identified by x-ms-copy-id.
       */
      Nullable<Models::CopyStatus> CopyStatus;
      /**
       * Included if the blob is incremental copy blob.
       */
      Nullable<bool> IsIncrementalCopy;
      /**
       * Included if the blob is incremental copy blob or incremental copy snapshot, if
       * x-ms-copy-status is success. Snapshot time of the last successful incremental copy snapshot
       * for this blob.
       */
      Nullable<std::string> IncrementalCopyDestinationSnapshot;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * Lease state of the blob.
       */
      Nullable<Models::LeaseState> LeaseState;
      /**
       * The current lease status of the blob.
       */
      Nullable<Models::LeaseStatus> LeaseStatus;
      /**
       * Size of the blob in bytes.
       */
      int64_t BlobSize = int64_t();
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * The current sequence number for a page blob. This header is not returned for block blobs or
       * append blobs.
       */
      Nullable<int64_t> SequenceNumber;
      /**
       * The number of committed blocks present in the blob. This header is returned only for append
       * blobs.
       */
      Nullable<int32_t> CommittedBlockCount;
      /**
       * The value of this header is set to true if the blob data and application metadata are
       * completely encrypted using the specified algorithm. Otherwise, the value is set to false
       * (when the blob is unencrypted, or if only parts of the blob/application metadata are
       * encrypted).
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the metadata. This header is only
       * returned when the metadata was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
      /**
       * The tier of page blob on a premium storage account or tier of block blob on blob storage
       * LRS accounts. For a list of allowed premium page blob tiers, see
       * https://docs.microsoft.com/en-us/azure/virtual-machines/windows/premium-storage#features.
       * For blob storage LRS accounts, valid values are Hot/Cool/Archive.
       */
      Nullable<Models::AccessTier> AccessTier;
      /**
       * For page blobs on a premium storage account only. If the access tier is not explicitly set
       * on the blob, the tier is inferred based on its content length and this header will be
       * returned with true value.
       */
      Nullable<bool> IsAccessTierInferred;
      /**
       * For blob storage LRS accounts, valid values are
       * rehydrate-pending-to-hot/rehydrate-pending-to-cool. If the blob is being rehydrated and is
       * not complete then this header is returned indicating that rehydrate is pending and also
       * tells the destination tier.
       */
      Nullable<Models::ArchiveStatus> ArchiveStatus;
      /**
       * The time the tier was changed on the object. This is only returned if the tier on the block
       * blob was ever set.
       */
      Nullable<DateTime> AccessTierChangedOn;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header indicates whether version of this blob is a current version, see
       * also x-ms-version-id header.
       */
      Nullable<bool> IsCurrentVersion;
      /**
       * The number of tags associated with the blob.
       */
      Nullable<int32_t> TagCount;
      /**
       * The time this blob will expire.
       */
      Nullable<DateTime> ExpiresOn;
      /**
       * If this blob has been sealed.
       */
      Nullable<bool> IsSealed;
      /**
       * If an object is in rehydrate pending state then this header is returned with priority of
       * rehydrate. Valid values are High and Standard.
       */
      Nullable<Models::RehydratePriority> RehydratePriority;
      /**
       * UTC date/time value generated by the service that indicates the time at which the blob was
       * last read or written to.
       */
      Nullable<DateTime> LastAccessedOn;
      /**
       * Indicates if a legal hold is present on the blob.
       */
      bool HasLegalHold = false;
    };
    /**
     * @brief Required if the blob has associated snapshots. Specify one of the following two
     * options: include: Delete the base blob and all of its snapshots. only: Delete only the blob's
     * snapshots and not the blob itself.
     */
    class DeleteSnapshotsOption final {
    public:
      /** Constructs a new DeleteSnapshotsOption instance */
      DeleteSnapshotsOption() = default;
      /** Constructs a new DeleteSnapshotsOption from a string. */
      explicit DeleteSnapshotsOption(std::string value) : m_value(std::move(value)) {}
      /** Compares with another DeleteSnapshotsOption. */
      bool operator==(const DeleteSnapshotsOption& other) const { return m_value == other.m_value; }
      /** Compares with another DeleteSnapshotsOption. */
      bool operator!=(const DeleteSnapshotsOption& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type DeleteSnapshotsOption: IncludeSnapshots */
      AZ_STORAGE_BLOBS_DLLEXPORT const static DeleteSnapshotsOption IncludeSnapshots;
      /** Constant value of type DeleteSnapshotsOption: OnlySnapshots */
      AZ_STORAGE_BLOBS_DLLEXPORT const static DeleteSnapshotsOption OnlySnapshots;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::Delete.
     */
    struct DeleteBlobResult final
    {
      /**
       * Indicates if the blob was successfully deleted by this operation.
       */
      bool Deleted = true;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::Undelete.
     */
    struct UndeleteBlobResult final
    {
    };
    /**
     * @brief Required. Indicates mode of the expiry time.
     */
    class ScheduleBlobExpiryOriginType final {
    public:
      /** Constructs a new ScheduleBlobExpiryOriginType instance */
      ScheduleBlobExpiryOriginType() = default;
      /** Constructs a new ScheduleBlobExpiryOriginType from a string. */
      explicit ScheduleBlobExpiryOriginType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another ScheduleBlobExpiryOriginType. */
      bool operator==(const ScheduleBlobExpiryOriginType& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another ScheduleBlobExpiryOriginType. */
      bool operator!=(const ScheduleBlobExpiryOriginType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type ScheduleBlobExpiryOriginType: NeverExpire */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ScheduleBlobExpiryOriginType NeverExpire;
      /** Constant value of type ScheduleBlobExpiryOriginType: RelativeToCreation */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ScheduleBlobExpiryOriginType RelativeToCreation;
      /** Constant value of type ScheduleBlobExpiryOriginType: RelativeToNow */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ScheduleBlobExpiryOriginType RelativeToNow;
      /** Constant value of type ScheduleBlobExpiryOriginType: Absolute */
      AZ_STORAGE_BLOBS_DLLEXPORT const static ScheduleBlobExpiryOriginType Absolute;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for Azure::Storage::Blobs::BlobClient::SetExpiry.
     */
    struct SetBlobExpiryResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetHttpHeaders.
     */
    struct SetBlobHttpHeadersResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The current sequence number for a page blob. This header is not returned for block blobs or
       * append blobs.
       */
      Nullable<int64_t> SequenceNumber;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetImmutabilityPolicy.
     */
    struct SetBlobImmutabilityPolicyResult final
    {
      /**
       * Immutability policy associated with the blob.
       */
      BlobImmutabilityPolicy ImmutabilityPolicy;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::DeleteImmutabilityPolicy.
     */
    struct DeleteBlobImmutabilityPolicyResult final
    {
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetLegalHold.
     */
    struct SetBlobLegalHoldResult final
    {
      /**
       * Indicates if the blob has a legal hold.
       */
      bool HasLegalHold = bool();
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetMetadata.
     */
    struct SetBlobMetadataResult final
    {
      /**
       * The field is deprecated and is always null. Use GetProperties() instead to check sequence
       * number for a page blob.
       */
      Nullable<int64_t> SequenceNumber;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the metadata. This header is only
       * returned when the metadata was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::AcquireLease.
       */
      struct AcquireBlobLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the blob was last modified. Any operation that modifies the
         * blob, including an update of the blob's metadata or properties, changes the last-modified
         * time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a blob's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::ReleaseLease.
       */
      struct ReleaseBlobLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the blob was last modified. Any operation that modifies the
         * blob, including an update of the blob's metadata or properties, changes the last-modified
         * time of the blob.
         */
        DateTime LastModified;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::RenewLease.
       */
      struct RenewBlobLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the blob was last modified. Any operation that modifies the
         * blob, including an update of the blob's metadata or properties, changes the last-modified
         * time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a blob's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::ChangeLease.
       */
      struct ChangeBlobLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the blob was last modified. Any operation that modifies the
         * blob, including an update of the blob's metadata or properties, changes the last-modified
         * time of the blob.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a blob's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::BreakLease.
       */
      struct BreakBlobLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the blob was last modified. Any operation that modifies the
         * blob, including an update of the blob's metadata or properties, changes the last-modified
         * time of the blob.
         */
        DateTime LastModified;
        /**
         * Approximate time remaining in the lease period, in seconds.
         */
        int32_t LeaseTime = int32_t();
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::CreateSnapshot.
     */
    struct CreateBlobSnapshotResult final
    {
      /**
       * The field is deprecated and is always null. Use GetProperties() instead to get SHA256 of
       * the encryption key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * The field is deprecated and is always null. Use GetProperties() instead to check the
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
      /**
       * Uniquely identifies the snapshot and indicates the snapshot version. It may be used in
       * subsequent requests to access the snapshot.
       */
      std::string Snapshot;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * True if the contents of the request are successfully encrypted using the specified
       * algorithm, and false otherwise. For a snapshot request, this header is set to true when
       * metadata was provided in the request and encrypted with a customer-provided key.
       */
      bool IsServerEncrypted = bool();
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Blobs::BlobClient::StartCopyFromUri.
       */
      struct StartBlobCopyFromUriResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * A DateTime value returned by the service that uniquely identifies the blob. The value of
         * this header indicates the blob version, and may be used in subsequent requests to access
         * this version of the blob.
         */
        Nullable<std::string> VersionId;
        /**
         * String identifier for this copy operation. Use with Get Blob Properties to check the
         * status of this copy operation, or pass to Abort Copy Blob to abort a pending copy.
         */
        std::string CopyId;
        /**
         * State of the copy operation identified by x-ms-copy-id.
         */
        Models::CopyStatus CopyStatus;
      };
    } // namespace _detail
    /**
     * @brief Optional, default 'replace'.  Indicates if source tags should be copied or replaced
     * with the tags specified by x-ms-tags.
     */
    class BlobCopySourceTagsMode final {
    public:
      /** Constructs a new BlobCopySourceTagsMode instance */
      BlobCopySourceTagsMode() = default;
      /** Constructs a new BlobCopySourceTagsMode from a string. */
      explicit BlobCopySourceTagsMode(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlobCopySourceTagsMode. */
      bool operator==(const BlobCopySourceTagsMode& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another BlobCopySourceTagsMode. */
      bool operator!=(const BlobCopySourceTagsMode& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlobCopySourceTagsMode: Replace */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobCopySourceTagsMode Replace;
      /** Constant value of type BlobCopySourceTagsMode: Copy */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobCopySourceTagsMode Copy;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::CopyFromUri.
     */
    struct CopyBlobFromUriResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * String identifier for this copy operation.
       */
      std::string CopyId;
      /**
       * State of the copy operation identified by x-ms-copy-id.
       */
      Models::CopyStatus CopyStatus;
      /**
       * This response header is returned so that the client can check for the integrity of the
       * copied content. This header is only returned if the source content MD5 was specified.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::AbortCopyFromUri.
     */
    struct AbortBlobCopyFromUriResult final
    {
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetAccessTier.
     */
    struct SetBlobAccessTierResult final
    {
    };
    namespace _detail {
      /**
       * @brief Required. The type of the provided query expression.
       */
      class QueryRequestQueryType final {
      public:
        /** Constructs a new QueryRequestQueryType instance */
        QueryRequestQueryType() = default;
        /** Constructs a new QueryRequestQueryType from a string. */
        explicit QueryRequestQueryType(std::string value) : m_value(std::move(value)) {}
        /** Compares with another QueryRequestQueryType. */
        bool operator==(const QueryRequestQueryType& other) const
        {
          return m_value == other.m_value;
        }
        /** Compares with another QueryRequestQueryType. */
        bool operator!=(const QueryRequestQueryType& other) const { return !(*this == other); }
        /** Converts the value to a string. */
        const std::string& ToString() const { return m_value; }
        /** Constant value of type QueryRequestQueryType: SQL */
        AZ_STORAGE_BLOBS_DLLEXPORT const static QueryRequestQueryType SQL;

      private:
        std::string m_value;
      };
      /**
       * @brief The quick query format type.
       */
      class QueryFormatType final {
      public:
        /** Constructs a new QueryFormatType instance */
        QueryFormatType() = default;
        /** Constructs a new QueryFormatType from a string. */
        explicit QueryFormatType(std::string value) : m_value(std::move(value)) {}
        /** Compares with another QueryFormatType. */
        bool operator==(const QueryFormatType& other) const { return m_value == other.m_value; }
        /** Compares with another QueryFormatType. */
        bool operator!=(const QueryFormatType& other) const { return !(*this == other); }
        /** Converts the value to a string. */
        const std::string& ToString() const { return m_value; }
        /** Constant value of type QueryFormatType: Delimited */
        AZ_STORAGE_BLOBS_DLLEXPORT const static QueryFormatType Delimited;
        /** Constant value of type QueryFormatType: Json */
        AZ_STORAGE_BLOBS_DLLEXPORT const static QueryFormatType Json;
        /** Constant value of type QueryFormatType: Arrow */
        AZ_STORAGE_BLOBS_DLLEXPORT const static QueryFormatType Arrow;
        /** Constant value of type QueryFormatType: Parquet */
        AZ_STORAGE_BLOBS_DLLEXPORT const static QueryFormatType Parquet;

      private:
        std::string m_value;
      };
      /**
       * @brief Groups the settings used for interpreting the blob data if the blob is delimited
       * text formatted.
       */
      struct DelimitedTextConfiguration final
      {
        /**
         * The string used to separate columns.
         */
        std::string ColumnSeparator;
        /**
         * The string used to quote a specific field.
         */
        std::string FieldQuote;
        /**
         * The string used to separate records.
         */
        std::string RecordSeparator;
        /**
         * The string used as an escape character.
         */
        std::string EscapeChar;
        /**
         * Represents whether the data has headers.
         */
        bool HeadersPresent = bool();
      };
      /**
       * @brief Json text configuration.
       */
      struct JsonTextConfiguration final
      {
        /**
         * The string used to separate records.
         */
        std::string RecordSeparator;
      };
    } // namespace _detail
    /**
     * @brief Type of blob query arrow field.
     */
    class BlobQueryArrowFieldType final {
    public:
      /** Constructs a new BlobQueryArrowFieldType instance */
      BlobQueryArrowFieldType() = default;
      /** Constructs a new BlobQueryArrowFieldType from a string. */
      explicit BlobQueryArrowFieldType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlobQueryArrowFieldType. */
      bool operator==(const BlobQueryArrowFieldType& other) const
      {
        return m_value == other.m_value;
      }
      /** Compares with another BlobQueryArrowFieldType. */
      bool operator!=(const BlobQueryArrowFieldType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlobQueryArrowFieldType: Int64 */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType Int64;
      /** Constant value of type BlobQueryArrowFieldType: Bool */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType Bool;
      /** Constant value of type BlobQueryArrowFieldType: Timestamp */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType Timestamp;
      /** Constant value of type BlobQueryArrowFieldType: String */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType String;
      /** Constant value of type BlobQueryArrowFieldType: Double */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType Double;
      /** Constant value of type BlobQueryArrowFieldType: Decimal */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlobQueryArrowFieldType Decimal;

    private:
      std::string m_value;
    };
    /**
     * @brief Groups settings regarding specific field of an arrow schema.
     */
    struct BlobQueryArrowField final
    {
      /**
       * Type of blob query arrow field.
       */
      BlobQueryArrowFieldType Type;
      /**
       * Name of the field.
       */
      Nullable<std::string> Name;
      /**
       * Precision of the field.
       */
      Nullable<int32_t> Precision;
      /**
       * Scale of the field.
       */
      Nullable<int32_t> Scale;
    };
    namespace _detail {
      /**
       * @brief Groups the settings used for formatting the response if the response should be Arrow
       * formatted.
       */
      struct ArrowConfiguration final
      {
        /**
         * Array of BlobQueryArrowField.
         */
        std::vector<BlobQueryArrowField> Schema;
      };
      /**
       * @brief Parquet configuration.
       */
      struct ParquetConfiguration final
      {
      };
      struct QueryFormat final
      {
        /**
         * The quick query format type.
         */
        QueryFormatType Type;
        /**
         * Groups the settings used for interpreting the blob data if the blob is delimited text
         * formatted.
         */
        Nullable<_detail::DelimitedTextConfiguration> DelimitedTextConfiguration;
        /**
         * Json text configuration.
         */
        Nullable<_detail::JsonTextConfiguration> JsonTextConfiguration;
        /**
         * Groups the settings used for formatting the response if the response should be Arrow
         * formatted.
         */
        Nullable<_detail::ArrowConfiguration> ArrowConfiguration;
        /**
         * Parquet configuration.
         */
        Nullable<ParquetConfiguration> ParquetTextConfiguration;
      };
      struct QuerySerialization final
      {
        QueryFormat Format;
      };
      /**
       * @brief Groups the set of query request settings.
       */
      struct QueryRequest final
      {
        /**
         * Required. The type of the provided query expression.
         */
        QueryRequestQueryType QueryType;
        /**
         * The query expression in SQL. The maximum size of the query expression is 256KiB.
         */
        std::string Expression;
        Nullable<QuerySerialization> InputSerialization;
        Nullable<QuerySerialization> OutputSerialization;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::Query.
     */
    struct QueryBlobResult final
    {
      /**
       * The response body stream.
       */
      std::unique_ptr<Core::IO::BodyStream> BodyStream;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * When a blob is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * Lease state of the blob.
       */
      Models::LeaseState LeaseState;
      /**
       * The current lease status of the blob.
       */
      Models::LeaseStatus LeaseStatus;
      /**
       * The value of this header is set to true if the blob data and application metadata are
       * completely encrypted using the specified algorithm. Otherwise, the value is set to false
       * (when the blob is unencrypted, or if only parts of the blob/application metadata are
       * encrypted).
       */
      bool IsServerEncrypted = bool();
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlobClient::SetTags.
     */
    struct SetBlobTagsResult final
    {
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::Create.
     */
    struct CreatePageBlobResult final
    {
      /**
       * Indicates if the page blob was successfully created by this operation.
       */
      bool Created = true;
      /**
       * The field is deprecated and is always null. Use GetProperties() instead to check sequence
       * number for a page blob.
       */
      Nullable<int64_t> SequenceNumber;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::UploadPages.
     */
    struct UploadPagesResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * The current sequence number for the page blob.
       */
      int64_t SequenceNumber = int64_t();
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the pages. This header is only
       * returned when the pages were encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::ClearPages.
     */
    struct ClearPagesResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The current sequence number for the page blob.
       */
      int64_t SequenceNumber = int64_t();
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::UploadPagesFromUri.
     */
    struct UploadPagesFromUriResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * The current sequence number for the page blob.
       */
      int64_t SequenceNumber = int64_t();
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::GetPageRanges.
       */
      struct GetPageRangesResult final
      {
        Azure::ETag ETag;
        DateTime LastModified;
        /**
         * Size of the blob in bytes.
         */
        int64_t BlobSize = int64_t();
        /**
         * Array of PageRange.
         */
        std::vector<Core::Http::HttpRange> PageRanges;
        /**
         * Array of ClearRange.
         */
        std::vector<Core::Http::HttpRange> ClearRanges;
        std::string ContinuationToken;
      };
      /**
       * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::GetPageRangesDiff.
       */
      struct GetPageRangesDiffResult final
      {
        Azure::ETag ETag;
        DateTime LastModified;
        /**
         * Size of the blob in bytes.
         */
        int64_t BlobSize = int64_t();
        /**
         * Array of PageRange.
         */
        std::vector<Core::Http::HttpRange> PageRanges;
        /**
         * Array of ClearRange.
         */
        std::vector<Core::Http::HttpRange> ClearRanges;
        std::string ContinuationToken;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::Resize.
     */
    struct ResizePageBlobResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The current sequence number for a page blob. This header is not returned for block blobs or
       * append blobs.
       */
      int64_t SequenceNumber = int64_t();
    };
    /**
     * @brief Required if the x-ms-blob-sequence-number header is set for the request. This property
     * applies to page blobs only. This property indicates how the service should modify the blob's
     * sequence number.
     */
    class SequenceNumberAction final {
    public:
      /** Constructs a new SequenceNumberAction instance */
      SequenceNumberAction() = default;
      /** Constructs a new SequenceNumberAction from a string. */
      explicit SequenceNumberAction(std::string value) : m_value(std::move(value)) {}
      /** Compares with another SequenceNumberAction. */
      bool operator==(const SequenceNumberAction& other) const { return m_value == other.m_value; }
      /** Compares with another SequenceNumberAction. */
      bool operator!=(const SequenceNumberAction& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type SequenceNumberAction: Max */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SequenceNumberAction Max;
      /** Constant value of type SequenceNumberAction: Update */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SequenceNumberAction Update;
      /** Constant value of type SequenceNumberAction: Increment */
      AZ_STORAGE_BLOBS_DLLEXPORT const static SequenceNumberAction Increment;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::UpdateSequenceNumber.
     */
    struct UpdateSequenceNumberResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * The current sequence number for a page blob. This header is not returned for block blobs or
       * append blobs.
       */
      int64_t SequenceNumber = int64_t();
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Blobs::PageBlobClient::StartCopyIncremental.
       */
      struct StartBlobCopyIncrementalResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the container was last modified. Any operation that modifies
         * the blob, including an update of the blob's metadata or properties, changes the
         * last-modified time of the blob.
         */
        DateTime LastModified;
        /**
         * String identifier for this copy operation. Use with Get Blob Properties to check the
         * status of this copy operation, or pass to Abort Copy Blob to abort a pending copy.
         */
        std::string CopyId;
        /**
         * State of the copy operation identified by x-ms-copy-id.
         */
        Models::CopyStatus CopyStatus;
        /**
         * A DateTime value returned by the service that uniquely identifies the blob. The value of
         * this header indicates the blob version, and may be used in subsequent requests to access
         * this version of the blob.
         */
        Nullable<std::string> VersionId;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Blobs::AppendBlobClient::Create.
     */
    struct CreateAppendBlobResult final
    {
      /**
       * Indicates if the append blob was successfully created by this operation.
       */
      bool Created = true;
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::AppendBlobClient::AppendBlock.
     */
    struct AppendBlockResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * This response header is returned only for append operations. It returns the offset at which
       * the block was committed, in bytes.
       */
      int64_t AppendOffset = int64_t();
      /**
       * The number of committed blocks present in the blob. This header is returned only for append
       * blobs.
       */
      int32_t CommittedBlockCount = int32_t();
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the block. This header is only
       * returned when the block was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::AppendBlobClient::AppendBlockFromUri.
     */
    struct AppendBlockFromUriResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * This response header is returned only for append operations. It returns the offset at which
       * the block was committed, in bytes.
       */
      int64_t AppendOffset = int64_t();
      /**
       * The number of committed blocks present in the blob. This header is returned only for append
       * blobs.
       */
      int32_t CommittedBlockCount = int32_t();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the block. This header is only
       * returned when the block was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::AppendBlobClient::Seal.
     */
    struct SealAppendBlobResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If this blob has been sealed.
       */
      bool IsSealed = bool();
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::Upload.
     */
    struct UploadBlockBlobResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::UploadFromUri.
     */
    struct UploadBlockBlobFromUriResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * If the blob has an MD5 hash and this operation is to read the full blob, this response
       * header is returned so that the client can check for message content integrity.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::StageBlock.
     */
    struct StageBlockResult final
    {
      /**
       * This header is returned so that the client can check for message content integrity. The
       * value of this header is computed by the Blob service; it is not necessarily the same value
       * specified in the request headers.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the block. This header is only
       * returned when the block was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::StageBlockFromUri.
     */
    struct StageBlockFromUriResult final
    {
      /**
       * This header is returned so that the client can check for message content integrity. The
       * value of this header is computed by the Blob service; it is not necessarily the same value
       * specified in the request headers.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the block. This header is only
       * returned when the block was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    namespace _detail {
      struct BlockLookupList final
      {
        /**
         * Array of BlockLookupListCommittedItem.
         */
        std::vector<std::string> Committed;
        /**
         * Array of BlockLookupListUncommittedItem.
         */
        std::vector<std::string> Uncommitted;
        /**
         * Array of BlockLookupListLatestItem.
         */
        std::vector<std::string> Latest;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::CommitBlockList.
     */
    struct CommitBlockListResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * This header is returned so that the client can check for message content integrity. This
       * header refers to the content of the request, meaning, in this case, the list of blocks, and
       * not the content of the blob itself.
       */
      Nullable<ContentHash> TransactionalContentHash;
      /**
       * A DateTime value returned by the service that uniquely identifies the blob. The value of
       * this header indicates the blob version, and may be used in subsequent requests to access
       * this version of the blob.
       */
      Nullable<std::string> VersionId;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
      /**
       * The SHA-256 hash of the encryption key used to encrypt the blob. This header is only
       * returned when the blob was encrypted with a customer-provided key.
       */
      Nullable<std::vector<uint8_t>> EncryptionKeySha256;
      /**
       * Returns the name of the encryption scope used to encrypt the blob contents and application
       * metadata.  Note that the absence of this header implies use of the default account
       * encryption scope.
       */
      Nullable<std::string> EncryptionScope;
    };
    /**
     * @brief Represents a single block in a block blob.  It describes the block's ID and size.
     */
    struct BlobBlock final
    {
      /**
       * The base64 encoded block ID.
       */
      std::string Name;
      /**
       * The block size in bytes.
       */
      int64_t Size = int64_t();
    };
    /**
     * @brief Specifies whether to return the list of committed blocks, the list of uncommitted
     * blocks, or both lists together.
     */
    class BlockListType final {
    public:
      /** Constructs a new BlockListType instance */
      BlockListType() = default;
      /** Constructs a new BlockListType from a string. */
      explicit BlockListType(std::string value) : m_value(std::move(value)) {}
      /** Compares with another BlockListType. */
      bool operator==(const BlockListType& other) const { return m_value == other.m_value; }
      /** Compares with another BlockListType. */
      bool operator!=(const BlockListType& other) const { return !(*this == other); }
      /** Converts the value to a string. */
      const std::string& ToString() const { return m_value; }
      /** Constant value of type BlockListType: Committed */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockListType Committed;
      /** Constant value of type BlockListType: Uncommitted */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockListType Uncommitted;
      /** Constant value of type BlockListType: All */
      AZ_STORAGE_BLOBS_DLLEXPORT const static BlockListType All;

    private:
      std::string m_value;
    };
    /**
     * @brief Response type for #Azure::Storage::Blobs::BlockBlobClient::GetBlockList.
     */
    struct GetBlockListResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally. If the
       * request version is 2011-08-18 or newer, the ETag value will be in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the container was last modified. Any operation that modifies the
       * blob, including an update of the blob's metadata or properties, changes the last-modified
       * time of the blob.
       */
      DateTime LastModified;
      /**
       * Size of the blob in bytes.
       */
      int64_t BlobSize = 0;
      /**
       * List of committed blocks.
       */
      std::vector<BlobBlock> CommittedBlocks;
      /**
       * List of uncommitted blocks.
       */
      std::vector<BlobBlock> UncommittedBlocks;
    };
  } // namespace Models
  namespace _detail {
    class ServiceClient final {
    public:
      struct SetServicePropertiesOptions final
      {
        Models::BlobServiceProperties BlobServiceProperties;
      };
      static Response<Models::SetServicePropertiesResult> SetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetServicePropertiesOptions& options,
          const Core::Context& context);
      struct GetServicePropertiesOptions final
      {
      };
      static Response<Models::BlobServiceProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServicePropertiesOptions& options,
          const Core::Context& context);
      struct GetServiceStatisticsOptions final
      {
      };
      static Response<Models::ServiceStatistics> GetStatistics(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServiceStatisticsOptions& options,
          const Core::Context& context);
      struct ListServiceBlobContainersOptions final
      {
        Nullable<std::string> Prefix;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
        Nullable<Models::ListBlobContainersIncludeFlags> Include;
      };
      static Response<Models::_detail::ListBlobContainersResult> ListBlobContainers(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListServiceBlobContainersOptions& options,
          const Core::Context& context);
      struct GetServiceUserDelegationKeyOptions final
      {
        Models::_detail::KeyInfo KeyInfo;
      };
      static Response<Models::UserDelegationKey> GetUserDelegationKey(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServiceUserDelegationKeyOptions& options,
          const Core::Context& context);
      struct GetServiceAccountInfoOptions final
      {
      };
      static Response<Models::AccountInfo> GetAccountInfo(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServiceAccountInfoOptions& options,
          const Core::Context& context);
      struct SubmitServiceBatchOptions final
      {
        std::string MultipartContentType;
      };
      static Response<Models::_detail::SubmitBatchResult> SubmitBatch(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const SubmitServiceBatchOptions& options,
          const Core::Context& context);
      struct FindServiceBlobsByTagsOptions final
      {
        Nullable<std::string> Where;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
      };
      static Response<Models::_detail::FindBlobsByTagsResult> FindBlobsByTags(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const FindServiceBlobsByTagsOptions& options,
          const Core::Context& context);
    };
    class BlobContainerClient final {
    public:
      struct CreateBlobContainerOptions final
      {
        std::map<std::string, std::string> Metadata;
        Models::PublicAccessType Access;
        Nullable<std::string> DefaultEncryptionScope;
        Nullable<bool> PreventEncryptionScopeOverride;
      };
      static Response<Models::CreateBlobContainerResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateBlobContainerOptions& options,
          const Core::Context& context);
      struct GetBlobContainerPropertiesOptions final
      {
        Nullable<std::string> LeaseId;
      };
      static Response<Models::BlobContainerProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetBlobContainerPropertiesOptions& options,
          const Core::Context& context);
      struct DeleteBlobContainerOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::DeleteBlobContainerResult> Delete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteBlobContainerOptions& options,
          const Core::Context& context);
      struct SetBlobContainerMetadataOptions final
      {
        Nullable<std::string> LeaseId;
        std::map<std::string, std::string> Metadata;
        Nullable<DateTime> IfModifiedSince;
      };
      static Response<Models::SetBlobContainerMetadataResult> SetMetadata(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobContainerMetadataOptions& options,
          const Core::Context& context);
      struct GetBlobContainerAccessPolicyOptions final
      {
        Nullable<std::string> LeaseId;
      };
      static Response<Models::BlobContainerAccessPolicy> GetAccessPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetBlobContainerAccessPolicyOptions& options,
          const Core::Context& context);
      struct SetBlobContainerAccessPolicyOptions final
      {
        std::vector<Models::SignedIdentifier> ContainerAcl;
        Nullable<std::string> LeaseId;
        Models::PublicAccessType Access;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::SetBlobContainerAccessPolicyResult> SetAccessPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobContainerAccessPolicyOptions& options,
          const Core::Context& context);
      struct UndeleteBlobContainerOptions final
      {
        Nullable<std::string> DeletedContainerName;
        Nullable<std::string> DeletedContainerVersion;
      };
      static Response<Models::_detail::UndeleteBlobContainerResult> Undelete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UndeleteBlobContainerOptions& options,
          const Core::Context& context);
      struct RenameBlobContainerOptions final
      {
        std::string SourceContainerName;
        Nullable<std::string> SourceLeaseId;
      };
      static Response<Models::_detail::RenameBlobContainerResult> Rename(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenameBlobContainerOptions& options,
          const Core::Context& context);
      struct SubmitBlobContainerBatchOptions final
      {
        std::string MultipartContentType;
      };
      static Response<Models::_detail::SubmitBatchResult> SubmitBatch(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const SubmitBlobContainerBatchOptions& options,
          const Core::Context& context);
      struct FindBlobContainerBlobsByTagsOptions final
      {
        Nullable<std::string> Where;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
      };
      static Response<Models::_detail::FindBlobsByTagsResult> FindBlobsByTags(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const FindBlobContainerBlobsByTagsOptions& options,
          const Core::Context& context);
      struct AcquireBlobContainerLeaseOptions final
      {
        Nullable<int32_t> Duration;
        Nullable<std::string> ProposedLeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::_detail::AcquireBlobContainerLeaseResult> AcquireLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AcquireBlobContainerLeaseOptions& options,
          const Core::Context& context);
      struct ReleaseBlobContainerLeaseOptions final
      {
        std::string LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::_detail::ReleaseBlobContainerLeaseResult> ReleaseLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ReleaseBlobContainerLeaseOptions& options,
          const Core::Context& context);
      struct RenewBlobContainerLeaseOptions final
      {
        std::string LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::_detail::RenewBlobContainerLeaseResult> RenewLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenewBlobContainerLeaseOptions& options,
          const Core::Context& context);
      struct BreakBlobContainerLeaseOptions final
      {
        Nullable<int32_t> BreakPeriod;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::_detail::BreakBlobContainerLeaseResult> BreakLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const BreakBlobContainerLeaseOptions& options,
          const Core::Context& context);
      struct ChangeBlobContainerLeaseOptions final
      {
        std::string LeaseId;
        std::string ProposedLeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
      };
      static Response<Models::_detail::ChangeBlobContainerLeaseResult> ChangeLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ChangeBlobContainerLeaseOptions& options,
          const Core::Context& context);
      struct ListBlobContainerBlobsOptions final
      {
        Nullable<std::string> Prefix;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
        Nullable<Models::ListBlobsIncludeFlags> Include;
      };
      static Response<Models::_detail::ListBlobsResult> ListBlobs(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListBlobContainerBlobsOptions& options,
          const Core::Context& context);
      struct ListBlobContainerBlobsByHierarchyOptions final
      {
        Nullable<std::string> Prefix;
        std::string Delimiter;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
        Nullable<Models::ListBlobsIncludeFlags> Include;
        Nullable<std::string> ShowOnly;
      };
      static Response<Models::_detail::ListBlobsByHierarchyResult> ListBlobsByHierarchy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListBlobContainerBlobsByHierarchyOptions& options,
          const Core::Context& context);
    };
    class BlobClient final {
    public:
      struct DownloadBlobOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> VersionId;
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<bool> RangeGetContentMD5;
        Nullable<bool> RangeGetContentCRC64;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::DownloadBlobResult> Download(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DownloadBlobOptions& options,
          const Core::Context& context);
      struct GetBlobPropertiesOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> VersionId;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::BlobProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetBlobPropertiesOptions& options,
          const Core::Context& context);
      struct DeleteBlobOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> VersionId;
        Nullable<std::string> LeaseId;
        Nullable<Models::DeleteSnapshotsOption> DeleteSnapshots;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::DeleteBlobResult> Delete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteBlobOptions& options,
          const Core::Context& context);
      struct UndeleteBlobOptions final
      {
      };
      static Response<Models::UndeleteBlobResult> Undelete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UndeleteBlobOptions& options,
          const Core::Context& context);
      struct SetBlobExpiryOptions final
      {
        Models::ScheduleBlobExpiryOriginType ExpiryOptions;
        Nullable<std::string> ExpiresOn;
      };
      static Response<Models::SetBlobExpiryResult> SetExpiry(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobExpiryOptions& options,
          const Core::Context& context);
      struct SetBlobHttpHeadersOptions final
      {
        std::string BlobCacheControl;
        std::string BlobContentType;
        std::vector<uint8_t> BlobContentMD5;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        std::string BlobContentDisposition;
      };
      static Response<Models::SetBlobHttpHeadersResult> SetHttpHeaders(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobHttpHeadersOptions& options,
          const Core::Context& context);
      struct SetBlobImmutabilityPolicyOptions final
      {
        Nullable<DateTime> IfUnmodifiedSince;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
      };
      static Response<Models::SetBlobImmutabilityPolicyResult> SetImmutabilityPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobImmutabilityPolicyOptions& options,
          const Core::Context& context);
      struct DeleteBlobImmutabilityPolicyOptions final
      {
      };
      static Response<Models::DeleteBlobImmutabilityPolicyResult> DeleteImmutabilityPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteBlobImmutabilityPolicyOptions& options,
          const Core::Context& context);
      struct SetBlobLegalHoldOptions final
      {
        bool LegalHold = bool();
      };
      static Response<Models::SetBlobLegalHoldResult> SetLegalHold(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobLegalHoldOptions& options,
          const Core::Context& context);
      struct SetBlobMetadataOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::SetBlobMetadataResult> SetMetadata(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobMetadataOptions& options,
          const Core::Context& context);
      struct AcquireBlobLeaseOptions final
      {
        Nullable<int32_t> Duration;
        Nullable<std::string> ProposedLeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::_detail::AcquireBlobLeaseResult> AcquireLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AcquireBlobLeaseOptions& options,
          const Core::Context& context);
      struct ReleaseBlobLeaseOptions final
      {
        std::string LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::_detail::ReleaseBlobLeaseResult> ReleaseLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ReleaseBlobLeaseOptions& options,
          const Core::Context& context);
      struct RenewBlobLeaseOptions final
      {
        std::string LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::_detail::RenewBlobLeaseResult> RenewLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenewBlobLeaseOptions& options,
          const Core::Context& context);
      struct ChangeBlobLeaseOptions final
      {
        std::string LeaseId;
        std::string ProposedLeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::_detail::ChangeBlobLeaseResult> ChangeLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ChangeBlobLeaseOptions& options,
          const Core::Context& context);
      struct BreakBlobLeaseOptions final
      {
        Nullable<int32_t> BreakPeriod;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::_detail::BreakBlobLeaseResult> BreakLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const BreakBlobLeaseOptions& options,
          const Core::Context& context);
      struct CreateBlobSnapshotOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> LeaseId;
      };
      static Response<Models::CreateBlobSnapshotResult> CreateSnapshot(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateBlobSnapshotOptions& options,
          const Core::Context& context);
      struct StartBlobCopyFromUriOptions final
      {
        Nullable<std::string> SourceLeaseId;
        std::map<std::string, std::string> Metadata;
        Nullable<Models::AccessTier> Tier;
        Nullable<Models::RehydratePriority> RehydratePriority;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<std::string> SourceIfTags;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        std::string CopySource;
        Nullable<std::string> LeaseId;
        Nullable<std::string> BlobTagsString;
        Nullable<bool> SealBlob;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
      };
      static Response<Models::_detail::StartBlobCopyFromUriResult> StartCopyFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const StartBlobCopyFromUriOptions& options,
          const Core::Context& context);
      struct CopyBlobFromUriOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<Models::AccessTier> Tier;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        std::string CopySource;
        Nullable<std::string> LeaseId;
        Nullable<std::vector<uint8_t>> SourceContentMD5;
        Nullable<std::string> BlobTagsString;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
        Nullable<std::string> CopySourceAuthorization;
        Nullable<std::string> EncryptionScope;
        Nullable<Models::BlobCopySourceTagsMode> CopySourceTags;
        Nullable<std::vector<uint8_t>> SourceContentcrc64;
      };
      static Response<Models::CopyBlobFromUriResult> CopyFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CopyBlobFromUriOptions& options,
          const Core::Context& context);
      struct AbortBlobCopyFromUriOptions final
      {
        std::string CopyId;
        Nullable<std::string> LeaseId;
      };
      static Response<Models::AbortBlobCopyFromUriResult> AbortCopyFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AbortBlobCopyFromUriOptions& options,
          const Core::Context& context);
      struct SetBlobTierOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> VersionId;
        Models::AccessTier Tier;
        Nullable<Models::RehydratePriority> RehydratePriority;
        Nullable<std::string> LeaseId;
        Nullable<std::string> IfTags;
      };
      static Response<Models::SetBlobAccessTierResult> SetTier(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobTierOptions& options,
          const Core::Context& context);
      struct QueryBlobOptions final
      {
        Models::_detail::QueryRequest QueryRequest;
        Nullable<std::string> Snapshot;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> EncryptionScope;
      };
      static Response<Models::QueryBlobResult> Query(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const QueryBlobOptions& options,
          const Core::Context& context);
      struct GetBlobTagsOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> VersionId;
        Nullable<std::string> IfTags;
        Nullable<std::string> LeaseId;
      };
      static Response<std::map<std::string, std::string>> GetTags(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetBlobTagsOptions& options,
          const Core::Context& context);
      struct SetBlobTagsOptions final
      {
        std::map<std::string, std::string> Tags;
        Nullable<std::string> VersionId;
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
        Nullable<std::string> IfTags;
        Nullable<std::string> LeaseId;
      };
      static Response<Models::SetBlobTagsResult> SetTags(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetBlobTagsOptions& options,
          const Core::Context& context);
    };
    class PageBlobClient final {
    public:
      struct CreatePageBlobOptions final
      {
        Nullable<Models::AccessTier> Tier;
        std::string BlobContentType;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        std::vector<uint8_t> BlobContentMD5;
        std::string BlobCacheControl;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        std::string BlobContentDisposition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        int64_t BlobContentLength = int64_t();
        Nullable<int64_t> BlobSequenceNumber;
        Nullable<std::string> BlobTagsString;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
      };
      static Response<Models::CreatePageBlobResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreatePageBlobOptions& options,
          const Core::Context& context);
      struct UploadPageBlobPagesOptions final
      {
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<int64_t> IfSequenceNumberLessThanOrEqualTo;
        Nullable<int64_t> IfSequenceNumberLessThan;
        Nullable<int64_t> IfSequenceNumberEqualTo;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::UploadPagesResult> UploadPages(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const UploadPageBlobPagesOptions& options,
          const Core::Context& context);
      struct ClearPageBlobPagesOptions final
      {
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<int64_t> IfSequenceNumberLessThanOrEqualTo;
        Nullable<int64_t> IfSequenceNumberLessThan;
        Nullable<int64_t> IfSequenceNumberEqualTo;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::ClearPagesResult> ClearPages(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ClearPageBlobPagesOptions& options,
          const Core::Context& context);
      struct UploadPageBlobPagesFromUriOptions final
      {
        std::string SourceUrl;
        std::string SourceRange;
        Nullable<std::vector<uint8_t>> SourceContentMD5;
        Nullable<std::vector<uint8_t>> SourceContentcrc64;
        std::string Range;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<std::string> LeaseId;
        Nullable<int64_t> IfSequenceNumberLessThanOrEqualTo;
        Nullable<int64_t> IfSequenceNumberLessThan;
        Nullable<int64_t> IfSequenceNumberEqualTo;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<std::string> CopySourceAuthorization;
      };
      static Response<Models::UploadPagesFromUriResult> UploadPagesFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UploadPageBlobPagesFromUriOptions& options,
          const Core::Context& context);
      struct GetPageBlobPageRangesOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
      };
      static Response<Models::_detail::GetPageRangesResult> GetPageRanges(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetPageBlobPageRangesOptions& options,
          const Core::Context& context);
      struct GetPageBlobPageRangesDiffOptions final
      {
        Nullable<std::string> Snapshot;
        Nullable<std::string> Prevsnapshot;
        Nullable<std::string> PrevSnapshotUrl;
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> Marker;
        Nullable<int32_t> MaxResults;
      };
      static Response<Models::_detail::GetPageRangesDiffResult> GetPageRangesDiff(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetPageBlobPageRangesDiffOptions& options,
          const Core::Context& context);
      struct ResizePageBlobOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        int64_t BlobContentLength = int64_t();
      };
      static Response<Models::ResizePageBlobResult> Resize(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ResizePageBlobOptions& options,
          const Core::Context& context);
      struct UpdatePageBlobSequenceNumberOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Models::SequenceNumberAction SequenceNumberAction;
        Nullable<int64_t> BlobSequenceNumber;
      };
      static Response<Models::UpdateSequenceNumberResult> UpdateSequenceNumber(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UpdatePageBlobSequenceNumberOptions& options,
          const Core::Context& context);
      struct StartPageBlobCopyIncrementalOptions final
      {
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        std::string CopySource;
      };
      static Response<Models::_detail::StartBlobCopyIncrementalResult> StartCopyIncremental(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const StartPageBlobCopyIncrementalOptions& options,
          const Core::Context& context);
    };
    class AppendBlobClient final {
    public:
      struct CreateAppendBlobOptions final
      {
        std::string BlobContentType;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        std::vector<uint8_t> BlobContentMD5;
        std::string BlobCacheControl;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        std::string BlobContentDisposition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> BlobTagsString;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
      };
      static Response<Models::CreateAppendBlobResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateAppendBlobOptions& options,
          const Core::Context& context);
      struct AppendAppendBlobBlockOptions final
      {
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
        Nullable<std::string> LeaseId;
        Nullable<int64_t> MaxSize;
        Nullable<int64_t> AppendPosition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
      };
      static Response<Models::AppendBlockResult> AppendBlock(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const AppendAppendBlobBlockOptions& options,
          const Core::Context& context);
      struct AppendAppendBlobBlockFromUriOptions final
      {
        std::string SourceUrl;
        Nullable<std::string> SourceRange;
        Nullable<std::vector<uint8_t>> SourceContentMD5;
        Nullable<std::vector<uint8_t>> SourceContentcrc64;
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<std::string> LeaseId;
        Nullable<int64_t> MaxSize;
        Nullable<int64_t> AppendPosition;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<std::string> CopySourceAuthorization;
      };
      static Response<Models::AppendBlockFromUriResult> AppendBlockFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AppendAppendBlobBlockFromUriOptions& options,
          const Core::Context& context);
      struct SealAppendBlobOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<int64_t> AppendPosition;
      };
      static Response<Models::SealAppendBlobResult> Seal(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SealAppendBlobOptions& options,
          const Core::Context& context);
    };
    class BlockBlobClient final {
    public:
      struct UploadBlockBlobOptions final
      {
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        std::string BlobContentType;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        std::vector<uint8_t> BlobContentMD5;
        std::string BlobCacheControl;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        std::string BlobContentDisposition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<Models::AccessTier> Tier;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> BlobTagsString;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
      };
      static Response<Models::UploadBlockBlobResult> Upload(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const UploadBlockBlobOptions& options,
          const Core::Context& context);
      struct UploadBlockBlobFromUriOptions final
      {
        std::string BlobContentType;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        std::vector<uint8_t> BlobContentMD5;
        std::string BlobCacheControl;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        std::string BlobContentDisposition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<Models::AccessTier> Tier;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<std::string> SourceIfTags;
        Nullable<std::vector<uint8_t>> SourceContentMD5;
        Nullable<std::string> BlobTagsString;
        std::string CopySource;
        Nullable<bool> CopySourceBlobProperties;
        Nullable<std::string> CopySourceAuthorization;
        Nullable<Models::BlobCopySourceTagsMode> CopySourceTags;
        Nullable<std::vector<uint8_t>> SourceContentcrc64;
      };
      static Response<Models::UploadBlockBlobFromUriResult> UploadFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UploadBlockBlobFromUriOptions& options,
          const Core::Context& context);
      struct StageBlockBlobBlockOptions final
      {
        std::string BlockId;
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
        Nullable<std::string> LeaseId;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
      };
      static Response<Models::StageBlockResult> StageBlock(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const StageBlockBlobBlockOptions& options,
          const Core::Context& context);
      struct StageBlockBlobBlockFromUriOptions final
      {
        std::string BlockId;
        std::string SourceUrl;
        Nullable<std::string> SourceRange;
        Nullable<std::vector<uint8_t>> SourceContentMD5;
        Nullable<std::vector<uint8_t>> SourceContentcrc64;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<std::string> LeaseId;
        Nullable<DateTime> SourceIfModifiedSince;
        Nullable<DateTime> SourceIfUnmodifiedSince;
        ETag SourceIfMatch;
        ETag SourceIfNoneMatch;
        Nullable<std::string> CopySourceAuthorization;
      };
      static Response<Models::StageBlockFromUriResult> StageBlockFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const StageBlockBlobBlockFromUriOptions& options,
          const Core::Context& context);
      struct CommitBlockBlobBlockListOptions final
      {
        Models::_detail::BlockLookupList Blocks;
        std::string BlobCacheControl;
        std::string BlobContentType;
        std::string BlobContentEncoding;
        std::string BlobContentLanguage;
        std::vector<uint8_t> BlobContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentMD5;
        Nullable<std::vector<uint8_t>> TransactionalContentCrc64;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        std::string BlobContentDisposition;
        Nullable<std::string> EncryptionKey;
        Nullable<std::vector<uint8_t>> EncryptionKeySha256;
        Nullable<std::string> EncryptionAlgorithm;
        Nullable<std::string> EncryptionScope;
        Nullable<Models::AccessTier> Tier;
        Nullable<DateTime> IfModifiedSince;
        Nullable<DateTime> IfUnmodifiedSince;
        ETag IfMatch;
        ETag IfNoneMatch;
        Nullable<std::string> IfTags;
        Nullable<std::string> BlobTagsString;
        Nullable<DateTime> ImmutabilityPolicyExpiry;
        Nullable<Models::BlobImmutabilityPolicyMode> ImmutabilityPolicyMode;
        Nullable<bool> LegalHold;
      };
      static Response<Models::CommitBlockListResult> CommitBlockList(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CommitBlockBlobBlockListOptions& options,
          const Core::Context& context);
      struct GetBlockBlobBlockListOptions final
      {
        Nullable<std::string> Snapshot;
        Models::BlockListType ListType;
        Nullable<std::string> LeaseId;
        Nullable<std::string> IfTags;
      };
      static Response<Models::GetBlockListResult> GetBlockList(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetBlockBlobBlockListOptions& options,
          const Core::Context& context);
    };
  } // namespace _detail
}}} // namespace Azure::Storage::Blobs