/*
 * Decompiled with CFR 0.152.
 */
package javax.script.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.http.HttpScriptContext;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpScriptServlet
extends GenericServlet {
    public abstract HttpScriptContext getContext(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    public abstract ScriptEngine getEngine(HttpServletRequest var1);

    public abstract void releaseEngine(ScriptEngine var1);

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new IllegalArgumentException();
        }
        HttpServletRequest httpreq = (HttpServletRequest)req;
        HttpServletResponse httpres = (HttpServletResponse)res;
        PrintWriter httpwriter = httpres.getWriter();
        HttpScriptContext ctxt = this.getContext(httpreq, httpres);
        if (ctxt.disableScript()) {
            httpres.setStatus(403);
            return;
        }
        String[] methods = ctxt.getMethods();
        int numMethods = methods.length;
        String method = httpreq.getMethod();
        int i = 0;
        for (i = 0; i < numMethods && method.compareToIgnoreCase(methods[i]) != 0; ++i) {
        }
        if (i == numMethods) {
            httpres.setStatus(405);
            return;
        }
        ScriptEngine engine = null;
        try {
            block18: {
                engine = this.getEngine(httpreq);
                String[] languages = ctxt.getAllowedLanguages();
                if (languages != null) {
                    List<String> names = engine.getFactory().getNames();
                    int lenLanguages = languages.length;
                    for (String name : names) {
                        for (int j = 0; j < lenLanguages; ++j) {
                            if (!name.equals(languages[j])) {
                                continue;
                            }
                            break block18;
                        }
                    }
                    httpres.setStatus(403);
                    return;
                }
            }
            Reader reader = ctxt.getScriptSource();
            ctxt.getBindings(100).put("javax.script.filename", httpreq.getRequestURI());
            if (reader == null) {
                httpres.setStatus(404);
                return;
            }
            ctxt.getBindings(100).put("request", ctxt.getRequest());
            ctxt.getBindings(100).put("response", ctxt.getResponse());
            ctxt.getBindings(100).put("context", ctxt);
            ctxt.getBindings(100).put("servlet", (Object)this);
            res.setContentType("text/html");
            Object ret = engine.eval(ctxt.getScriptSource(), (ScriptContext)ctxt);
            if (ret != null && ctxt.displayResults()) {
                ((Writer)httpwriter).write(ret.toString());
            }
            ((Writer)httpwriter).flush();
            reader.close();
        }
        catch (ScriptException e) {
            httpres.setStatus(500);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (engine != null) {
                this.releaseEngine(engine);
            }
            ctxt.release();
        }
    }
}

