/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  sortbox.h

  Sorting functions 
*/


#ifndef SORTBOX_SORTBOX_H
#define SORTBOX_SORTBOX_H

#include <stdio.h>

extern unsigned int Libsortbox_WARNING_On;
extern unsigned int Libsortbox_ERROR_On;
extern unsigned int Libsortbox_OUTPUT_On;
extern unsigned int Libsortbox_HEADER_On;

extern FILE *Libsortbox_err;
extern FILE *Libsortbox_out;

typedef struct {
  unsigned char NbrLetters;
  unsigned char *Order;
  unsigned char *Priority;
} s_SBAlphabet;

/*
 * A SB_Word is a word if NbrIDs >0 and a partial word otherwise.
 * A partial word is the part of a word : this part have a nbr of letters
 * equal to the NbrLetters of the Box where it is stored, and its last letter
 * is Letter.
 * The next letter of the word is in the box Daughter 
 */

typedef struct {
  unsigned int NbrIDs;        /* Nbr of IDs */
  void **IDs;                 /* Array of pointers to elements related to the 
				 Word  */
  struct s_SBBox *Daughter;   /* Box that contain the following letter of the
				 Word */
  unsigned char Letter;       /* Letter of the Word */
} s_SBWord;


struct s_SBBox {
  struct s_SBBox *Mother;     /* Box that contain the previous letter of all 
				 the Words in this Box */
  unsigned char MotherLetter; /* Letter of the previous Box */
  unsigned short NbrLetters;  /* Lenght of the partail words contained in the 
				 Box */
  unsigned char NbrWords;     /* Nbr of partial words in the Box */
  s_SBWord **Words;           /* Array of pointers to Words */
};

typedef struct s_SBBox s_SBBox;

typedef enum e_SortBoxType {SB_ALPHANUM=0,SB_NUM} e_SortBoxType;

typedef struct {
  e_SortBoxType Type;         /* Type of data sorted: Alphanumerical or 
				 numerical */
  unsigned long NbrBoxes;     /* Nbr of Boxes int he SortBox */
  s_SBAlphabet *Alphabet;     /* Alphabet used for sorting */
  s_SBBox **Boxes;            /* Array of pointers to Boxes */
} s_SortBox;


/* s_NameID is used to send a pool of word into the SortBox */
typedef struct {
  char *Name;                 
  void *ID;
} s_NameID;

s_SortBox* InitSortBox (e_SortBoxType Type,const char *PriorityOrder);
void SortBox_AddOneWord (s_SortBox *SortBox, unsigned char *Name, void *ID);
void SortBox_AddOneUint (s_SortBox *SortBox, unsigned int Number, void *ID);
void SortBox_AddWordsTable(s_SortBox *SortBox, unsigned int NbrWords, 
			   s_NameID **WordsTable);
void** SortBox_Find (s_SortBox *SortBox,unsigned char *Origin, 
		      unsigned int *MaxNbrData_ptr);
void** SortBox_FindTheWord (s_SortBox *SortBox,unsigned char *Origin, 
			    unsigned int *NbrData_ptr);
void** SortBox_FindTheUint (s_SortBox *SortBox,unsigned int Number, 
			    unsigned int *NbrData_ptr);
void FreeSortBox( s_SortBox *SortBox);

unsigned int SortBox_GetUsedMemory(s_SortBox *SortBox);

#endif // __SORTBOX_H
