/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.util.Path;

public class ResolvedLocalComponentsResultGraphVisitor
implements DependencyGraphVisitor {
    private final BuildIdentifier thisBuild;
    private final ProjectStateRegistry projectStateRegistry;
    private ComponentIdentifier rootId;
    private final List<ResolvedProjectConfiguration> resolvedProjectConfigurations = new ArrayList<ResolvedProjectConfiguration>();

    public ResolvedLocalComponentsResultGraphVisitor(BuildIdentifier thisBuild, ProjectStateRegistry projectStateRegistry) {
        this.thisBuild = thisBuild;
        this.projectStateRegistry = projectStateRegistry;
    }

    @Override
    public void start(RootGraphNode root) {
        this.rootId = root.getOwner().getComponentId();
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        ProjectComponentIdentifierInternal projectComponentId;
        ComponentIdentifier componentId = node.getOwner().getComponentId();
        if (!this.rootId.equals(componentId) && componentId instanceof ProjectComponentIdentifierInternal && (projectComponentId = (ProjectComponentIdentifierInternal)componentId).getBuild().equals(this.thisBuild)) {
            this.resolvedProjectConfigurations.add(new ResolvedProjectConfiguration(projectComponentId.getIdentityPath(), node.getResolvedConfigurationId().getConfiguration()));
        }
    }

    public void complete(ConfigurationInternal.InternalState requestedState) {
        for (ResolvedProjectConfiguration projectResult : this.resolvedProjectConfigurations) {
            ProjectState targetState = this.projectStateRegistry.stateFor(projectResult.projectIdentity);
            ConfigurationInternal targetConfig = (ConfigurationInternal)targetState.getMutableModel().getConfigurations().findByName(projectResult.targetConfiguration);
            if (targetConfig == null) continue;
            targetConfig.markAsObserved(requestedState);
        }
    }

    private static class ResolvedProjectConfiguration {
        private final Path projectIdentity;
        private final String targetConfiguration;

        public ResolvedProjectConfiguration(Path projectIdentity, String targetConfiguration) {
            this.projectIdentity = projectIdentity;
            this.targetConfiguration = targetConfiguration;
        }
    }
}

