/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import java.util.List;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.dsl.dependencies.UnknownProjectFinder;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.scopes.AbstractPluginServiceRegistry;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.plugin.management.internal.DefaultPluginManagementSpec;
import org.gradle.plugin.management.internal.DefaultPluginResolutionStrategy;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;
import org.gradle.plugin.management.internal.autoapply.CompositeAutoAppliedPluginRegistry;
import org.gradle.plugin.management.internal.autoapply.DefaultAutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.InjectedAutoAppliedPluginRegistry;
import org.gradle.plugin.use.internal.DefaultPluginRequestApplicator;
import org.gradle.plugin.use.internal.InjectedPluginClasspath;
import org.gradle.plugin.use.internal.PluginDependencyResolutionServices;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;
import org.gradle.plugin.use.internal.PluginResolverFactory;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.DefaultInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathInstrumentationStrategy;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;

public class PluginUsePluginServiceRegistry
extends AbstractPluginServiceRegistry {
    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((Object)new BuildScopeServices());
    }

    public void registerSettingsServices(ServiceRegistration registration) {
        registration.addProvider((Object)new SettingsScopeServices());
    }

    private static class BuildScopeServices {
        private BuildScopeServices() {
        }

        void configure(ServiceRegistration registration) {
            registration.add(PluginResolverFactory.class);
            registration.add(DefaultPluginRequestApplicator.class);
            registration.add(PluginVersionTracker.class);
        }

        AutoAppliedPluginRegistry createInjectedAutoAppliedPluginRegistry(BuildDefinition buildDefinition) {
            return new InjectedAutoAppliedPluginRegistry(buildDefinition);
        }

        AutoAppliedPluginHandler createAutoAppliedPluginHandler(List<AutoAppliedPluginRegistry> registries) {
            return new DefaultAutoAppliedPluginHandler(new CompositeAutoAppliedPluginRegistry(registries));
        }

        ClientInjectedClasspathPluginResolver createInjectedClassPathPluginResolver(FileResolver fileResolver, DependencyManagementServices dependencyManagementServices, DependencyMetaDataProvider dependencyMetaDataProvider, ClassLoaderScopeRegistry classLoaderScopeRegistry, PluginInspector pluginInspector, InjectedPluginClasspath injectedPluginClasspath, ScriptClassPathResolver scriptClassPathResolver, FileCollectionFactory fileCollectionFactory, InjectedClasspathInstrumentationStrategy instrumentationStrategy) {
            if (injectedPluginClasspath.getClasspath().isEmpty()) {
                return ClientInjectedClasspathPluginResolver.EMPTY;
            }
            Factory<DependencyResolutionServices> dependencyResolutionServicesFactory = this.makeDependencyResolutionServicesFactory(fileResolver, fileCollectionFactory, dependencyManagementServices, dependencyMetaDataProvider);
            return new DefaultInjectedClasspathPluginResolver(classLoaderScopeRegistry.getCoreAndPluginsScope(), scriptClassPathResolver, fileCollectionFactory, pluginInspector, injectedPluginClasspath.getClasspath(), instrumentationStrategy, dependencyResolutionServicesFactory);
        }

        PluginResolutionStrategyInternal createPluginResolutionStrategy(Instantiator instantiator, ListenerManager listenerManager) {
            return (PluginResolutionStrategyInternal)instantiator.newInstance(DefaultPluginResolutionStrategy.class, new Object[]{listenerManager});
        }

        PluginDependencyResolutionServices createPluginDependencyResolutionServices(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, DependencyManagementServices dependencyManagementServices, DependencyMetaDataProvider dependencyMetaDataProvider) {
            return new PluginDependencyResolutionServices(this.makeDependencyResolutionServicesFactory(fileResolver, fileCollectionFactory, dependencyManagementServices, dependencyMetaDataProvider));
        }

        private Factory<DependencyResolutionServices> makeDependencyResolutionServicesFactory(final FileResolver fileResolver, final FileCollectionFactory fileCollectionFactory, final DependencyManagementServices dependencyManagementServices, final DependencyMetaDataProvider dependencyMetaDataProvider) {
            return new Factory<DependencyResolutionServices>(){

                public DependencyResolutionServices create() {
                    return dependencyManagementServices.create(fileResolver, fileCollectionFactory, dependencyMetaDataProvider, this.makeUnknownProjectFinder(), (DomainObjectContext)RootScriptDomainObjectContext.PLUGINS);
                }
            };
        }

        private ProjectFinder makeUnknownProjectFinder() {
            return new UnknownProjectFinder("Cannot use project dependencies in a plugin resolution definition.");
        }
    }

    private static class SettingsScopeServices {
        private SettingsScopeServices() {
        }

        protected PluginManagementSpec createPluginManagementSpec(Instantiator instantiator, PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider, PluginResolutionStrategyInternal internalPluginResolutionStrategy, FileResolver fileResolver, BuildIncluder buildIncluder) {
            return (PluginManagementSpec)instantiator.newInstance(DefaultPluginManagementSpec.class, new Object[]{pluginRepositoryHandlerProvider, internalPluginResolutionStrategy, fileResolver, buildIncluder});
        }
    }
}

