#! ruby -Ks

# make_oyaji_list.rb
# ʂ̖{f[^ƐeoXg
# ǂݕtoXg𐶐

# simplify_font: \L̃tHgwȗ
def simplify_font(kanji)
    kanji.gsub!(/<\/ST>/, "t")
    kanji.gsub!(/<ST,(12|13|14|51)>/, "s<\\1>")
    kanji.gsub!(/<ST,2([45])>/, "s<2\\1>")
    kanji.gsub!(/<ST,(11|3[345]|41)>/, "s<11>")
    kanji.gsub!(/<ST,[0-9]+>/, "s")
    kanji.gsub!(/s(m|n|i|j)t/,'\1')
end
#def simplify_font(kanji)
#    kanji.gsub!(/<\/ST>/, "")
#    kanji.gsub!(/<ST,(12|13|14|51)>/, "<\\1>")
#    kanji.gsub!(/<ST,2([45])>/, "<2\\1>")
#    kanji.gsub!(/<ST,(11|3[345]|41)>/, "<11>")
#    kanji.gsub!(/<ST,[0-9]+>/, "")
#end

# decrypt: dat/lstGg̓e𕽕ɂ
def decrypt(ent, len)
    # 擪4̔{oCĝA4oCgƂ
    # 4oCgBE̒lƂ݂Ȃ0xffffffffXORA
    # 0x8831b311𕄍ȂZ
    len4 = len & ~3
    arr = ent[0, len4].unpack("N*")
    arr.length.times { |i|
	arr[i] = ((arr[i] ^ 0xffffffff) + 0x8831b311) & 0xffffffff
    }
    ent[0, len4] = arr.pack("N*")

    # ]̃oCg0xffXOR
    i = len4
    while i < len
	ent[i] ^= 0xff
	i += 1
    end

    # 0x000xff̒O܂łʂƂĕԂ
    i = 0
    while i < len && ent[i] != 0x00 && ent[i] != 0xff
	i += 1
    end
    return ent[0, i]
end

# get_yomi: datGg2s(ǂ)o
def get_yomi(ent)
    n1 = ent.index(0x0d)
    n2 = ent.index(0x0d, n1 + 1)
    return ent[n1 + 1 ... n2]
end

# add_yomi_tag: <yomi>^OGgɕtB
def add_yomi_tag(yomi)
  yomi.gsub!(/n|E/,'\&<yomi>')
  yomi.gsub!(/(@?mPn)|E|i|\z/,'</yomi>\&')
end

# C

# dat/lstt@C
HONMON_DAT = "dat/honmon.dat"
OYAJI_LST = "lst/oyaji.lst"

# dat/lstt@CI[v
if ARGV[0] == nil then
    STDERR.print "Usage: make_oyaji_list.rb data_directory\n"
    exit(1)
end
dat_path = ARGV[0] + "/" + HONMON_DAT
lst_path = ARGV[0] + "/" + OYAJI_LST
begin
    datf = File.open(dat_path, "rb")
    lstf = File.open(lst_path, "rb")
rescue
    STDERR.print "Can't open dat/lst files\n"
    exit 1
end

# dat/lstGg擾
ent_num = datf.read(4).unpack("V1")[0]

# datGg\ǂݍ
dat_pos = Array.new(ent_num)
dat_len = Array.new(ent_num)
ent_num.times { |i|
    dat_pos[i] = datf.read(4).unpack("V1")[0]
    dat_len[i] = datf.read(4).unpack("V1")[0]
}

# lstGgTCY/TCY擾
lstf.seek(16, IO::SEEK_SET)
lst_ent_len = lstf.read(4).unpack("V1")[0]
lst_str_len = lstf.read(4).unpack("V1")[0]
lstf.seek(32, IO::SEEK_SET)

# dat/lstGgSǂ݁A
# GgԍƂƂɐ`ďo͂
ent_num.times { |i|
    # lstGgǂŕɂ
    list = lstf.read(lst_str_len)
    list = decrypt(list, lst_str_len)
    dummy = lstf.read(lst_ent_len - lst_str_len)

    # \L̃tHgwȗ
    simplify_font(list)

    # datGgǂŕɂA2sڂo
    # {ŕKvȂ̂2sڂȂ̂Ő擪160oCgǂ
    datf.seek(dat_pos[i], IO::SEEK_SET)
    data = datf.read(160)
    data = decrypt(data, 160)
    data = get_yomi(data)
    data = add_yomi_tag(data)

    # lstGgdatGgo͂
    printf "%04d %s %s\n", i+1, list, data
}

# n
datf.close
lstf.close
