/* $Id: icmp_dummy.c,v 1.2 1999/10/11 05:25:19 fgouget Exp $ */

/* was in */
int do_probe(handle, target, size, ttl, probe)
{
#ifdef FAKE_NET
    if ((SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b1==192) &&
        (SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b2==168)) {
        struct sockaddr_in* itarget=SOCKADDR_IN(target);
        int retcode;
        /* Fake the probe results according to the target address */
        if (ttl==0) {
            /* Fake information concerning the local host */
            probe->rtt=10*size/100;
            SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_addr=inet_addr("127.0.0.1");
            probe->type=ICMP_TIMXCEED;
            probe->subtype=ICMP_TIMXCEED_INTRANS;
            retcode=BP_RES_TTL_EXCEEDED;
        } else if (ttl>=itarget->sin_addr.S_un.S_un_b.s_b4) {
            /* Fake information concerning the target host */
            probe->rtt=((double)itarget->sin_addr.S_un.S_un_b.s_b3)*itarget->sin_addr.S_un.S_un_b.s_b4*size/100;
            SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_addr=itarget->sin_addr.S_un.S_addr;
            probe->type=ICMP_ECHOREPLY;
            probe->subtype=0;
            retcode=BP_RES_HIT;
        } else {
            /* Do as if the ttl expired in transit */
            probe->rtt=((double)itarget->sin_addr.S_un.S_un_b.s_b3)*ttl*size/100;
            SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_addr=itarget->sin_addr.S_un.S_addr;
            SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_un_b.s_b4=ttl;
            probe->type=ICMP_TIMXCEED;
            probe->subtype=ICMP_TIMXCEED_INTRANS;
            retcode=BP_RES_TTL_EXCEEDED;
        }
        probe->src_addr.sa_family=AF_INET;
        probe->size=0;
        probe->contents=NULL;
        return retcode;
    } else if ((SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b1==208) && 
               (SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b2==199) && 
               (SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b3==87) && 
               (SOCKADDR_IN(target)->sin_addr.S_un.S_un_b.s_b4==55)) {
            /* Fake information concerning the local host */
            probe->rtt=size/1000;
            SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_addr=inet_addr("127.0.0.1");
            probe->type=ICMP_ECHOREPLY;
            probe->subtype=0;
            return BP_RES_HIT;
    } else {
        probe->rtt=50;
        probe->src_addr.sa_family=AF_INET;
        SOCKADDR_IN(&probe->src_addr)->sin_addr.S_un.S_addr=inet_addr("127.0.0.1");
        probe->type=ICMP_UNREACH;
        probe->subtype=ICMP_UNREACH_NET_UNKNOWN;
        probe->size=0;
        probe->contents=NULL;
        return BP_RES_UNKNOWN;
    }
#endif /* FAKE_NET */
}
