/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.language.csharp.generator.Section;
import org.argouml.model.DirectionKind;
import org.argouml.model.Facade;
import org.argouml.model.Model;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.ocl.ArgoFacade;
import org.argouml.uml.DocumentationManager;
import org.argouml.uml.UUIDHelper;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.GeneratorHelper;
import org.argouml.uml.generator.GeneratorManager;
import org.argouml.uml.generator.Language;
import org.argouml.uml.generator.SourceUnit;
import org.argouml.uml.generator.TempFileUtils;
import tudresden.ocl.OclTree;
import tudresden.ocl.check.types.ModelFacade;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AConstraintBody;
import tudresden.ocl.parser.node.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorCSharp
implements CodeGenerator,
ModuleInterface {
    private static final boolean VERBOSE = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LANGUAGE_NAME = "CSharp";
    private static final String INDENT = "    ";
    private static Section sect;
    private static final Logger LOG;
    private static final GeneratorCSharp INSTANCE;
    private Language myLang = GeneratorHelper.makeLanguage((String)"CSharp", (Icon)ResourceLoaderWrapper.lookupIconResource((String)"CSharpNotation"));

    public static GeneratorCSharp getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateFile(Object cls, String path) {
        File f3;
        File f2;
        sect = new Section();
        String name = Model.getFacade().getName(cls);
        if (name == null || name.length() == 0) {
            return null;
        }
        String filename = name + ".cs";
        if (!path.endsWith(FILE_SEPARATOR)) {
            path = path + FILE_SEPARATOR;
        }
        String packagePath = "";
        Object parent = Model.getFacade().getNamespace(Model.getFacade().getNamespace(cls));
        if (parent != null) {
            packagePath = Model.getFacade().getName(Model.getFacade().getNamespace(cls));
        }
        while (parent != null) {
            if (Model.getFacade().getNamespace(parent) != null) {
                packagePath = Model.getFacade().getName(parent) + "." + packagePath;
            }
            parent = Model.getFacade().getNamespace(parent);
        }
        int lastIndex = -1;
        while (true) {
            File f;
            if (!(f = new File(path)).isDirectory() && !f.mkdir()) {
                LOG.debug((Object)(" could not make directory " + path));
                return null;
            }
            if (lastIndex == packagePath.length()) break;
            int index = packagePath.indexOf(".", lastIndex + 1);
            if (index == -1) {
                index = packagePath.length();
            }
            path = path + packagePath.substring(lastIndex + 1, index) + FILE_SEPARATOR;
            lastIndex = index;
        }
        String pathname = path + filename;
        LOG.debug((Object)("-----" + pathname + "-----"));
        File f = new File(pathname);
        if (f.exists()) {
            LOG.debug((Object)("Generating (updated) " + f.getPath()));
            sect.read(pathname);
        } else {
            LOG.debug((Object)("Generating (new) " + f.getPath()));
        }
        String header = INSTANCE.generateHeader(cls, pathname, packagePath);
        String src = INSTANCE.generateClassifier(cls);
        if (packagePath.length() > 0) {
            src = src + "\n}";
        }
        BufferedWriter fos = null;
        try {
            fos = new BufferedWriter(new FileWriter(f));
            fos.write(header);
            fos.write(src);
        }
        catch (IOException exp) {
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException exp) {
                LOG.debug((Object)("FAILED: " + f.getPath()));
            }
        }
        sect.write(pathname, INDENT);
        LOG.debug((Object)("written: " + pathname));
        File f1 = new File(pathname + ".bak");
        if (f1.exists()) {
            f1.delete();
        }
        if ((f2 = new File(pathname)).exists()) {
            f2.renameTo(new File(pathname + ".bak"));
        }
        if ((f3 = new File(pathname + ".out")).exists()) {
            f3.renameTo(new File(pathname));
        }
        LOG.debug((Object)"----- end updating -----");
        return pathname;
    }

    private String generateHeader(Object cls, String pathname, String packagePath) {
        String s = "";
        s = s + "// FILE: " + pathname.replace('\\', '/') + "\n\n";
        s = s + this.generateImports(cls, packagePath);
        if (packagePath.length() > 0) {
            s = s + "namespace " + packagePath + " {\n";
        }
        s = s + "\n";
        return s;
    }

    private String generateSubmachine(Object m) {
        Object c = Model.getFacade().getSubmachine(m);
        if (c == null) {
            return "include / ";
        }
        if (Model.getFacade().getName(c) == null) {
            return "include / ";
        }
        if (Model.getFacade().getName(c).length() == 0) {
            return "include / ";
        }
        return "include / " + Model.getFacade().getName(c);
    }

    private String generateObjectFlowState(Object m) {
        Object c = Model.getFacade().getType(m);
        if (c == null) {
            return "";
        }
        return Model.getFacade().getName(c);
    }

    private String generateOperation(Object op, boolean documented) {
        List rps;
        String s = "";
        boolean isDestructor = false;
        Object cls = Model.getFacade().getOwner(op);
        String nameStr = Model.getFacade().getName(op);
        String clsName = Model.getFacade().getName(Model.getFacade().getOwner(op));
        String tagStr = "";
        String tag = Model.getFacade().getTaggedValueValue(op, "override");
        if ("true".equals(tag)) {
            tagStr = " override ";
        }
        if (Model.getExtensionMechanismsHelper().hasStereotype(op, "destroy")) {
            nameStr = "~" + nameStr;
            isDestructor = true;
        }
        if ((rps = Model.getCoreHelper().getReturnParameters(op)).size() > 1) {
            throw new RuntimeException("Multiple return parameters not supported");
        }
        Object rp = null;
        if (rps.size() == 1) {
            rp = rps.get(0);
        }
        ArrayList params = new ArrayList(Model.getFacade().getParameters(op));
        String returnDoc = this.generateConstraintEnrichedDocComment(rp, "/// <returns>", "/// ", "/// </returns>") + "\n" + INDENT;
        params.remove(rp);
        if (documented) {
            s = s + this.generateConstraintEnrichedDocComment(op, "/// <summary>", "/// ", "/// </summary>") + "\n" + INDENT;
            for (Object p : params) {
                s = s + this.generateConstraintEnrichedDocComment(p, "/// <param name=\"" + Model.getFacade().getName(p) + "\">", "/// ", "/// </param>") + "\n" + INDENT;
            }
            s = s + returnDoc;
        }
        if (!Model.getFacade().isAInterface(cls) && !isDestructor) {
            s = s + this.generateAbstractness(op);
            s = s + this.generateScope(op);
            s = s + this.generateChangeability(op);
            s = s + this.generateVisibility(op);
        }
        s = s + tagStr;
        if (rp != null) {
            Object returnType = Model.getFacade().getType(rp);
            if (returnType == null && !nameStr.equals(clsName)) {
                s = s + " void ";
            } else if (returnType != null) {
                s = s + " " + GeneratorCSharp.generateClassifierRef(returnType) + " ";
            }
        }
        s = s + nameStr + "(";
        boolean first = true;
        for (Object p : params) {
            if (!first) {
                s = s + ", ";
            }
            s = s + this.generateParameter(p);
            first = false;
        }
        s = s + ")";
        return s;
    }

    private String generateAttribute(Object attr, boolean documented) {
        String initStr;
        Object type;
        String temp;
        String s = "";
        String makeGet = Model.getFacade().getTaggedValueValue(attr, "get");
        String makeSet = Model.getFacade().getTaggedValueValue(attr, "set");
        boolean genAccessor = false;
        boolean bl = genAccessor = makeGet != null && makeGet.equals("true") || makeSet != null && makeSet.equals("true");
        if (documented) {
            s = s + this.generateConstraintEnrichedDocComment(attr) + "\n" + INDENT;
        }
        s = genAccessor ? s + " private " : s + this.generateVisibility(attr);
        s = s + this.generateScope(attr);
        s = s + this.generateChangability(attr);
        if (this.isCollection(attr) && (temp = this.generateMultiplicity(Model.getFacade().getMultiplicity(attr))).length() > 0) {
            s = s + temp + " ";
        }
        if ((type = Model.getFacade().getType(attr)) != null) {
            s = s + GeneratorCSharp.generateClassifierRef(type) + " ";
        }
        String slash = "";
        String attrName = Model.getFacade().getName(attr);
        Object vis = Model.getFacade().getVisibility(attr);
        if (Model.getVisibilityKind().getPrivate().equals(vis)) {
            attrName = Model.getFacade().getName(Model.getFacade().getOwner(attr)) + "_" + attrName;
        }
        if (genAccessor) {
            attrName = "m_" + attrName;
        }
        s = s + slash + attrName;
        Object init = Model.getFacade().getInitialValue(attr);
        if (init != null && (initStr = GeneratorCSharp.generateExpression(init).trim()).length() > 0) {
            s = s + " = " + initStr;
        }
        s = s + ";\n";
        if (genAccessor) {
            s = s + "\n";
            s = s + INDENT + this.generateVisibility(attr) + " ";
            s = s + GeneratorCSharp.generateClassifierRef(type) + " " + Model.getFacade().getName(attr);
            s = s + " {\n";
            if (makeSet != null && makeSet.equals("true")) {
                s = s + "        set { m_" + Model.getFacade().getName(attr);
                s = s + " = value; } \n";
            }
            if (makeGet != null && makeGet.equals("true")) {
                s = s + "        ";
                s = s + "get { return m_" + Model.getFacade().getName(attr) + "; } \n";
            }
            s = s + "    }\n";
        }
        return s;
    }

    private boolean isCollection(Object element) {
        int upper;
        Object multiplicity = Model.getFacade().getMultiplicity(element);
        return multiplicity != null && ((upper = Model.getFacade().getUpper(multiplicity)) > 1 || upper == -1);
    }

    private String generateParameter(Object param) {
        String s = "";
        String temp = "";
        s = s + GeneratorCSharp.generateClassifierRef(Model.getFacade().getType(param)) + " ";
        Facade fac = Model.getFacade();
        Object kind = fac.getKind(param);
        DirectionKind dirkind = Model.getDirectionKind();
        Object inoutParam = dirkind.getInOutParameter();
        if (kind != null) {
            if (kind.equals(inoutParam)) {
                s = temp = "ref " + s;
            }
            if (Model.getFacade().getKind(param).equals(Model.getDirectionKind().getOutParameter())) {
                s = temp = "out " + s;
            }
        }
        s = s + Model.getFacade().getName(param);
        return s;
    }

    private String generateClassifier(Object cls) {
        Collection ends;
        List strs;
        String makeConstructor;
        String interfaces;
        String classifierKeyword;
        String generatedName = Model.getFacade().getName(cls);
        LOG.debug((Object)("generateClassifier: " + generatedName));
        if (Model.getFacade().isAClass(cls)) {
            classifierKeyword = "class";
        } else if (Model.getFacade().isAInterface(cls)) {
            classifierKeyword = "interface";
        } else {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DocumentationManager.getComments((Object)cls, (String)"/// <summary>", (String)"/// ", (String)" /// </summary>"));
        sb.append(this.generateConstraintEnrichedDocComment(cls, "/// <summary>", "/// ", " /// </summary>")).append("\n");
        sb.append(this.generateVisibility(Model.getFacade().getVisibility(cls)));
        if (Model.getFacade().isAbstract(cls) && !Model.getFacade().isAInterface(cls)) {
            sb.append(" abstract ");
        }
        if (Model.getFacade().isLeaf(cls)) {
            sb.append(" final ");
        }
        sb.append(classifierKeyword).append(" ").append(generatedName);
        String baseClass = this.generateGeneralization(Model.getFacade().getGeneralizations(cls));
        String tv = null;
        if (!baseClass.equals("")) {
            sb.append(' ').append(": ").append(baseClass);
        }
        if (Model.getFacade().isAClass(cls) && !(interfaces = this.generateSpecification(cls)).equals("")) {
            if (baseClass.equals("")) {
                sb.append(": ");
            } else {
                sb.append(", ");
            }
            sb.append(interfaces);
        }
        sb.append("\n{");
        tv = this.generateTaggedValues(cls);
        if (tv != null && tv.length() > 0) {
            sb.append(INDENT).append(tv);
        }
        if ((makeConstructor = Model.getFacade().getTaggedValueValue(cls, "constructor")) != null && makeConstructor.equals("true")) {
            sb.append(Model.getFacade().getName(cls)).append("() {\n");
            sb.append(this.generateSection(cls));
            sb.append(INDENT).append("}\n");
        }
        if ((strs = Model.getFacade().getAttributes(cls)).size() > 0) {
            sb.append('\n');
            if (Model.getFacade().isAClass(cls)) {
                sb.append(INDENT).append("// Attributes\n");
            }
            for (Object sf : strs) {
                sb.append('\n').append(INDENT).append(this.generateAttribute(sf, false));
                tv = this.generateTaggedValues(sf);
                if (tv == null || tv.length() <= 0) continue;
                sb.append(INDENT).append(tv).append('\n');
            }
        }
        if ((ends = Model.getFacade().getAssociationEnds(cls)).size() > 0) {
            sb.append('\n');
            if (Model.getFacade().isAClass(cls)) {
                sb.append(INDENT).append("// Associations\n");
            }
            for (Object ae : ends) {
                Object a = Model.getFacade().getAssociation(ae);
                sb.append('\n');
                sb.append(INDENT).append(this.generateAssociationFrom(a, ae));
                tv = this.generateTaggedValues(a);
                if (tv == null || tv.length() <= 0) continue;
                sb.append(INDENT).append(tv);
            }
        }
        List behs = Model.getFacade().getOperations(cls);
        for (Object bf : Model.getCoreHelper().getRealizedInterfaces(cls)) {
            behs.addAll(Model.getFacade().getOperations(bf));
        }
        if (behs.size() > 0) {
            sb.append('\n');
            sb.append(INDENT).append("// Operations\n");
            for (Object bf : behs) {
                StringBuffer sbtemp = new StringBuffer();
                sbtemp.append('\n').append(INDENT);
                Object parent = Model.getFacade().getOwner(bf);
                if (Model.getFacade().isAInterface(parent)) {
                    sbtemp.append("public ");
                }
                sbtemp.append(this.generateOperation(bf, true));
                tv = this.generateTaggedValues(bf);
                if (Model.getFacade().isAClass(cls) && Model.getFacade().isAOperation(bf) && !Model.getFacade().isAbstract(bf)) {
                    sbtemp.append('\n').append(INDENT).append("{\n");
                    if (tv.length() > 0) {
                        sbtemp.append(INDENT).append(tv);
                    }
                    sbtemp.append(this.generateMethodBody(bf));
                    sbtemp.append('\n');
                    sbtemp.append(INDENT).append("}\n");
                } else {
                    sbtemp.append(";\n");
                    if (tv.length() > 0) {
                        sbtemp.append(INDENT).append(tv).append('\n');
                    }
                }
                sb.append(sbtemp);
            }
        }
        sb.append("} /* end ").append(classifierKeyword).append(' ');
        sb.append(generatedName).append(" */\n");
        return sb.toString();
    }

    private String generateMethodBody(Object op) {
        if (op != null) {
            return this.generateSection(op);
        }
        return this.generateDefaultReturnStatement(null);
    }

    private String generateDefaultReturnStatement(Object cls) {
        if (cls == null) {
            return "";
        }
        String clsName = Model.getFacade().getName(cls);
        if (clsName.equals("void")) {
            return "";
        }
        if (clsName.equals("char")) {
            return "    return 'x';\n";
        }
        if (clsName.equals("int")) {
            return "    return 0;\n";
        }
        if (clsName.equals("boolean")) {
            return "    return false;\n";
        }
        if (clsName.equals("byte")) {
            return "    return 0;\n";
        }
        if (clsName.equals("long")) {
            return "    return 0;\n";
        }
        if (clsName.equals("float")) {
            return "    return 0.0;\n";
        }
        if (clsName.equals("double")) {
            return "    return 0.0;\n";
        }
        return "    return null;\n";
    }

    private String generateTaggedValues(Object e) {
        Iterator iter = Model.getFacade().getTaggedValues(e);
        if (!iter.hasNext()) {
            return "";
        }
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        String s = null;
        while (iter.hasNext()) {
            s = this.generateTaggedValue(iter.next());
            if (s == null || s.length() <= 0 || s.contains("documentation")) continue;
            if (first) {
                buf.append("/* {");
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(s);
        }
        if (!first) {
            buf.append("}*/\n");
        }
        return buf.toString();
    }

    private String generateTaggedValue(Object tv) {
        if (tv == null) {
            return "";
        }
        String s = GeneratorCSharp.generateUninterpreted(Model.getFacade().getValueOfTag(tv));
        if (s == null || s.length() == 0 || s.equals("/** */")) {
            return "";
        }
        return Model.getFacade().getTagOfTag(tv) + "=" + s;
    }

    private String generateConstraintEnrichedDocComment(Object me, Object ae) {
        String sDocComment = this.generateConstraintEnrichedDocComment(me);
        if (this.isCollection(ae)) {
            sDocComment = sDocComment != null ? sDocComment.substring(0, sDocComment.indexOf("*/") + 1) : "";
            sDocComment = sDocComment + " @element-type ";
            sDocComment = sDocComment + Model.getFacade().getName(Model.getFacade().getType(ae));
            sDocComment = sDocComment + "\n     */";
            return sDocComment;
        }
        if (sDocComment != null) {
            return sDocComment;
        }
        return "";
    }

    private String generateConstraintEnrichedDocComment(Object me) {
        return this.generateConstraintEnrichedDocComment(me, "/// <summary> ", "/// ", "/// </summary>");
    }

    private String generateConstraintEnrichedDocComment(Object me, String header, String prefix, String footer) {
        Collection cConstraints;
        String sDocComment = DocumentationManager.getDocs((Object)me, (String)"", (String)header, (String)prefix, (String)footer);
        LOG.debug((Object)("sDocComment: " + sDocComment));
        if (sDocComment != null) {
            int i = sDocComment.indexOf(10);
            while (i >= 0 && i < sDocComment.length()) {
                sDocComment = sDocComment.substring(0, i + 1) + INDENT + sDocComment.substring(i + 1);
                i = sDocComment.indexOf(10, i + 1);
            }
        }
        if ((cConstraints = Model.getFacade().getConstraints(me)).size() == 0) {
            if (sDocComment != null) {
                return sDocComment;
            }
            return "";
        }
        sDocComment = sDocComment != null ? sDocComment.substring(0, sDocComment.indexOf(footer) + 1) : "";
        ArgoFacade mf = new ArgoFacade(me);
        for (Object constraint : cConstraints) {
            try {
                OclTree otParsed = OclTree.createTree((String)((String)Model.getFacade().getBody(Model.getFacade().getBody(constraint))), (ModelFacade)mf);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class TagExtractor
                extends DepthFirstAdapter {
                    private LinkedList<String> llsTags = new LinkedList();
                    private String constraintName;
                    private int constraintID = 0;

                    public TagExtractor(String sConstraintName) {
                        this.constraintName = sConstraintName;
                    }

                    public Iterator<String> getTags() {
                        return this.llsTags.iterator();
                    }

                    public void caseAConstraintBody(AConstraintBody node) {
                        String sTag;
                        String sKind = null;
                        if (node.getStereotype() != null) {
                            sKind = node.getStereotype().toString();
                        }
                        String sExpression = null;
                        if (node.getExpression() != null) {
                            sExpression = node.getExpression().toString();
                        }
                        String sName = node.getName() != null ? node.getName().getText() : this.constraintName + "_" + this.constraintID++;
                        if (sKind == null || sExpression == null) {
                            return;
                        }
                        if (sKind.equals("inv ")) {
                            sTag = "@invariant ";
                        } else if (sKind.equals("post ")) {
                            sTag = "@post-condition ";
                        } else if (sKind.equals("pre ")) {
                            sTag = "@pre-condition ";
                        } else {
                            return;
                        }
                        sTag = sTag + sName + ": " + sExpression;
                        this.llsTags.addLast(sTag);
                    }
                }
                TagExtractor te = new TagExtractor(Model.getFacade().getName(constraint));
                otParsed.apply((Switch)te);
                Iterator<String> j = te.getTags();
                while (j.hasNext()) {
                    sDocComment = sDocComment + " " + j.next() + "\n" + INDENT + " ///";
                }
            }
            catch (IOException ioe) {
            }
        }
        sDocComment = sDocComment + "\n" + footer;
        return sDocComment;
    }

    private String generateAssociationFrom(Object association, Object associationEnd) {
        String s = "";
        for (Object associationEnd2 : Model.getFacade().getConnections(association)) {
            if (associationEnd2 == associationEnd) continue;
            s = s + this.generateConstraintEnrichedDocComment(association, associationEnd2);
            s = s + "\n";
            s = s + this.generateAssociationEnd(associationEnd2);
        }
        return s;
    }

    private String generateAssociation(Object a) {
        String s = "";
        return s;
    }

    private String generateAssociationEnd(Object associationEnd) {
        if (!Model.getFacade().isNavigable(associationEnd)) {
            return "";
        }
        String s = INDENT;
        String tempS = "";
        s = INDENT;
        s = s + this.generateVisibility(Model.getFacade().getVisibility(associationEnd));
        if (Model.getExtensionMechanismsHelper().hasStereotype(associationEnd, "event")) {
            s = s + "event ";
        }
        if (Model.getFacade().isStatic(associationEnd)) {
            // empty if block
        }
        if (tempS.length() > 0) {
            s = s + tempS + " ";
        }
        String name = Model.getFacade().getName(associationEnd);
        Object association = Model.getFacade().getAssociation(associationEnd);
        s = this.isCollection(associationEnd) ? s + GeneratorCSharp.generateClassifierRef(Model.getFacade().getType(associationEnd)) + " " : s + "ArrayList ";
        String associationName = Model.getFacade().getName(association);
        if (name != null && name != null && name.length() > 0) {
            s = s + " " + name;
        } else if (associationName != null && associationName != null && associationName.length() > 0) {
            s = s + " " + associationName;
        } else {
            s = s + " my";
            s = s + GeneratorCSharp.generateClassifierRef(Model.getFacade().getType(associationEnd));
        }
        return s + ";\n";
    }

    private String generateGeneralization(Collection generalizations) {
        if (generalizations == null || generalizations.size() == 0) {
            return "";
        }
        ArrayList<Object> classes = new ArrayList<Object>();
        for (Object generalization : generalizations) {
            Object generalizableElement = Model.getFacade().getGeneral(generalization);
            if (generalizableElement == null) continue;
            classes.add(generalizableElement);
        }
        return this.generateClassList(classes);
    }

    private String generateSpecification(Object cls) {
        String s = "";
        Collection realizations = Model.getCoreHelper().getRealizedInterfaces(cls);
        if (realizations.size() == 0) {
            return "";
        }
        Iterator clsEnum = realizations.iterator();
        while (clsEnum.hasNext()) {
            Object i = clsEnum.next();
            s = s + GeneratorCSharp.generateClassifierRef(i);
            if (!clsEnum.hasNext()) continue;
            s = s + ", ";
        }
        return s;
    }

    private String generateClassList(Collection classifiers) {
        String s = "";
        if (classifiers == null) {
            return "";
        }
        Iterator clsEnum = classifiers.iterator();
        while (clsEnum.hasNext()) {
            s = s + GeneratorCSharp.generateClassifierRef(clsEnum.next());
            if (!clsEnum.hasNext()) continue;
            s = s + ", ";
        }
        return s;
    }

    private String generateVisibility(Object handle) {
        Object visibility = Model.getFacade().isAFeature(handle) ? Model.getFacade().getVisibility(handle) : handle;
        if (Model.getVisibilityKind().getPublic().equals(visibility)) {
            return "public ";
        }
        if (Model.getVisibilityKind().getPrivate().equals(visibility)) {
            return "private ";
        }
        if (Model.getVisibilityKind().getProtected().equals(visibility)) {
            return "protected ";
        }
        return "";
    }

    private String generateScope(Object feature) {
        if (Model.getFacade().isStatic(feature)) {
            return "static ";
        }
        return "";
    }

    private String generateAbstractness(Object op) {
        if (Model.getFacade().isAbstract(op)) {
            return "abstract ";
        }
        if (Model.getFacade().isRoot(op)) {
            return "virtual ";
        }
        return "";
    }

    private String generateChangeability(Object op) {
        if (Model.getFacade().isLeaf(op)) {
            return " sealed ";
        }
        return "";
    }

    private String generateChangability(Object sf) {
        Object ck = Model.getFacade().getChangeability(sf);
        if (Model.getChangeableKind().getFrozen().equals(ck)) {
            return " sealed ";
        }
        return "";
    }

    private String generateMultiplicity(Object multiplicity) {
        if (multiplicity == null) {
            return "";
        }
        return Model.getFacade().toString(multiplicity);
    }

    private String generateState(Object m) {
        return Model.getFacade().getName(m);
    }

    private String generateStateBody(Object state) {
        String entryStr;
        LOG.debug((Object)"GeneratorCSharp: generating state body");
        String s = "";
        Object entry = Model.getFacade().getEntry(state);
        Object exit = Model.getFacade().getExit(state);
        if (entry != null && (entryStr = this.generateAction(entry)).length() > 0) {
            s = s + "entry / " + entryStr;
        }
        if (exit != null) {
            String exitStr = this.generateAction(exit);
            if (s.length() > 0) {
                s = s + "\n";
            }
            if (exitStr.length() > 0) {
                s = s + "exit / " + exitStr;
            }
        }
        Collection trans = Model.getFacade().getInternalTransitions(state);
        for (Object tran : trans) {
            if (s.length() > 0) {
                s = s + "\n";
            }
            s = s + this.generateTransition(tran);
        }
        return s;
    }

    private String generateTransition(Object state) {
        String s = Model.getFacade().getName(state);
        String t = this.generateEvent(Model.getFacade().getTrigger(state));
        String g = this.generateGuard(Model.getFacade().getGuard(state));
        String e = this.generateAction(Model.getFacade().getEffect(state));
        if (s.length() > 0) {
            s = s + ": ";
        }
        s = s + t;
        if (g.length() > 0) {
            s = s + " [" + g + "]";
        }
        if (e.length() > 0) {
            s = s + " / " + e;
        }
        return s;
    }

    private String generateAction(Object m) {
        Object script = Model.getFacade().getScript(m);
        if (script != null && Model.getFacade().getBody(script) != null) {
            return Model.getFacade().getBody(script).toString();
        }
        return "";
    }

    private String generateGuard(Object guard) {
        if (Model.getFacade().getExpression(guard) != null) {
            return GeneratorCSharp.generateExpression(Model.getFacade().getExpression(guard));
        }
        return "";
    }

    private String generateMessage(Object message) {
        if (message == null) {
            return "";
        }
        return Model.getFacade().getName(message) + "::" + this.generateAction(Model.getFacade().getAction(message));
    }

    private String generateEvent(Object modelElement) {
        if (!Model.getFacade().isAEvent(modelElement)) {
            throw new ClassCastException(modelElement.getClass() + " has wrong object type, Event required");
        }
        return "";
    }

    private String generateSection(Object cls) {
        String id = UUIDHelper.getUUID((Object)cls);
        assert (id != null);
        return Section.generate(id, INDENT);
    }

    public String getName() {
        return "GeneratorCSharp";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "CSharp Notation and Code Generator";
            }
            case 1: {
                return "Mike Lipki";
            }
            case 2: {
                return "0.1.0 - $Id: GeneratorCSharp.java 280 2010-01-11 21:16:34Z linus $";
            }
        }
        return null;
    }

    public boolean enable() {
        GeneratorManager.getInstance().addGenerator(this.myLang, (CodeGenerator)this);
        return true;
    }

    public boolean disable() {
        GeneratorManager.getInstance().removeGenerator(this.myLang);
        return true;
    }

    private String generateActionState(Object actionState) {
        Object expression;
        String ret = "";
        Object action = Model.getFacade().getEntry(actionState);
        if (action != null && (expression = Model.getFacade().getScript(action)) != null) {
            ret = GeneratorCSharp.generateExpression(expression);
        }
        return ret;
    }

    private String generateImports(Object cls, String packagePath) {
        StringBuffer sb = new StringBuffer(80);
        HashSet<String> importSet = new HashSet<String>();
        for (Object mFeature : Model.getFacade().getFeatures(cls)) {
            if (Model.getFacade().isAAttribute(mFeature)) {
                this.addImportType(importSet, mFeature, packagePath);
                continue;
            }
            if (!Model.getFacade().isAOperation(mFeature)) continue;
            for (Object parameter : Model.getFacade().getParameters(mFeature)) {
                this.addImportType(importSet, parameter, packagePath);
            }
            for (Object parameter : Model.getCoreHelper().getReturnParameters(mFeature)) {
                this.addImportType(importSet, parameter, packagePath);
            }
            for (Object signal : Model.getFacade().getRaisedSignals(mFeature)) {
                if (!Model.getFacade().isAException(signal)) continue;
                this.addImport(importSet, signal, packagePath);
            }
        }
        for (Object gen : Model.getFacade().getGeneralizations(cls)) {
            Object parent = Model.getFacade().getGeneral(gen);
            if (parent == cls) continue;
            this.addImport(importSet, parent, packagePath);
        }
        for (Object iface : Model.getFacade().getSpecifications(cls)) {
            this.addImport(importSet, iface, packagePath);
        }
        for (Object associationEnd : Model.getFacade().getAssociationEnds(cls)) {
            Object association = Model.getFacade().getAssociation(associationEnd);
            for (Object associationEnd2 : Model.getFacade().getConnections(association)) {
                if (associationEnd2 == associationEnd || !Model.getFacade().isNavigable(associationEnd2) || Model.getFacade().isAbstract(Model.getFacade().getAssociation(associationEnd2))) continue;
                if (this.isCollection(associationEnd2)) {
                    importSet.add("System.Collections");
                    continue;
                }
                this.addImportType(importSet, associationEnd2, packagePath);
            }
        }
        for (String imp : importSet) {
            sb.append("using ").append(imp).append(";");
            sb.append(LINE_SEPARATOR);
        }
        if (!importSet.isEmpty()) {
            sb.append(LINE_SEPARATOR);
        }
        sb.append("// In this section you can add your own using directives");
        sb.append(LINE_SEPARATOR);
        sb.append(this.generateSection(cls));
        return sb.toString();
    }

    private String generateImport(Object element, String exclude) {
        String p;
        String ret = null;
        if (element != null && Model.getFacade().getNamespace(element) != null && !(p = this.getPackageName(Model.getFacade().getNamespace(element))).equals(exclude)) {
            ret = p;
            ret = p.length() > 0 ? p : null;
        }
        return ret;
    }

    private void addImport(Set<String> imports, Object element, String exclude) {
        String importString = this.generateImport(element, exclude);
        if (importString != null) {
            imports.add(importString);
        }
    }

    private void addImportType(Set<String> imports, Object feature, String exclude) {
        Object type = Model.getFacade().getType(feature);
        this.addImport(imports, type, exclude);
    }

    public String getPackageName(Object namespace) {
        if (namespace == null || !Model.getFacade().isANamespace(namespace) || Model.getFacade().getNamespace(namespace) == null) {
            return "";
        }
        String packagePath = Model.getFacade().getName(namespace);
        while ((namespace = Model.getFacade().getNamespace(namespace)) != null) {
            if (Model.getFacade().getNamespace(namespace) == null) continue;
            packagePath = Model.getFacade().getName(namespace) + '.' + packagePath;
        }
        return packagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SourceUnit> generate(Collection elements, boolean deps) {
        LOG.debug((Object)"generate() called");
        File tmpdir = null;
        try {
            tmpdir = TempFileUtils.createTempDir();
            if (tmpdir != null) {
                this.generateFiles(elements, tmpdir.getPath(), deps);
                Collection collection = TempFileUtils.readAllFiles((File)tmpdir);
                return collection;
            }
            List<SourceUnit> list = Collections.emptyList();
            return list;
        }
        finally {
            if (tmpdir != null) {
                TempFileUtils.deleteDir((File)tmpdir);
            }
            LOG.debug((Object)"generate() terminated");
        }
    }

    public Collection<String> generateFiles(Collection elements, String path, boolean deps) {
        LOG.debug((Object)"generateFiles() called");
        for (Object element : elements) {
            GeneratorCSharp.generateFile(element, path);
        }
        return TempFileUtils.readFileNames((File)new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> generateFileList(Collection elements, boolean deps) {
        LOG.debug((Object)"generateFileList() called");
        File tmpdir = null;
        try {
            tmpdir = TempFileUtils.createTempDir();
            for (Object element : elements) {
                GeneratorCSharp.generateFile(element, tmpdir.getName());
            }
            Collection collection = TempFileUtils.readFileNames((File)tmpdir);
            return collection;
        }
        finally {
            if (tmpdir != null) {
                TempFileUtils.deleteDir((File)tmpdir);
            }
        }
    }

    private static String generateExpression(Object expr) {
        if (Model.getFacade().isAExpression(expr)) {
            return GeneratorCSharp.generateUninterpreted((String)Model.getFacade().getBody(expr));
        }
        if (Model.getFacade().isAConstraint(expr)) {
            return GeneratorCSharp.generateExpression(Model.getFacade().getBody(expr));
        }
        return "";
    }

    private static String generateUninterpreted(String un) {
        if (un == null) {
            return "";
        }
        return un;
    }

    private static String generateClassifierRef(Object cls) {
        if (cls == null) {
            return "";
        }
        return Model.getFacade().getName(cls);
    }

    static {
        LOG = Logger.getLogger(GeneratorCSharp.class);
        INSTANCE = new GeneratorCSharp();
    }
}

