/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Progress
extends Frame
implements ActionListener {
    private int _total;
    private int _current = 0;
    private boolean _canceled = false;
    private Canvas _barCanvas;
    private Label _header;
    private TextField _message;
    private Button _cancelButton;
    private static final int BAR_WIDTH = 250;
    private static final int BAR_HEIGHT = 20;
    private static final int BORDER = 10;

    public Progress(String header, int total) {
        this._header = new Label(header);
        this._total = total;
        if (this._total < 1) {
            this._total = 1;
        }
        this.build();
        this.setTitle("Progress");
    }

    public void advance() {
        ++this._current;
        this.paintBar();
    }

    public int current() {
        return this._current;
    }

    public int total() {
        return this._total;
    }

    public int percentComplete() {
        return this._current * 100 / this._total;
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void setMessage(String m) {
        this._message.setText(m);
        this.update(this.getGraphics());
    }

    protected int pixelsComplete() {
        return this._current * 250 / this._total;
    }

    protected void build() {
        this.add(this._header);
        this._header.setAlignment(1);
        this._header.setFont(new Font("Times Roman", 1, 18));
        this.setLayout(new GridLayout(4, 1, 10, 0));
        this._barCanvas = new Canvas();
        this._barCanvas.setSize(270, 40);
        this.add(this._barCanvas);
        this._message = new TextField("Working...");
        this._message.setEditable(false);
        this.add(this._message);
        Panel buttonPanel = new Panel();
        this._cancelButton = new Button("Cancel");
        this._cancelButton.addActionListener(this);
        buttonPanel.add(this._cancelButton);
        this.add(buttonPanel);
        this.pack();
    }

    public void paint(Graphics g) {
        this.paintBar();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this._cancelButton) {
            this._canceled = true;
            this._cancelButton.setBackground(Color.darkGray);
        }
    }

    protected void paintBar() {
        Graphics g = this._barCanvas.getGraphics();
        Image off = this.createImage(270, 40);
        Graphics offG = off.getGraphics();
        offG.setColor(this.getBackground());
        offG.fillRect(0, 0, 270, 40);
        offG.setColor(Color.gray);
        offG.fillRect(10, 10, this.pixelsComplete(), 20);
        offG.setColor(Color.darkGray);
        offG.draw3DRect(11, 11, this.pixelsComplete() - 1, 18, true);
        offG.setColor(Color.black);
        offG.drawRect(10, 10, 250, 20);
        String perString = Integer.toString(this.percentComplete()) + "% Complete";
        g.setFont(new Font("Times Roman", 0, 12));
        FontMetrics fm = g.getFontMetrics();
        int halfHeight = fm.getHeight() / 2;
        int halfWidth = fm.stringWidth(perString) / 2;
        offG.drawString(perString, 135 - halfWidth, 20 + halfHeight);
        g.drawImage(off, 0, 0, null);
        offG.dispose();
        off.flush();
    }

    public static void main(String[] argv) {
        Progress _p = new Progress("Test", 100);
        _p.setVisible(true);
        for (int i = 0; i < 100; ++i) {
            System.out.println(i);
            if (_p.canceled()) break;
            _p.advance();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        _p.setVisible(false);
        _p.dispose();
    }
}

