#!/usr/bin/python
#
#    IBM Omni driver
#    Copyright (c) International Business Machines Corp., 2000-2004
#
#    This library is free software; you can redistribute it and/or modify
#    it under the terms of the GNU Lesser General Public License as published
#    by the Free Software Foundation; either version 2.1 of the License, or
#    (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
#    the GNU Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public License
#    along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

from Utils import *

class DeviceOutputBins:
    def __init__ (self, filename, rootElement):
        print 'Parsing "%s"' % filename

        self.filename    = filename
        self.rootElement = rootElement
        self.outputbins  = []

        error = self.isValid ()
        if error != None:
            e = "Error: '%s' is not a valid device. %s" % (filename, error)
            raise Exception, e

    def isValidName (self, name):
        return name in [ "Booklet",       \
                         "Bottom",        \
                         "Center",        \
                         "FaceDown",      \
                         "FaceUp",        \
                         "FitMedia",      \
                         "LargeCapacity", \
                         "Left",          \
                         "Mailbox-1",     \
                         "Mailbox-2",     \
                         "Mailbox-3",     \
                         "Mailbox-4",     \
                         "Mailbox-5",     \
                         "Mailbox-6",     \
                         "Mailbox-7",     \
                         "Mailbox-8",     \
                         "Mailbox-9",     \
                         "Rear",          \
                         "Right",         \
                         "Side",          \
                         "Stacker-1",     \
                         "Stacker-2",     \
                         "Stacker-3",     \
                         "Stacker-4",     \
                         "Stacker-5",     \
                         "Stacker-6",     \
                         "Stacker-7",     \
                         "Stacker-8",     \
                         "Stacker-9",     \
                         "Top",           \
                         "Tray-1",        \
                         "Tray-2",        \
                         "Tray-3",        \
                         "Tray-4",        \
                         "Tray-5",        \
                         "Tray-6",        \
                         "Tray-7",        \
                         "Tray-8",        \
                         "Tray-9"         \
                       ]

    def isValid (self):
#       print self.__class__.__name__ + ".isValid"

        elmOutputBins = self.rootElement

        if elmOutputBins.nodeName != "deviceOutputBins":
            return "Missing <deviceOutputBins>, found " + elmOutputBins.nodeName

        if countChildren (elmOutputBins) < 1:
            return "At least one <deviceOutputBin> element is required"

        elmOutputBin  = firstNode (elmOutputBins.firstChild)
        elmOutputBins = nextNode (elmOutputBins)

        while elmOutputBin != None:
            if elmOutputBin.nodeName != "deviceOutputBin":
                return "Missing <deviceOutputBin>, found " + elmOutputBin.nodeName

            elm = firstNode (elmOutputBin.firstChild)

            if elm.nodeName != "name":
                return "Missing <name>, found " + elm.nodeName

            name = getValue (elm)
            elm  = nextNode (elm)

            if not self.isValidName (name):
                return "Invalid <name> " + name

            if elm.nodeName != "command":
                return "Missing <command>, found " + elm.nodeName

            command = getCommand (elm)
            elm     = nextNode (elm)

            deviceID = None
            if elm != None:
                if elm.nodeName != "deviceID":
                    return "Missing <deviceID>, found " + elm.nodeName

                deviceID = getValue (elm)
                elm      = nextNode (elm)

            elmOutputBin = nextNode (elmOutputBin)

            if elm != None:
                return "Expecting no more tags in <deviceOutputBin>"

            self.outputbins.append ((name, command, deviceID))

        if elmOutputBins != None:
            return "Expecting no more tags in <deviceOutputBins>"

        return None

    def getOutputBins (self):
        return self.outputbins
