/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gServerBrowser.h"
#include "gGame.h"
#include "gLogo.h"

#include "nServerInfo.h"
#include "nNetwork.h"

#include "rSysdep.h"
#include "rScreen.h"
#include "rConsole.h"
#include "rRender.h"

#include "uMenu.h"

#include "tMemManager.h"
#include "tSysTime.h"

#include "tDirectories.h"

int gServerBrowser::lowPort  = 4534;

int gServerBrowser::highPort = 4540;
static bool continuePoll = false;
static const int sg_simultaneous = 5;

static tOutput *sg_StartHelpText = NULL;

class gServerMenuItem;


class gServerInfo: public nServerInfo
{
public:
	gServerMenuItem *menuItem;
	
	gServerInfo():menuItem(NULL)
		{
		};
	
	virtual ~gServerInfo();
};

nServerInfo* CreateGServer()
{
	nServerInfo *ret = tNEW(gServerInfo);
	
	if (!continuePoll)
    {
		nServerInfo::StartQueryAll();
		continuePoll = true;
    }
	
	return ret;
}


class gServerMenu: public uMenu
{
public:
	void Update(); // sort the server view by score
	gServerMenu(const char *title);
	~gServerMenu();
};


class gBrowserMenuItem: public uMenuItem
{
protected:
	gBrowserMenuItem(uMenu *M,const tOutput &help): uMenuItem( M, help )
	{
	}

	virtual void RenderBackground();
};

class gServerMenuItem: public gBrowserMenuItem
{
protected:
	gServerInfo *server;

public:
	void SetServer(nServerInfo *s);
	gServerInfo *GetServer();

	virtual void Render(REAL x,REAL y,REAL alpha=1, bool selected=0);
	virtual void RenderBackground();

	virtual void Enter();

	gServerMenuItem(gServerMenu *men);
	virtual ~gServerMenuItem();
};

class gServerStartMenuItem: public gBrowserMenuItem
{
public:
	virtual void Render(REAL x,REAL y,REAL alpha=1, bool selected=0);

	virtual void Enter();

	gServerStartMenuItem(gServerMenu *men);
	virtual ~gServerStartMenuItem();
};






static bool sg_RequestLANcontinuously = false;

void gServerBrowser::BrowseMaster()
{
	sg_RequestLANcontinuously = false;

	sn_ServerInfoCreator *cback = nServerInfo::SetCreator(&CreateGServer);

	sr_con.autoDisplayAtNewline=true;
	sr_con.fullscreen=true;

#ifndef DEDICATED
	sr_SwapGL();
	sr_ClearGL();
	sr_SwapGL();
	sr_ClearGL();
#endif

	bool to=sr_textOut;
	sr_textOut=true;

	nServerInfo::DeleteAll();
	nServerInfo::GetFromMaster();
	nServerInfo::Save();

	//  gLogo::SetBig(true);
	//  gLogo::SetSpinning(false);

	sr_textOut = to;

	tOutput StartHelpTextInternet("$network_master_host_inet_help");
	sg_StartHelpText = &StartHelpTextInternet;
	sg_TalkToMaster = true;

	BrowseServers();

	sg_TalkToMaster = false;

	nServerInfo::SetCreator(cback);
}


void gServerBrowser::BrowseLAN()
{
	// TODO: reacivate and see what happens. Done.
	sg_RequestLANcontinuously = true;
//	sg_RequestLANcontinuously = false;

	sn_ServerInfoCreator *cback = nServerInfo::SetCreator(&CreateGServer);

	sr_con.autoDisplayAtNewline=true;
	sr_con.fullscreen=true;

#ifndef DEDICATED
	sr_SwapGL();
	sr_ClearGL();
	sr_SwapGL();
	sr_ClearGL();
#endif

	bool to=sr_textOut;
	sr_textOut=true;

	nServerInfo::DeleteAll();
	nServerInfo::GetFromLAN(lowPort, highPort);

	sr_textOut = to;

	tOutput StartHelpTextLAN("$network_master_host_lan_help");
	sg_StartHelpText = &StartHelpTextLAN;
	sg_TalkToMaster = false;
  
	BrowseServers();

	nServerInfo::SetCreator(cback);
}

void gServerBrowser::BrowseServers()
{
	nServerInfo::StartQueryAll();
	continuePoll = nServerInfo::DoQueryAll(sg_simultaneous);

	gServerMenu browser("Server Browser");

	gServerStartMenuItem start(&browser);

	/*
	  while (nServerInfo::DoQueryAll(sg_simultaneous));
	  sn_SetNetState(nSTANDALONE);
	  nServerInfo::Sort();

	  if (nServerInfo::GetFirstServer())
	  ConnectToServer(nServerInfo::GetFirstServer());
	*/
	browser.Update();
	browser.Enter();

	nServerInfo::GetFromLANContinuouslyStop();

	//  gLogo::SetBig(false);
	//  gLogo::SetSpinning(true);
	// gLogo::SetDisplayed(true);
}







void gServerMenu::Update()
{
	// get currently selected server
	gServerMenuItem *item = NULL;
	if ( selected < items.Len() )
		item = dynamic_cast<gServerMenuItem*>(items(selected));
	gServerInfo* info = NULL;
	if ( item )
	{
		info = item->GetServer();
	}

	ReverseItems();

	nServerInfo::Sort();

	int mi = 1;
	nServerInfo *run = nServerInfo::GetFirstServer();
	while (run)
    {
		if (mi >= items.Len())
			tNEW(gServerMenuItem)(this);
      
		gServerMenuItem *item = dynamic_cast<gServerMenuItem*>(items(mi));
		item->SetServer(run);
		run = run->Next();
		mi ++;
    }

	if (items.Len() == 1)
		selected = 1;
  
	while(mi < items.Len() && items.Len() > 2)
    {
		uMenuItem *it = items(items.Len()-1);
		delete it;
    }

	ReverseItems();

	// set cursor to currently selected server
	if ( info )
	{
		selected = info->menuItem->GetID();
	}

	if (sg_RequestLANcontinuously)
    {
		static REAL timeout=-1E+32f;
      
		if (timeout < tSysTimeFloat())
		{
			nServerInfo::GetFromLANContinuously();
			if (!continuePoll)
			{
				nServerInfo::StartQueryAll();
				continuePoll = true;
			}
			timeout = tSysTimeFloat()+10;
		}
    }
}

gServerMenu::gServerMenu(const char *title)
	: uMenu(title, false)
{
	nServerInfo *run = nServerInfo::GetFirstServer();
	while (run)
    {
		gServerMenuItem *item = tNEW(gServerMenuItem)(this);
		item->SetServer(run);
		run = run->Next();
    }

	ReverseItems();

	if (items.Len() <= 0)
    {
		selected = 1;
		tNEW(gServerMenuItem)(this);
    }
	else
		selected = items.Len();
}

gServerMenu::~gServerMenu()
{
	for (int i=items.Len()-1; i>=0; i--)
		delete items(i);
}

#ifndef DEDICATED
static REAL text_height=.05;
static REAL text_width=.025;

static REAL shrink = .6f;
static REAL displace = .15;

static void Render(REAL y, 
				   const tString &servername, const tString &score,
				   const tString &users     , const tString &ping)
{
	if (sr_glOut)
    {
		rTextField c(-.9f, y+text_height*.5, text_width, text_height);
		c.SetWidth(1000);
      
		c.SetIndent(5);
      
		tString text;
		if (servername.Len() > 1)
			text << servername;  
		else
			text << tOutput("$network_master_unknown");

		if (ping.Len() > 1)
		{
			text.SetPos(static_cast<int>(1.35/c.GetCWidth())  - ping.Len(), false );
			text << ping;
		}

		if (users.Len() > 1)
		{
			text.SetPos(static_cast<int>(1.6/c.GetCWidth() ) - users.Len(), false );
			text << users;
		}

		if (score.Len() > 1)
		{
			text.SetPos(static_cast<int>(1.8/c.GetCWidth() ) - score.Len(), false );
			text << score;
		}

		c << text;
    }
}

static void Render(REAL y, 
				   const tOutput &servername, const tOutput &score,
				   const tOutput &users     , const tOutput &ping)
{
	tString sn, s, u, p;
	sn << servername;
	s  << score;
	u  << users;
	p  << ping;
	::Render(y, sn, s, u, p);
}

#endif

void gServerMenuItem::Render(REAL x,REAL y,REAL alpha, bool selected)
{
#ifndef DEDICATED
	REAL time=tSysTimeFloat()*10;
  
	if(selected)
		glColor4f(.8+.2*sin(time),.3-.1*sin(time),.3-.1*sin(time),alpha);
	else
		glColor4f(1,1,1,alpha);


	if (server)
    {
		tString score;
		tString users;
		tString ping;
      
		int p = static_cast<int>(server->Ping()*1000);
		if (p < 0)
			p = 0;
		if (p > 10000)
			p = 10000;

		int s = static_cast<int>(server->Score());
		if (server->Score() > 10000)
			s = 10000;
		if (server->Score() < -10000)
			s = -10000;
      
		if (server->Polling())
		{
			score << tOutput("$network_master_polling");
		}
		else if (!server->Reachable())
		{
			score << tOutput("$network_master_unreachable");
		}
		else if ( nServerInfo::Compat_Ok != server->Compatibility() )
		{
			switch( server->Compatibility() )
			{
				case nServerInfo::Compat_Upgrade:
					score << tOutput( "$network_master_upgrage" );
					break;
				case nServerInfo::Compat_Downgrade:
					score << tOutput( "$network_master_downgrage" );
					break;
				default:
					score << tOutput( "$network_master_incompatible" );
					break;
			}
		}
		else if ( server->Users() >= server->MaxUsers() )
		{
			score << tOutput( "$network_master_full" );
		}
		else
		{
			score << s;
			users << server->Users();
			ping  << p;
		}

		::Render(y*shrink + displace, 
				 server->Name(), 
				 score, users, ping);
    }
	else
    {
		tOutput o("$network_master_noserver");
		tString s;
		s << o;
		::Render(y*shrink + displace, 
				 s, 
				 "", "", "");
      
    }
#endif
}


void gServerMenuItem::RenderBackground()
{
#ifndef DEDICATED
	gBrowserMenuItem::RenderBackground();

	if ( server )
	{
		glColor3f(1,1,1);

		rTextField players( -.9, -.3, text_width, text_height );
		players << tOutput( "$network_master_players" );
		if ( server->UserNamesOneLine().Len() > 2 )
			players << server->UserNamesOneLine();
		else
			players << tOutput( "$network_master_players_empty" );
	}
#endif
}

void gBrowserMenuItem::RenderBackground()
{
	sn_Receive();

	menu->GenericBackground();
	if (continuePoll)
    {
		continuePoll = nServerInfo::DoQueryAll(sg_simultaneous);
		sn_Receive();
    }

	static REAL timeout=-1E+32f;

	if (timeout < tSysTimeFloat())
	{
		(static_cast<gServerMenu*>(menu))->Update();
		timeout = tSysTimeFloat()+2.0f;
	}

#ifndef DEDICATED
	glColor4f(.8,.3,.3,1);

	::Render(.62, 
			 tOutput("$network_master_servername"),
			 tOutput("$network_master_score"),
			 tOutput("$network_master_users"),
			 tOutput("$network_master_ping"));
#endif
}

void gServerMenuItem::Enter()
{
	nServerInfo::GetFromLANContinuouslyStop();

	menu->Exit();

	//  gLogo::SetBig(false);
	//  gLogo::SetSpinning(true);
	// gLogo::SetDisplayed(false);

	if (server)
		ConnectToServer(server);
}


void gServerMenuItem::SetServer(nServerInfo *s)
{
	if (s == server)
		return;
	
	if (server)
		server->menuItem = NULL;
	
	server = dynamic_cast<gServerInfo*>(s);
	
	if (server)
    {
		if (server->menuItem)
			server->menuItem->SetServer(NULL);
		
		server->menuItem = this;
    }
}

gServerInfo *gServerMenuItem::GetServer()
{
	return server;
}

static char *sg_HelpText = "$network_master_browserhelp";

gServerMenuItem::gServerMenuItem(gServerMenu *men)
	:gBrowserMenuItem(men, sg_HelpText), server(NULL)
{}

gServerMenuItem::~gServerMenuItem()
{
	SetServer(NULL);

	// make sure the last entry in the array (the first menuitem)
	// stays the same
	uMenuItem* last = menu->Item(menu->NumItems()-1);
	menu->RemoveItem(last);
	menu->RemoveItem(this);
	menu->AddItem(last);
}


gServerInfo::~gServerInfo()
{
	if (menuItem)
		delete menuItem;
}


void gServerStartMenuItem::Render(REAL x,REAL y,REAL alpha, bool selected)
{
#ifndef DEDICATED
	REAL time=tSysTimeFloat()*10;

	if(selected)
		glColor4f(.8+.2*sin(time),.3-.1*sin(time),.3-.1*sin(time),alpha);
	else
		glColor4f(1,1,1,alpha);


	::Render(y*shrink + displace, 
			 tOutput("$network_master_start"), 
			 "", "", "");
#endif
}

void gServerStartMenuItem::Enter()
{
	nServerInfo::GetFromLANContinuouslyStop();

	menu->Exit();

	//  gLogo::SetBig(false);
	//  gLogo::SetSpinning(true);
	// gLogo::SetDisplayed(false);

	sg_HostGameMenu();
}



gServerStartMenuItem::gServerStartMenuItem(gServerMenu *men)
	:gBrowserMenuItem(men, *sg_StartHelpText)
{}

gServerStartMenuItem::~gServerStartMenuItem()
{
}


