/* GDC -- D front-end for GCC
   Copyright (C) 2004 David Friedman
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* eventually #ifdef HAVE_SYS_MMAN... */
#include "config.h"

#include <sys/types.h>
#include <signal.h>
#include <sys/signal.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <errno.h>


#ifdef HAVE_SEMAPHORE_H
#include <semaphore.h>
#endif
#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

#include "makestruct.h"

void c_fcntl()
{
    printf("enum {\n");
    CES( O_RDONLY );
    CES( O_WRONLY );
    CES( O_RDWR );
    CES( O_NONBLOCK );
    CES( O_CREAT );
    CES( O_EXCL );
    CES( O_TRUNC );
    CES( O_APPEND );
#ifdef O_NOFOLLOW
    CES( O_NOFOLLOW );
#endif
    printf("}\n");
    printf("\n");
    printf("enum {\n");
    CES( F_DUPFD );
    CES( F_GETFD );
    CES( F_SETFD );
    CES( F_GETFL );
    CES( F_SETFL );
    // todo: locking, signaling, misc features
    printf("}\n");
    
    printf("\n");
}

void c_time() {
    time_t cool;
    INT_TYPE(time_t);

    {
	FieldInfo fi[2];
	struct timespec rec;
	INT_FIELD(fi[0], tv_sec);
	INT_FIELD(fi[1], tv_nsec);
	finish_struct(fi, 2, "timespec");
    }
    {
	FieldInfo fi[2];
	struct timeval rec;
	INT_FIELD(fi[0], tv_sec);
	INT_FIELD(fi[1], tv_usec);
	finish_struct(fi, 2, "timeval");
    }
    {
	FieldInfo fi[2];
	struct timezone rec;
	INT_FIELD(fi[0], tz_minuteswest);
	INT_FIELD(fi[1], tz_dsttime);
	finish_struct(fi, 2, "timezone");
    }
    {
	FieldInfo fi[9];
	unsigned n;
	struct tm rec;
	INT_FIELD(fi[0], tm_sec);
	INT_FIELD(fi[1], tm_min);
	INT_FIELD(fi[2], tm_hour);
	INT_FIELD(fi[3], tm_mday);
	INT_FIELD(fi[4], tm_mon);
	INT_FIELD(fi[5], tm_year);
	INT_FIELD(fi[6], tm_wday);
	INT_FIELD(fi[7], tm_yday);
	INT_FIELD(fi[8], tm_isdst);
	n = 9;
	// just check for BSD?
#ifdef HAVE_TM_GMTOFF_AND_ZONE
	INT_FIELD(fi[n], tm_gmtoff);
	n++;
	ADD_FIELD(fi[n], "char *", tm_zone);
	n++;
#endif
	finish_struct(fi, n, "tm");
    }
}

void c_stat()
{
    printf("enum {\n");
    CES( S_IFIFO );
    CES( S_IFCHR );
    CES( S_IFDIR );
    CES( S_IFBLK );
    CES( S_IFREG );
    CES( S_IFLNK );
    CES( S_IFSOCK );
    CES( S_IFMT );
    CES( S_IRUSR );
    CES( S_IWUSR );
    CES( S_IXUSR );
    CES( S_IRGRP );
    CES( S_IWGRP );
    CES( S_IXGRP );
    CES( S_IROTH );
    CES( S_IWOTH );
    CES( S_IXOTH );
    CES( S_IRWXG ); // standard?
    CES( S_IRWXO );
    printf("}\n\n");
    
    FieldInfo fi[13];
    struct stat rec;
    INT_FIELD(fi[0], st_dev); 
    INT_FIELD(fi[1], st_ino); 
    INT_FIELD(fi[2], st_mode); 
    INT_FIELD(fi[3], st_nlink); 
    INT_FIELD(fi[4], st_uid); 
    INT_FIELD(fi[5], st_gid); 
    INT_FIELD(fi[6], st_rdev); 
    INT_FIELD(fi[7], st_size); 
    INT_FIELD(fi[8], st_blksize); 
    INT_FIELD(fi[9], st_blocks); 
    INT_FIELD(fi[10], st_atime); 
    INT_FIELD(fi[11], st_mtime); 
    INT_FIELD(fi[12], st_ctime);
    finish_struct(fi, 13, "struct_stat");
}

void c_signal()
{
    printf("// from <sys/signal.h>\n");
    printf("enum {\n");
    CES( SIGHUP );
    CES( SIGINT );
    CES( SIGQUIT );
    CES( SIGILL );
    CES( SIGABRT );
#ifdef SIGIOT
    CES( SIGIOT );
#else
    CESZ( SIGIOT );
#endif
    CES( SIGBUS );
    CES( SIGFPE );
    CES( SIGKILL );
    CES( SIGUSR1 );
    CES( SIGUSR2 );
    CES( SIGPIPE );
    CES( SIGALRM );
    CES( SIGTERM );
#ifdef SIGSTKFLT
    CES( SIGSTKFLT );
#else
    CESZ( SIGSTKFLT );
#endif
    CES( SIGCHLD );
    CES( SIGCONT );
    CES( SIGSTOP );
    CES( SIGTSTP );
    CES( SIGTTIN );
    CES( SIGTTOU );
    CES( SIGIO );
#ifdef SIGPOLL
    /* are these defined to be macros? */
    CES( SIGPOLL );
#else
    CESZ( SIGPOLL );
#endif    
#ifdef SIGWINCH
    CES( SIGWINCH );
#else
    CESZ( SIGWINCH );
#endif    
    CES( SIGURG );
#ifdef SIGTRAP
    CES( SIGTRAP );
#else
    CESZ( SIGTRAP );
#endif
    printf("}\n");

    printf("enum {\n");
    CES( SA_NOCLDSTOP );
#ifdef SA_NOCLDWAIT
    CES( SA_NOCLDWAIT );
#else
    CESZ( SA_NOCLDWAIT );
#endif
    CES( SA_SIGINFO );
#ifdef SA_ONSTACK
    CES( SA_ONSTACK );
#else
    CESZ( SA_ONSTACK );
#endif
    CES( SA_RESTART );
    CES( SA_NODEFER );
    CES( SA_RESETHAND );
    printf("}\n");
    printf("\n");

    // configure test that it is integral?
    OPAQUE_TYPE(sigset_t);

    printf("alias  void function(int) __sighandler_t;\n");
    printf("const __sighandler_t SIG_DFL = cast(__sighandler_t) %d;\n", SIG_DFL);
    printf("const __sighandler_t SIG_IGN = cast(__sighandler_t) %d;\n", SIG_IGN);
    printf("const __sighandler_t SIG_ERR = cast(__sighandler_t) %d;\n", SIG_ERR);
    printf("\n");

    {
	siginfo_t rec;
	FieldInfo fi[1];
	INT_FIELD(fi[0],si_signo);
	INT_FIELD(fi[1],si_errno);
	INT_FIELD(fi[2],si_code);
	printf("/* siginfo_t is not finished... see gen_unix.c */\n");
	finish_struct(fi, 3, "siginfo_t");
    }

    {
	struct sigaction rec;
	FieldInfo fi[4];
	ADD_FIELD(fi[0], "void function(int)",  sa_handler);
	ADD_FIELD(fi[1], "void function(int, siginfo_t *, void *)", sa_sigaction);
	ADD_FIELD(fi[2], "sigset_t", sa_mask);
	INT_FIELD(fi[3], sa_flags);
	//FN_FIELD(fi[4], "void (*sa_restorer)(void)", sa_restorer);
	//ADD_FIELD(fi[4], "void function(void)", sa_restorer);
	finish_struct(fi, 4, "sigaction_t");
    }
    // not sure about this

}

void c_mman()
{
    printf("// from <sys/mman.h>\n");
    printf("extern(D) const void * MAP_FAILED = cast(void *) %d;\n", (int) MAP_FAILED); // %% int/ptr issues
    printf("enum { PROT_NONE = %d, PROT_READ = %d, PROT_WRITE = %d, PROT_EXEC = %d }\n",
	PROT_NONE, PROT_READ, PROT_WRITE, PROT_EXEC);
    // there are more flags, but this is all that is needed for GC and other modules
    printf(
	   "enum { MAP_SHARED = 0x%x, MAP_PRIVATE = 0x%x, MAP_ANON = 0x%x,"
	   "       MAP_ANONYMOUS = 0x%x }\n",
	   MAP_SHARED, MAP_PRIVATE,
	   // not sure if these are alway macros, if not, just add an autoconf test
#ifdef MAP_ANON
	   MAP_ANON, MAP_ANON
#else
	   MAP_ANONYMOUS, MAP_ANONYMOUS
#endif
	   );
    printf("enum { MS_ASYNC = 0x%x, MS_SYNC = 0x%x, MS_INVALIDATE = 0x%x }\n",
	MS_ASYNC, MS_SYNC, MS_INVALIDATE);
    printf("\n");
}

void c_errno()
{
    printf("enum {\n");
    CES( EPERM );
    CES( ENOENT );
    CES( ESRCH );
    CES( EINTR );
    CES( ENXIO );
    CES( E2BIG );
    CES( ENOEXEC );
    CES( EBADF );
    CES( ECHILD );
#ifdef EINPROGRESS
    CES( EINPROGRESS );
#endif
#ifdef EWOULDBLOCK
    CES( EWOULDBLOCK );
#endif
#ifdef EAGAIN
    CES( EAGAIN );
#endif
    
    /* etc... */
    printf("}\n");
    printf("\n");
}

void c_semaphore() {
    unsigned sem_t_size = 0;
#ifdef HAVE_SEMAPHORE_H
    sem_t_size = sizeof(sem_t);
#endif
    printf("struct sem_t { ubyte[%u] opaque; }\n", sem_t_size);
}

void c_pthread() {
#ifdef HAVE_PTHREAD_H
    // pthread_t is a pointer on some platforms... probably not too important
    // would have to write a config test; can't think of a way to detect
    // this in C code
    INT_TYPE(pthread_t);
    
#endif
}

void c_socket() {
    printf("// from <sys/socket.h>\n");
    printf("const int SOL_SOCKET = %d\n\n;", SOL_SOCKET);
    printf("enum {\n");
    CES( SO_DEBUG );
    CES( SO_ACCEPTCONN );
    CES( SO_REUSEADDR );
    CES( SO_KEEPALIVE );
    CES( SO_DONTROUTE );
    CES( SO_BROADCAST );
#ifdef SO_USELOOPBACK
    CES( SO_USELOOPBACK );
#endif
    CES( SO_LINGER );
    CES( SO_OOBINLINE );
#ifdef SO_BSDCOMPAT
    CES( SO_BSDCOMPAT );
#endif
#ifdef SO_REUSEPORT
    CES( SO_REUSEPORT );
#endif
#ifdef SO_TIMESTAMP
    CES( SO_TIMESTAMP );
#endif
    CES( SO_SNDBUF );
    CES( SO_RCVBUF );
    CES( SO_SNDLOWAT );
    CES( SO_RCVLOWAT );
    CES( SO_SNDTIMEO );
    CES( SO_RCVTIMEO );
    CES( SO_ERROR );
    CES( SO_TYPE );
    printf("}\n");
    printf("\n");
    {
	struct linger rec;
	FieldInfo fi[2];
	INT_FIELD(fi[0],l_onoff);
	INT_FIELD(fi[1],l_linger);
	finish_struct(fi, 2, "linger");
    }
    printf("\n");
}

void c_types() {
    printf("const int __FD_SET_SIZEOF = %d;\n", sizeof(fd_set));
    printf("const int FD_SETSIZE = %d;\n", FD_SETSIZE);
    printf("\n");
}

int main()
{
    printf("extern(C) {\n\n");
    c_fcntl();
    c_time();
    c_stat();
    c_signal();
    c_mman();
    c_errno();
    c_semaphore();
    c_pthread();
    c_socket();
    c_types();
    printf("}\n\n");
    
    return 0;
}
