/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: menu.h,v 1.1.2.1 2003/08/01 13:47:53 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifndef HAVE_MENU_H
#define HAVE_MENU_H

#include <gtk/gtk.h>

typedef struct _MenuEntry MenuEntry;
typedef struct _Menu Menu;

typedef void (*MenuActivateFunc) (GtkMenuItem *item, gpointer user_data);

struct _MenuEntry {
	gchar *label;
	gint data;
	MenuActivateFunc func;
};

GtkWidget *menu_new (MenuEntry *entry, gpointer user_data);
GtkWidget *radio_menu_new (MenuEntry *entry, gpointer data);

void radio_menu_add (GtkWidget *radio_menu, GtkWidget *add_menu);
void menu_add (GtkWidget *menu, GtkWidget *add_menu);

void radio_menu_add_entry (GtkWidget *radio_menu, MenuEntry *entry, gpointer user_data);
void menu_add_entry (GtkWidget *menu, MenuEntry *entry, gpointer user_data);

gpointer menu_item_get_activate_data (GtkWidget *menu_item);

GtkWidget *menu_find_item_by_data (GtkWidget *menu, gpointer user_data);

#endif
