/*
 * commands.h
 * Thomas Nemeth, le 08.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef COMMANDS_H
#define COMMANDS_H

#include "tmms.h"

typedef struct Cmdslst {
    int    key;
    int  (*fct)();
} Cmdslst;

typedef enum {
    NoColor = -1,
    Black,
    Red,
    Green,
    Yellow,
    Blue,
    Magenta,
    Cyan,
    White
} TColor;


#define YES    1
#define NO     2
#define CANCEL 3

#define CONT   1
#define STOP   2
#define QUIT   3

int uses_color;

void init_colors   ();
int  command_loop  (Cmdslst *cmds);
void set_color     (WINDOW *win, int color);
char *robust_home  (const char *user);

#endif
