/*
 * playlist.h
 * Thomas Nemeth, le 07.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H


typedef unsigned int ListID;


typedef enum {NRM_PLAY, RND_PLAY} PlayMode;


typedef struct _PlayList {
    char             *file;   /* file or url to play   */
    ListID            sel;    /* entry selected        */
    int               played; /* played in random play */
    struct _PlayList *prev;   /* prev entry            */
    struct _PlayList *next;   /* next entry            */
} PlayList;


void playlist_add(const char *entry);
void playlist_add_sort(const char *entry);
void playlist_del(int position);
void playlist_free();
char *playlist_get(ListID n);
void playlist_move(ListID from, ListID to);
char *playlist_current();
ListID playlist_max();
void playlist_sel(ListID n, int sel);
void playlist_tsel(ListID n);
ListID playlist_get_sel(ListID n);
ListID playlist_nb_sel();
ListID playlist_first_sel();
ListID playlist_last_sel();
int playlist_next(int rotate);
int playlist_prev(int rotate);
void load_playlist(const char *dataloc);
void save_playlist(const char *filename);
ListID get_current();
void set_current(int c);
int is_playable(const char *entry);
char *get_playlist_name();
void toggle_playmode();
PlayMode get_playmode();

#endif

