/*
 * printlog.c
 *
 */

#include <stdio.h>
#ifdef OS_SunOS
#include <sys/varargs.h>
#else
#include <stdarg.h>
#endif
#include <string.h>
#include "config.h"
#include "defines.h"
#include "printlog.h"


extern FILE *logfile;


void printlog(int level, const char *format, ...) {
    va_list    ap;

    va_start(ap, format);
    if ((level != 0) && logfile && (
            ((DEBUG_LEVEL > 0) && (level <= DEBUG_LEVEL)) ||
            (level == -DEBUG_LEVEL) ) ) {
        vfprintf(logfile, format, ap);
        fflush(logfile);
    }
    va_end(ap);
}

