/*
 * tmms.h
 * Thomas Nemeth, le 07.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TMMS_H
#define TMMS_H

#include <pthread.h>

/* Access to current entry */
pthread_mutex_t mutex_current;

/* Requests and Status */
pthread_mutex_t mutex_request;
pthread_mutex_t mutex_status;

/* Display operations */
pthread_mutex_t mutex_display;


#define COLORIZED

typedef enum {NOTHING, PLAYING, PAUSED, STOPPED, FFW, RWD, NEXT, PREV} Status;
typedef enum {REPEAT_NUL, REPEAT_ONE, REPEAT_ALL} Mode;
typedef enum {NORMAL, REMAIN} TimeData;


TimeData  timedata;
char     *all_locale;


int redisp();
int quit();
int reload_list();


#endif
