.TH network-mip6.conf 5 "10 December 2002" "@VERSION@"
.SH NAME
network-mip6.conf \- MIPL Mobile IPv6 main configuration file
.SH DESCRIPTION
.B network-mip6.conf
is the main configuration file for MIPL Mobile IPv6 kernel
module. This file is used by automatic startup script to set up
parameters for the kernel module.
.SH SYNTAX
Configuration file consists of option and value pairs: OPTION=value. 
Option name must be in all capitals. Value is case-insensitive.
.SH OPTIONS
.IP "FUNCTIONALITY"
Should this node act as a home agent (ha), mobile node (mn) or
correspondent node (cn). HA and MN both have CN functionality
embedded. Default: cn.
.IP "DEBUGLEVEL"
In error situations it may be desired to get more detailed
information what is happening. Increase this value to get more
messages from the module (default: 0).
.IP "TUNNEL_SITELOCAL"
Should unicasts to node's site-local address be tunneled when mobile
node is not in its home network (default: yes).
.IP "MIN_TUNNEL_NR"
Minimum number of free tunnel devices kept in cache on MN or HA
Must be set to at least 1 for MN and HA. To ensure successful 
bindings even during high work loads it could be set to a bigger 
value on the HA.
.IP "MAX_TUNNEL_NR"
Maximum number of free tunnel devices kept in cache on MN or HA
Must be set to at least 1 for MN and HA. To improve performance
set it higher than MIN_TUNNEL_NR
.IP "HOMEADDRESS"
Home address for mobile node with prefix length. Example:
3FFE:2620:6:1234:ABCD::1/48 (Don't use the example value!)
.IP "HOMEAGENT"
Home agent's address for mobile node. 
.IP "HOMEDEVICE"
Home address is assigned to an interface.  This option specifies which
interface is used.  Example: eth0.
.SH EXAMPLES
.PP
  # Home Agent configuration file
  FUNCTIONALITY=ha
  DEBUGLEVEL=0
  TUNNEL_SITELOCAL=yes

  # Mobile Node configuration file
  FUNCTIONALITY=mn
  DEBUGLEVEL=1
  HOMEADDRESS=3ffe:2620:6:1234:abcd::2/64
  HOMEAGENT=3ffe:2620:6:1234:abcd::1/64
.PP
.SH AUTHOR
Antti J Tuominen <ajtuomin@tml.hut.fi>
.SH "SEE ALSO"
.BR mipdiag(8)
