/* Copyright (C) 2002 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * Author: 
 *        Mitsuru KANDA  <mk@linux-ipv6.org>
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <syslog.h>
#include <net/if.h>

#include "chap.h"
#include "dtcp.h"
#include "util.h"
#include "nl.h"



int
do_write(int fd, const char *msg, size_t len)
{
	return write(fd, (void *)msg, len);
}

int
do_rcvchk(char *msg)
{
	int rtn;

	if (msg==NULL)
		return -1;

	if (!strncasecmp("+OK", msg, 3)) {
		rtn = DTCP_OK;
	} else if (!strncasecmp("-ERR", msg, 4)) {
		rtn = DTCP_ERR;
	} else 
		rtn = -1;
	
	return rtn;
}


int 
detect_tuntype(char *tuntype)
{
	int retval = -1;

	if (!strcasecmp(tuntype, "host")) {
		retval = DTCP_HOST;
	} else if (!strcasecmp(tuntype, "network")) {
		retval = DTCP_NETWORK;
	} else if (!strcasecmp(tuntype, "tunnelonly")) {
		retval =  DTCP_TUNNEL_ONLY;
	}

	return retval;
}

int
send_ping(int sockfd)
{
	char msg[]= "ping\r\n";
	int len = strlen(msg);
	int rtn = 0;
	char recvbuf[BUFSIZ];
	
	rtn = do_write(sockfd, msg, len);
	if (rtn != len) {
		return -1;
	}

	if (getline(sockfd, recvbuf, sizeof(recvbuf)) < 0)
		return -1;

	rtn = do_rcvchk(recvbuf);
	if (rtn == DTCP_ERR)
		return -1;

	return 0;
}

int
send_quit(int sockfd)
{
	char msg[]= "QUIT\r\n";
	int len = strlen(msg);
	int rtn = 0;
	char recvbuf[BUFSIZ];
	
	rtn = do_write(sockfd, msg, len);
	if (rtn != len) {
		return -1;
	}

	if (getline(sockfd, recvbuf, sizeof(recvbuf)) < 0)
		return -1;

	rtn = do_rcvchk(recvbuf);
	if (rtn == DTCP_ERR)
		return -1;

	return 0;
}

