/* Copyright (C) 2002 Mitsuru KANDA */
#ifndef __NL_H__
#define __NL_H__ 1

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>

/* operation for link. if OK, return 0. */
int link_set(char *dev, int updown);
int link_set_mtu(char *dev, int mtu);
/* flag : IFF_?? */
int link_check(char *devname, int flag);

/* operation for sit device */
/* create sit device, in: remote ipv4 addr. */
int sit_set(char *devname, struct in_addr *in, int add_del);

/* operation for ipv6 address */
int ipaddr6_set(char *devname, struct in6_addr *in6, unsigned char plen, int add_or_del);

/* operation for ipv6 route */
struct in6_dst_room {
	struct in6_addr *range; /* dst range */
	struct in6_addr *gw; /* gateway */
	unsigned char   plen; /* dst rage prefix len, 0: default route  */
};

int rt6_set(char *devname, struct in6_dst_room *in6dr, int add_del);

#endif /* __NL_H__ */
