/*
 * Copyright (C) 2001 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __CTLMSG_H
#define __CTLMSG_H

#include <sys/types.h>
#include <sys/socket.h>
#include "talkaddr.h"

/* Internal structure */
struct CtlMessage {
	u_int8_t		vers;
	u_int8_t		type;
	u_int8_t		answer;
	u_int8_t		pad;
	u_int32_t		id_num;
#ifdef INET6
	struct sockaddr_storage	addr;
	struct sockaddr_storage	ctl_addr;
#else
	struct sockaddr		addr;
	struct sockaddr		ctl_addr;
#endif
	u_int32_t		pid;
	char			l_name[NAME_SIZE];
	char			r_name[NAME_SIZE];
	char			r_tty[TTY_SIZE];
};

struct CtlResponse {
	u_int8_t		vers;
	u_int8_t		type;
	u_int8_t		answer;
	u_int8_t		pad;
	u_int32_t		id_num;
#ifdef INET6
	struct sockaddr_storage	addr;
#else
	struct sockaddr		addr;
#endif
};

int cm_import(const char *msg, int msglen, struct CtlMessage *buf);
int cr_import(const char *msg, int msglen, struct CtlResponse *buf);
int cm_export(const struct CtlMessage *cm, char *buf, int buflen);
int cr_export(const struct CtlResponse *cr, char *buf, int buflen);

#endif	/* __CTLMSG_H */

