/*
 * Copyright (C) 2001 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <arpa/inet.h>
#include "talkaddr.h"

ta_family_t talkfamily(sa_family_t af){
	ta_family_t tf = TF_UNSPEC;
	switch(af) {
#ifdef AF_LOCAL
	case AF_LOCAL:
		tf = TF_LOCAL;
		break;
#endif
	case AF_INET:
		tf = TF_INET;
		break;
#ifdef INET6
	case AF_INET6:
		tf = TF_INET6;
		break;
#endif
	}
	return tf;
}

sa_family_t sockfamily(ta_family_t tf){
	sa_family_t af = AF_UNSPEC;
	switch(tf) {
#ifdef AF_LOCAL
	case TF_LOCAL:
		af = AF_LOCAL;
		break;
#endif
	case TF_INET:
		af = AF_INET;
		break;
#ifdef INET6
	case TF_INET6:
		af = AF_INET6;
		break;
#endif
	}
	return af;
}

struct talkaddr *saddr2taddr(const struct sockaddr *sa, struct talkaddr *ta) {
#ifdef INET6
	struct sockaddr_in sin_tmp;
	socklen_t salen;
#endif

	if (!sa || !ta)
		return NULL;

	memset(ta, 0, sizeof(*ta));

	switch(sa->sa_family) {
#ifdef INET6
	case AF_INET6:
	    {
		const struct sockaddr_in6 *sin6 = (const struct sockaddr_in6*)sa;
		struct talkaddr6 *ta6 = (struct talkaddr6*)ta;
		if (IN6_IS_ADDR_V4MAPPED(&sin6->sin6_addr)) {
			memset(&sin_tmp, 0, sizeof(sin_tmp));
			sin_tmp.sin_family = AF_INET;
			sin_tmp.sin_port = sin6->sin6_port;
			sin_tmp.sin_addr.s_addr = sin6->sin6_addr.s6_addr32[3];
			sa = (struct sockaddr*)&sin_tmp;
			salen = sizeof(sin_tmp);
			/* do AF_INET case */
		} else {
			ta6->ta_family = TF_INET6;
			ta6->ta_port = sin6->sin6_port;
			ta6->ta_addr6 = sin6->sin6_addr;
			break;
		}
	    }
#endif
	case AF_INET:
	    {
		const struct sockaddr_in *sin = (const struct sockaddr_in*)sa;
		ta->ta_family = TF_INET;
		ta->ta_port = sin->sin_port;
		ta->ta_addr = sin->sin_addr.s_addr;
		break;
	    }
	default:
		ta = NULL;
	}
	return ta;
}

struct sockaddr *taddr2saddr(const struct talkaddr *ta, struct sockaddr *sa) {
	if (!sa || !ta)
		return NULL;

	memset(sa, 0, sizeof(*sa));	/*XXX*/

	switch(ta->ta_family){
#ifdef INET6
	case TF_INET6:
	    {
		const struct talkaddr6 *ta6 = (const struct talkaddr6*)ta;
		struct sockaddr_in6 *sin6 = (struct sockaddr_in6*)sa;
		sin6->sin6_family = AF_INET6;
		sin6->sin6_port = ta6->ta_port;
		sin6->sin6_addr = ta6->ta_addr6;
		break;
	    }
#endif
	case TF_INET:
	    {
		struct sockaddr_in *sin = (struct sockaddr_in*)sa;
		sin->sin_family = AF_INET;
		sin->sin_port = ta->ta_port;
		sin->sin_addr.s_addr = ta->ta_addr;
		break;
	    }
	default:
		sa = NULL;
	}

	return sa;
}

