/* $USAGI: mip6.h,v 1.9 2004/04/27 09:51:37 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Noriaki TAKAMIYA @USAGI
 *	Masahide NAKAMURA @USAGI
 *	YOSHIFUJI Hideaki @USAGI
 */
#ifndef _MIP6_H
#define _MIP6_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <linux/types.h>

/* RFC3542: currently not supported */
#define	IPV6_RECVPKTINFO		IPV6_PKTINFO
#define	IPV6_RECVDSTOPTS		IPV6_DSTOPTS
#define	IPV6_RECVRTHDR			IPV6_RTHDR

/*
 *	IPv6 TLV options.
 */
#ifndef IPV6_TLV_HAO

#define IPV6_TLV_PAD0		0
#define IPV6_TLV_PADN		1
#define IPV6_TLV_ROUTERALERT	5
#define IPV6_TLV_JUMBO		194
#define IPV6_TLV_HAO		201	/* home address option */

#define __u8 unsigned char
struct destopt_hao
{
	__u8			type;
	__u8			length;
	struct in6_addr		addr;	/* Home Address */
} __attribute__ ((__packed__));
#endif


/*
 * ICMPv6
 */
#define	ICMPV6_DHAAD_REQUEST		144
#define	ICMPV6_DHAAD_REPLY		145
#define	ICMPV6_MOBILE_PREFIX_SOLICIT	146
#define	ICMPV6_MOBILE_PREFIX_ADVERT	147

/*
 * Mobility Header
 */
#ifndef IPPROTO_MH
#define IPPROTO_MH 135
#endif
#define IPPROTO_MOBILITY IPPROTO_MH /* for backward compatibility */

struct mip6_mh_hdr {
	unsigned char	nexthdr;
	unsigned char	hdrlen;
	unsigned char	type;
	unsigned char	reserved;
	unsigned short	cksum;
	unsigned char	data[0];
} __attribute__ ((__packed__));

struct mip6_mh_brr {
	unsigned short	reserved;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_test_init {
	unsigned short	reserved;
	unsigned char	cookie[8];
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_test {
	unsigned short	nonce_index;
	unsigned char	cookie[8];
	unsigned char	keygen[8];
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_bu {
	unsigned short	seq;
	unsigned char	flags;
	unsigned char	reserved;
	unsigned short	lifetime;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_ba {
	unsigned char	status;
	unsigned char	flags;
	unsigned short	seq;
	unsigned short	lifetime;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_be {
	unsigned char	status;
	unsigned char	reserved;
	struct in6_addr hoa;
} __attribute__ ((__packed__));


/*
 * Mobility Header Type
 */
#define	MIP6_MH_BRR	0
#define	MIP6_MH_HOTI	1
#define	MIP6_MH_COTI	2
#define	MIP6_MH_HOT	3
#define	MIP6_MH_COT	4
#define	MIP6_MH_BU	5
#define	MIP6_MH_BA	6
#define	MIP6_MH_BE	7

struct mip6_mh_opt {
	unsigned char	type;
	unsigned char	len;
	unsigned char	data[0];
} __attribute__ ((__packed__));

struct mip6_mh_opt_pad_1 {
	unsigned char	type;
} __attribute__ ((__packed__));

struct mip6_mh_opt_pad_n {
	unsigned char	type;
	unsigned char	len;
	unsigned char	padding[0];	/* variable length */
} __attribute__ ((__packed__));

struct mip6_mh_opt_bra {
	unsigned char	type;
	unsigned char	len;
	unsigned short	refresh_interval;
} __attribute__ ((__packed__));

struct mip6_mh_opt_alt_coa {
	unsigned char	type;
	unsigned char	len;
	struct in6_addr	alt_coa;
} __attribute__ ((__packed__));

struct mip6_mh_opt_nonce_index {
	unsigned char	type;
	unsigned char	len;
	unsigned short	home_nonce_index;
	unsigned short	careof_nonce_index;
} __attribute__ ((__packed__));

struct mip6_mh_opt_binding_auth {
	unsigned char	type;
	unsigned char	len;
	unsigned char	authdata[12];	/* XXX: variable length? */
} __attribute__ ((__packed__));


/*
 * Mobility Option Type
 */
#define	MIP6_OPT_PAD_1		0
#define	MIP6_OPT_PAD_N		1
#define	MIP6_OPT_BRA		2
#define	MIP6_OPT_ALT_COA	3
#define	MIP6_OPT_NONCE_INDEX	4
#define	MIP6_OPT_BINDING_AUTH	5


/*
 * Status in BA
           0 Binding Update accepted
           1 Accepted but prefix discovery necessary
         128 Reason unspecified
         129 Administratively prohibited
         130 Insufficient resources
         131 Home registration not supported
         132 Not home subnet
         133 Not home agent for this mobile node
         134 Duplicate Address Detection failed
         135 Sequence number out of window
         136 Expired home nonce index
         137 Expired care-of nonce index
         138 Expired nonces
         139 Registration type change disallowed
*/
#define MIP6_BA_ACCEPTED			0
#define MIP6_BA_NEED_PREFIX_DISC		1
#define MIP6_BA_UNSPEC				128
#define MIP6_BA_ADMIN				129
#define MIP6_BA_INSUFFICIENT_RESOURCE		130
#define MIP6_BA_HOME_REG_NOT_SUPPORTED		131
#define MIP6_BA_NOT_HOME_SUBNET			132
#define MIP6_BA_NOT_HOME_AGENT			133
#define MIP6_BA_DAD_FAILED			134
#define MIP6_BA_SEQ_OUT_OF_WINDOW		135
#define	MIP6_BA_EXPIRED_HOME_NONCE_INDEX	136
#define	MIP6_BA_EXPIRED_CAREOF_NONCE_INDEX	137
#define	MIP6_BA_EXPIRED_NONCE			138
#define MIP6_BA_REG_TYPE_CHANGE_DISALLOWED	139

/*
 * Status in BE
 */
#define MIP6_BE_UNKNOWN_BINDING	1
#define MIP6_BE_UNRECOGNIZED_MH	2

/*
 * Flags in BU
 */
#define	MIP6_BU_F_ACK	0x80
#define	MIP6_BU_F_HR	0x40
#define	MIP6_BU_F_LL	0x20
#define	MIP6_BU_F_KM	0x10

/*
 * Flags in BA
 */
#define MIP6_BA_F_KM	0x80

/*
 * Protocol Configuration Variables
 */
#define	DEFAULT_MAXMOBPFXADVINTERVAL		86400
#define	DEFAULT_MINDELAYBETWEENRAS		3
#define	MIN_MINDELAYBETWEENRAS			0.03
#define	DEFAULT_MINMOBPFXADVINTERVAL		600
#define	DEFAULT_INITIALBINDACKTIMEOUTFIRSTREG	1.5

/*
 * This constants are original for this implement 
 */
#define	DEFAULT_HOME_REGISTRATION		60

/*
 * Protocol Constants
 */
#define	DHAAD_RETRIES			4
#define	INITIAL_BINDACK_TIMEOUT		1
#define	INITIAL_DHAAD_TIMEOUT		3
#define	INITIAL_SOLICIT_TIMER		3
#define	MAX_BINDACK_TIMEOUT		32
#define	MAX_NONCE_LIFETIME		240
#define	MAX_TOKEN_LIFETIME		210
#define	MAX_RR_BINDING_LIFETIME		420
#define	MAX_UPDATE_RATE			3
#define	PREFIX_ADV_RETRIES		3
#define	PREFIX_ADV_TIMEOUT		3


/* RR Status */
#define	MIP6_RR_HOTI_SENT	0x01
#define	MIP6_RR_HOT_RECV	0x02
#define	MIP6_RR_COTI_SENT	0x04
#define	MIP6_RR_COT_RECV	0x08
#define	MIP6_BU_SENT		0x10
#define	MIP6_BA_RECV		0x20
#define	MIP6_DONT_BU		0x40
#define	MIP6_DONT_RR		0x80

/*
 * Sequence Number
 */
static inline int mip6_seq_chk(__u16 x, __u16 y)
{
        return (__s16)(x - y) > 0;
}

#endif
