/* $USAGI: bul.c,v 1.13 2003/11/13 16:17:03 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *      Noriaki TAKAMIYA @USAGI
 */

#include <sys/types.h>
#include <asm/types.h>
#include <sys/socket.h>
#include <linux/xfrm.h>
#include <netinet/in.h>
#include <mip6.h>
#include "mip6d.h"
#include "bul.h"

extern struct mip6d_handle *mn_info;
struct mip6_bul mip6_mn_bul;

void mip6_bul_dump_one(struct mip6_bul_entry *bul)
{
	char addrstr[INET6_ADDRSTRLEN];
	if (!bul)
		return;

	printf("--------------------------------------------\n");
	printf("BUL: destination = %s\n", inet_ntop(PF_INET6, &bul->cn_addr, addrstr, sizeof(addrstr)));
	printf("BUL: care-of address = %s\n", inet_ntop(PF_INET6, &bul->coa, addrstr, sizeof(addrstr)));
	printf("BUL: flags(%x): \n", bul->bu_flags);
	printf("	A = %s\n", bul->bu_flags & MIP6_BU_F_ACK ? "yes": "no");
	printf("	H = %s\n", bul->bu_flags & MIP6_BU_F_HR ? "yes": "no");
	printf("	L = %s\n", bul->bu_flags & MIP6_BU_F_LL ? "yes": "no");
	printf("	K = %s\n", bul->bu_flags & MIP6_BU_F_KM ? "yes": "no");
	printf("BUL: seq  = %d\n", bul->seq);
	printf("BUL: state= %x\n", bul->state);
	printf("BUL: lifetime  = %d\n", bul->init_lifetime);
	printf("--------------------------------------------\n");
}
void mip6_bul_dump()
{
	struct mip6_bul_entry *list, *x;
	int i;

	for(i = 0; i < MIP6_BUL_HASH_SIZE; i++) {
		list = &mip6_mn_bul.entry_table[i];
		
		list_for_each(((struct list_head *)x), ((struct list_head *)list)) {
			mip6_bul_dump_one(x);
		}
	}
}

/* hash function */
static unsigned char mip6_bul_hash(const struct in6_addr *addr)
{
	return (ipv6_addr_hash(addr) % MIP6_BUL_HASH_SIZE);
}


/*
 * Initialize BUL
 */
void mip6_mn_bul_init()
{
	int i;

	memset(&mip6_mn_bul, 0, sizeof(struct mip6_bul));
	for(i = 0; i < MIP6_BUL_HASH_SIZE; i++) {
		INIT_LIST_HEAD(((struct list_head *)&mip6_mn_bul.entry_table[i]));
	}
		
}

/*
 * get new binding update list entry
 */
struct mip6_bul_entry *mip6_get_new_bul_entry(struct in6_addr *cn)
{
	struct mip6_bul_entry *new_entry;

#ifdef DEBUG
	{
		char buf[100];
		printf("%s(%d): cn = %s\n", __FUNCTION__, __LINE__, inet_ntop(PF_INET6, cn, buf, sizeof(buf)));
	}
#endif
	new_entry = (struct mip6_bul_entry *)malloc(sizeof(struct mip6_bul_entry));
	if (!new_entry)
		return NULL;

	memset(new_entry, 0, sizeof(struct mip6_bul_entry));
	INIT_LIST_HEAD((struct list_head *)new_entry);
	/*
	 * Initialize value
	 */
	memcpy(&new_entry->cn_addr, cn, sizeof(struct in6_addr));

	return new_entry;
}

/*
 * get existing entry.
 */
struct mip6_bul_entry *mip6_get_bul_entry(struct in6_addr *cn, int flags)
{
	struct mip6_bul_entry *list = NULL;
	struct mip6_bul_entry *entry = NULL;
	
#ifdef DEBUG
	{
		char buf[100];
		printf("destination = %s\n", inet_ntop(PF_INET6, cn, buf, sizeof(buf)));
	}
#endif
	list = (struct mip6_bul_entry *)&mip6_mn_bul.entry_table[mip6_bul_hash(cn)];
	if (list) {
		list_for_each(((struct list_head *)entry), ((struct list_head *)list)) {
			if (!memcmp(&entry->cn_addr, cn, sizeof(struct in6_addr))) {
				return entry;
			}
		}
		if (flags == MIP6_BUL_CREATE) {
			entry = mip6_get_new_bul_entry(cn);
			if (entry) {
				list_add(((struct list_head *)entry), ((struct list_head *)list));
				return entry;
			}
		} else {
			return NULL;
		}
	} 
	return NULL;
}

/*
 * delete existing entry.
 */
void mip6_del_bul_entry(struct in6_addr *cn_addr)
{
	struct mip6_bul_entry *list;
	struct mip6_bul_entry *entry;
	struct in6_addr hoa;
	int ifindex;

	get_home_addr(&hoa, &ifindex);
	list = (struct mip6_bul_entry *)&mip6_mn_bul.entry_table[mip6_bul_hash(cn_addr)];
	list_for_each(((struct list_head *)entry), ((struct list_head *)list)) {
		if (!memcmp(&entry->cn_addr, cn_addr, sizeof(struct in6_addr)))
		list_del(((struct list_head *)entry));
	}
}

void mip6_bu_observe(struct mip6d_handle *mp)
{
	struct mip6_bul_entry *list;
	struct mip6_bul_entry *entry;
	int i;
	int current_time;
#ifdef DEBUG
	int j = 0;
#endif

#ifdef DEBUG
	printf("Checking BUL entries.\n");
#endif
	time(&current_time);
	for(i = 0; i < MIP6_BUL_HASH_SIZE; i++) {
		list = &mip6_mn_bul.entry_table[i];
		entry = NULL;
		
		list_for_each(((struct list_head *)entry), ((struct list_head *)list)) {
			if (entry) {
#ifdef DEBUG
#if 1
				printf("entry[%d]: \n", j);
				mip6_bul_dump_one(entry);
				j++;
#endif
#endif
				if (entry->init_lifetime + entry->sent_bu_time <= current_time) {
#ifdef DEBUG
					char buf[100];
					printf("cn = %s\n", inet_ntop(PF_INET6, &entry->cn_addr, buf, 100));
					printf("life time is expired, sending BU\n");
					printf("init_lifetime = %d\n", entry->init_lifetime);
					printf("sent_bu_time = %d\n", entry->sent_bu_time);
					printf("current_time = %d\n", current_time);
#endif
					mip6_send_bu(entry);
				}
			}
		}
	}
}
/*
 * validation of Binding Acknowledgement
 */
int mip6_mn_ba_validate(struct mip6_mh_ba *bamsg)
{
}

int mn_ba_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
		struct mip6_mh_hdr *mh, size_t len)
{
	int err_code = 0;
	struct mip6_bul_entry *entry = NULL;

	struct mip6_mh_ba *bamsg = (struct mip6_mh_ba *)(mh+1);

	/* validation of BA msg */
	mip6_mn_ba_validate(bamsg);

#ifdef DEBUG
		printf("BA is:\n");
		printf("\tstatus = %d\n", bamsg->status);
		printf("\tflags = %x\n", bamsg->flags);
		printf("\tseq = %d\n", bamsg->seq);
		printf("\tlifetime = %d\n", bamsg->lifetime);
#endif

	switch(bamsg->status) {
	case MIP6_BA_ACCEPTED:
		{
			struct sockaddr_in6 *src;
			src = &msg_info->from_addr;
			entry  = mip6_get_bul_entry(&src->sin6_addr, MIP6_BUL_CREATE);
			if (!entry) {
				return -1;
			}

			entry->state |= MIP6_BA_RECV;

			printf("BA accepted\n");
			entry->retrans_timer = 0;
			if (entry->init_lifetime <  bamsg->lifetime)
				entry->init_lifetime = bamsg->lifetime * 4;

			/* set timer */
			printf("configre tunnel to HA\n");
			mn_tunnel_add();
		}
		break;
	case MIP6_BA_NEED_PREFIX_DISC:
		/*
		 * Send MPS
		 */
	case MIP6_BA_UNSPEC:
		break;
	case MIP6_BA_ADMIN:
		break;
	case MIP6_BA_INSUFFICIENT_RESOURCE:
		break;
	case MIP6_BA_HOME_REG_NOT_SUPPORTED:
		break;
	case MIP6_BA_NOT_HOME_SUBNET:
		break;
	case MIP6_BA_NOT_HOME_AGENT:
		break;
	case MIP6_BA_DAD_FAILED:
		break;
	case MIP6_BA_SEQ_OUT_OF_WINDOW:
		{
			struct sockaddr_in6 *src;
			src = &msg_info->from_addr;
			entry  = mip6_get_bul_entry(&src->sin6_addr, MIP6_BUL_CREATE);
			if (!entry) {
				return -1;
			}

			entry->seq = bamsg->seq;
			mip6_send_bu(entry);
			break;
		}
	case MIP6_BA_EXPIRED_HOME_NONCE_INDEX:
		break;
	case MIP6_BA_EXPIRED_CAREOF_NONCE_INDEX:
		break;
	case MIP6_BA_EXPIRED_NONCE:
		break;
	case MIP6_BA_REG_TYPE_CHANGE_DISALLOWED:
		break;
	default:
		printf("Unkonw BA Status, discarded\n");
	}
printf("%d: here\n", __LINE__);
	return err_code;
}
