/* $USAGI: ha.c,v 1.21 2003/11/20 03:06:58 takamiya Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <linux/xfrm.h>
#include "mip6d.h"
#include <net/if.h>
#include <ifaddrs.h>

#define	IPV6_JOIN_ANYCAST	27
#define	NLMSG_BUF	512
#define	CMSGBUF		1024

/*
 * Home Agent List Entry
 */
struct mip6_hal ha_halist;

struct mip6d_handle *ha_info;

void dump_halist(int ifindex);

int ha_prefix_cmp(struct in6_addr *hoa)
{
	return 0;
}

int ha_dad(struct in6_addr *hoa)
{
	return 0;
}
/*
 * set anycast address for DHAAD
 */
int set_anycast(struct mip6d_handle *mp, char *ifname)
{
	struct in6_addr *anycast;
	struct in6_addr anycast_rta;
	struct msghdr	msghdr;
	struct iovec iov;
	int ifindex = if_nametoindex(ifname);
	struct ipv6_mreq areq;
	int ret;
	struct ifaddrs *ifap = NULL, *p;
	int on;

	/* get address */
	ret = getifaddrs(&ifap);
	if (ret != 0) {
		__perror("getifaddrs");
		return 0;
	}

	/*
	 * set anycast for the specified interfaces
	 * and, bind the icmp socket and MH socket by this unicast address
	on = 1;
	ret = setsockopt(mp->icmp_sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
	ret = setsockopt(mp->icmp_sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
	if (ret < 0) {
		__perror("setsockopt");
	}
	ret = setsockopt(mp->mh_sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
	if (ret < 0) {
		__perror("setsockopt");
	}
	 */
	for(p = ifap; p; p = p->ifa_next) {
		anycast = &((struct sockaddr_in6 *)(p->ifa_addr))->sin6_addr;
		if (!strcmp(p->ifa_name, ifname) &&
		    (p->ifa_addr->sa_family == PF_INET6) &&
		    (p->ifa_flags & (IFF_UP | IFF_BROADCAST | IFF_MULTICAST)) &&
		    ((anycast->s6_addr[0] >> 5) == 1)) {

			memset(&areq, 0, sizeof(areq));
			memcpy(&areq.ipv6mr_multiaddr, anycast, 8);
			areq.ipv6mr_multiaddr.s6_addr32[2] = htonl(0xfdffffff);
			areq.ipv6mr_multiaddr.s6_addr32[3] = htonl(0xfffffffe);
			areq.ipv6mr_interface = ifindex;
			ret = setsockopt(mp->icmp_sock, IPPROTO_IPV6, IPV6_JOIN_ANYCAST, &areq, sizeof(areq));
#ifdef DEBUG
			{
				char buf[100];
				printf("anycast = %s\n", inet_ntop(PF_INET6, &areq.ipv6mr_multiaddr, buf, 100));
				printf("socket = %d, interface = %s\n", mp->icmp_sock, ifname);
				printf("%s: ret = %d\n", __FUNCTION__, ret);
			}
#endif
			if (ret < 0) {
				__perror("setsockopt");
				if (ifap)
					freeifaddrs(ifap);
				return 0;
			}
			if (anycast->s6_addr32[2] || anycast->s6_addr32[3])
				memcpy(&mp->conf->ha_addr, anycast, sizeof(struct in6_addr));
		}
	}
	if (ifap)
		freeifaddrs(ifap);
	return 1;
}

void send_dhaad_reply(struct mip6d_handle *mp, unsigned char *data, struct mip6_msg_info *msg_info)
{
	struct dhaad_rep *rep_msg;
	struct dhaad_req *req_msg = (struct dhaad_req *)data;
	struct icmp6_hdr *hdr;
	unsigned char 	*p;
	int ha_entries = 0;
	struct mip6_hal_entry *x;
	struct home_link_prefix *y;
	struct in6_addr *candidate_p;
	int dhaad_rep_len;
	int ret;
	int i;
	int ifindex;
	struct mip6_hal_entry *entry;
	struct msghdr msghdr;
	struct cmsghdr *cmsghdr;
	unsigned char cmsgbuf[CMSGBUF];
	struct iovec iov;
	struct in6_pktinfo *pktinfo;
	
	__dprintf("called\n");

	if (strlen(mp->conf->home_link_dev))
		ifindex = if_nametoindex(mp->conf->home_link_dev);
	else
		ifindex = if_nametoindex("eth0");	/* XXX */

	entry = (struct mip6_hal_entry *)&ha_halist.entry_table[ifindex];

	if (entry) {
		list_for_each(((struct list_head *)x), ((struct list_head *)entry)) {
			list_for_each(((struct list_head *)y), &x->gaddr_list) {
				ha_entries++;
			}
		}
	}

	/* dhaad reply should be sent in one packet */
	if (ha_entries > 78)
		ha_entries = 77;

	dhaad_rep_len = sizeof(struct in6_addr) * ha_entries + sizeof(struct dhaad_rep);
	p = (unsigned char *)malloc(dhaad_rep_len);

	if (p == NULL) {
		return;
	}

	memset(p, 0, dhaad_rep_len);
	rep_msg = (struct dhaad_rep *)p;

	rep_msg->type = ICMPV6_DHAAD_REPLY;
	rep_msg->identifier = req_msg->identifier;

	candidate_p = (struct in6_addr *)(p + sizeof(struct dhaad_rep));
	list_for_each(((struct list_head *)x), ((struct list_head *)entry)) {
		list_for_each(((struct list_head *)y), &x->gaddr_list) {
			memcpy(candidate_p, &y->prefix, sizeof(struct in6_addr));
				candidate_p++;
		}
	}

	/* Specify the source address */
	memset(&msghdr, 0, sizeof(msghdr));
	msghdr.msg_name = &msg_info->from_addr;
	msghdr.msg_namelen = sizeof(msg_info->from_addr);
	msghdr.msg_iov = &iov;
	msghdr.msg_iovlen = 1;
	cmsghdr = (struct cmsghdr *)cmsgbuf;
	msghdr.msg_control = cmsghdr;

	iov.iov_base = (void *)rep_msg;
	iov.iov_len = dhaad_rep_len;

	memset(cmsgbuf, 0, CMSGBUF);
	cmsghdr->cmsg_len = CMSG_LEN(sizeof(struct in6_pktinfo));
	cmsghdr->cmsg_level = IPPROTO_IPV6;
	cmsghdr->cmsg_type = IPV6_PKTINFO;
	msghdr.msg_controllen = cmsghdr->cmsg_len;
	
	pktinfo = (struct in6_pktinfo *)CMSG_DATA(cmsghdr);
	memcpy(&pktinfo->ipi6_addr, &mp->conf->ha_addr, sizeof(struct in6_addr));
	ret = sendmsg(mp->icmp_sock, &msghdr, 0);
#if 0
	ret = sendto(mp->icmp_sock, rep_msg, dhaad_rep_len, 0, (struct sockaddr *)(&msg_info->from_addr), sizeof(msg_info->from_addr));
#endif
	__dprintf("ret = %d\n", ret);

}
/*
 * delete the selected home agents list entry
 */
void delete_halist_entry(struct mip6_msg_info *msg_info)
{
	struct mip6_hal_entry *list, *x;
	int ifindex=msg_info->pktinfo->ipi6_ifindex;

	list = (struct mip6_hal_entry *)&ha_halist.entry_table[ifindex];

	if (list) {
		list_for_each(((struct list_head *)x), ((struct list_head *)list)) {
			if (!memcmp(&x->laddr, &((struct sockaddr_in6 *)&msg_info->from_addr)->sin6_addr, sizeof(struct in6_addr))) {
#ifdef DEBUG
		printf("deleting entry!\n");
#endif
				list_del(((struct list_head *)x));
			}
		}
	}
#ifdef DEBUG
	printf("%s(%d): called, ifindex = %d\n", __FUNCTION__, __LINE__, ifindex);
	dump_halist(ifindex);
#endif
}

/*
 * add or update the home agents list entry
 */
void update_halist(int ifindex, struct mip6_hal_entry *new_entry)
{
	struct mip6_hal_entry *list, *x;
	struct list_head *next = NULL;
	struct list_head *delete_point = NULL;
	int found = 0;

	list = (struct mip6_hal_entry *)&ha_halist.entry_table[ifindex];

	if (list) {
		list_for_each(((struct list_head *)x), ((struct list_head *)list)) {
			/* keep the insertion point */
			if (x->preference > new_entry->preference)
				next = (struct list_head *)x;
			/*
			 * If link-local address for this RA is the same,
			 * update the value
			 */
			if (!memcmp(&x->laddr, &new_entry->laddr, sizeof(struct in6_addr))) {
					delete_point = (struct list_head *)x;
			}
		}
	}
	if (delete_point) {
#ifdef DEBUG
		printf("update old entry!\n");
#endif
		list_del(delete_point);
	}
	if (new_entry->lifetime > 0) {
		if (next)
			list_add((struct list_head *)new_entry, next);
		else
			list_add((struct list_head *)new_entry, (struct list_head *)list);

		/*
		 * If not exist, add policy
		 */
		mip6_ha_set_policy(XFRM_POLICY_IN, IPPROTO_MOBILITY, IPPROTO_DSTOPTS, ha_info);

	}
#ifdef DEBUG
	printf("%s(%d): called, ifindex = %d\n", __FUNCTION__, __LINE__, ifindex);
	dump_halist(ifindex);
#endif
}

void dump_halist(int ifindex)
{
	struct mip6_hal_entry *list, *x;
	struct home_link_prefix *prefix;

	list = (struct mip6_hal_entry *)&ha_halist.entry_table[ifindex];

	printf("================\n");
	list_for_each(((struct list_head *)x), ((struct list_head *)list)) {
		char buf[100];

		printf("laddr = %s\n", inet_ntop(AF_INET6, &x->laddr, buf, sizeof(buf)));
		printf("lifetime = %d\n", x->lifetime);
		printf("preference = %d\n", x->preference);
		list_for_each(((struct list_head *)prefix), ((struct list_head *)&x->gaddr_list)) {
			printf("\tPrefix = %s\n", inet_ntop(AF_INET6, &prefix->prefix, buf, sizeof(buf)));
		}
	}
	printf("================\n");
}

void dump_allhalist()
{
	int i;

	for(i = 0; i < MIP6_HAL_HASH_SIZE; i++)
		dump_halist(i);
}

/*
 * Process Routing Advertisement Message
 *
 * o Check the Home Agent flag
 * o Check the lifetime in the message
 *
 */
void process_ra_msg(struct mip6d_handle *mp,  unsigned char *data, int len,
		struct mip6_msg_info *msg_info)
{
	struct nd_router_advert *ra = (struct nd_router_advert *)data;
	unsigned char *p = (unsigned char *)(ra+1);
	unsigned char *end = data + len;
	struct nd_opt_hdr *current;
	struct mip6_hal_entry *new_entry, *x;
	struct nd_opt_prefix_info *pinfo;
	struct nd_opt_home_agent_info *hainfo;
	struct home_link_prefix *prefix;

	unsigned int ifindex = msg_info->pktinfo->ipi6_ifindex;

	new_entry = (struct mip6_hal_entry *)malloc(sizeof(struct mip6_hal_entry));
	memset(new_entry, 0, sizeof(struct mip6_hal_entry));
	INIT_LIST_HEAD(((struct list_head *)new_entry));
	INIT_LIST_HEAD(&new_entry->gaddr_list);
	/* default lifetime for this home agent */
	new_entry->lifetime = ntohs(ra->nd_ra_hdr.icmp6_data16[1]);

	if (ND_RA_FLAG_HOME_AGENT & ra->nd_ra_hdr.icmp6_data8[1]) {
		memcpy(&new_entry->laddr, &msg_info->from_addr.sin6_addr,
			sizeof(struct in6_addr));

		/* Parse the options */
		while( p < end) {
			current = (struct nd_opt_hdr *)p;
			switch(current->nd_opt_type) {
			case ND_OPT_PREFIX_INFORMATION:
				pinfo = (struct nd_opt_prefix_info *)p;
				if (!(ND_OPT_PI_FLAG_RADDR & pinfo->nd_opt_pi_flags_reserved)) {
					printf("This Prefix info doesn't have router address!\n");
				} else {
					prefix = (struct home_link_prefix *)malloc(sizeof(struct home_link_prefix));
					if (prefix == NULL) {
						printf("%s(%d): failed to allocate prefix entry\n", __FUNCTION__, __LINE__);
					}
					memcpy(&prefix->prefix, &pinfo->nd_opt_pi_prefix, sizeof(struct in6_addr));
					prefix->prefixlen = pinfo->nd_opt_pi_prefix_len;
#ifdef DEBUG
					{
						char buf[100];
						printf("prefix = %s/%d\n", inet_ntop(AF_INET6, &prefix->prefix, buf, sizeof(buf)), prefix->prefixlen);
					}
#endif
					list_add_tail((struct list_head *)prefix, (struct list_head *)&new_entry->gaddr_list);
				}
				break;
			case ND_OPT_HOME_AGENT_INFO:
				hainfo = (struct nd_opt_home_agent_info *)p;
				new_entry->preference = ntohs(hainfo->nd_opt_home_agent_info_preference);
				new_entry->lifetime = ntohs(hainfo->nd_opt_home_agent_info_lifetime);
				break;
			default:
				printf("Ignore this option type = %d!\n", current->nd_opt_type);
				break;
			}
			printf("len = %d\n", (current->nd_opt_len)<<3);
			p+= current->nd_opt_len << 3;
		}

		update_halist(ifindex, new_entry);
		
	} else {
		/*
		 * If the Home Agent (H) bit in the Router Advertisement is not set,
		 * delete the sending node's entry in the current Home Agents List
		 * (if one exists).  Skip all the following steps.
		 */
		delete_halist_entry(msg_info);
	}
	
}

int ha_rthdr_add(struct mip6d_handle *mp, struct mip6_bc_entry *bce)
{
char buf[100];
printf("%s: home agent = %s\n", __FUNCTION__, inet_ntop(PF_INET6, &bce->hoa, buf, 100));
	mip6_rthdr_set(mp, XFRM_POLICY_OUT, &bce->hoa, &mp->conf->ha_addr,
		       &bce->coa, IPPROTO_MOBILITY, 1);
}

int ha_rthdr_del(struct mip6d_handle *mp, struct mip6_bc_entry *bce)
{
	mip6_rthdr_set(mp, XFRM_POLICY_OUT, &bce->hoa, &mp->conf->ha_addr,
		       &bce->coa, IPPROTO_MOBILITY, 0);
}
/* tunnel handling */
static int ha_tunnel_update(struct mip6d_handle *mp, struct mip6_bc_entry *bce, int add)
{
	/* Inbound:
	 * selector = (any, HoA)
	 *       id = (HA@, CoA)
	 */
	/* Outbound:
	 * selector = (HoA, any)
	 *       id = (CoA, HA@)
	return mip6_tunnel_update(mp, &in6addr_any, &bce->hoa, &mp->ha_addr, &bce->coa, add);
	 */
}

/* HA add new tunnel */
int ha_tunnel_add(struct mip6d_handle *mp, struct mip6_bc_entry *bce)
{
	return ha_tunnel_update(mp, bce, 1);
}

/* HA delete binding */
int ha_tunnel_del(struct mip6d_handle *mp, struct mip6_bc_entry *bce)
{
	return ha_tunnel_update(mp, bce, 0);
}

static int ha_init(struct mip6d_handle *mp)
{

	int i;

	memset(&ha_halist, 0, sizeof(struct mip6_hal));

	/* Initialize Home Agents List */
	for(i = 0; i < MIP6_HAL_HASH_SIZE; i++)
		INIT_LIST_HEAD(((struct list_head *)&ha_halist.entry_table[i]));

	ha_info = mp;

	/*
	 * Set initial Policy/State
	 */
#if 0
	memset(&mp->home_addr, 0, sizeof(struct in6_addr));
#endif

	/* set HA input policy */
	mip6_ha_set_policy(XFRM_POLICY_IN, IPPROTO_MOBILITY, IPPROTO_DSTOPTS,
			   mp);
	return 0;
}

static void ha_fini(struct mip6d_handle *mp)
{
}

static int ha_observe(struct mip6d_handle *mp)
{
	return 0;
}

#if 0
static int ha_nlroute_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	return 0;
}

static int ha_nlxfrm_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	return 0;
}

static int ha_mh_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
		       struct mip6_mh_hdr *mh, ssize_t len)
{
	int err_code = 0;

	switch (mh->type) {
	case MIP6_MH_BRR:
		break;
	case MIP6_MH_HOTI:
		break;
	case MIP6_MH_COTI:
		break;
	case MIP6_MH_HOT:
		break;
	case MIP6_MH_COT:
		break;
	case MIP6_MH_BU:
		__dprintf("called\n");
		err_code = mip6d_bu_input(mp, msg_info, mh, len); /* XXX */
		break;
	case MIP6_MH_BA:
		break;
	case MIP6_MH_BE:
		break;
	default:
		err_code = -EINVAL;
		goto fin;
	}

 fin:
	return err_code;
}
#endif

static int ha_icmp_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
			 struct icmp6_hdr *icmp, ssize_t len)
{
	struct icmp6_hdr *hdr;
	struct dhaad_req *req_msg;
	struct dhaad_req *rep_msg;

	/*
	 * HA cares the DHAAD request and MPS.
	 */
	hdr = icmp;

	switch(hdr->icmp6_type) {
	case ICMPV6_DHAAD_REQUEST:
		/*
		 * handling DHAAD request
		 */
		send_dhaad_reply(mp, (unsigned char *)icmp, msg_info);
		break;

	case ICMPV6_MOBILE_PREFIX_SOLICIT:
		/*
		 * handling Mobile Prefix Solicitation
		 */
		break;

	case ND_ROUTER_ADVERT:
		/*
		 * update home agent list
		 */
		process_ra_msg(mp, (unsigned char *)icmp, len, msg_info);
		break;
	default:
		break;

	}
	return 0;
}
int ha_register(struct mip6d_handle *mp)
{
	mp->init = ha_init;
	mp->fini = ha_fini;
	mp->observe = ha_observe;
#if 0
	mp->nlroute_input = ha_nlroute_input;
	mp->nlxfrm_input = ha_nlxfrm_input;
	mp->mh_input = ha_mh_input;
#endif
	mp->icmp_input = ha_icmp_input;

	return 0;
}
