/* $USAGI: mip6d.h,v 1.15 2004/04/24 08:37:12 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */
#ifndef _MIP6D_H
#define _MIP6D_H

#include <errno.h>
#include <net/if.h>
#include <netinet/icmp6.h>

#include <mip6.h>
#include <mip6log.h>

#include "glue.h"

/*
 * Binding Cache
 */
#define MIP6_BC_ENTRY_MAX 10240
/*#define MIP6_BC_HASH_SIZE 32*/
#define	MIP6_BC_HASH_SIZE	4
#define	MIP6_BUL_HASH_SIZE      32

#define	MIP6_BUL_LOOKUP	0
#define	MIP6_BUL_CREATE	1

struct mip6_bc {
	struct list_head	entry_table[MIP6_BC_HASH_SIZE];
	unsigned int entry_count;
	rwlock_t lock;
};

/*
 * Binding Cache Entry
 */
struct mip6_bc_entry {
	struct	list_head	list;

	struct in6_addr		hoa;
	struct in6_addr		coa;
	unsigned short		lifetime;
	unsigned char		flags;
	unsigned short		seq;

	/* If any, add usage information for this Binding Cache entry.
	 * This is needed to implement the cache replacement
	 * policy in use in the Binding Cache.
	 */
};

/*
 * structure of keygen information included in Home/Care-of Test
 */
struct keygen_info {
	unsigned char			keygen[8];
	unsigned short			nonce_index;
	unsigned long			recv_time;
};


#define MIP6_BUL_HASH_SIZE 32

/*
 * structure of Binding Update List
 */
struct mip6_bul {
	struct list_head	entry_table[MIP6_BUL_HASH_SIZE];
	rwlock_t lock;
};

/*
 * Binding Update List Entry
 */
struct mip6_bul_entry {
	struct	list_head		list;
	struct in6_addr			cn_addr;
	struct in6_addr			coa;
	unsigned short			init_lifetime;
	unsigned short			lifetime;
	double				retrans_timer;
	unsigned short			seq;
	unsigned long			sent_bu_time;
	unsigned char			bu_flags;
	unsigned char			state;
	unsigned char			need_bu;
	/* for Return Routability */
	unsigned long			sent_time_hoti;
	unsigned long			sent_time_coti;
	unsigned char			rr_state;	/* XXX: same as state? */
	unsigned char			home_cookie[8];
	unsigned char			careof_cookie[8];
	struct keygen_info	home_keygen_info;
	struct keygen_info	careof_keygen_info;
};


/*
 * Home Agents List
 */
#define MIP6_HAL_HASH_SIZE 32

/* XXX: home agents list must be maintained for each link */
struct mip6_hal {
	struct list_head	entry_table[MIP6_HAL_HASH_SIZE];
				/* XXX: hash is interface oriented? */
	rwlock_t lock;
};


/*
 * Prefix Information for Home Agent List
 */
struct home_link_prefix {
	struct list_head	list;
	struct in6_addr		prefix;
	unsigned char		prefixlen;
};

/*
 * Home Agents List Entry
 */
struct mip6_hal_entry {
	struct	list_head	list;

	struct in6_addr		laddr;
	struct list_head	gaddr_list;
	unsigned short		lifetime;
/*
 * The preference value is taken from the Home Agent Preference field
 * in the received Router Advertisement, if the Router Advertisement
 * contains a Home Agent Information Option, and is otherwise set to
 * the default value of 0
 */
/* XXX: I'm not sure the type below. I must check later. */
	unsigned short		preference;
};


#define IPPROTO_ANY		(0)
#define DHAAD_REQ_SIZE          8

struct dhaad_req {
        unsigned char   type;
        unsigned char   code;
        unsigned short  cksum;
        unsigned short  identifier;
        unsigned short  reserved;
};
   
struct dhaad_rep {
        unsigned char   type;
        unsigned char   code;
        unsigned short  cksum;
        unsigned short  identifier;
        unsigned short  reserved;
        struct in6_addr halist[0];
};

struct mip6_msg_info {
	struct sockaddr_in6 from_addr;
	struct in6_pktinfo *pktinfo;

	int msg_type; /* flag */
	struct in6_addr dstopt_hoa;
	struct in6_addr rthdr_hoa;
};

typedef enum {
	NODE_CN,
	NODE_HA,
	NODE_MN,
} mip6_node_type_t;

struct mip6d_conf {
	mip6_node_type_t node_type;

	/* HA/MN specific */
	struct in6_addr ha_addr;

	/* HA specific */
	char home_link_dev[IFNAMSIZ + 1];
	int home_link_ifindex;
	struct in6_addr home_link_lladdr;

	/* MN specific */
	struct in6_addr hoa;
	struct in6_addr coa;
	int hoa_ifindex;
	unsigned int coa_preferred_time;
};

struct mip6d_handle {
	/* sockets */
	int	nlroute_sock;
	int	nlxfrm_sock;
	int	mh_sock;
	int	icmp_sock;

	struct mip6d_conf *conf;

	/* functions */
	int (*init)(struct mip6d_handle *handle);
	void (*fini)(struct mip6d_handle *handle);
	int (*observe)(struct mip6d_handle *handle);

#if 0
	int (*nlroute_input)(struct mip6d_handle *handle,
			     void *buf, ssize_t len);
	int (*nlxfrm_input)(struct mip6d_handle *handle,
			    void *buf, ssize_t len);
	int (*mh_input)(struct mip6d_handle *handle,
			struct mip6_msg_info *msg_info,
			struct mip6_mh_hdr *mh, ssize_t len);
#endif
	int (*icmp_input)(struct mip6d_handle *handle,
			  struct mip6_msg_info *msg_info,
			  struct icmp6_hdr *icmp, ssize_t len);
};


#if 0
extern int mip6_tunnel_update(struct mip6d_parms *mp,
			      struct in6_addr *sel_addr1, struct in6_addr *sel_addr2,
			      struct in6_addr *id_addr1, struct in6_addr *id_addr2,
			      int add);

extern int mip6_rthdr_set(struct mip6d_parms *mp, int dir,
			  struct in6_addr *daddr, struct in6_addr *saddr,
			  struct in6_addr *rtaddr,
			  __u8 proto, int add);

extern int set_anycast(struct mip6d_parms *mp, char *ifname);
#endif

#endif /* _MIP6D_H */
