/* $USAGI: miping6.h,v 1.4 2003/10/22 06:10:48 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */
#ifndef _MIPING6_H
#define _MIPING6_H

#include <netinet/in.h>

struct mh_type_entry {
	unsigned char type;
	char *name;
	char *desc;
};

struct opt_parms {
	struct mh_type_entry mte;
#define mh_type mte.type
#define mh_type_name mte.name
#define mh_type_desc mte.desc

	struct in6_addr daddr;
	struct in6_addr saddr;
	struct in6_addr dsto_addr;
	struct in6_addr rt_addr;

	__u8 bu_flags;
	__u8 ba_flags;
	__u8 status;
	__u16 seq;
	__u16 lifetime;
	unsigned char	cookie[8];
};

extern int miping6_send();

#endif /* _MIPING6_H */
