/*
 * Copyright (C) 2002 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* Author:
 * 	YOSHIFUJI Hideaki, University of Tokyo
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/sockios.h>

#ifndef HAVE_STRUCT_IP6_ZONEID
struct ip6_zoneid {
	uint32_t	zone[16];
};
#endif
#ifndef IPV6_ADDR_SCOPE_NODELOCAL
#define IPV6_ADDR_SCOPE_NODELOCAL	0x01
#define IPV6_ADDR_SCOPE_LINKLOCAL	0x02
#define IPV6_ADDR_SCOPE_SITELOCAL	0x05
#define IPV6_ADDR_SCOPE_ORGLOCAL	0x08
#define IPV6_ADDR_SCOPE_GLOBAL		0x0e
#endif

#ifndef SIOCGIFZONE
#define SIOCGIFZONE     (SIOCPROTOPRIVATE + 0)
#define SIOCSIFZONE     (SIOCPROTOPRIVATE + 1)
#endif

void print_zoneid(struct ip6_zoneid *zoneid)
{
	int i;
	printf("[");
	for (i = 0; i < 16; i++) {
		printf(" %x", zoneid->zone[i]);
	}
	printf(" ]");
	return;
}
int main(int argc, char **argv) {
	char *ifname, *param;
	int ifindex;
	struct ip6_zoneid zoneid;
	int i,j;
	char *p;
	int s;
	int err;

	if (argc != 2 && argc != 3) {
		fprintf(stderr, "%s ifname [llid,...]\n", argv[0]);
		exit(1);
	}
	ifname = argv[1];
	param = argc == 3 ? argv[2] : NULL;

	ifindex = if_nametoindex(ifname);
	if (ifindex <= 0) {
		perror("if_nametoindex");
		exit(1);
	}
	
	memset(&zoneid, 0, sizeof(zoneid));
	zoneid.zone[IPV6_ADDR_SCOPE_NODELOCAL] = ifindex;

	s = socket(AF_INET6, SOCK_DGRAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}

	if (param) {
		p = param;
		for (i=0; i<16; i++) {
			char *cp = strchr(p, ',');
			if (cp)
				*cp = '\0';
			if (*p) {
				j = atoi(p);
				p = cp ? cp + 1 : p + strlen(p);
			} else {
				j = 0;
				p += cp ? 1 : 0;
			}
			if (i == IPV6_ADDR_SCOPE_NODELOCAL) {
				if (j && j != zoneid.zone[i]) {
					fprintf(stderr, "%s: zoneid for scope %d is invalid (%d)\n",
						argv[0], i, j);
					exit(1);
				}
			} else {
				zoneid.zone[i] = j;
			}
		}
		print_zoneid(&zoneid);
		puts("");
		err = ioctl(s, SIOCSIFZONE, &zoneid);
		if (err < 0) {
			perror("SIOCSIFZONE");
			exit(1);
		}
	} else {
		err = ioctl(s, SIOCGIFZONE, &zoneid);
		if (err < 0) {
			perror("SIOCGIFZONE");
			exit(1);
		}
		print_zoneid(&zoneid);
		puts("");
	}
}

