//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: net.cc
//
// Purpose: models a net that connects two or more device ports together
//
// Remarks: 
//
// History: 03/22/97 - MAR - created.
//
// Copyright (c) 1997 Michael A. Riepe
//
// RCS Version:
//     $Id: net.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <vector>
#include <map>
#include <list>
using namespace std;
#include "net.hh"

//-----------------------------------------------------------------------------
// Function: net()
//
// Purpose: Constructors.  Can take either void, a string containing the
//          name of the net, or another net.
//
// Side-effects:
//
// Notes: 
//-----------------------------------------------------------------------------

net::net() : _terminals() { _name = NULL; _number=-1; _external = false; }
net::net(char *name, int number) : _terminals() { _name = name; _number=number; _external = false; }
net::net(net &n) : _terminals() {
    _name = strdup(n.name());
    _number = n.number();
    _external = false;
}


//-----------------------------------------------------------------------------
// Function: ~net()
//
// Purpose: Destructor.
//
// Side-effects:
//
// Notes: _terminals are desstructed by the devices that own the ports.
//-----------------------------------------------------------------------------
net::~net() {
	DBG0(cout<<"net destructor: "<<_name<<endl;);
    free (_name);
}


//-----------------------------------------------------------------------------
// Function: remove_terminal
//
// Purpose: removes a port as a terminal to this net
//
// Side-effects: the _terminals vector is modified
//
// Notes: 
//-----------------------------------------------------------------------------

void net::remove_terminal (port &nPort) {
    DBG0(cout<<"removing terminal "<<nPort.device_ref()->name()<<"("<<nPort.name()<<")"
         <<" from net "<<name()<<endl;);
		vector<port*>::iterator i;
		for(i=_terminals.begin();i!=_terminals.end();i++)
		{
			if (*i==&nPort)
			{
				_terminals.erase(i);
				return;
			}
		}

	//cerr<<"Didn't find terminal to be removed: "<<nPort.name()<<endl;
}

//-----------------------------------------------------------------------------
// Function: add_terminal
//
// Purpose: connect a new port as a terminal to this net
//
// Side-effects: the _terminals vector is modified
//
// Notes: 
//-----------------------------------------------------------------------------

void net::add_terminal (port &nPort) {
    DBG0(cout<<"adding terminal "<<nPort.device_ref()->name()<<"("<<nPort.name()<<")"
         <<" to net "<<name()<<endl;);
    _terminals.push_back(&nPort);
}

//-----------------------------------------------------------------------------
// Function: dump
//
// Purpose: dump the contents of the net to the given stream
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void net::dump(ostream &os)
{
    os<<"\tnet name: "<<name();
    if (_external) os<<" (external)";
    os<<endl;
    os<<"\t\tconnected to ports: "<<endl;
    for (int i=0; i != _terminals.size(); i++) {
        os<<"\t\t\t"<<_terminals[i]->device_ref()->name()<<
            "("<<_terminals[i]->name()<<")"<<endl;
    }
}

/*****************************************************************************/
