//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: port.cc
//
// Purpose: models a port that provides an interface between a device and a wire
//
// Remarks: 
//
// History: 03/22/97 - MAR - created.
//
// Copyright (c) 1997 Michael A. Riepe
//
// RCS Version:
//     $Id: port.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#include <string.h>
#include <vector>
#include <map>
#include <list>
using namespace std;
#include "port.hh"

//-----------------------------------------------------------------------------
// Function: port()
//
// Purpose: Constructors.  Can take any combination of void, a string
//          containing the name of the port, or an enumerated direction type.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

port::port() {
    _name = NULL; _net_ref = NULL; _direction = _UNSPECIFIED_; _device_ref = NULL;
}

port::port(dirEnum dir) {
    _name = NULL; _net_ref = NULL; _direction = dir; _device_ref = NULL;
}

port::port(char *name) {
    _name = name; _net_ref = NULL; _direction = _UNSPECIFIED_; _device_ref = NULL;
}

port::port(char *name, dirEnum dir) {
    _name = name; _net_ref = NULL; _direction = dir; _device_ref = NULL;
}
port::port(port &p) {
    _name = strdup(p.name());
    _direction = p.direction();
}



//-----------------------------------------------------------------------------
// Function: ~port()
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: The objects pointed to by _new_ref and _device_ref will be deleted
//        by the top-level circuit object that owns them.
//-----------------------------------------------------------------------------

port::~port() {
	DBG0(cout<<"port destructor: "<<_name<<endl;);
    free ( _name);
}

//-----------------------------------------------------------------------------
// Function: operator<<
//
// Purpose: output operator overload
//
// Side-effects: none
//
// Notes: 
//-----------------------------------------------------------------------------
ostream &operator<<(ostream &os, port &p) {
	os << p.net_ref()->name();
	return(os);
}

//-----------------------------------------------------------------------------
// Function: dump
//
// Purpose: dump the contents of the net to the given stream
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void port::dump(ostream &os)
{
    os<<"\tport name: "<<name();
    switch (_direction) {
        case _INPUT_ :
            os<<" (input)"<<endl;
            break;
        case _OUTPUT_ :
            os<<" (output)"<<endl;
            break;
        case _BIDIR_ :
            os<<" (bidirectional)"<<endl;
            break;
        case _UNSPECIFIED_ :
            os<<" (unspecified)"<<endl;
            break;
    }
    os<<"\t\ton device: "<<_device_ref->name()<<endl;
    os<<"\t\tconnected to net: "<<_net_ref->name()<<endl;
}

/*****************************************************************************/
