//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: appCmds.cc
//
// Purpose: Sets up configuration options for running the GRASP SAT algorithm.
//
// Remarks: --
//
// History: 6/21/95 - JPMS - created.
//          3/16/96 - JPMS - repackaged for new version of GRASP.
//          3/13/97 - MAR - modified for use in cellsyn
//
// RCS Version:
//     $Id: appCmds.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <vector>
#include <map>
#include <list>
using namespace std;
#include "defs.hh"
#include "utils.hh"
#include "appCmds.hh"


//-----------------------------------------------------------------------------
// Constructor/destructor.
//-----------------------------------------------------------------------------

appCmds::appCmds (appMode &nmode) : _mode (nmode) {}

appCmds::~appCmds() {}

// ----------------------------------------------------------------------------
// Function: cmdLineParse
//
// Purpose: Parses the initial command line arguments and uses them for
//          configuring application.
//
// Notes: The file name, if any, has to be the last argument.
//
// History: 6/21/95 - JPMS - created.
// ----------------------------------------------------------------------------

char *appCmds::cmdLineParse (int argc, char *argv[])
{
    char *filename = NULL;
    cmdLine cmd_line (argc, argv);
    
    for (int k = 1; k < argc; k++) {

	if (cmd_line[k].matches("+")) {
	    handlePlusOption (cmd_line[k] >> 1);
	}
	else if (cmd_line[k].matches("-")) {
	    handleMinusOption (cmd_line[k] >> 1);
	}
	else {
            // assume last arg is filename
	    DBG1(cout<<"Filename: "<<argv[k]<<endl;);
	    filename = argv[k];
	}
    }

    if (_mode.int_mode(_HELP_)) {
        help(cout);
        exit(0);
    }

    // check modes for consistency
    check_modes();
    
    return filename;
}

//-----------------------------------------------------------------------------
// Parses command line options of the form +Zy.
//-----------------------------------------------------------------------------

int appCmds::handlePlusOption (cmdArg &cmd)
{
    if (cmd.matches("D")) {
	_mode[_DEBUG_] = _mode.new_int_mode((int) (cmd >> 1));
    }
    else if ( cmd.matches("H") || cmd.matches("h") ) {
	_mode[_HELP_] = _mode.new_int_mode(TRUE);
    }
    else if (cmd.matches("V")) {
	_mode[_VERBOSE_] = _mode.new_int_mode((int) (cmd >> 1));
    }
    else {
        cout << "\n    Unsupported plus (+) option: " << (char*) cmd << endl;
        cout << endl;
        return FALSE;
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
// Parses command line options of the form +Zy.
//-----------------------------------------------------------------------------

int appCmds::handleMinusOption (cmdArg &cmd)
{
    if (cmd.matches("D")) {
	_mode[_DEBUG_] = _mode.new_int_mode(0);
    }
    else if ( cmd.matches("H") || cmd.matches("h") ) {
	_mode[_HELP_] = _mode.new_int_mode(TRUE);
    }
    else if (cmd.matches("V")) {
	_mode[_VERBOSE_] = _mode.new_int_mode(0);
    }
    else {
	cout << "\n    Unsupported minus (-) option: " << (char*) cmd << endl;
	cout << endl;
	return FALSE;
    }
    return TRUE;
}


//-----------------------------------------------------------------------------
// checks the command line options for consistency with current tool
//-----------------------------------------------------------------------------
void appCmds::check_modes () {
}

//-----------------------------------------------------------------------------
// print help screen with commands
//-----------------------------------------------------------------------------
void appCmds::help (ostream &outs)
{
    outs<<endl;
    outs<<"Usage: hspice_parser <options> filename"<<endl;
    outs<<endl;
    outs<<"options:"<<endl<<endl;
    outs<<"    [+|-]H         Help (prints this message)"<<endl;
    outs<<"    [+|-]h         Help (prints this message)"<<endl;
    outs<<"    +D<level>      Sets the DEBUG mode to the supplied level"<<endl;
    outs<<"        D0         no debugging information (default)"<<endl;
    outs<<"        D1         runtime efficient debugging info"<<endl;
    outs<<"        D2         runtime inefficient debugging info"<<endl;
    outs<<"    -D             Same as +D0"<<endl;
    outs<<"    +V<level>      Sets the VERBOSE mode to the supplied level"<<endl;
    outs<<"        V0         no runtime information (default)"<<endl;
    outs<<"        V1         major algorithm steps displayed"<<endl;
    outs<<"        V2         full dumps of each algorithmic step"<<endl;
    outs<<"    -V             Same as +V0"<<endl;
    outs<<endl;
}

/*****************************************************************************/
