//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: macros.hh
//
// Purpose: Macro definitions for optimizations, consistency maintenance
//          and debugging purposes.
//
// Remarks: Expanded version of the debugging macros in LEAP.
//
// History: 5/12/94 - JPMS - created.
//          3/18/97 - MAR - adapted for cellsyn
//
// Copyright (c) 1996 Joao P. Marques Silva.
//
// RCS Version:
//     $Id: macros.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef _MACROS_DEF_
#define _MACROS_DEF_

//-----------------------------------------------------------------------------
// Expansion macros that can be used to print warning/error/debugging
// messages as well as validating invalid run-time conditions.
//-----------------------------------------------------------------------------

#ifdef STATS
#define STAT(x) x
#else
#define STAT(x)
#endif


#ifdef CHCK
#define CHECK(x) x
#else
#define CHECK(x)
#endif


#ifdef DEBUG_0
#define DBG0(x) x
#else
#define DBG0(x)
#endif


#ifdef DEBUG_1
#define DBG1(x) x
#else
#define DBG1(x)
#endif

#ifdef DEBUG_n
#define DBGn(x) x
#else
#define DBGn(x)
#endif

#endif    // _MACROS_DEF_

/*****************************************************************************/

