 
#ifndef AMFS_XML_H
#define AMFS_XML_H

#include "cb.h"
#include "label-command.h"
#include "amarokfs_config.h"
#include "label-pixmap.h"
		
#include <qdom.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qvariant.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qstring.h>
#include <qimage.h>
#include <qdialog.h>
#include <qaction.h>
#include <qpopupmenu.h>
#include <kaboutapplication.h>
				
#include <vector>
#include <dcopclient.h>		
#include <iostream>
		
	
class AmfsXML : public QWidget
{
	Q_OBJECT

public:
	AmfsXML( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~AmfsXML();

 private:
	QDomDocument domTree;
	AKControlButton *cb;
	QLabel *b;
	QPushButton* pushButton1;

private:
	QString getDCOPDataText(QCString func);
	QStringList getDCOPDataSQL(QString query);
	int getDCOPDataInt(QCString func);
	void sendPlayerCommand(QCString command);
	QImage getCoverPath(QString artist, QString album, bool transDef=FALSE);
	void restoreScreenSaver();
	void restoreAmarokOSD();
	
	void updateTrackLabels();
	void updateInstantLabels();
	void updateCover();
	void updateGradient();
	
	void wheelEvent ( QWheelEvent * e );
	void contextMenuEvent(QContextMenuEvent *event);
	void mouseMoveEvent( QMouseEvent *e );
	void closeEvent( QCloseEvent* ce );
			
			
	int topOffset, leftOffset;
	bool isSetDisScrSvr;
	bool isSetDisAmaOSD;
	bool isSetDisThemeHint;
	
	//vector to store the buttons;
	std::vector<AKControlButton*> controlButtons;
	//vector to store labels that get updated every second
	std::vector<AKLabelCommand*> labelsInstant;
	//vector to store labels that get update upon track change
	std::vector<AKLabelCommand*> labelsTrack;
	//vector to store static labels
	std::vector<AKLabelCommand*> labelsStatic;
		//vector to store pixmap labels
	std::vector<AKLabelPixmap*> labelsPixmap;
	
	QPopupMenu* contextMenu;
	DCOPClient* dcopClient;
	QProgressBar* progressBar;
	QLabel *cdcover, *gradient, *themeHint;
	int cdcoverPosX, cdcoverPosY;
	QPixmap cdimagePixmap, reflectionPixmap, gradientPixmap;
	QTimer* timer, *hintTimer, *mouseTimer;
	AKLabelCommand *lInstant, *lTrack, *lStatic;
	AKLabelPixmap *lPixmap;
	QString nowPlaying;
	QString nextSongIntroduction, nextSongFormat;
	QLabel *nextSongs;
	int nextSongCount;
	
	AmarokFS_config *configWindow;


private slots:
	void updateTime();
	void updateNextSongs();
	void controlButtonClicked(QCString command);
	void launchConfig();
	void launchAbout();
	void hideHint();
	void hideMouse(bool now = TRUE);

public:
	QAction *reloadAct, *setupAct, *closeAct, *aboutAct;
	KAboutApplication* aboutWindow;
};

#endif
 
