/////////////////////////////////////////////////////////////////////////////
// Name:        AVPropDlg.cpp
// Purpose:     DVD audio/video properties dialog
// Author:      Alex Thuering
// Created:     23.02.2005
// RCS-ID:      $Id: AVPropDlg.cpp,v 1.5 2006/12/06 14:34:25 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "AVPropDlg.h"

AVPropDlg::AVPropDlg(wxWindow *parent, Audio* audio, Video* video, bool menu):
 wxPropDlg(parent), m_audio(audio), m_video(video), m_menu(menu)
{
  m_auto = _("auto");
  Create();
  SetSize(360,-1);
}

void AVPropDlg::CreatePropPanel(wxSizer* sizer)
{
  wxSizer* grpSizer = BeginGroup(sizer, _("Audio"));
  wxFlexGridSizer* grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  AddComboProp(grid, _("Format:"), String2Auto(m_audio->GetFormat()), m_audio->GetFormatStrings(m_auto));
  AddTextProp(grid, _("Channels:"), 
	m_audio->GetChannels() >= 0 ? wxString::Format(_T("%d"), m_audio->GetChannels()) : _T(""));
  AddComboProp(grid, _("Quantity:"), String2Auto(m_audio->GetQuant()), m_audio->GetQuantStrings(m_auto));
  AddComboProp(grid, _("Dolby:"), String2Auto(m_audio->GetDolby()), m_audio->GetDolbyStrings(m_auto));
  AddComboProp(grid, _("Samplerate:"), String2Auto(m_audio->GetSamplerate()), m_audio->GetSamplerateStrings(m_auto));
  AddTextProp(grid, _("Language:"), m_audio->GetLang());
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  
  sizer->Add(6,6);
  
  grpSizer = BeginGroup(sizer, _("Video"));
  grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  if (!m_menu)
  {
	AddComboProp(grid, _("Format:"), String2Auto(m_video->GetFormat()), m_video->GetFormatStrings(m_auto));
	AddTextProp(grid, _("Resolution:"), m_video->GetResolution());
  }
  AddComboProp(grid, _("Aspect ratio:"), String2Auto(m_video->GetAspect()), m_video->GetAspectStrings(m_auto));
  AddTextProp(grid, _("Caption:"), m_video->GetCaption());
  AddComboProp(grid, _("Widescreen:"), String2Auto(m_video->GetWidescreen()), m_video->GetWidescreenStrings(m_auto));
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  
  sizer->Add(6,6);
  
  if (m_menu)
	AddText(sizer, _("Note: these properties will be set\nfor all menus in the currect titleset"));
  else
	AddText(sizer, _("Note: these properties will be set\nfor all titles in the currect titleset"));
}

bool AVPropDlg::SetValues()
{
  int n = 0;
  m_audio->SetFormat(Auto2String(GetString(n++)));
  long lval;
  if (!Auto2String(GetString(n++)).ToLong(&lval))
	lval = -1;
  m_audio->SetChannels(lval);
  m_audio->SetQuant(Auto2String(GetString(n++)));
  m_audio->SetDolby(Auto2String(GetString(n++)));
  m_audio->SetSamplerate(Auto2String(GetString(n++)));
  m_audio->SetLang(Auto2String(GetString(n++)));
  
  if (!m_menu)
  {
	m_video->SetFormat(Auto2String(GetString(n++)));
	m_video->SetResolution(Auto2String(GetString(n++)));
  }
  m_video->SetAspect(Auto2String(GetString(n++)));
  m_video->SetCaption(Auto2String(GetString(n++)));
  m_video->SetWidescreen(Auto2String(GetString(n++)));
  return true;
}
