/////////////////////////////////////////////////////////////////////////////
// Name:        AVPropDlg.h
// Purpose:     DVD audio/video properties dialog
// Author:      Alex Thuering
// Created:     23.02.2005
// RCS-ID:      $Id: AVPropDlg.h,v 1.3 2005/10/18 08:12:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef AV_PROP_DLG_H
#define AV_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

class AVPropDlg: public wxPropDlg
{
  public:
    AVPropDlg(wxWindow *parent, Audio* audio, Video* video, bool menu);

  protected:
	Audio* m_audio;
	Video* m_video;
	bool m_menu;
	wxString m_auto;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	wxString String2Auto(wxString s) { return s == _T("") ? m_auto : s; }
	wxString Auto2String(wxString s) { return s == m_auto ? _T("") : s; }
};

#endif // AV_PROP_DLG_H
