/////////////////////////////////////////////////////////////////////////////
// Name:        MenuPropDlg.h
// Purpose:     DVD menu properties dialog
// Author:      Alex Thuering
// Created:     25.04.2004
// RCS-ID:      $Id: MenuPropDlg.h,v 1.4 2005/10/18 08:12:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef MENU_PROP_DLG_H
#define MENU_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"
#include "Menu.h"

class MenuPropDlg: public wxPropDlg
{
  public:
    MenuPropDlg(wxWindow *parent, DVD* dvd, int tsi, int pgci);
	virtual ~MenuPropDlg() {}

  protected:
	DVD* m_dvd;
	Audio* m_audio;
	Video* m_video;
	int m_tsi;
	int m_pgci;
    Pgc* m_pgc;
	Vob* m_vob;
	Menu* m_menu;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	void CreateButtonPane(wxSizer* sizer, bool resetButton = false);
	void OnAV(wxCommandEvent& event);
	
  private:
    DECLARE_EVENT_TABLE()
};

#endif // MENU_PROP_DLG_H
