/////////////////////////////////////////////////////////////////////////////
// Name:        TitlesetManager.h
// Purpose:     Titleset Manager
// Author:      Alex Thuering
// Created:	27.01.2003
// RCS-ID:      $Id: TitlesetManager.h,v 1.6 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef TITLE_THUMBNAILS_H
#define TITLE_THUMBNAILS_H

#include <wxVillaLib/Thumbnails.h>
#include "DVD.h"

class TitlesetManager: public wxThumbnails
{
  public:
    TitlesetManager(wxWindow* parent, int id);
    ~TitlesetManager();
	
	void SetDVD(DVD* dvd);
	inline DVD* GetDVD() { return m_dvd; }
	inline int GetSelectedMenu() { return m_selectedMenu; }
	int GetPointedId() { return GetItem(GetPointed())->GetId(); }
	int GetSelectedId() { return GetItem(GetSelected())->GetId(); }
	int GetSelectedMenuId() { return GetItem(GetSelectedMenu())->GetId(); }
	
	void AddVideo(const wxString& fname, bool createTitle = true);
    void AddAudio(const wxString& fname);
    void AddSubtitles(const wxString& fname);
    void AddImage(const wxString& fname, bool createTitle = true);
	void SelectFirstMenu();
	void SelectMenu(int tsi, int pgci);
	
	void AddMenu();
	void AddVmMenu();
	void AddTitleset();
    
    /** updates items to display current content of DVD */
    void UpdateItems();

  protected:
	DVD* m_dvd;
	int m_selectedMenu;
    void DrawThumbnail(wxBitmap& bmp, wxThumb& thumb, int index);
    int GetCaptionHeight(int begRow, int count);
	/** returns index of thumbnail for specified vob */
	int GetIndex(int tsi, int pgci, int vobi, bool menu);
	int GetIndex(int id);
	bool IsBeginOfTitleset(int tsi, int pgci, int vobi, bool isMenu);
	bool IsEndOfTitleset(int tsi, int pgci, int vobi, bool isMenu);
    void SendMenuSelectedEvent();
	void SendDvdChangedEvent();
	
	wxMenu* m_mainMenu;
	wxMenu* m_titleMenu;
	void OnMouseDown(wxMouseEvent& event);
	void OnMouseDClick(wxMouseEvent& WXUNUSED(event));
	void OnAddMenu(wxCommandEvent& WXUNUSED(event)) { AddMenu(); }
	void OnAddVmMenu(wxCommandEvent& WXUNUSED(event)) { AddVmMenu(); }
	void OnAddTitleset(wxCommandEvent& WXUNUSED(event)) { AddTitleset(); }
	void OnAddTitlesetUpdateUI(wxUpdateUIEvent& event);
	void OnMoveTitleLeft(wxCommandEvent& WXUNUSED(event));
	void OnMoveTitleRight(wxCommandEvent& WXUNUSED(event));
	void OnMoveTitleLeftUpdateUI(wxUpdateUIEvent& event);
	void OnMoveTitleRightUpdateUI(wxUpdateUIEvent& event);
	void OnDelete(wxCommandEvent& WXUNUSED(event));
	void OnProps(wxCommandEvent& WXUNUSED(event));
  
  private:
    DECLARE_EVENT_TABLE()
};

BEGIN_DECLARE_EVENT_TYPES()
  DECLARE_EVENT_TYPE(EVT_COMMAND_MENU_SELECTED, 3300)
  DECLARE_EVENT_TYPE(EVT_COMMAND_DVD_CHANGED, 3301)
END_DECLARE_EVENT_TYPES()

#define EVT_MENU_SELECTED(id, fn)\
 DECLARE_EVENT_TABLE_ENTRY(EVT_COMMAND_MENU_SELECTED, id, wxID_ANY,\
 (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction)& fn, NULL),
#define EVT_DVD_CHANGED(id, fn)\
 DECLARE_EVENT_TABLE_ENTRY(EVT_COMMAND_DVD_CHANGED, id, wxID_ANY,\
 (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction)& fn, NULL),

#endif // TITLE_THUMBNAILS_H
