;;;
;;; quoted-printable.scm - quoted-printable encoding/decoding routine
;;;  
;;;   Copyright (c) 2000-2007  Shiro Kawai  <shiro@acm.org>
;;;   
;;;   Redistribution and use in source and binary forms, with or without
;;;   modification, are permitted provided that the following conditions
;;;   are met:
;;;   
;;;   1. Redistributions of source code must retain the above copyright
;;;      notice, this list of conditions and the following disclaimer.
;;;  
;;;   2. Redistributions in binary form must reproduce the above copyright
;;;      notice, this list of conditions and the following disclaimer in the
;;;      documentation and/or other materials provided with the distribution.
;;;  
;;;   3. Neither the name of the authors nor the names of its contributors
;;;      may be used to endorse or promote products derived from this
;;;      software without specific prior written permission.
;;;  
;;;   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;;   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;;   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;;   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;;   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;;   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
;;;   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;;   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;;   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;;   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;;   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;  
;;;  $Id: quoted-printable.scm,v 1.7 2007/03/02 07:39:10 shirok Exp $
;;;


;; Ref: RFC2045 section 6.7  <http://www.rfc-editor.org/rfc/rfc2045.txt>

(define-module rfc.quoted-printable
  (export quoted-printable-encode quoted-printable-encode-string
          quoted-printable-decode quoted-printable-decode-string)
  )
(select-module rfc.quoted-printable)

;; TODO: binary encoding
(define (quoted-printable-encode . args)
  (define binary? (get-keyword :binary? args #t))
  (let loop ((c (read-byte))
             (lcnt 0))
    (cond ((eof-object? c))
          ((>= lcnt 73) (display "=\r\n") (loop c 0)) ;soft newline
          ((= c #x3d) ; '='
           (display "=3D") (loop (read-byte) (+ lcnt 3)))
          ((and (>= lcnt 72)            ; space or tab at the end of line
                (or (= c #x20) (= c #x09)))
           (write-byte c) (display "=\r\n") (loop (read-byte) 0))
          ((= c #x0d)
           (let ((c1 (read-byte)))
             (cond ((= c1 #x0a) (display "\r\n") (loop (read-byte) 0))
                   (else (display "\r\n") (loop c1 0)))))
          ((= c #x0a)
           (display "\r\n") (loop (read-byte) 0))
          ((<= #x21 c #x7e)
           (write-byte c) (loop (read-byte) (+ lcnt 1)))
          (else (format #t "=~2,'0X" c) (loop (read-byte) (+ lcnt 3))))
    ))

(define (quoted-printable-encode-string string . args)
  (with-string-io string (lambda () (apply quoted-printable-encode args))))

(define (quoted-printable-decode)
  (let loop ((c (read-char)))
    (cond ((eof-object? c))
          ((char=? c #\=)
           (let ((c1 (read-char)))
             (cond
              ((eof-object? c1)) ; illegal, but we recognize it as a soft newline
              ((char=? c1 #\newline) (loop (read-char))) ; soft newline
              ((char=? c1 #\return)      ; soft newline
               (let ((c2 (read-char)))
                 (if (char=? c2 #\newline) (loop (read-char)) (loop c2))))
              ((memv c1 '(#\tab #\space)) ; possibly soft newline
               (let loop2 ((c2 (read-char))
                           (r (list c1 c)))
                 (cond ((eof-object? c2))
                       ((char=? c2 #\newline) (loop (read-char)))
                       ((char=? c2 #\return)
                        (let ((c3 (read-char)))
                          (if (char=? c3 #\newline)
                              (loop (read-char))
                              (loop c3))))
                       ((memv c2 '(#\tab #\space))
                        (loop2 (read-char) (cons c2 r)))
                       (else
                        (for-each write-char (reverse r))
                        (loop c2)))))
              ((digit->integer c1 16)
               => (lambda (num1)
                    (let ((c2 (read-char)))
                      (cond ((eof-object? c2) (write-char c) (write-char c1))
                            ((digit->integer c2 16)
                             => (lambda (num2)
                                  (write-byte (+ (* num1 16) num2))
                                  (loop (read-char))))
                            (else
                             (write-char c) (write-char c1) (loop c2))))))
              (else
               (write-char c) (loop c1)))))
          (else
           (write-char c) (loop (read-char))))
    )
  )
             
(define (quoted-printable-decode-string string)
  (with-string-io string quoted-printable-decode))

(provide "rfc/quoted-printable")
