/* Generated by genstub.  Do not edit. */
#define LIBGAUCHE_BODY
#include <gauche.h>
#if defined(__CYGWIN__) || defined(__MINGW32__)
#define SCM_CGEN_CONST /*empty*/
#else
#define SCM_CGEN_CONST const
#endif
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <locale.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <math.h>
#ifndef __MINGW32__
#include <sys/wait.h>
#include <grp.h>
#include <pwd.h>
#else  /* __MINGW32__ */
#include <windows.h>
#endif /* __MINGW32__ */
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if HAVE_CRYPT_H
#include <crypt.h>
#endif

static ScmObj syslib_sys_readdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-readdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_ReadDirectory(pathname);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_readdir__NAME, "sys-readdir", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_readdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_readdir__NAME), syslib_sys_readdir, NULL, NULL);

static ScmObj syslib_sys_glob(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pattern_scm;
  ScmString* pattern;
  SCM_ENTER_SUBR("sys-glob");
  pattern_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pattern_scm)) Scm_Error("string required, but got %S", pattern_scm);
  pattern = SCM_STRING(pattern_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GlobDirectory(pattern);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_glob__NAME, "sys-glob", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_glob__STUB, 1, 0, SCM_OBJ(&syslib_sys_glob__NAME), syslib_sys_glob, NULL, NULL);

static SCM_DEFINE_STRING_CONST(KEYARG_absolute__NAME, "absolute", 8, 8);
static ScmObj KEYARG_absolute = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_expand__NAME, "expand", 6, 6);
static ScmObj KEYARG_expand = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_canonicalize__NAME, "canonicalize", 12, 12);
static ScmObj KEYARG_canonicalize = SCM_UNBOUND;
static ScmObj syslib_sys_normalize_pathname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  ScmObj absolute_scm = SCM_FALSE;
  ScmObj absolute;
  ScmObj expand_scm = SCM_FALSE;
  ScmObj expand;
  ScmObj canonicalize_scm = SCM_FALSE;
  ScmObj canonicalize;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-normalize-pathname");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  if (Scm_Length(SCM_OPTARGS) % 2)
    Scm_Error("keyword list not even: %S", SCM_OPTARGS);
  while (!SCM_NULLP(SCM_OPTARGS)) {
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_absolute))) {
      absolute_scm = SCM_CADR(SCM_OPTARGS);
    } else 
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_expand))) {
      expand_scm = SCM_CADR(SCM_OPTARGS);
    } else 
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_canonicalize))) {
      canonicalize_scm = SCM_CADR(SCM_OPTARGS);
    }
    else Scm_Warn("unknown keyword %S", SCM_CAR(SCM_OPTARGS));
    SCM_OPTARGS = SCM_CDDR(SCM_OPTARGS);
  }
  absolute = (absolute_scm);
  expand = (expand_scm);
  canonicalize = (canonicalize_scm);
  {
  int flags = 0;
  if (!SCM_FALSEP(absolute)) flags |= SCM_PATH_ABSOLUTE;
  if (!SCM_FALSEP(expand))   flags |= SCM_PATH_EXPAND;
  if (!SCM_FALSEP(canonicalize)) flags |= SCM_PATH_CANONICALIZE;
  SCM_RETURN(Scm_NormalizePathname(pathname, flags));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_normalize_pathname__NAME, "sys-normalize-pathname", 22, 22);
static SCM_DEFINE_SUBR(syslib_sys_normalize_pathname__STUB, 1, 1, SCM_OBJ(&syslib_sys_normalize_pathname__NAME), syslib_sys_normalize_pathname, NULL, NULL);

static ScmObj syslib_sys_basename(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-basename");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_BaseName(pathname);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_basename__NAME, "sys-basename", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_basename__STUB, 1, 0, SCM_OBJ(&syslib_sys_basename__NAME), syslib_sys_basename, NULL, NULL);

static ScmObj syslib_sys_dirname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-dirname");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_DirName(pathname);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_dirname__NAME, "sys-dirname", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_dirname__STUB, 1, 0, SCM_OBJ(&syslib_sys_dirname__NAME), syslib_sys_dirname, NULL, NULL);

#if defined(E2BIG)
static SCM_DEFINE_STRING_CONST(syslib_E2BIG__VAR__NAME, "E2BIG", 5, 5);
static ScmObj syslib_E2BIG__VAR = SCM_UNBOUND;
#endif /*defined(E2BIG)*/
#if defined(EACCES)
static SCM_DEFINE_STRING_CONST(syslib_EACCES__VAR__NAME, "EACCES", 6, 6);
static ScmObj syslib_EACCES__VAR = SCM_UNBOUND;
#endif /*defined(EACCES)*/
#if defined(EADDRINUSE)
static SCM_DEFINE_STRING_CONST(syslib_EADDRINUSE__VAR__NAME, "EADDRINUSE", 10, 10);
static ScmObj syslib_EADDRINUSE__VAR = SCM_UNBOUND;
#endif /*defined(EADDRINUSE)*/
#if defined(EADDRNOTAVAIL)
static SCM_DEFINE_STRING_CONST(syslib_EADDRNOTAVAIL__VAR__NAME, "EADDRNOTAVAIL", 13, 13);
static ScmObj syslib_EADDRNOTAVAIL__VAR = SCM_UNBOUND;
#endif /*defined(EADDRNOTAVAIL)*/
#if defined(EADV)
static SCM_DEFINE_STRING_CONST(syslib_EADV__VAR__NAME, "EADV", 4, 4);
static ScmObj syslib_EADV__VAR = SCM_UNBOUND;
#endif /*defined(EADV)*/
#if defined(EAFNOSUPPORT)
static SCM_DEFINE_STRING_CONST(syslib_EAFNOSUPPORT__VAR__NAME, "EAFNOSUPPORT", 12, 12);
static ScmObj syslib_EAFNOSUPPORT__VAR = SCM_UNBOUND;
#endif /*defined(EAFNOSUPPORT)*/
#if defined(EAGAIN)
static SCM_DEFINE_STRING_CONST(syslib_EAGAIN__VAR__NAME, "EAGAIN", 6, 6);
static ScmObj syslib_EAGAIN__VAR = SCM_UNBOUND;
#endif /*defined(EAGAIN)*/
#if defined(EALREADY)
static SCM_DEFINE_STRING_CONST(syslib_EALREADY__VAR__NAME, "EALREADY", 8, 8);
static ScmObj syslib_EALREADY__VAR = SCM_UNBOUND;
#endif /*defined(EALREADY)*/
#if defined(EBADE)
static SCM_DEFINE_STRING_CONST(syslib_EBADE__VAR__NAME, "EBADE", 5, 5);
static ScmObj syslib_EBADE__VAR = SCM_UNBOUND;
#endif /*defined(EBADE)*/
#if defined(EBADF)
static SCM_DEFINE_STRING_CONST(syslib_EBADF__VAR__NAME, "EBADF", 5, 5);
static ScmObj syslib_EBADF__VAR = SCM_UNBOUND;
#endif /*defined(EBADF)*/
#if defined(EBADFD)
static SCM_DEFINE_STRING_CONST(syslib_EBADFD__VAR__NAME, "EBADFD", 6, 6);
static ScmObj syslib_EBADFD__VAR = SCM_UNBOUND;
#endif /*defined(EBADFD)*/
#if defined(EBADMSG)
static SCM_DEFINE_STRING_CONST(syslib_EBADMSG__VAR__NAME, "EBADMSG", 7, 7);
static ScmObj syslib_EBADMSG__VAR = SCM_UNBOUND;
#endif /*defined(EBADMSG)*/
#if defined(EBADR)
static SCM_DEFINE_STRING_CONST(syslib_EBADR__VAR__NAME, "EBADR", 5, 5);
static ScmObj syslib_EBADR__VAR = SCM_UNBOUND;
#endif /*defined(EBADR)*/
#if defined(EBADRQC)
static SCM_DEFINE_STRING_CONST(syslib_EBADRQC__VAR__NAME, "EBADRQC", 7, 7);
static ScmObj syslib_EBADRQC__VAR = SCM_UNBOUND;
#endif /*defined(EBADRQC)*/
#if defined(EBADSLT)
static SCM_DEFINE_STRING_CONST(syslib_EBADSLT__VAR__NAME, "EBADSLT", 7, 7);
static ScmObj syslib_EBADSLT__VAR = SCM_UNBOUND;
#endif /*defined(EBADSLT)*/
#if defined(EBFONT)
static SCM_DEFINE_STRING_CONST(syslib_EBFONT__VAR__NAME, "EBFONT", 6, 6);
static ScmObj syslib_EBFONT__VAR = SCM_UNBOUND;
#endif /*defined(EBFONT)*/
#if defined(EBUSY)
static SCM_DEFINE_STRING_CONST(syslib_EBUSY__VAR__NAME, "EBUSY", 5, 5);
static ScmObj syslib_EBUSY__VAR = SCM_UNBOUND;
#endif /*defined(EBUSY)*/
#if defined(ECANCELED)
static SCM_DEFINE_STRING_CONST(syslib_ECANCELED__VAR__NAME, "ECANCELED", 9, 9);
static ScmObj syslib_ECANCELED__VAR = SCM_UNBOUND;
#endif /*defined(ECANCELED)*/
#if defined(ECHILD)
static SCM_DEFINE_STRING_CONST(syslib_ECHILD__VAR__NAME, "ECHILD", 6, 6);
static ScmObj syslib_ECHILD__VAR = SCM_UNBOUND;
#endif /*defined(ECHILD)*/
#if defined(ECHRNG)
static SCM_DEFINE_STRING_CONST(syslib_ECHRNG__VAR__NAME, "ECHRNG", 6, 6);
static ScmObj syslib_ECHRNG__VAR = SCM_UNBOUND;
#endif /*defined(ECHRNG)*/
#if defined(ECOMM)
static SCM_DEFINE_STRING_CONST(syslib_ECOMM__VAR__NAME, "ECOMM", 5, 5);
static ScmObj syslib_ECOMM__VAR = SCM_UNBOUND;
#endif /*defined(ECOMM)*/
#if defined(ECONNABORTED)
static SCM_DEFINE_STRING_CONST(syslib_ECONNABORTED__VAR__NAME, "ECONNABORTED", 12, 12);
static ScmObj syslib_ECONNABORTED__VAR = SCM_UNBOUND;
#endif /*defined(ECONNABORTED)*/
#if defined(ECONNREFUSED)
static SCM_DEFINE_STRING_CONST(syslib_ECONNREFUSED__VAR__NAME, "ECONNREFUSED", 12, 12);
static ScmObj syslib_ECONNREFUSED__VAR = SCM_UNBOUND;
#endif /*defined(ECONNREFUSED)*/
#if defined(ECONNRESET)
static SCM_DEFINE_STRING_CONST(syslib_ECONNRESET__VAR__NAME, "ECONNRESET", 10, 10);
static ScmObj syslib_ECONNRESET__VAR = SCM_UNBOUND;
#endif /*defined(ECONNRESET)*/
#if defined(EDEADLK)
static SCM_DEFINE_STRING_CONST(syslib_EDEADLK__VAR__NAME, "EDEADLK", 7, 7);
static ScmObj syslib_EDEADLK__VAR = SCM_UNBOUND;
#endif /*defined(EDEADLK)*/
#if defined(EDEADLOCK)
static SCM_DEFINE_STRING_CONST(syslib_EDEADLOCK__VAR__NAME, "EDEADLOCK", 9, 9);
static ScmObj syslib_EDEADLOCK__VAR = SCM_UNBOUND;
#endif /*defined(EDEADLOCK)*/
#if defined(EDESTADDRREQ)
static SCM_DEFINE_STRING_CONST(syslib_EDESTADDRREQ__VAR__NAME, "EDESTADDRREQ", 12, 12);
static ScmObj syslib_EDESTADDRREQ__VAR = SCM_UNBOUND;
#endif /*defined(EDESTADDRREQ)*/
#if defined(EDOM)
static SCM_DEFINE_STRING_CONST(syslib_EDOM__VAR__NAME, "EDOM", 4, 4);
static ScmObj syslib_EDOM__VAR = SCM_UNBOUND;
#endif /*defined(EDOM)*/
#if defined(EDOTDOT)
static SCM_DEFINE_STRING_CONST(syslib_EDOTDOT__VAR__NAME, "EDOTDOT", 7, 7);
static ScmObj syslib_EDOTDOT__VAR = SCM_UNBOUND;
#endif /*defined(EDOTDOT)*/
#if defined(EDQUOT)
static SCM_DEFINE_STRING_CONST(syslib_EDQUOT__VAR__NAME, "EDQUOT", 6, 6);
static ScmObj syslib_EDQUOT__VAR = SCM_UNBOUND;
#endif /*defined(EDQUOT)*/
#if defined(EEXIST)
static SCM_DEFINE_STRING_CONST(syslib_EEXIST__VAR__NAME, "EEXIST", 6, 6);
static ScmObj syslib_EEXIST__VAR = SCM_UNBOUND;
#endif /*defined(EEXIST)*/
#if defined(EFAULT)
static SCM_DEFINE_STRING_CONST(syslib_EFAULT__VAR__NAME, "EFAULT", 6, 6);
static ScmObj syslib_EFAULT__VAR = SCM_UNBOUND;
#endif /*defined(EFAULT)*/
#if defined(EFBIG)
static SCM_DEFINE_STRING_CONST(syslib_EFBIG__VAR__NAME, "EFBIG", 5, 5);
static ScmObj syslib_EFBIG__VAR = SCM_UNBOUND;
#endif /*defined(EFBIG)*/
#if defined(EHOSTDOWN)
static SCM_DEFINE_STRING_CONST(syslib_EHOSTDOWN__VAR__NAME, "EHOSTDOWN", 9, 9);
static ScmObj syslib_EHOSTDOWN__VAR = SCM_UNBOUND;
#endif /*defined(EHOSTDOWN)*/
#if defined(EHOSTUNREACH)
static SCM_DEFINE_STRING_CONST(syslib_EHOSTUNREACH__VAR__NAME, "EHOSTUNREACH", 12, 12);
static ScmObj syslib_EHOSTUNREACH__VAR = SCM_UNBOUND;
#endif /*defined(EHOSTUNREACH)*/
#if defined(EIDRM)
static SCM_DEFINE_STRING_CONST(syslib_EIDRM__VAR__NAME, "EIDRM", 5, 5);
static ScmObj syslib_EIDRM__VAR = SCM_UNBOUND;
#endif /*defined(EIDRM)*/
#if defined(EILSEQ)
static SCM_DEFINE_STRING_CONST(syslib_EILSEQ__VAR__NAME, "EILSEQ", 6, 6);
static ScmObj syslib_EILSEQ__VAR = SCM_UNBOUND;
#endif /*defined(EILSEQ)*/
#if defined(EINPROGRESS)
static SCM_DEFINE_STRING_CONST(syslib_EINPROGRESS__VAR__NAME, "EINPROGRESS", 11, 11);
static ScmObj syslib_EINPROGRESS__VAR = SCM_UNBOUND;
#endif /*defined(EINPROGRESS)*/
#if defined(EINTR)
static SCM_DEFINE_STRING_CONST(syslib_EINTR__VAR__NAME, "EINTR", 5, 5);
static ScmObj syslib_EINTR__VAR = SCM_UNBOUND;
#endif /*defined(EINTR)*/
#if defined(EINVAL)
static SCM_DEFINE_STRING_CONST(syslib_EINVAL__VAR__NAME, "EINVAL", 6, 6);
static ScmObj syslib_EINVAL__VAR = SCM_UNBOUND;
#endif /*defined(EINVAL)*/
#if defined(EIO)
static SCM_DEFINE_STRING_CONST(syslib_EIO__VAR__NAME, "EIO", 3, 3);
static ScmObj syslib_EIO__VAR = SCM_UNBOUND;
#endif /*defined(EIO)*/
#if defined(EISCONN)
static SCM_DEFINE_STRING_CONST(syslib_EISCONN__VAR__NAME, "EISCONN", 7, 7);
static ScmObj syslib_EISCONN__VAR = SCM_UNBOUND;
#endif /*defined(EISCONN)*/
#if defined(EISDIR)
static SCM_DEFINE_STRING_CONST(syslib_EISDIR__VAR__NAME, "EISDIR", 6, 6);
static ScmObj syslib_EISDIR__VAR = SCM_UNBOUND;
#endif /*defined(EISDIR)*/
#if defined(EISNAM)
static SCM_DEFINE_STRING_CONST(syslib_EISNAM__VAR__NAME, "EISNAM", 6, 6);
static ScmObj syslib_EISNAM__VAR = SCM_UNBOUND;
#endif /*defined(EISNAM)*/
#if defined(EKEYEXPIRED)
static SCM_DEFINE_STRING_CONST(syslib_EKEYEXPIRED__VAR__NAME, "EKEYEXPIRED", 11, 11);
static ScmObj syslib_EKEYEXPIRED__VAR = SCM_UNBOUND;
#endif /*defined(EKEYEXPIRED)*/
#if defined(EKEYREJECTED)
static SCM_DEFINE_STRING_CONST(syslib_EKEYREJECTED__VAR__NAME, "EKEYREJECTED", 12, 12);
static ScmObj syslib_EKEYREJECTED__VAR = SCM_UNBOUND;
#endif /*defined(EKEYREJECTED)*/
#if defined(EKEYREVOKED)
static SCM_DEFINE_STRING_CONST(syslib_EKEYREVOKED__VAR__NAME, "EKEYREVOKED", 11, 11);
static ScmObj syslib_EKEYREVOKED__VAR = SCM_UNBOUND;
#endif /*defined(EKEYREVOKED)*/
#if defined(EL2HLT)
static SCM_DEFINE_STRING_CONST(syslib_EL2HLT__VAR__NAME, "EL2HLT", 6, 6);
static ScmObj syslib_EL2HLT__VAR = SCM_UNBOUND;
#endif /*defined(EL2HLT)*/
#if defined(EL2NSYNC)
static SCM_DEFINE_STRING_CONST(syslib_EL2NSYNC__VAR__NAME, "EL2NSYNC", 8, 8);
static ScmObj syslib_EL2NSYNC__VAR = SCM_UNBOUND;
#endif /*defined(EL2NSYNC)*/
#if defined(EL3HLT)
static SCM_DEFINE_STRING_CONST(syslib_EL3HLT__VAR__NAME, "EL3HLT", 6, 6);
static ScmObj syslib_EL3HLT__VAR = SCM_UNBOUND;
#endif /*defined(EL3HLT)*/
#if defined(EL3RST)
static SCM_DEFINE_STRING_CONST(syslib_EL3RST__VAR__NAME, "EL3RST", 6, 6);
static ScmObj syslib_EL3RST__VAR = SCM_UNBOUND;
#endif /*defined(EL3RST)*/
#if defined(ELIBACC)
static SCM_DEFINE_STRING_CONST(syslib_ELIBACC__VAR__NAME, "ELIBACC", 7, 7);
static ScmObj syslib_ELIBACC__VAR = SCM_UNBOUND;
#endif /*defined(ELIBACC)*/
#if defined(ELIBBAD)
static SCM_DEFINE_STRING_CONST(syslib_ELIBBAD__VAR__NAME, "ELIBBAD", 7, 7);
static ScmObj syslib_ELIBBAD__VAR = SCM_UNBOUND;
#endif /*defined(ELIBBAD)*/
#if defined(ELIBEXEC)
static SCM_DEFINE_STRING_CONST(syslib_ELIBEXEC__VAR__NAME, "ELIBEXEC", 8, 8);
static ScmObj syslib_ELIBEXEC__VAR = SCM_UNBOUND;
#endif /*defined(ELIBEXEC)*/
#if defined(ELIBMAX)
static SCM_DEFINE_STRING_CONST(syslib_ELIBMAX__VAR__NAME, "ELIBMAX", 7, 7);
static ScmObj syslib_ELIBMAX__VAR = SCM_UNBOUND;
#endif /*defined(ELIBMAX)*/
#if defined(ELIBSCN)
static SCM_DEFINE_STRING_CONST(syslib_ELIBSCN__VAR__NAME, "ELIBSCN", 7, 7);
static ScmObj syslib_ELIBSCN__VAR = SCM_UNBOUND;
#endif /*defined(ELIBSCN)*/
#if defined(ELNRNG)
static SCM_DEFINE_STRING_CONST(syslib_ELNRNG__VAR__NAME, "ELNRNG", 6, 6);
static ScmObj syslib_ELNRNG__VAR = SCM_UNBOUND;
#endif /*defined(ELNRNG)*/
#if defined(ELOOP)
static SCM_DEFINE_STRING_CONST(syslib_ELOOP__VAR__NAME, "ELOOP", 5, 5);
static ScmObj syslib_ELOOP__VAR = SCM_UNBOUND;
#endif /*defined(ELOOP)*/
#if defined(EMEDIUMTYPE)
static SCM_DEFINE_STRING_CONST(syslib_EMEDIUMTYPE__VAR__NAME, "EMEDIUMTYPE", 11, 11);
static ScmObj syslib_EMEDIUMTYPE__VAR = SCM_UNBOUND;
#endif /*defined(EMEDIUMTYPE)*/
#if defined(EMFILE)
static SCM_DEFINE_STRING_CONST(syslib_EMFILE__VAR__NAME, "EMFILE", 6, 6);
static ScmObj syslib_EMFILE__VAR = SCM_UNBOUND;
#endif /*defined(EMFILE)*/
#if defined(EMLINK)
static SCM_DEFINE_STRING_CONST(syslib_EMLINK__VAR__NAME, "EMLINK", 6, 6);
static ScmObj syslib_EMLINK__VAR = SCM_UNBOUND;
#endif /*defined(EMLINK)*/
#if defined(EMSGSIZE)
static SCM_DEFINE_STRING_CONST(syslib_EMSGSIZE__VAR__NAME, "EMSGSIZE", 8, 8);
static ScmObj syslib_EMSGSIZE__VAR = SCM_UNBOUND;
#endif /*defined(EMSGSIZE)*/
#if defined(EMULTIHOP)
static SCM_DEFINE_STRING_CONST(syslib_EMULTIHOP__VAR__NAME, "EMULTIHOP", 9, 9);
static ScmObj syslib_EMULTIHOP__VAR = SCM_UNBOUND;
#endif /*defined(EMULTIHOP)*/
#if defined(ENAMETOOLONG)
static SCM_DEFINE_STRING_CONST(syslib_ENAMETOOLONG__VAR__NAME, "ENAMETOOLONG", 12, 12);
static ScmObj syslib_ENAMETOOLONG__VAR = SCM_UNBOUND;
#endif /*defined(ENAMETOOLONG)*/
#if defined(ENAVAIL)
static SCM_DEFINE_STRING_CONST(syslib_ENAVAIL__VAR__NAME, "ENAVAIL", 7, 7);
static ScmObj syslib_ENAVAIL__VAR = SCM_UNBOUND;
#endif /*defined(ENAVAIL)*/
#if defined(ENETDOWN)
static SCM_DEFINE_STRING_CONST(syslib_ENETDOWN__VAR__NAME, "ENETDOWN", 8, 8);
static ScmObj syslib_ENETDOWN__VAR = SCM_UNBOUND;
#endif /*defined(ENETDOWN)*/
#if defined(ENETRESET)
static SCM_DEFINE_STRING_CONST(syslib_ENETRESET__VAR__NAME, "ENETRESET", 9, 9);
static ScmObj syslib_ENETRESET__VAR = SCM_UNBOUND;
#endif /*defined(ENETRESET)*/
#if defined(ENETUNREACH)
static SCM_DEFINE_STRING_CONST(syslib_ENETUNREACH__VAR__NAME, "ENETUNREACH", 11, 11);
static ScmObj syslib_ENETUNREACH__VAR = SCM_UNBOUND;
#endif /*defined(ENETUNREACH)*/
#if defined(ENFILE)
static SCM_DEFINE_STRING_CONST(syslib_ENFILE__VAR__NAME, "ENFILE", 6, 6);
static ScmObj syslib_ENFILE__VAR = SCM_UNBOUND;
#endif /*defined(ENFILE)*/
#if defined(ENOANO)
static SCM_DEFINE_STRING_CONST(syslib_ENOANO__VAR__NAME, "ENOANO", 6, 6);
static ScmObj syslib_ENOANO__VAR = SCM_UNBOUND;
#endif /*defined(ENOANO)*/
#if defined(ENOBUFS)
static SCM_DEFINE_STRING_CONST(syslib_ENOBUFS__VAR__NAME, "ENOBUFS", 7, 7);
static ScmObj syslib_ENOBUFS__VAR = SCM_UNBOUND;
#endif /*defined(ENOBUFS)*/
#if defined(ENOCSI)
static SCM_DEFINE_STRING_CONST(syslib_ENOCSI__VAR__NAME, "ENOCSI", 6, 6);
static ScmObj syslib_ENOCSI__VAR = SCM_UNBOUND;
#endif /*defined(ENOCSI)*/
#if defined(ENODATA)
static SCM_DEFINE_STRING_CONST(syslib_ENODATA__VAR__NAME, "ENODATA", 7, 7);
static ScmObj syslib_ENODATA__VAR = SCM_UNBOUND;
#endif /*defined(ENODATA)*/
#if defined(ENODEV)
static SCM_DEFINE_STRING_CONST(syslib_ENODEV__VAR__NAME, "ENODEV", 6, 6);
static ScmObj syslib_ENODEV__VAR = SCM_UNBOUND;
#endif /*defined(ENODEV)*/
#if defined(ENOENT)
static SCM_DEFINE_STRING_CONST(syslib_ENOENT__VAR__NAME, "ENOENT", 6, 6);
static ScmObj syslib_ENOENT__VAR = SCM_UNBOUND;
#endif /*defined(ENOENT)*/
#if defined(ENOEXEC)
static SCM_DEFINE_STRING_CONST(syslib_ENOEXEC__VAR__NAME, "ENOEXEC", 7, 7);
static ScmObj syslib_ENOEXEC__VAR = SCM_UNBOUND;
#endif /*defined(ENOEXEC)*/
#if defined(ENOKEY)
static SCM_DEFINE_STRING_CONST(syslib_ENOKEY__VAR__NAME, "ENOKEY", 6, 6);
static ScmObj syslib_ENOKEY__VAR = SCM_UNBOUND;
#endif /*defined(ENOKEY)*/
#if defined(ENOLCK)
static SCM_DEFINE_STRING_CONST(syslib_ENOLCK__VAR__NAME, "ENOLCK", 6, 6);
static ScmObj syslib_ENOLCK__VAR = SCM_UNBOUND;
#endif /*defined(ENOLCK)*/
#if defined(ENOLINK)
static SCM_DEFINE_STRING_CONST(syslib_ENOLINK__VAR__NAME, "ENOLINK", 7, 7);
static ScmObj syslib_ENOLINK__VAR = SCM_UNBOUND;
#endif /*defined(ENOLINK)*/
#if defined(ENOMEDIUM)
static SCM_DEFINE_STRING_CONST(syslib_ENOMEDIUM__VAR__NAME, "ENOMEDIUM", 9, 9);
static ScmObj syslib_ENOMEDIUM__VAR = SCM_UNBOUND;
#endif /*defined(ENOMEDIUM)*/
#if defined(ENOMEM)
static SCM_DEFINE_STRING_CONST(syslib_ENOMEM__VAR__NAME, "ENOMEM", 6, 6);
static ScmObj syslib_ENOMEM__VAR = SCM_UNBOUND;
#endif /*defined(ENOMEM)*/
#if defined(ENOMSG)
static SCM_DEFINE_STRING_CONST(syslib_ENOMSG__VAR__NAME, "ENOMSG", 6, 6);
static ScmObj syslib_ENOMSG__VAR = SCM_UNBOUND;
#endif /*defined(ENOMSG)*/
#if defined(ENONET)
static SCM_DEFINE_STRING_CONST(syslib_ENONET__VAR__NAME, "ENONET", 6, 6);
static ScmObj syslib_ENONET__VAR = SCM_UNBOUND;
#endif /*defined(ENONET)*/
#if defined(ENOPKG)
static SCM_DEFINE_STRING_CONST(syslib_ENOPKG__VAR__NAME, "ENOPKG", 6, 6);
static ScmObj syslib_ENOPKG__VAR = SCM_UNBOUND;
#endif /*defined(ENOPKG)*/
#if defined(ENOPROTOOPT)
static SCM_DEFINE_STRING_CONST(syslib_ENOPROTOOPT__VAR__NAME, "ENOPROTOOPT", 11, 11);
static ScmObj syslib_ENOPROTOOPT__VAR = SCM_UNBOUND;
#endif /*defined(ENOPROTOOPT)*/
#if defined(ENOSPC)
static SCM_DEFINE_STRING_CONST(syslib_ENOSPC__VAR__NAME, "ENOSPC", 6, 6);
static ScmObj syslib_ENOSPC__VAR = SCM_UNBOUND;
#endif /*defined(ENOSPC)*/
#if defined(ENOSR)
static SCM_DEFINE_STRING_CONST(syslib_ENOSR__VAR__NAME, "ENOSR", 5, 5);
static ScmObj syslib_ENOSR__VAR = SCM_UNBOUND;
#endif /*defined(ENOSR)*/
#if defined(ENOSTR)
static SCM_DEFINE_STRING_CONST(syslib_ENOSTR__VAR__NAME, "ENOSTR", 6, 6);
static ScmObj syslib_ENOSTR__VAR = SCM_UNBOUND;
#endif /*defined(ENOSTR)*/
#if defined(ENOSYS)
static SCM_DEFINE_STRING_CONST(syslib_ENOSYS__VAR__NAME, "ENOSYS", 6, 6);
static ScmObj syslib_ENOSYS__VAR = SCM_UNBOUND;
#endif /*defined(ENOSYS)*/
#if defined(ENOTBLK)
static SCM_DEFINE_STRING_CONST(syslib_ENOTBLK__VAR__NAME, "ENOTBLK", 7, 7);
static ScmObj syslib_ENOTBLK__VAR = SCM_UNBOUND;
#endif /*defined(ENOTBLK)*/
#if defined(ENOTCONN)
static SCM_DEFINE_STRING_CONST(syslib_ENOTCONN__VAR__NAME, "ENOTCONN", 8, 8);
static ScmObj syslib_ENOTCONN__VAR = SCM_UNBOUND;
#endif /*defined(ENOTCONN)*/
#if defined(ENOTDIR)
static SCM_DEFINE_STRING_CONST(syslib_ENOTDIR__VAR__NAME, "ENOTDIR", 7, 7);
static ScmObj syslib_ENOTDIR__VAR = SCM_UNBOUND;
#endif /*defined(ENOTDIR)*/
#if defined(ENOTEMPTY)
static SCM_DEFINE_STRING_CONST(syslib_ENOTEMPTY__VAR__NAME, "ENOTEMPTY", 9, 9);
static ScmObj syslib_ENOTEMPTY__VAR = SCM_UNBOUND;
#endif /*defined(ENOTEMPTY)*/
#if defined(ENOTNAM)
static SCM_DEFINE_STRING_CONST(syslib_ENOTNAM__VAR__NAME, "ENOTNAM", 7, 7);
static ScmObj syslib_ENOTNAM__VAR = SCM_UNBOUND;
#endif /*defined(ENOTNAM)*/
#if defined(ENOTSOCK)
static SCM_DEFINE_STRING_CONST(syslib_ENOTSOCK__VAR__NAME, "ENOTSOCK", 8, 8);
static ScmObj syslib_ENOTSOCK__VAR = SCM_UNBOUND;
#endif /*defined(ENOTSOCK)*/
#if defined(ENOTTY)
static SCM_DEFINE_STRING_CONST(syslib_ENOTTY__VAR__NAME, "ENOTTY", 6, 6);
static ScmObj syslib_ENOTTY__VAR = SCM_UNBOUND;
#endif /*defined(ENOTTY)*/
#if defined(ENOTUNIQ)
static SCM_DEFINE_STRING_CONST(syslib_ENOTUNIQ__VAR__NAME, "ENOTUNIQ", 8, 8);
static ScmObj syslib_ENOTUNIQ__VAR = SCM_UNBOUND;
#endif /*defined(ENOTUNIQ)*/
#if defined(ENXIO)
static SCM_DEFINE_STRING_CONST(syslib_ENXIO__VAR__NAME, "ENXIO", 5, 5);
static ScmObj syslib_ENXIO__VAR = SCM_UNBOUND;
#endif /*defined(ENXIO)*/
#if defined(EOPNOTSUPP)
static SCM_DEFINE_STRING_CONST(syslib_EOPNOTSUPP__VAR__NAME, "EOPNOTSUPP", 10, 10);
static ScmObj syslib_EOPNOTSUPP__VAR = SCM_UNBOUND;
#endif /*defined(EOPNOTSUPP)*/
#if defined(EOVERFLOW)
static SCM_DEFINE_STRING_CONST(syslib_EOVERFLOW__VAR__NAME, "EOVERFLOW", 9, 9);
static ScmObj syslib_EOVERFLOW__VAR = SCM_UNBOUND;
#endif /*defined(EOVERFLOW)*/
#if defined(EPERM)
static SCM_DEFINE_STRING_CONST(syslib_EPERM__VAR__NAME, "EPERM", 5, 5);
static ScmObj syslib_EPERM__VAR = SCM_UNBOUND;
#endif /*defined(EPERM)*/
#if defined(EPFNOSUPPORT)
static SCM_DEFINE_STRING_CONST(syslib_EPFNOSUPPORT__VAR__NAME, "EPFNOSUPPORT", 12, 12);
static ScmObj syslib_EPFNOSUPPORT__VAR = SCM_UNBOUND;
#endif /*defined(EPFNOSUPPORT)*/
#if defined(EPIPE)
static SCM_DEFINE_STRING_CONST(syslib_EPIPE__VAR__NAME, "EPIPE", 5, 5);
static ScmObj syslib_EPIPE__VAR = SCM_UNBOUND;
#endif /*defined(EPIPE)*/
#if defined(EPROTO)
static SCM_DEFINE_STRING_CONST(syslib_EPROTO__VAR__NAME, "EPROTO", 6, 6);
static ScmObj syslib_EPROTO__VAR = SCM_UNBOUND;
#endif /*defined(EPROTO)*/
#if defined(EPROTONOSUPPORT)
static SCM_DEFINE_STRING_CONST(syslib_EPROTONOSUPPORT__VAR__NAME, "EPROTONOSUPPORT", 15, 15);
static ScmObj syslib_EPROTONOSUPPORT__VAR = SCM_UNBOUND;
#endif /*defined(EPROTONOSUPPORT)*/
#if defined(EPROTOTYPE)
static SCM_DEFINE_STRING_CONST(syslib_EPROTOTYPE__VAR__NAME, "EPROTOTYPE", 10, 10);
static ScmObj syslib_EPROTOTYPE__VAR = SCM_UNBOUND;
#endif /*defined(EPROTOTYPE)*/
#if defined(ERANGE)
static SCM_DEFINE_STRING_CONST(syslib_ERANGE__VAR__NAME, "ERANGE", 6, 6);
static ScmObj syslib_ERANGE__VAR = SCM_UNBOUND;
#endif /*defined(ERANGE)*/
#if defined(EREMCHG)
static SCM_DEFINE_STRING_CONST(syslib_EREMCHG__VAR__NAME, "EREMCHG", 7, 7);
static ScmObj syslib_EREMCHG__VAR = SCM_UNBOUND;
#endif /*defined(EREMCHG)*/
#if defined(EREMOTE)
static SCM_DEFINE_STRING_CONST(syslib_EREMOTE__VAR__NAME, "EREMOTE", 7, 7);
static ScmObj syslib_EREMOTE__VAR = SCM_UNBOUND;
#endif /*defined(EREMOTE)*/
#if defined(EREMOTEIO)
static SCM_DEFINE_STRING_CONST(syslib_EREMOTEIO__VAR__NAME, "EREMOTEIO", 9, 9);
static ScmObj syslib_EREMOTEIO__VAR = SCM_UNBOUND;
#endif /*defined(EREMOTEIO)*/
#if defined(ERESTART)
static SCM_DEFINE_STRING_CONST(syslib_ERESTART__VAR__NAME, "ERESTART", 8, 8);
static ScmObj syslib_ERESTART__VAR = SCM_UNBOUND;
#endif /*defined(ERESTART)*/
#if defined(EROFS)
static SCM_DEFINE_STRING_CONST(syslib_EROFS__VAR__NAME, "EROFS", 5, 5);
static ScmObj syslib_EROFS__VAR = SCM_UNBOUND;
#endif /*defined(EROFS)*/
#if defined(ESHUTDOWN)
static SCM_DEFINE_STRING_CONST(syslib_ESHUTDOWN__VAR__NAME, "ESHUTDOWN", 9, 9);
static ScmObj syslib_ESHUTDOWN__VAR = SCM_UNBOUND;
#endif /*defined(ESHUTDOWN)*/
#if defined(ESOCKTNOSUPPORT)
static SCM_DEFINE_STRING_CONST(syslib_ESOCKTNOSUPPORT__VAR__NAME, "ESOCKTNOSUPPORT", 15, 15);
static ScmObj syslib_ESOCKTNOSUPPORT__VAR = SCM_UNBOUND;
#endif /*defined(ESOCKTNOSUPPORT)*/
#if defined(ESPIPE)
static SCM_DEFINE_STRING_CONST(syslib_ESPIPE__VAR__NAME, "ESPIPE", 6, 6);
static ScmObj syslib_ESPIPE__VAR = SCM_UNBOUND;
#endif /*defined(ESPIPE)*/
#if defined(ESRCH)
static SCM_DEFINE_STRING_CONST(syslib_ESRCH__VAR__NAME, "ESRCH", 5, 5);
static ScmObj syslib_ESRCH__VAR = SCM_UNBOUND;
#endif /*defined(ESRCH)*/
#if defined(ESRMNT)
static SCM_DEFINE_STRING_CONST(syslib_ESRMNT__VAR__NAME, "ESRMNT", 6, 6);
static ScmObj syslib_ESRMNT__VAR = SCM_UNBOUND;
#endif /*defined(ESRMNT)*/
#if defined(ESTALE)
static SCM_DEFINE_STRING_CONST(syslib_ESTALE__VAR__NAME, "ESTALE", 6, 6);
static ScmObj syslib_ESTALE__VAR = SCM_UNBOUND;
#endif /*defined(ESTALE)*/
#if defined(ESTRPIPE)
static SCM_DEFINE_STRING_CONST(syslib_ESTRPIPE__VAR__NAME, "ESTRPIPE", 8, 8);
static ScmObj syslib_ESTRPIPE__VAR = SCM_UNBOUND;
#endif /*defined(ESTRPIPE)*/
#if defined(ETIME)
static SCM_DEFINE_STRING_CONST(syslib_ETIME__VAR__NAME, "ETIME", 5, 5);
static ScmObj syslib_ETIME__VAR = SCM_UNBOUND;
#endif /*defined(ETIME)*/
#if defined(ETIMEDOUT)
static SCM_DEFINE_STRING_CONST(syslib_ETIMEDOUT__VAR__NAME, "ETIMEDOUT", 9, 9);
static ScmObj syslib_ETIMEDOUT__VAR = SCM_UNBOUND;
#endif /*defined(ETIMEDOUT)*/
#if defined(ETOOMANYREFS)
static SCM_DEFINE_STRING_CONST(syslib_ETOOMANYREFS__VAR__NAME, "ETOOMANYREFS", 12, 12);
static ScmObj syslib_ETOOMANYREFS__VAR = SCM_UNBOUND;
#endif /*defined(ETOOMANYREFS)*/
#if defined(ETXTBSY)
static SCM_DEFINE_STRING_CONST(syslib_ETXTBSY__VAR__NAME, "ETXTBSY", 7, 7);
static ScmObj syslib_ETXTBSY__VAR = SCM_UNBOUND;
#endif /*defined(ETXTBSY)*/
#if defined(EUCLEAN)
static SCM_DEFINE_STRING_CONST(syslib_EUCLEAN__VAR__NAME, "EUCLEAN", 7, 7);
static ScmObj syslib_EUCLEAN__VAR = SCM_UNBOUND;
#endif /*defined(EUCLEAN)*/
#if defined(EUNATCH)
static SCM_DEFINE_STRING_CONST(syslib_EUNATCH__VAR__NAME, "EUNATCH", 7, 7);
static ScmObj syslib_EUNATCH__VAR = SCM_UNBOUND;
#endif /*defined(EUNATCH)*/
#if defined(EUSERS)
static SCM_DEFINE_STRING_CONST(syslib_EUSERS__VAR__NAME, "EUSERS", 6, 6);
static ScmObj syslib_EUSERS__VAR = SCM_UNBOUND;
#endif /*defined(EUSERS)*/
#if defined(EWOULDBLOCK)
static SCM_DEFINE_STRING_CONST(syslib_EWOULDBLOCK__VAR__NAME, "EWOULDBLOCK", 11, 11);
static ScmObj syslib_EWOULDBLOCK__VAR = SCM_UNBOUND;
#endif /*defined(EWOULDBLOCK)*/
#if defined(EXDEV)
static SCM_DEFINE_STRING_CONST(syslib_EXDEV__VAR__NAME, "EXDEV", 5, 5);
static ScmObj syslib_EXDEV__VAR = SCM_UNBOUND;
#endif /*defined(EXDEV)*/
#if defined(EXFULL)
static SCM_DEFINE_STRING_CONST(syslib_EXFULL__VAR__NAME, "EXFULL", 6, 6);
static ScmObj syslib_EXFULL__VAR = SCM_UNBOUND;
#endif /*defined(EXFULL)*/
static ScmObj syslib_sys_getgrgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj gid_scm;
  int gid;
  SCM_ENTER_SUBR("sys-getgrgid");
  gid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(gid_scm)) Scm_Error("C integer required, but got %S", gid_scm);
  gid = Scm_GetInteger(gid_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetGroupById(gid);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgrgid__NAME, "sys-getgrgid", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getgrgid__STUB, 1, 0, SCM_OBJ(&syslib_sys_getgrgid__NAME), syslib_sys_getgrgid, NULL, NULL);

static ScmObj syslib_sys_getgrnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-getgrnam");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetGroupByName(name);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgrnam__NAME, "sys-getgrnam", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getgrnam__STUB, 1, 0, SCM_OBJ(&syslib_sys_getgrnam__NAME), syslib_sys_getgrnam, NULL, NULL);

static ScmObj syslib_sys_gid_TOgroup_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj gid_scm;
  int gid;
  SCM_ENTER_SUBR("sys-gid->group-name");
  gid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(gid_scm)) Scm_Error("C integer required, but got %S", gid_scm);
  gid = Scm_GetInteger(gid_scm);
  {
  struct group *g = getgrgid(gid);
  if (g == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(SCM_MAKE_STR_COPYING(g->gr_name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_gid_TOgroup_name__NAME, "sys-gid->group-name", 19, 19);
static SCM_DEFINE_SUBR(syslib_sys_gid_TOgroup_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_gid_TOgroup_name__NAME), syslib_sys_gid_TOgroup_name, NULL, NULL);

static ScmObj syslib_sys_group_name_TOgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-group-name->gid");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
  struct group *g = getgrnam(Scm_GetStringConst(name));
  if (g == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(Scm_MakeInteger(g->gr_gid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_group_name_TOgid__NAME, "sys-group-name->gid", 19, 19);
static SCM_DEFINE_SUBR(syslib_sys_group_name_TOgid__STUB, 1, 0, SCM_OBJ(&syslib_sys_group_name_TOgid__NAME), syslib_sys_group_name_TOgid, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_LC_ALL__VAR__NAME, "LC_ALL", 6, 6);
static ScmObj syslib_LC_ALL__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_COLLATE__VAR__NAME, "LC_COLLATE", 10, 10);
static ScmObj syslib_LC_COLLATE__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_CTYPE__VAR__NAME, "LC_CTYPE", 8, 8);
static ScmObj syslib_LC_CTYPE__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_MONETARY__VAR__NAME, "LC_MONETARY", 11, 11);
static ScmObj syslib_LC_MONETARY__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_NUMERIC__VAR__NAME, "LC_NUMERIC", 10, 10);
static ScmObj syslib_LC_NUMERIC__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_TIME__VAR__NAME, "LC_TIME", 7, 7);
static ScmObj syslib_LC_TIME__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_setlocale(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj category_scm;
  int category;
  ScmObj locale_scm;
  const char * locale;
  SCM_ENTER_SUBR("sys-setlocale");
  category_scm = SCM_ARGREF(0);
  if (!SCM_INTP(category_scm)) Scm_Error("small integer required, but got %S", category_scm);
  category = SCM_INT_VALUE(category_scm);
  locale_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(locale_scm)) Scm_Error("const C string required, but got %S", locale_scm);
  locale = SCM_STRING_CONST_CSTRING(locale_scm);
  {
{
const char * SCM_RESULT;
SCM_RESULT = setlocale(category, locale);
SCM_RETURN(SCM_MAKE_MAYBE(SCM_MAKE_STR_COPYING, SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_setlocale__NAME, "sys-setlocale", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_setlocale__STUB, 2, 0, SCM_OBJ(&syslib_sys_setlocale__NAME), syslib_sys_setlocale, NULL, NULL);

static ScmObj syslib_sys_getpwuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj uid_scm;
  int uid;
  SCM_ENTER_SUBR("sys-getpwuid");
  uid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(uid_scm)) Scm_Error("C integer required, but got %S", uid_scm);
  uid = Scm_GetInteger(uid_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetPasswdById(uid);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpwuid__NAME, "sys-getpwuid", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getpwuid__STUB, 1, 0, SCM_OBJ(&syslib_sys_getpwuid__NAME), syslib_sys_getpwuid, NULL, NULL);

static ScmObj syslib_sys_getpwnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-getpwnam");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetPasswdByName(name);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpwnam__NAME, "sys-getpwnam", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getpwnam__STUB, 1, 0, SCM_OBJ(&syslib_sys_getpwnam__NAME), syslib_sys_getpwnam, NULL, NULL);

static ScmObj syslib_sys_uid_TOuser_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj uid_scm;
  int uid;
  SCM_ENTER_SUBR("sys-uid->user-name");
  uid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(uid_scm)) Scm_Error("C integer required, but got %S", uid_scm);
  uid = Scm_GetInteger(uid_scm);
  {
  struct passwd *p = getpwuid(uid);
  if (p == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(SCM_MAKE_STR_COPYING(p->pw_name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_uid_TOuser_name__NAME, "sys-uid->user-name", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_uid_TOuser_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_uid_TOuser_name__NAME), syslib_sys_uid_TOuser_name, NULL, NULL);

static ScmObj syslib_sys_user_name_TOuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-user-name->uid");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
  struct passwd *p = getpwnam(Scm_GetStringConst(name));
  if (p == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(Scm_MakeInteger(p->pw_uid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_user_name_TOuid__NAME, "sys-user-name->uid", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_user_name_TOuid__STUB, 1, 0, SCM_OBJ(&syslib_sys_user_name_TOuid__NAME), syslib_sys_user_name_TOuid, NULL, NULL);

static ScmObj syslib_sys_sigset_addX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  ScmObj sigs_scm;
  ScmObj sigs;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-sigset-add!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  sigs_scm = SCM_OPTARGS;
  sigs = (sigs_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_SysSigsetOp(set, sigs, FALSE));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_addX__NAME, "sys-sigset-add!", 15, 15);
static SCM_DEFINE_SUBR(syslib_sys_sigset_addX__STUB, 1, 1, SCM_OBJ(&syslib_sys_sigset_addX__NAME), syslib_sys_sigset_addX, NULL, NULL);

static ScmObj syslib_sys_sigset_deleteX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  ScmObj sigs_scm;
  ScmObj sigs;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-sigset-delete!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  sigs_scm = SCM_OPTARGS;
  sigs = (sigs_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_SysSigsetOp(set, sigs, TRUE));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_deleteX__NAME, "sys-sigset-delete!", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_sigset_deleteX__STUB, 1, 1, SCM_OBJ(&syslib_sys_sigset_deleteX__NAME), syslib_sys_sigset_deleteX, NULL, NULL);

static ScmObj syslib_sys_sigset_fillX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  SCM_ENTER_SUBR("sys-sigset-fill!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_SysSigsetFill(set, FALSE));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_fillX__NAME, "sys-sigset-fill!", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_sigset_fillX__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigset_fillX__NAME), syslib_sys_sigset_fillX, NULL, NULL);

static ScmObj syslib_sys_sigset_emptyX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  SCM_ENTER_SUBR("sys-sigset-empty!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_SysSigsetFill(set, TRUE));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_emptyX__NAME, "sys-sigset-empty!", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_sigset_emptyX__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigset_emptyX__NAME), syslib_sys_sigset_emptyX, NULL, NULL);

static ScmObj syslib_sys_signal_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("sys-signal-name");
  sig_scm = SCM_ARGREF(0);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SignalName(sig);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_signal_name__NAME, "sys-signal-name", 15, 15);
static SCM_DEFINE_SUBR(syslib_sys_signal_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_signal_name__NAME), syslib_sys_signal_name, NULL, NULL);

static ScmObj syslib_sys_kill(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pid_scm;
  int pid;
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("sys-kill");
  pid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(pid_scm)) Scm_Error("C integer required, but got %S", pid_scm);
  pid = Scm_GetInteger(pid_scm);
  sig_scm = SCM_ARGREF(1);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
int r; SCM_SYSCALL(r, kill(pid, sig));
if (r < 0) Scm_SysError("kill failed");
SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_kill__NAME, "sys-kill", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_kill__STUB, 2, 0, SCM_OBJ(&syslib_sys_kill__NAME), syslib_sys_kill, NULL, NULL);

static ScmObj syslib_set_signal_handlerX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  ScmObj sig;
  ScmObj proc_scm;
  ScmObj proc;
  ScmObj mask_scm;
  ScmSysSigset* mask;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("set-signal-handler!");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 3 is expected, %d given.", Scm_Length(SCM_OPTARGS)+2);
  sig_scm = SCM_ARGREF(0);
  sig = (sig_scm);
  proc_scm = SCM_ARGREF(1);
  proc = (proc_scm);
  if (SCM_NULLP(SCM_OPTARGS)) mask_scm = SCM_FALSE;
  else {
    mask_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  if (!SCM_MAYBE_P(SCM_SYS_SIGSET_P, mask_scm)) Scm_Error("<sys-sigset> or #f required, but got %S", mask_scm);
  mask = SCM_MAYBE(SCM_SYS_SIGSET, mask_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SetSignalHandler(sig, proc, mask);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_set_signal_handlerX__NAME, "set-signal-handler!", 19, 19);
static SCM_DEFINE_SUBR(syslib_set_signal_handlerX__STUB, 2, 1, SCM_OBJ(&syslib_set_signal_handlerX__NAME), syslib_set_signal_handlerX, NULL, NULL);

static ScmObj syslib_get_signal_handler(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("get-signal-handler");
  sig_scm = SCM_ARGREF(0);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetSignalHandler(sig);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_handler__NAME, "get-signal-handler", 18, 18);
static SCM_DEFINE_SUBR(syslib_get_signal_handler__STUB, 1, 0, SCM_OBJ(&syslib_get_signal_handler__NAME), syslib_get_signal_handler, NULL, NULL);

static ScmObj syslib_get_signal_handler_mask(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("get-signal-handler-mask");
  sig_scm = SCM_ARGREF(0);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetSignalHandlerMask(sig);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_handler_mask__NAME, "get-signal-handler-mask", 23, 23);
static SCM_DEFINE_SUBR(syslib_get_signal_handler_mask__STUB, 1, 0, SCM_OBJ(&syslib_get_signal_handler_mask__NAME), syslib_get_signal_handler_mask, NULL, NULL);

static ScmObj syslib_get_signal_handlers(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("get-signal-handlers");
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_GetSignalHandlers();
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_handlers__NAME, "get-signal-handlers", 19, 19);
static SCM_DEFINE_SUBR(syslib_get_signal_handlers__STUB, 0, 0, SCM_OBJ(&syslib_get_signal_handlers__NAME), syslib_get_signal_handlers, NULL, NULL);

static ScmObj syslib_set_signal_pending_limit(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj limit_scm;
  int limit;
  SCM_ENTER_SUBR("set-signal-pending-limit");
  limit_scm = SCM_ARGREF(0);
  if (!SCM_INTP(limit_scm)) Scm_Error("small integer required, but got %S", limit_scm);
  limit = SCM_INT_VALUE(limit_scm);
  {
Scm_SetSignalPendingLimit(limit);
SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_set_signal_pending_limit__NAME, "set-signal-pending-limit", 24, 24);
static SCM_DEFINE_SUBR(syslib_set_signal_pending_limit__STUB, 1, 0, SCM_OBJ(&syslib_set_signal_pending_limit__NAME), syslib_set_signal_pending_limit, NULL, NULL);

static ScmObj syslib_get_signal_pending_limit(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("get-signal-pending-limit");
  {
{
int SCM_RESULT;
SCM_RESULT = Scm_GetSignalPendingLimit();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_pending_limit__NAME, "get-signal-pending-limit", 24, 24);
static SCM_DEFINE_SUBR(syslib_get_signal_pending_limit__STUB, 0, 0, SCM_OBJ(&syslib_get_signal_pending_limit__NAME), syslib_get_signal_pending_limit, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_SIG_SETMASK__VAR__NAME, "SIG_SETMASK", 11, 11);
static ScmObj syslib_SIG_SETMASK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_SIG_BLOCK__VAR__NAME, "SIG_BLOCK", 9, 9);
static ScmObj syslib_SIG_BLOCK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_SIG_UNBLOCK__VAR__NAME, "SIG_UNBLOCK", 11, 11);
static ScmObj syslib_SIG_UNBLOCK__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_sigmask(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj how_scm;
  int how;
  ScmObj mask_scm;
  ScmSysSigset* mask;
  SCM_ENTER_SUBR("sys-sigmask");
  how_scm = SCM_ARGREF(0);
  if (!SCM_INTP(how_scm)) Scm_Error("small integer required, but got %S", how_scm);
  how = SCM_INT_VALUE(how_scm);
  mask_scm = SCM_ARGREF(1);
  if (!SCM_MAYBE_P(SCM_SYS_SIGSET_P, mask_scm)) Scm_Error("<sys-sigset> or #f required, but got %S", mask_scm);
  mask = SCM_MAYBE(SCM_SYS_SIGSET, mask_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SysSigmask(how, mask);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigmask__NAME, "sys-sigmask", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_sigmask__STUB, 2, 0, SCM_OBJ(&syslib_sys_sigmask__NAME), syslib_sys_sigmask, NULL, NULL);

static ScmObj syslib_sys_sigsuspend(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj mask_scm;
  ScmSysSigset* mask;
  SCM_ENTER_SUBR("sys-sigsuspend");
  mask_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(mask_scm)) Scm_Error("<sys-sigset> required, but got %S", mask_scm);
  mask = SCM_SYS_SIGSET(mask_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SigSuspend(mask);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigsuspend__NAME, "sys-sigsuspend", 14, 14);
static SCM_DEFINE_SUBR(syslib_sys_sigsuspend__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigsuspend__NAME), syslib_sys_sigsuspend, NULL, NULL);

#if defined HAVE_SIGWAIT
static ScmObj syslib_sys_sigwait(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj mask_scm;
  ScmSysSigset* mask;
  SCM_ENTER_SUBR("sys-sigwait");
  mask_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(mask_scm)) Scm_Error("<sys-sigset> required, but got %S", mask_scm);
  mask = SCM_SYS_SIGSET(mask_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = Scm_SigWait(mask);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigwait__NAME, "sys-sigwait", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_sigwait__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigwait__NAME), syslib_sys_sigwait, NULL, NULL);

#endif /*defined HAVE_SIGWAIT*/
static ScmObj syslib_sys_remove(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj filename_scm;
  const char * filename;
  SCM_ENTER_SUBR("sys-remove");
  filename_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(filename_scm)) Scm_Error("const C string required, but got %S", filename_scm);
  filename = SCM_STRING_CONST_CSTRING(filename_scm);
  {
  int r;
  SCM_SYSCALL(r, remove(filename));
  if (r < 0) Scm_SysError("removing %s failed", filename);
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_remove__NAME, "sys-remove", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_remove__STUB, 1, 0, SCM_OBJ(&syslib_sys_remove__NAME), syslib_sys_remove, NULL, NULL);

static ScmObj syslib_sys_rename(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj oldname_scm;
  const char * oldname;
  ScmObj newname_scm;
  const char * newname;
  SCM_ENTER_SUBR("sys-rename");
  oldname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(oldname_scm)) Scm_Error("const C string required, but got %S", oldname_scm);
  oldname = SCM_STRING_CONST_CSTRING(oldname_scm);
  newname_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(newname_scm)) Scm_Error("const C string required, but got %S", newname_scm);
  newname = SCM_STRING_CONST_CSTRING(newname_scm);
  {
  int r;
#if defined(__MINGW32__)
  /* Windows doesn't allow renaming to the existing file, so we unlink
     it first.  This breaks the atomicity of rename operation.
     We don't check and raise an error here, since the error will be
     caught by rename() call. */
  chmod(newname, 0666);
  unlink(newname);
#endif /* __MINGW32__ */
  SCM_SYSCALL(r, rename(oldname, newname));
  if (r < 0) Scm_SysError("renaming %s to %s failed", oldname, newname);
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_rename__NAME, "sys-rename", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_rename__STUB, 2, 0, SCM_OBJ(&syslib_sys_rename__NAME), syslib_sys_rename, NULL, NULL);

static ScmObj syslib_sys_tmpnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-tmpnam");
  {

#ifdef HAVE_MKSTEMP
  char nam[] = "/tmp/fileXXXXXX";
  int fd;
  SCM_SYSCALL(fd, mkstemp(nam));
  if (fd < 0) Scm_SysError("mkstemp failed");
  close(fd);
  unlink(nam);
  SCM_RETURN(SCM_MAKE_STR_COPYING(nam));
#else
  char *s = tmpnam(NULL);
  SCM_RETURN(SCM_MAKE_STR_COPYING(s));
#endif
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_tmpnam__NAME, "sys-tmpnam", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_tmpnam__STUB, 0, 0, SCM_OBJ(&syslib_sys_tmpnam__NAME), syslib_sys_tmpnam, NULL, NULL);

static ScmObj syslib_sys_mkstemp(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj template_scm;
  ScmString* template;
  SCM_ENTER_SUBR("sys-mkstemp");
  template_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(template_scm)) Scm_Error("string required, but got %S", template_scm);
  template = SCM_STRING(template_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SysMkstemp(template);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mkstemp__NAME, "sys-mkstemp", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_mkstemp__STUB, 1, 0, SCM_OBJ(&syslib_sys_mkstemp__NAME), syslib_sys_mkstemp, NULL, NULL);

static ScmObj syslib_sys_exit(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj code_scm;
  int code;
  SCM_ENTER_SUBR("sys-exit");
  code_scm = SCM_ARGREF(0);
  if (!SCM_INTP(code_scm)) Scm_Error("small integer required, but got %S", code_scm);
  code = SCM_INT_VALUE(code_scm);
  {
_exit(code);
SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_exit__NAME, "sys-exit", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_exit__STUB, 1, 0, SCM_OBJ(&syslib_sys_exit__NAME), syslib_sys_exit, NULL, NULL);

static ScmObj syslib_sys_getenv(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  const char * name;
  SCM_ENTER_SUBR("sys-getenv");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("const C string required, but got %S", name_scm);
  name = SCM_STRING_CONST_CSTRING(name_scm);
  {
{
const char * SCM_RESULT;
SCM_RESULT = getenv(name);
SCM_RETURN(SCM_MAKE_MAYBE(SCM_MAKE_STR_COPYING, SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getenv__NAME, "sys-getenv", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getenv__STUB, 1, 0, SCM_OBJ(&syslib_sys_getenv__NAME), syslib_sys_getenv, NULL, NULL);

static ScmObj syslib_sys_system(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  const char * command;
  SCM_ENTER_SUBR("sys-system");
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("const C string required, but got %S", command_scm);
  command = SCM_STRING_CONST_CSTRING(command_scm);
  {
{
int SCM_RESULT;
SCM_SYSCALL(SCM_RESULT, system(command));
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_system__NAME, "sys-system", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_system__STUB, 1, 0, SCM_OBJ(&syslib_sys_system__NAME), syslib_sys_system, NULL, NULL);

static ScmObj syslib_sys_random(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-random");
  {
#if defined(HAVE_RANDOM) && defined(HAVE_SRANDOM)
  SCM_RETURN(Scm_MakeInteger(random()));
#elif defined(LRAND48) && defined(SRAND48)
  SCM_RETURN(Scm_MakeInteger(lrand48()));
#else
  /* fallback - we don't want to use rand(), for it is not very good RNG.
     replace it when we have time. */
  SCM_RETURN(Scm_MakeInteger(rand()));
#endif
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_random__NAME, "sys-random", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_random__STUB, 0, 0, SCM_OBJ(&syslib_sys_random__NAME), syslib_sys_random, NULL, NULL);

static ScmObj syslib_sys_srandom(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seed_scm;
  ScmObj seed;
  SCM_ENTER_SUBR("sys-srandom");
  seed_scm = SCM_ARGREF(0);
  seed = (seed_scm);
  {
  if (!SCM_EXACTP(seed)) Scm_Error("exact integer required: %S", seed);
#if defined(HAVE_RANDOM) && defined(HAVE_SRANDOM)
  srandom(Scm_GetUInteger(seed));
#elif defined(LRAND48) && defined(SRAND48)
  srand48(Scm_GetUInteger(seed));
#else
  /* fallback - we don't want to use rand(), for it is not very good RNG.
     replace it when we have time. */
  srand(Scm_GetUInteger(seed));
#endif
  SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_srandom__NAME, "sys-srandom", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_srandom__STUB, 1, 0, SCM_OBJ(&syslib_sys_srandom__NAME), syslib_sys_srandom, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_RAND_MAX__VAR__NAME, "RAND_MAX", 8, 8);
static ScmObj syslib_RAND_MAX__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_strerror(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj errno_scm;
  int errno;
  SCM_ENTER_SUBR("sys-strerror");
  errno_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(errno_scm)) Scm_Error("C integer required, but got %S", errno_scm);
  errno = Scm_GetInteger(errno_scm);
  {
{
const char * SCM_RESULT;
SCM_RESULT = strerror(errno);
SCM_RETURN(SCM_MAKE_STR_COPYING(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_strerror__NAME, "sys-strerror", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_strerror__STUB, 1, 0, SCM_OBJ(&syslib_sys_strerror__NAME), syslib_sys_strerror, NULL, NULL);

static ScmObj syslib_sys_stat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  const char * path;
  SCM_ENTER_SUBR("sys-stat");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("const C string required, but got %S", path_scm);
  path = SCM_STRING_CONST_CSTRING(path_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int r;
  SCM_SYSCALL(r, stat(path, &s->statrec));
  if (r < 0) Scm_SysError("stat failed for %s", path);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_stat__NAME, "sys-stat", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_stat__STUB, 1, 0, SCM_OBJ(&syslib_sys_stat__NAME), syslib_sys_stat, NULL, NULL);

#if !defined(__MINGW32__)
static ScmObj syslib_sys_lstat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  const char * path;
  SCM_ENTER_SUBR("sys-lstat");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("const C string required, but got %S", path_scm);
  path = SCM_STRING_CONST_CSTRING(path_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int r;
  SCM_SYSCALL(r, lstat(path, &s->statrec));
  if (r < 0) Scm_SysError("lstat failed for %s", path);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_lstat__NAME, "sys-lstat", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_lstat__STUB, 1, 0, SCM_OBJ(&syslib_sys_lstat__NAME), syslib_sys_lstat, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_fstat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-fstat");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int fd = Scm_GetPortFd(port_or_fd, FALSE), r;
  if (fd < 0) SCM_RETURN(SCM_FALSE);
  SCM_SYSCALL(r, fstat(fd, &s->statrec));
  if (r < 0) Scm_SysError("fstat failed for %d", fd);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fstat__NAME, "sys-fstat", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_fstat__STUB, 1, 0, SCM_OBJ(&syslib_sys_fstat__NAME), syslib_sys_fstat, NULL, NULL);

#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-wait");
  {
int SCM_RESULT0;
int SCM_RESULT1;
{
int status;  pid_t r;
SCM_SYSCALL(r, wait(&status));
if (r < 0) Scm_SysError("wait() failed");
SCM_RESULT0 = r; SCM_RESULT1 = status;
}
SCM_RETURN(Scm_Values2(Scm_MakeInteger(SCM_RESULT0),Scm_MakeInteger(SCM_RESULT1)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait__NAME, "sys-wait", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_wait__STUB, 0, 0, SCM_OBJ(&syslib_sys_wait__NAME), syslib_sys_wait, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
#if !defined(__MINGW32__)
static SCM_DEFINE_STRING_CONST(KEYARG_nohang__NAME, "nohang", 6, 6);
static ScmObj KEYARG_nohang = SCM_UNBOUND;
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static SCM_DEFINE_STRING_CONST(KEYARG_untraced__NAME, "untraced", 8, 8);
static ScmObj KEYARG_untraced = SCM_UNBOUND;
#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_waitpid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pid_scm;
  int pid;
  ScmObj nohang_scm = SCM_FALSE;
  ScmObj nohang;
  ScmObj untraced_scm = SCM_FALSE;
  ScmObj untraced;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-waitpid");
  pid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(pid_scm)) Scm_Error("C integer required, but got %S", pid_scm);
  pid = Scm_GetInteger(pid_scm);
  if (Scm_Length(SCM_OPTARGS) % 2)
    Scm_Error("keyword list not even: %S", SCM_OPTARGS);
  while (!SCM_NULLP(SCM_OPTARGS)) {
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_nohang))) {
      nohang_scm = SCM_CADR(SCM_OPTARGS);
    } else 
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_untraced))) {
      untraced_scm = SCM_CADR(SCM_OPTARGS);
    }
    else Scm_Warn("unknown keyword %S", SCM_CAR(SCM_OPTARGS));
    SCM_OPTARGS = SCM_CDDR(SCM_OPTARGS);
  }
  nohang = (nohang_scm);
  untraced = (untraced_scm);
  {
int SCM_RESULT0;
int SCM_RESULT1;
{
  int status, options = 0;  pid_t r;
if (!SCM_FALSEP(nohang))   options |= WNOHANG;
if (!SCM_FALSEP(untraced)) options |= WUNTRACED;
SCM_SYSCALL(r, waitpid(pid, &status, options));
if (r < 0) Scm_SysError("waitpid() failed");
SCM_RESULT0 = r; SCM_RESULT1 = status;
}
SCM_RETURN(Scm_Values2(Scm_MakeInteger(SCM_RESULT0),Scm_MakeInteger(SCM_RESULT1)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_waitpid__NAME, "sys-waitpid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_waitpid__STUB, 1, 1, SCM_OBJ(&syslib_sys_waitpid__NAME), syslib_sys_waitpid, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_exitedP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-exited?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WIFEXITED(status);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_exitedP__NAME, "sys-wait-exited?", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_exitedP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_exitedP__NAME), syslib_sys_wait_exitedP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_exit_status(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-exit-status");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WEXITSTATUS(status);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_exit_status__NAME, "sys-wait-exit-status", 20, 20);
static SCM_DEFINE_SUBR(syslib_sys_wait_exit_status__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_exit_status__NAME), syslib_sys_wait_exit_status, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_signaledP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-signaled?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WIFSIGNALED(status);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_signaledP__NAME, "sys-wait-signaled?", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_wait_signaledP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_signaledP__NAME), syslib_sys_wait_signaledP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_termsig(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-termsig");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WTERMSIG(status);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_termsig__NAME, "sys-wait-termsig", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_termsig__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_termsig__NAME), syslib_sys_wait_termsig, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_stoppedP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-stopped?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WIFSTOPPED(status);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_stoppedP__NAME, "sys-wait-stopped?", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_wait_stoppedP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_stoppedP__NAME), syslib_sys_wait_stoppedP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_stopsig(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-stopsig");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = WSTOPSIG(status);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_stopsig__NAME, "sys-wait-stopsig", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_stopsig__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_stopsig__NAME), syslib_sys_wait_stopsig, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_time(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-time");
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_MakeSysTime(time(NULL)));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_time__NAME, "sys-time", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_time__STUB, 0, 0, SCM_OBJ(&syslib_sys_time__NAME), syslib_sys_time, NULL, NULL);

static ScmObj syslib_sys_gettimeofday(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-gettimeofday");
  {
u_long SCM_RESULT0;
u_long SCM_RESULT1;
{
Scm_GetTimeOfDay(&SCM_RESULT0, &SCM_RESULT1);
}
SCM_RETURN(Scm_Values2(Scm_MakeIntegerFromUI(SCM_RESULT0),Scm_MakeIntegerFromUI(SCM_RESULT1)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_gettimeofday__NAME, "sys-gettimeofday", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_gettimeofday__STUB, 0, 0, SCM_OBJ(&syslib_sys_gettimeofday__NAME), syslib_sys_gettimeofday, NULL, NULL);

static ScmObj syslib_current_time(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("current-time");
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_CurrentTime();
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_current_time__NAME, "current-time", 12, 12);
static SCM_DEFINE_SUBR(syslib_current_time__STUB, 0, 0, SCM_OBJ(&syslib_current_time__NAME), syslib_current_time, NULL, NULL);

static ScmObj syslib_timeP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj obj_scm;
  ScmObj obj;
  SCM_ENTER_SUBR("time?");
  obj_scm = SCM_ARGREF(0);
  obj = (obj_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = SCM_TIMEP(obj);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_timeP__NAME, "time?", 5, 5);
static SCM_DEFINE_SUBR(syslib_timeP__STUB, 1, 0, SCM_OBJ(&syslib_timeP__NAME), syslib_timeP, NULL, NULL);

static ScmObj syslib_time_TOseconds(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj t_scm;
  ScmTime* t;
  SCM_ENTER_SUBR("time->seconds");
  t_scm = SCM_ARGREF(0);
  if (!SCM_TIMEP(t_scm)) Scm_Error("<time> required, but got %S", t_scm);
  t = SCM_TIME(t_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_TimeToSeconds(t);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_time_TOseconds__NAME, "time->seconds", 13, 13);
static SCM_DEFINE_SUBR(syslib_time_TOseconds__STUB, 1, 0, SCM_OBJ(&syslib_time_TOseconds__NAME), syslib_time_TOseconds, NULL, NULL);

static ScmObj syslib_seconds_TOtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj t_scm;
  double t;
  SCM_ENTER_SUBR("seconds->time");
  t_scm = SCM_ARGREF(0);
  if (!SCM_REALP(t_scm)) Scm_Error("real number required, but got %S", t_scm);
  t = Scm_GetDouble(t_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_RealSecondsToTime(t);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_seconds_TOtime__NAME, "seconds->time", 13, 13);
static SCM_DEFINE_SUBR(syslib_seconds_TOtime__STUB, 1, 0, SCM_OBJ(&syslib_seconds_TOtime__NAME), syslib_seconds_TOtime, NULL, NULL);

static ScmObj syslib_sys_asctime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-asctime");
  tm_scm = SCM_ARGREF(0);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (SCM_MAKE_STR_COPYING(asctime(&SCM_SYS_TM_TM(tm))));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_asctime__NAME, "sys-asctime", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_asctime__STUB, 1, 0, SCM_OBJ(&syslib_sys_asctime__NAME), syslib_sys_asctime, NULL, NULL);

static ScmObj syslib_sys_ctime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-ctime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
{
const char * SCM_RESULT;
time_t tim = Scm_GetSysTime(time);
SCM_RESULT = ctime(&tim);
SCM_RETURN(SCM_MAKE_STR_COPYING(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ctime__NAME, "sys-ctime", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_ctime__STUB, 1, 0, SCM_OBJ(&syslib_sys_ctime__NAME), syslib_sys_ctime, NULL, NULL);

static ScmObj syslib_sys_difftime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time1_scm;
  ScmObj time1;
  ScmObj time0_scm;
  ScmObj time0;
  SCM_ENTER_SUBR("sys-difftime");
  time1_scm = SCM_ARGREF(0);
  time1 = (time1_scm);
  time0_scm = SCM_ARGREF(1);
  time0 = (time0_scm);
  {
{
double SCM_RESULT;
 SCM_RESULT = (difftime(Scm_GetSysTime(time1), Scm_GetSysTime(time0)));
SCM_RETURN(Scm_MakeFlonum(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_difftime__NAME, "sys-difftime", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_difftime__STUB, 2, 0, SCM_OBJ(&syslib_sys_difftime__NAME), syslib_sys_difftime, NULL, NULL);

static ScmObj syslib_sys_strftime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj format_scm;
  const char * format;
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-strftime");
  format_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(format_scm)) Scm_Error("const C string required, but got %S", format_scm);
  format = SCM_STRING_CONST_CSTRING(format_scm);
  tm_scm = SCM_ARGREF(1);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
{
const char * SCM_RESULT;
char tmpbuf[256];
strftime(tmpbuf, sizeof(tmpbuf), format, &SCM_SYS_TM_TM(tm));
SCM_RESULT = tmpbuf;
SCM_RETURN(SCM_MAKE_STR_COPYING(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_strftime__NAME, "sys-strftime", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_strftime__STUB, 2, 0, SCM_OBJ(&syslib_sys_strftime__NAME), syslib_sys_strftime, NULL, NULL);

static ScmObj syslib_sys_gmtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-gmtime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
{
ScmObj SCM_RESULT;
time_t tim = Scm_GetSysTime(time);
SCM_RESULT = Scm_MakeSysTm(gmtime(&tim));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_gmtime__NAME, "sys-gmtime", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_gmtime__STUB, 1, 0, SCM_OBJ(&syslib_sys_gmtime__NAME), syslib_sys_gmtime, NULL, NULL);

static ScmObj syslib_sys_localtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-localtime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
{
ScmObj SCM_RESULT;
time_t tim = Scm_GetSysTime(time);
SCM_RESULT = Scm_MakeSysTm(localtime(&tim));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_localtime__NAME, "sys-localtime", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_localtime__STUB, 1, 0, SCM_OBJ(&syslib_sys_localtime__NAME), syslib_sys_localtime, NULL, NULL);

static ScmObj syslib_sys_mktime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-mktime");
  tm_scm = SCM_ARGREF(0);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
{
ScmObj SCM_RESULT;
 SCM_RESULT = (Scm_MakeSysTime(mktime(&SCM_SYS_TM_TM(tm))));
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mktime__NAME, "sys-mktime", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_mktime__STUB, 1, 0, SCM_OBJ(&syslib_sys_mktime__NAME), syslib_sys_mktime, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_R_OK__VAR__NAME, "R_OK", 4, 4);
static ScmObj syslib_R_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_W_OK__VAR__NAME, "W_OK", 4, 4);
static ScmObj syslib_W_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_X_OK__VAR__NAME, "X_OK", 4, 4);
static ScmObj syslib_X_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_F_OK__VAR__NAME, "F_OK", 4, 4);
static ScmObj syslib_F_OK__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_access(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  ScmObj amode_scm;
  int amode;
  SCM_ENTER_SUBR("sys-access");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  amode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(amode_scm)) Scm_Error("C integer required, but got %S", amode_scm);
  amode = Scm_GetInteger(amode_scm);
  {
{
int SCM_RESULT;
int r;
if (Scm_IsSugid()) {
           Scm_Error("cannot use sys-access in suid/sgid program.");
}
SCM_SYSCALL(r, access(pathname, amode));
SCM_RESULT = (r == 0);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_access__NAME, "sys-access", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_access__STUB, 2, 0, SCM_OBJ(&syslib_sys_access__NAME), syslib_sys_access, NULL, NULL);

static ScmObj syslib_sys_chdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  SCM_ENTER_SUBR("sys-chdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, chdir(pathname));
if (r < 0) Scm_SysError("chdir failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_chdir__NAME, "sys-chdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_chdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_chdir__NAME), syslib_sys_chdir, NULL, NULL);

static ScmObj syslib_sys_chmod(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-chmod");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  mode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(mode_scm)) Scm_Error("C integer required, but got %S", mode_scm);
  mode = Scm_GetInteger(mode_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, chmod(pathname, mode));
if (r < 0) Scm_SysError("chmod failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_chmod__NAME, "sys-chmod", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_chmod__STUB, 2, 0, SCM_OBJ(&syslib_sys_chmod__NAME), syslib_sys_chmod, NULL, NULL);

#if !defined(__MINGW32__)
static ScmObj syslib_sys_fchmod(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-fchmod");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  mode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(mode_scm)) Scm_Error("C integer required, but got %S", mode_scm);
  mode = Scm_GetInteger(mode_scm);
  {
{
ScmObj SCM_RESULT;
int fd = Scm_GetPortFd(port_or_fd, TRUE), r;
SCM_SYSCALL(r, fchmod(fd, mode));
if (r < 0) Scm_SysError("fchmod failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fchmod__NAME, "sys-fchmod", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_fchmod__STUB, 2, 0, SCM_OBJ(&syslib_sys_fchmod__NAME), syslib_sys_fchmod, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_fork(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-fork");
  {
{
int SCM_RESULT;
pid_t pid;
GC_gcollect();
SCM_SYSCALL(pid, fork());
if (pid < 0) Scm_SysError("fork failed");
SCM_RESULT = pid;
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fork__NAME, "sys-fork", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_fork__STUB, 0, 0, SCM_OBJ(&syslib_sys_fork__NAME), syslib_sys_fork, NULL, NULL);

static SCM_DEFINE_STRING_CONST(key_iomap__NAME, "iomap", 5, 5);
static ScmObj key_iomap = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(key_sigmask__NAME, "sigmask", 7, 7);
static ScmObj key_sigmask = SCM_UNBOUND;
static void get_exec_args(ScmObj rest, ScmObj *iomap, ScmSysSigset **sigmask)
{
  ScmObj s_sigmask = SCM_NIL;
  *iomap = SCM_NIL; *sigmask = NULL;
  if (SCM_PAIRP(rest) && SCM_NULLP(SCM_CDR(rest))) {
    /* OLD SIGNATURE */
    *iomap = SCM_CAR(rest);
  } else {
    *iomap = Scm_GetKeyword(key_iomap, rest, SCM_NIL);
    s_sigmask = Scm_GetKeyword(key_sigmask, rest, SCM_FALSE);
    if (SCM_SYS_SIGSET_P(s_sigmask)) {
      *sigmask = SCM_SYS_SIGSET(s_sigmask);
    } else if (!SCM_FALSEP(s_sigmask)) {
      Scm_Error("<sys-sigset> or #f required, but got %S", s_sigmask);
    }
  }
}
static ScmObj syslib_sys_exec(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  ScmString* command;
  ScmObj args_scm;
  ScmObj args;
  ScmObj rest_scm;
  ScmObj rest;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-exec");
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("string required, but got %S", command_scm);
  command = SCM_STRING(command_scm);
  args_scm = SCM_ARGREF(1);
  if (!SCM_LISTP(args_scm)) Scm_Error("list required, but got %S", args_scm);
  args = (args_scm);
  rest_scm = SCM_OPTARGS;
  rest = (rest_scm);
  {
ScmObj iomap = SCM_NIL;
ScmSysSigset *sigmask = NULL;
get_exec_args(rest, &iomap, &sigmask);
Scm_SysExec(command, args, iomap, sigmask, 0);
SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_exec__NAME, "sys-exec", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_exec__STUB, 2, 1, SCM_OBJ(&syslib_sys_exec__NAME), syslib_sys_exec, NULL, NULL);

static ScmObj syslib_sys_fork_and_exec(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  ScmString* command;
  ScmObj args_scm;
  ScmObj args;
  ScmObj rest_scm;
  ScmObj rest;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-fork-and-exec");
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("string required, but got %S", command_scm);
  command = SCM_STRING(command_scm);
  args_scm = SCM_ARGREF(1);
  if (!SCM_LISTP(args_scm)) Scm_Error("list required, but got %S", args_scm);
  args = (args_scm);
  rest_scm = SCM_OPTARGS;
  rest = (rest_scm);
  {
{
ScmObj SCM_RESULT;
ScmObj iomap = SCM_NIL;
ScmSysSigset *sigmask = NULL;
get_exec_args(rest, &iomap, &sigmask);
SCM_RESULT = Scm_SysExec(command, args, iomap, sigmask, SCM_EXEC_WITH_FORK);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fork_and_exec__NAME, "sys-fork-and-exec", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_fork_and_exec__STUB, 2, 1, SCM_OBJ(&syslib_sys_fork_and_exec__NAME), syslib_sys_fork_and_exec, NULL, NULL);

static ScmObj syslib_sys_getcwd(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getcwd");
  {
{
const char * SCM_RESULT;
#define GETCWD_PATH_MAX 1024  /* TODO: needs to be configured */
char p[GETCWD_PATH_MAX];
if (getcwd(p, GETCWD_PATH_MAX-1) == NULL) {
  Scm_SysError("getcwd failed");
}
SCM_RESULT = p;
SCM_RETURN(SCM_MAKE_STR_COPYING(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getcwd__NAME, "sys-getcwd", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getcwd__STUB, 0, 0, SCM_OBJ(&syslib_sys_getcwd__NAME), syslib_sys_getcwd, NULL, NULL);

static ScmObj syslib_sys_getegid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getegid");
  {
{
int SCM_RESULT;
SCM_RESULT = getegid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getegid__NAME, "sys-getegid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_getegid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getegid__NAME), syslib_sys_getegid, NULL, NULL);

static ScmObj syslib_sys_getgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getgid");
  {
{
int SCM_RESULT;
SCM_RESULT = getgid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgid__NAME, "sys-getgid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getgid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getgid__NAME), syslib_sys_getgid, NULL, NULL);

static ScmObj syslib_sys_geteuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-geteuid");
  {
{
int SCM_RESULT;
SCM_RESULT = geteuid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_geteuid__NAME, "sys-geteuid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_geteuid__STUB, 0, 0, SCM_OBJ(&syslib_sys_geteuid__NAME), syslib_sys_geteuid, NULL, NULL);

static ScmObj syslib_sys_getuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getuid");
  {
{
int SCM_RESULT;
SCM_RESULT = getuid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getuid__NAME, "sys-getuid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getuid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getuid__NAME), syslib_sys_getuid, NULL, NULL);

static ScmObj syslib_sys_getpid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getpid");
  {
{
int SCM_RESULT;
SCM_RESULT = getpid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpid__NAME, "sys-getpid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getpid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getpid__NAME), syslib_sys_getpid, NULL, NULL);

static ScmObj syslib_sys_getppid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getppid");
  {
{
int SCM_RESULT;
SCM_RESULT = getppid();
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getppid__NAME, "sys-getppid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_getppid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getppid__NAME), syslib_sys_getppid, NULL, NULL);

static ScmObj syslib_sys_link(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj existing_scm;
  const char * existing;
  ScmObj newpath_scm;
  const char * newpath;
  SCM_ENTER_SUBR("sys-link");
  existing_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(existing_scm)) Scm_Error("const C string required, but got %S", existing_scm);
  existing = SCM_STRING_CONST_CSTRING(existing_scm);
  newpath_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(newpath_scm)) Scm_Error("const C string required, but got %S", newpath_scm);
  newpath = SCM_STRING_CONST_CSTRING(newpath_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, link(existing, newpath));
if (r < 0) Scm_SysError("link failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_link__NAME, "sys-link", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_link__STUB, 2, 0, SCM_OBJ(&syslib_sys_link__NAME), syslib_sys_link, NULL, NULL);

static ScmObj syslib_sys_pause(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-pause");
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_Pause();
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_pause__NAME, "sys-pause", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_pause__STUB, 0, 0, SCM_OBJ(&syslib_sys_pause__NAME), syslib_sys_pause, NULL, NULL);

static ScmObj syslib_sys_alarm(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seconds_scm;
  int seconds;
  SCM_ENTER_SUBR("sys-alarm");
  seconds_scm = SCM_ARGREF(0);
  if (!SCM_INTP(seconds_scm)) Scm_Error("small integer required, but got %S", seconds_scm);
  seconds = SCM_INT_VALUE(seconds_scm);
  {
{
int SCM_RESULT;
SCM_SYSCALL(SCM_RESULT, alarm(seconds));
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_alarm__NAME, "sys-alarm", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_alarm__STUB, 1, 0, SCM_OBJ(&syslib_sys_alarm__NAME), syslib_sys_alarm, NULL, NULL);

static SCM_DEFINE_STRING_CONST(KEYARG_name__NAME, "name", 4, 4);
static ScmObj KEYARG_name = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_buffering__NAME, "buffering", 9, 9);
static ScmObj KEYARG_buffering = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_bufferedP__NAME, "buffered?", 9, 9);
static ScmObj KEYARG_bufferedP = SCM_UNBOUND;
static ScmObj syslib_sys_pipe(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm = SCM_MAKE_STR("(pipe)");
  ScmObj name;
  ScmObj buffering_scm = SCM_FALSE;
  ScmObj buffering;
  ScmObj bufferedP_scm = SCM_FALSE;
  ScmObj bufferedP;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-pipe");
  if (Scm_Length(SCM_OPTARGS) % 2)
    Scm_Error("keyword list not even: %S", SCM_OPTARGS);
  while (!SCM_NULLP(SCM_OPTARGS)) {
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_name))) {
      name_scm = SCM_CADR(SCM_OPTARGS);
    } else 
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_buffering))) {
      buffering_scm = SCM_CADR(SCM_OPTARGS);
    } else 
    if (SCM_EQ(SCM_CAR(SCM_OPTARGS), SCM_OBJ(KEYARG_bufferedP))) {
      bufferedP_scm = SCM_CADR(SCM_OPTARGS);
    }
    else Scm_Warn("unknown keyword %S", SCM_CAR(SCM_OPTARGS));
    SCM_OPTARGS = SCM_CDDR(SCM_OPTARGS);
  }
  name = (name_scm);
  buffering = (buffering_scm);
  bufferedP = (bufferedP_scm);
  {
ScmObj SCM_RESULT0;
ScmObj SCM_RESULT1;
{
int fds[2], r, bufmode;
SCM_SYSCALL(r, pipe(fds));
if (r < 0) Scm_SysError("pipe failed");
if (SCM_TRUEP(bufferedP)) {
  bufmode = SCM_PORT_BUFFER_FULL; /* for backward compatibility */
} else {
  bufmode = Scm_BufferingMode(buffering, -1, SCM_PORT_BUFFER_LINE);
}
SCM_RESULT0 = Scm_MakePortWithFd(name, SCM_PORT_INPUT, fds[0], bufmode, TRUE);
SCM_RESULT1 = Scm_MakePortWithFd(name, SCM_PORT_OUTPUT, fds[1], bufmode, TRUE);
}
SCM_RETURN(Scm_Values2(SCM_OBJ_SAFE(SCM_RESULT0),SCM_OBJ_SAFE(SCM_RESULT1)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_pipe__NAME, "sys-pipe", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_pipe__STUB, 0, 1, SCM_OBJ(&syslib_sys_pipe__NAME), syslib_sys_pipe, NULL, NULL);

static ScmObj syslib_sys_close(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fd_scm;
  int fd;
  SCM_ENTER_SUBR("sys-close");
  fd_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(fd_scm)) Scm_Error("C integer required, but got %S", fd_scm);
  fd = Scm_GetInteger(fd_scm);
  {
{
ScmObj SCM_RESULT;
int r;
SCM_SYSCALL(r, close(fd));
if (r < 0) Scm_SysError("close failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_close__NAME, "sys-close", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_close__STUB, 1, 0, SCM_OBJ(&syslib_sys_close__NAME), syslib_sys_close, NULL, NULL);

static ScmObj syslib_sys_mkdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-mkdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  mode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(mode_scm)) Scm_Error("C integer required, but got %S", mode_scm);
  mode = Scm_GetInteger(mode_scm);
  {
{
ScmObj SCM_RESULT;
int r;
#ifndef __MINGW32__
SCM_SYSCALL(r, mkdir(pathname, mode));
#else
SCM_SYSCALL(r, mkdir(pathname));
#endif /*__MINGW32__*/
if (r < 0) Scm_SysError("mkdir failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mkdir__NAME, "sys-mkdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_mkdir__STUB, 2, 0, SCM_OBJ(&syslib_sys_mkdir__NAME), syslib_sys_mkdir, NULL, NULL);

static ScmObj syslib_sys_rmdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  SCM_ENTER_SUBR("sys-rmdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, rmdir(pathname));
if (r < 0) Scm_SysError("rmdir failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_rmdir__NAME, "sys-rmdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_rmdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_rmdir__NAME), syslib_sys_rmdir, NULL, NULL);

static ScmObj syslib_sys_umask(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-umask");
  mode_scm = SCM_ARGREF(0);
  if (!SCM_INTP(mode_scm)) Scm_Error("small integer required, but got %S", mode_scm);
  mode = SCM_INT_VALUE(mode_scm);
  {
{
int SCM_RESULT;
SCM_RESULT = umask(mode);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_umask__NAME, "sys-umask", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_umask__STUB, 1, 0, SCM_OBJ(&syslib_sys_umask__NAME), syslib_sys_umask, NULL, NULL);

static ScmObj syslib_sys_sleep(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seconds_scm;
  int seconds;
  SCM_ENTER_SUBR("sys-sleep");
  seconds_scm = SCM_ARGREF(0);
  if (!SCM_INTP(seconds_scm)) Scm_Error("small integer required, but got %S", seconds_scm);
  seconds = SCM_INT_VALUE(seconds_scm);
  {
{
int SCM_RESULT;
#if defined(__MINGW32__)
  Sleep(seconds*1000); SCM_RESULT=0;
#else
  SCM_RESULT = sleep(seconds);
#endif
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sleep__NAME, "sys-sleep", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_sleep__STUB, 1, 0, SCM_OBJ(&syslib_sys_sleep__NAME), syslib_sys_sleep, NULL, NULL);

#if defined(HAVE_NANOSLEEP)
static ScmObj syslib_sys_nanosleep(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj nanoseconds_scm;
  ScmObj nanoseconds;
  SCM_ENTER_SUBR("sys-nanosleep");
  nanoseconds_scm = SCM_ARGREF(0);
  nanoseconds = (nanoseconds_scm);
  {
struct timespec spec, rem;
       if (SCM_TIMEP(nanoseconds)) {
           spec.tv_sec = SCM_TIME(nanoseconds)->sec;
           spec.tv_nsec = SCM_TIME(nanoseconds)->nsec;
       } else if (!SCM_REALP(nanoseconds)) {
           Scm_Error("bad timeout spec: <time> object or real number is required, but got %S", nanoseconds);
       } else {
           double v = Scm_GetDouble(nanoseconds);
           if (v < 0) Scm_Error("bad timeout spec: positive number required, but got %S", nanoseconds);
           spec.tv_sec = (unsigned long)floor(v/1.0e9);
           spec.tv_nsec = (unsigned long)fmod(v, 1.0e9);
           while (spec.tv_nsec >= 1000000000) {
               spec.tv_nsec -= 1000000000;
               spec.tv_sec += 1;
           }
       }
       rem.tv_sec = rem.tv_nsec = 0;
       nanosleep(&spec, &rem);
       if (rem.tv_sec == 0 && rem.tv_nsec == 0) SCM_RETURN(SCM_FALSE);
       else SCM_RETURN(Scm_MakeTime(SCM_FALSE, rem.tv_sec, rem.tv_nsec));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_nanosleep__NAME, "sys-nanosleep", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_nanosleep__STUB, 1, 0, SCM_OBJ(&syslib_sys_nanosleep__NAME), syslib_sys_nanosleep, NULL, NULL);

#endif /*defined(HAVE_NANOSLEEP)*/
static ScmObj syslib_sys_unlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  const char * pathname;
  SCM_ENTER_SUBR("sys-unlink");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("const C string required, but got %S", pathname_scm);
  pathname = SCM_STRING_CONST_CSTRING(pathname_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, unlink(pathname));
if (r < 0) {
  if (errno == ENOENT) { SCM_RETURN(SCM_FALSE); }
  else Scm_SysError("unlink failed");
}
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_unlink__NAME, "sys-unlink", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_unlink__STUB, 1, 0, SCM_OBJ(&syslib_sys_unlink__NAME), syslib_sys_unlink, NULL, NULL);

static ScmObj syslib_sys_isatty(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-isatty");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
{
int SCM_RESULT;
int fd = Scm_GetPortFd(port_or_fd, FALSE);
SCM_RESULT = (fd >= 0 && isatty(fd));
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_isatty__NAME, "sys-isatty", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_isatty__STUB, 1, 0, SCM_OBJ(&syslib_sys_isatty__NAME), syslib_sys_isatty, NULL, NULL);

static ScmObj syslib_sys_ttyname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-ttyname");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
{
const char * SCM_RESULT;
int fd = Scm_GetPortFd(port_or_fd, FALSE);
if (fd < 0) SCM_RESULT = NULL;
else SCM_RESULT = ttyname(fd);
SCM_RETURN(SCM_MAKE_MAYBE(SCM_MAKE_STR_COPYING, SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ttyname__NAME, "sys-ttyname", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_ttyname__STUB, 1, 0, SCM_OBJ(&syslib_sys_ttyname__NAME), syslib_sys_ttyname, NULL, NULL);

static ScmObj syslib_sys_truncate(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  const char * path;
  ScmObj length_scm;
  ScmObj length;
  SCM_ENTER_SUBR("sys-truncate");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("const C string required, but got %S", path_scm);
  path = SCM_STRING_CONST_CSTRING(path_scm);
  length_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(length_scm)) Scm_Error("exact integer required, but got %S", length_scm);
  length = (length_scm);
  {
{
ScmObj SCM_RESULT;
int r; SCM_SYSCALL(r, truncate(path, Scm_IntegerToOffset(length)));
if (r < 0) Scm_SysError("truncate failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_truncate__NAME, "sys-truncate", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_truncate__STUB, 2, 0, SCM_OBJ(&syslib_sys_truncate__NAME), syslib_sys_truncate, NULL, NULL);

static ScmObj syslib_sys_ftruncate(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  ScmObj length_scm;
  ScmObj length;
  SCM_ENTER_SUBR("sys-ftruncate");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  length_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(length_scm)) Scm_Error("exact integer required, but got %S", length_scm);
  length = (length_scm);
  {
{
ScmObj SCM_RESULT;
int r; int fd = Scm_GetPortFd(port_or_fd, TRUE);
SCM_SYSCALL(r, ftruncate(fd, Scm_IntegerToOffset(length)));
if (r < 0) Scm_SysError("ftruncate failed");
SCM_RESULT = SCM_TRUE;
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ftruncate__NAME, "sys-ftruncate", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_ftruncate__STUB, 2, 0, SCM_OBJ(&syslib_sys_ftruncate__NAME), syslib_sys_ftruncate, NULL, NULL);

#if defined(HAVE_CRYPT)
static ScmObj syslib_sys_crypt(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj key_scm;
  const char * key;
  ScmObj salt_scm;
  const char * salt;
  SCM_ENTER_SUBR("sys-crypt");
  key_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(key_scm)) Scm_Error("const C string required, but got %S", key_scm);
  key = SCM_STRING_CONST_CSTRING(key_scm);
  salt_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(salt_scm)) Scm_Error("const C string required, but got %S", salt_scm);
  salt = SCM_STRING_CONST_CSTRING(salt_scm);
  {
{
const char * SCM_RESULT;
 SCM_RESULT = ((const char *)crypt(key, salt));
SCM_RETURN(SCM_MAKE_STR_COPYING(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_crypt__NAME, "sys-crypt", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_crypt__STUB, 2, 0, SCM_OBJ(&syslib_sys_crypt__NAME), syslib_sys_crypt, NULL, NULL);

#endif /*defined(HAVE_CRYPT)*/
#if defined(HAVE_SYMLINK)
static ScmObj syslib_sys_symlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj existing_scm;
  const char * existing;
  ScmObj newpath_scm;
  const char * newpath;
  SCM_ENTER_SUBR("sys-symlink");
  existing_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(existing_scm)) Scm_Error("const C string required, but got %S", existing_scm);
  existing = SCM_STRING_CONST_CSTRING(existing_scm);
  newpath_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(newpath_scm)) Scm_Error("const C string required, but got %S", newpath_scm);
  newpath = SCM_STRING_CONST_CSTRING(newpath_scm);
  {
{
ScmObj SCM_RESULT;
int r;
SCM_SYSCALL(r, symlink(existing, newpath));
if (r < 0) Scm_SysError("link failed");
SCM_RETURN(SCM_TRUE);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_symlink__NAME, "sys-symlink", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_symlink__STUB, 2, 0, SCM_OBJ(&syslib_sys_symlink__NAME), syslib_sys_symlink, NULL, NULL);

#endif /*defined(HAVE_SYMLINK)*/
#if defined(HAVE_READLINK)
static ScmObj syslib_sys_readlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  const char * path;
  SCM_ENTER_SUBR("sys-readlink");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("const C string required, but got %S", path_scm);
  path = SCM_STRING_CONST_CSTRING(path_scm);
  {
#define READLINK_PATH_MAX 1024  /* TODO: needs to be configured */
  char buf[READLINK_PATH_MAX];
  int n;
  SCM_SYSCALL(n, readlink(path, buf, READLINK_PATH_MAX));
  if (n < 0) Scm_SysError("readlink failed");
  if (n == READLINK_PATH_MAX) Scm_Error("readlink result too long");
  return Scm_MakeString(buf, n, -1, SCM_STRING_COPYING);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_readlink__NAME, "sys-readlink", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_readlink__STUB, 1, 0, SCM_OBJ(&syslib_sys_readlink__NAME), syslib_sys_readlink, NULL, NULL);

#endif /*defined(HAVE_READLINK)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_ref(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  ScmObj pf_scm;
  ScmObj pf;
  SCM_ENTER_SUBR("sys-fdset-ref");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  pf_scm = SCM_ARGREF(1);
  pf = (pf_scm);
  {
{
int SCM_RESULT;
int fd = Scm_GetPortFd(pf, FALSE);
if (fd < 0) SCM_RESULT = TRUE;
else SCM_RESULT = FD_ISSET(fd, &fdset->fdset);
SCM_RETURN(SCM_MAKE_BOOL(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_ref__NAME, "sys-fdset-ref", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_fdset_ref__STUB, 2, 0, SCM_OBJ(&syslib_sys_fdset_ref__NAME), syslib_sys_fdset_ref, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_setX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  ScmObj pf_scm;
  ScmObj pf;
  ScmObj flag_scm;
  int flag;
  SCM_ENTER_SUBR("sys-fdset-set!");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  pf_scm = SCM_ARGREF(1);
  pf = (pf_scm);
  flag_scm = SCM_ARGREF(2);
  if (!SCM_BOOLP(flag_scm)) Scm_Error("boolean required, but got %S", flag_scm);
  flag = SCM_BOOL_VALUE(flag_scm);
  {
int fd = Scm_GetPortFd(pf, FALSE);
  if (fd >= 0) {
    if (flag) {
      FD_SET(fd, &fdset->fdset);
      if (fdset->maxfd < fd) fdset->maxfd = fd;
    } else {
      FD_CLR(fd, &fdset->fdset);
      if (fdset->maxfd == fd) {
        int i;
        for (i=fdset->maxfd-1; i>=0; i--) {
          if (FD_ISSET(i, &fdset->fdset)) break;
        }
        fdset->maxfd = i;
      }
    }
  }
  SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_setX__NAME, "sys-fdset-set!", 14, 14);
static SCM_DEFINE_SUBR(syslib_sys_fdset_setX__STUB, 3, 0, SCM_OBJ(&syslib_sys_fdset_setX__NAME), syslib_sys_fdset_setX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_max_fd(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  SCM_ENTER_SUBR("sys-fdset-max-fd");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  {
{
int SCM_RESULT;
 SCM_RESULT = (fdset->maxfd);
SCM_RETURN(Scm_MakeInteger(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_max_fd__NAME, "sys-fdset-max-fd", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_fdset_max_fd__STUB, 1, 0, SCM_OBJ(&syslib_sys_fdset_max_fd__NAME), syslib_sys_fdset_max_fd, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_clearX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  SCM_ENTER_SUBR("sys-fdset-clear!");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  {
{
ScmObj SCM_RESULT;
FD_ZERO(&fdset->fdset);
fdset->maxfd = -1;
SCM_RESULT = SCM_OBJ(fdset);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_clearX__NAME, "sys-fdset-clear!", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_fdset_clearX__STUB, 1, 0, SCM_OBJ(&syslib_sys_fdset_clearX__NAME), syslib_sys_fdset_clearX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_copyX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj dst_scm;
  ScmSysFdset* dst;
  ScmObj src_scm;
  ScmSysFdset* src;
  SCM_ENTER_SUBR("sys-fdset-copy!");
  dst_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(dst_scm)) Scm_Error("<sys-fdset> required, but got %S", dst_scm);
  dst = SCM_SYS_FDSET(dst_scm);
  src_scm = SCM_ARGREF(1);
  if (!SCM_SYS_FDSET_P(src_scm)) Scm_Error("<sys-fdset> required, but got %S", src_scm);
  src = SCM_SYS_FDSET(src_scm);
  {
{
ScmObj SCM_RESULT;
dst->fdset = src->fdset;
dst->maxfd = src->maxfd;
SCM_RESULT = SCM_OBJ(dst);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_copyX__NAME, "sys-fdset-copy!", 15, 15);
static SCM_DEFINE_SUBR(syslib_sys_fdset_copyX__STUB, 2, 0, SCM_OBJ(&syslib_sys_fdset_copyX__NAME), syslib_sys_fdset_copyX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_select(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj rfds_scm;
  ScmObj rfds;
  ScmObj wfds_scm;
  ScmObj wfds;
  ScmObj efds_scm;
  ScmObj efds;
  ScmObj timeout_scm;
  ScmObj timeout;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-select");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 4 is expected, %d given.", Scm_Length(SCM_OPTARGS)+3);
  rfds_scm = SCM_ARGREF(0);
  rfds = (rfds_scm);
  wfds_scm = SCM_ARGREF(1);
  wfds = (wfds_scm);
  efds_scm = SCM_ARGREF(2);
  efds = (efds_scm);
  if (SCM_NULLP(SCM_OPTARGS)) timeout_scm = SCM_FALSE;
  else {
    timeout_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  timeout = (timeout_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SysSelect(rfds, wfds, efds, timeout);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_select__NAME, "sys-select", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_select__STUB, 3, 1, SCM_OBJ(&syslib_sys_select__NAME), syslib_sys_select, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_selectX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj rfds_scm;
  ScmObj rfds;
  ScmObj wfds_scm;
  ScmObj wfds;
  ScmObj efds_scm;
  ScmObj efds;
  ScmObj timeout_scm;
  ScmObj timeout;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-select!");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 4 is expected, %d given.", Scm_Length(SCM_OPTARGS)+3);
  rfds_scm = SCM_ARGREF(0);
  rfds = (rfds_scm);
  wfds_scm = SCM_ARGREF(1);
  wfds = (wfds_scm);
  efds_scm = SCM_ARGREF(2);
  efds = (efds_scm);
  if (SCM_NULLP(SCM_OPTARGS)) timeout_scm = SCM_FALSE;
  else {
    timeout_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  timeout = (timeout_scm);
  {
{
ScmObj SCM_RESULT;
SCM_RESULT = Scm_SysSelectX(rfds, wfds, efds, timeout);
SCM_RETURN(SCM_OBJ_SAFE(SCM_RESULT));
}
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_selectX__NAME, "sys-select!", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_selectX__STUB, 3, 1, SCM_OBJ(&syslib_sys_selectX__NAME), syslib_sys_selectX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
void Scm_Init_syslib(ScmModule *module)
{

  SCM_DEFINE(module, "sys-readdir", SCM_OBJ(&syslib_sys_readdir__STUB));
  SCM_DEFINE(module, "sys-glob", SCM_OBJ(&syslib_sys_glob__STUB));
  SCM_DEFINE(module, "sys-normalize-pathname", SCM_OBJ(&syslib_sys_normalize_pathname__STUB));
  KEYARG_absolute = Scm_MakeKeyword(&KEYARG_absolute__NAME);
  KEYARG_expand = Scm_MakeKeyword(&KEYARG_expand__NAME);
  KEYARG_canonicalize = Scm_MakeKeyword(&KEYARG_canonicalize__NAME);
  SCM_DEFINE(module, "sys-basename", SCM_OBJ(&syslib_sys_basename__STUB));
  SCM_DEFINE(module, "sys-dirname", SCM_OBJ(&syslib_sys_dirname__STUB));
#if defined(E2BIG)
  syslib_E2BIG__VAR = Scm_Intern(&syslib_E2BIG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_E2BIG__VAR)), SCM_OBJ(Scm_MakeInteger(E2BIG)));
#endif /* defined(E2BIG) */
#if defined(EACCES)
  syslib_EACCES__VAR = Scm_Intern(&syslib_EACCES__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EACCES__VAR)), SCM_OBJ(Scm_MakeInteger(EACCES)));
#endif /* defined(EACCES) */
#if defined(EADDRINUSE)
  syslib_EADDRINUSE__VAR = Scm_Intern(&syslib_EADDRINUSE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EADDRINUSE__VAR)), SCM_OBJ(Scm_MakeInteger(EADDRINUSE)));
#endif /* defined(EADDRINUSE) */
#if defined(EADDRNOTAVAIL)
  syslib_EADDRNOTAVAIL__VAR = Scm_Intern(&syslib_EADDRNOTAVAIL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EADDRNOTAVAIL__VAR)), SCM_OBJ(Scm_MakeInteger(EADDRNOTAVAIL)));
#endif /* defined(EADDRNOTAVAIL) */
#if defined(EADV)
  syslib_EADV__VAR = Scm_Intern(&syslib_EADV__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EADV__VAR)), SCM_OBJ(Scm_MakeInteger(EADV)));
#endif /* defined(EADV) */
#if defined(EAFNOSUPPORT)
  syslib_EAFNOSUPPORT__VAR = Scm_Intern(&syslib_EAFNOSUPPORT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EAFNOSUPPORT__VAR)), SCM_OBJ(Scm_MakeInteger(EAFNOSUPPORT)));
#endif /* defined(EAFNOSUPPORT) */
#if defined(EAGAIN)
  syslib_EAGAIN__VAR = Scm_Intern(&syslib_EAGAIN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EAGAIN__VAR)), SCM_OBJ(Scm_MakeInteger(EAGAIN)));
#endif /* defined(EAGAIN) */
#if defined(EALREADY)
  syslib_EALREADY__VAR = Scm_Intern(&syslib_EALREADY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EALREADY__VAR)), SCM_OBJ(Scm_MakeInteger(EALREADY)));
#endif /* defined(EALREADY) */
#if defined(EBADE)
  syslib_EBADE__VAR = Scm_Intern(&syslib_EBADE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADE__VAR)), SCM_OBJ(Scm_MakeInteger(EBADE)));
#endif /* defined(EBADE) */
#if defined(EBADF)
  syslib_EBADF__VAR = Scm_Intern(&syslib_EBADF__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADF__VAR)), SCM_OBJ(Scm_MakeInteger(EBADF)));
#endif /* defined(EBADF) */
#if defined(EBADFD)
  syslib_EBADFD__VAR = Scm_Intern(&syslib_EBADFD__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADFD__VAR)), SCM_OBJ(Scm_MakeInteger(EBADFD)));
#endif /* defined(EBADFD) */
#if defined(EBADMSG)
  syslib_EBADMSG__VAR = Scm_Intern(&syslib_EBADMSG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADMSG__VAR)), SCM_OBJ(Scm_MakeInteger(EBADMSG)));
#endif /* defined(EBADMSG) */
#if defined(EBADR)
  syslib_EBADR__VAR = Scm_Intern(&syslib_EBADR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADR__VAR)), SCM_OBJ(Scm_MakeInteger(EBADR)));
#endif /* defined(EBADR) */
#if defined(EBADRQC)
  syslib_EBADRQC__VAR = Scm_Intern(&syslib_EBADRQC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADRQC__VAR)), SCM_OBJ(Scm_MakeInteger(EBADRQC)));
#endif /* defined(EBADRQC) */
#if defined(EBADSLT)
  syslib_EBADSLT__VAR = Scm_Intern(&syslib_EBADSLT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBADSLT__VAR)), SCM_OBJ(Scm_MakeInteger(EBADSLT)));
#endif /* defined(EBADSLT) */
#if defined(EBFONT)
  syslib_EBFONT__VAR = Scm_Intern(&syslib_EBFONT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBFONT__VAR)), SCM_OBJ(Scm_MakeInteger(EBFONT)));
#endif /* defined(EBFONT) */
#if defined(EBUSY)
  syslib_EBUSY__VAR = Scm_Intern(&syslib_EBUSY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EBUSY__VAR)), SCM_OBJ(Scm_MakeInteger(EBUSY)));
#endif /* defined(EBUSY) */
#if defined(ECANCELED)
  syslib_ECANCELED__VAR = Scm_Intern(&syslib_ECANCELED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECANCELED__VAR)), SCM_OBJ(Scm_MakeInteger(ECANCELED)));
#endif /* defined(ECANCELED) */
#if defined(ECHILD)
  syslib_ECHILD__VAR = Scm_Intern(&syslib_ECHILD__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECHILD__VAR)), SCM_OBJ(Scm_MakeInteger(ECHILD)));
#endif /* defined(ECHILD) */
#if defined(ECHRNG)
  syslib_ECHRNG__VAR = Scm_Intern(&syslib_ECHRNG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECHRNG__VAR)), SCM_OBJ(Scm_MakeInteger(ECHRNG)));
#endif /* defined(ECHRNG) */
#if defined(ECOMM)
  syslib_ECOMM__VAR = Scm_Intern(&syslib_ECOMM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECOMM__VAR)), SCM_OBJ(Scm_MakeInteger(ECOMM)));
#endif /* defined(ECOMM) */
#if defined(ECONNABORTED)
  syslib_ECONNABORTED__VAR = Scm_Intern(&syslib_ECONNABORTED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECONNABORTED__VAR)), SCM_OBJ(Scm_MakeInteger(ECONNABORTED)));
#endif /* defined(ECONNABORTED) */
#if defined(ECONNREFUSED)
  syslib_ECONNREFUSED__VAR = Scm_Intern(&syslib_ECONNREFUSED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECONNREFUSED__VAR)), SCM_OBJ(Scm_MakeInteger(ECONNREFUSED)));
#endif /* defined(ECONNREFUSED) */
#if defined(ECONNRESET)
  syslib_ECONNRESET__VAR = Scm_Intern(&syslib_ECONNRESET__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ECONNRESET__VAR)), SCM_OBJ(Scm_MakeInteger(ECONNRESET)));
#endif /* defined(ECONNRESET) */
#if defined(EDEADLK)
  syslib_EDEADLK__VAR = Scm_Intern(&syslib_EDEADLK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDEADLK__VAR)), SCM_OBJ(Scm_MakeInteger(EDEADLK)));
#endif /* defined(EDEADLK) */
#if defined(EDEADLOCK)
  syslib_EDEADLOCK__VAR = Scm_Intern(&syslib_EDEADLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDEADLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(EDEADLOCK)));
#endif /* defined(EDEADLOCK) */
#if defined(EDESTADDRREQ)
  syslib_EDESTADDRREQ__VAR = Scm_Intern(&syslib_EDESTADDRREQ__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDESTADDRREQ__VAR)), SCM_OBJ(Scm_MakeInteger(EDESTADDRREQ)));
#endif /* defined(EDESTADDRREQ) */
#if defined(EDOM)
  syslib_EDOM__VAR = Scm_Intern(&syslib_EDOM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDOM__VAR)), SCM_OBJ(Scm_MakeInteger(EDOM)));
#endif /* defined(EDOM) */
#if defined(EDOTDOT)
  syslib_EDOTDOT__VAR = Scm_Intern(&syslib_EDOTDOT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDOTDOT__VAR)), SCM_OBJ(Scm_MakeInteger(EDOTDOT)));
#endif /* defined(EDOTDOT) */
#if defined(EDQUOT)
  syslib_EDQUOT__VAR = Scm_Intern(&syslib_EDQUOT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EDQUOT__VAR)), SCM_OBJ(Scm_MakeInteger(EDQUOT)));
#endif /* defined(EDQUOT) */
#if defined(EEXIST)
  syslib_EEXIST__VAR = Scm_Intern(&syslib_EEXIST__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EEXIST__VAR)), SCM_OBJ(Scm_MakeInteger(EEXIST)));
#endif /* defined(EEXIST) */
#if defined(EFAULT)
  syslib_EFAULT__VAR = Scm_Intern(&syslib_EFAULT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EFAULT__VAR)), SCM_OBJ(Scm_MakeInteger(EFAULT)));
#endif /* defined(EFAULT) */
#if defined(EFBIG)
  syslib_EFBIG__VAR = Scm_Intern(&syslib_EFBIG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EFBIG__VAR)), SCM_OBJ(Scm_MakeInteger(EFBIG)));
#endif /* defined(EFBIG) */
#if defined(EHOSTDOWN)
  syslib_EHOSTDOWN__VAR = Scm_Intern(&syslib_EHOSTDOWN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EHOSTDOWN__VAR)), SCM_OBJ(Scm_MakeInteger(EHOSTDOWN)));
#endif /* defined(EHOSTDOWN) */
#if defined(EHOSTUNREACH)
  syslib_EHOSTUNREACH__VAR = Scm_Intern(&syslib_EHOSTUNREACH__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EHOSTUNREACH__VAR)), SCM_OBJ(Scm_MakeInteger(EHOSTUNREACH)));
#endif /* defined(EHOSTUNREACH) */
#if defined(EIDRM)
  syslib_EIDRM__VAR = Scm_Intern(&syslib_EIDRM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EIDRM__VAR)), SCM_OBJ(Scm_MakeInteger(EIDRM)));
#endif /* defined(EIDRM) */
#if defined(EILSEQ)
  syslib_EILSEQ__VAR = Scm_Intern(&syslib_EILSEQ__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EILSEQ__VAR)), SCM_OBJ(Scm_MakeInteger(EILSEQ)));
#endif /* defined(EILSEQ) */
#if defined(EINPROGRESS)
  syslib_EINPROGRESS__VAR = Scm_Intern(&syslib_EINPROGRESS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EINPROGRESS__VAR)), SCM_OBJ(Scm_MakeInteger(EINPROGRESS)));
#endif /* defined(EINPROGRESS) */
#if defined(EINTR)
  syslib_EINTR__VAR = Scm_Intern(&syslib_EINTR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EINTR__VAR)), SCM_OBJ(Scm_MakeInteger(EINTR)));
#endif /* defined(EINTR) */
#if defined(EINVAL)
  syslib_EINVAL__VAR = Scm_Intern(&syslib_EINVAL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EINVAL__VAR)), SCM_OBJ(Scm_MakeInteger(EINVAL)));
#endif /* defined(EINVAL) */
#if defined(EIO)
  syslib_EIO__VAR = Scm_Intern(&syslib_EIO__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EIO__VAR)), SCM_OBJ(Scm_MakeInteger(EIO)));
#endif /* defined(EIO) */
#if defined(EISCONN)
  syslib_EISCONN__VAR = Scm_Intern(&syslib_EISCONN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EISCONN__VAR)), SCM_OBJ(Scm_MakeInteger(EISCONN)));
#endif /* defined(EISCONN) */
#if defined(EISDIR)
  syslib_EISDIR__VAR = Scm_Intern(&syslib_EISDIR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EISDIR__VAR)), SCM_OBJ(Scm_MakeInteger(EISDIR)));
#endif /* defined(EISDIR) */
#if defined(EISNAM)
  syslib_EISNAM__VAR = Scm_Intern(&syslib_EISNAM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EISNAM__VAR)), SCM_OBJ(Scm_MakeInteger(EISNAM)));
#endif /* defined(EISNAM) */
#if defined(EKEYEXPIRED)
  syslib_EKEYEXPIRED__VAR = Scm_Intern(&syslib_EKEYEXPIRED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EKEYEXPIRED__VAR)), SCM_OBJ(Scm_MakeInteger(EKEYEXPIRED)));
#endif /* defined(EKEYEXPIRED) */
#if defined(EKEYREJECTED)
  syslib_EKEYREJECTED__VAR = Scm_Intern(&syslib_EKEYREJECTED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EKEYREJECTED__VAR)), SCM_OBJ(Scm_MakeInteger(EKEYREJECTED)));
#endif /* defined(EKEYREJECTED) */
#if defined(EKEYREVOKED)
  syslib_EKEYREVOKED__VAR = Scm_Intern(&syslib_EKEYREVOKED__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EKEYREVOKED__VAR)), SCM_OBJ(Scm_MakeInteger(EKEYREVOKED)));
#endif /* defined(EKEYREVOKED) */
#if defined(EL2HLT)
  syslib_EL2HLT__VAR = Scm_Intern(&syslib_EL2HLT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EL2HLT__VAR)), SCM_OBJ(Scm_MakeInteger(EL2HLT)));
#endif /* defined(EL2HLT) */
#if defined(EL2NSYNC)
  syslib_EL2NSYNC__VAR = Scm_Intern(&syslib_EL2NSYNC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EL2NSYNC__VAR)), SCM_OBJ(Scm_MakeInteger(EL2NSYNC)));
#endif /* defined(EL2NSYNC) */
#if defined(EL3HLT)
  syslib_EL3HLT__VAR = Scm_Intern(&syslib_EL3HLT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EL3HLT__VAR)), SCM_OBJ(Scm_MakeInteger(EL3HLT)));
#endif /* defined(EL3HLT) */
#if defined(EL3RST)
  syslib_EL3RST__VAR = Scm_Intern(&syslib_EL3RST__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EL3RST__VAR)), SCM_OBJ(Scm_MakeInteger(EL3RST)));
#endif /* defined(EL3RST) */
#if defined(ELIBACC)
  syslib_ELIBACC__VAR = Scm_Intern(&syslib_ELIBACC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELIBACC__VAR)), SCM_OBJ(Scm_MakeInteger(ELIBACC)));
#endif /* defined(ELIBACC) */
#if defined(ELIBBAD)
  syslib_ELIBBAD__VAR = Scm_Intern(&syslib_ELIBBAD__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELIBBAD__VAR)), SCM_OBJ(Scm_MakeInteger(ELIBBAD)));
#endif /* defined(ELIBBAD) */
#if defined(ELIBEXEC)
  syslib_ELIBEXEC__VAR = Scm_Intern(&syslib_ELIBEXEC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELIBEXEC__VAR)), SCM_OBJ(Scm_MakeInteger(ELIBEXEC)));
#endif /* defined(ELIBEXEC) */
#if defined(ELIBMAX)
  syslib_ELIBMAX__VAR = Scm_Intern(&syslib_ELIBMAX__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELIBMAX__VAR)), SCM_OBJ(Scm_MakeInteger(ELIBMAX)));
#endif /* defined(ELIBMAX) */
#if defined(ELIBSCN)
  syslib_ELIBSCN__VAR = Scm_Intern(&syslib_ELIBSCN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELIBSCN__VAR)), SCM_OBJ(Scm_MakeInteger(ELIBSCN)));
#endif /* defined(ELIBSCN) */
#if defined(ELNRNG)
  syslib_ELNRNG__VAR = Scm_Intern(&syslib_ELNRNG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELNRNG__VAR)), SCM_OBJ(Scm_MakeInteger(ELNRNG)));
#endif /* defined(ELNRNG) */
#if defined(ELOOP)
  syslib_ELOOP__VAR = Scm_Intern(&syslib_ELOOP__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ELOOP__VAR)), SCM_OBJ(Scm_MakeInteger(ELOOP)));
#endif /* defined(ELOOP) */
#if defined(EMEDIUMTYPE)
  syslib_EMEDIUMTYPE__VAR = Scm_Intern(&syslib_EMEDIUMTYPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EMEDIUMTYPE__VAR)), SCM_OBJ(Scm_MakeInteger(EMEDIUMTYPE)));
#endif /* defined(EMEDIUMTYPE) */
#if defined(EMFILE)
  syslib_EMFILE__VAR = Scm_Intern(&syslib_EMFILE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EMFILE__VAR)), SCM_OBJ(Scm_MakeInteger(EMFILE)));
#endif /* defined(EMFILE) */
#if defined(EMLINK)
  syslib_EMLINK__VAR = Scm_Intern(&syslib_EMLINK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EMLINK__VAR)), SCM_OBJ(Scm_MakeInteger(EMLINK)));
#endif /* defined(EMLINK) */
#if defined(EMSGSIZE)
  syslib_EMSGSIZE__VAR = Scm_Intern(&syslib_EMSGSIZE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EMSGSIZE__VAR)), SCM_OBJ(Scm_MakeInteger(EMSGSIZE)));
#endif /* defined(EMSGSIZE) */
#if defined(EMULTIHOP)
  syslib_EMULTIHOP__VAR = Scm_Intern(&syslib_EMULTIHOP__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EMULTIHOP__VAR)), SCM_OBJ(Scm_MakeInteger(EMULTIHOP)));
#endif /* defined(EMULTIHOP) */
#if defined(ENAMETOOLONG)
  syslib_ENAMETOOLONG__VAR = Scm_Intern(&syslib_ENAMETOOLONG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENAMETOOLONG__VAR)), SCM_OBJ(Scm_MakeInteger(ENAMETOOLONG)));
#endif /* defined(ENAMETOOLONG) */
#if defined(ENAVAIL)
  syslib_ENAVAIL__VAR = Scm_Intern(&syslib_ENAVAIL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENAVAIL__VAR)), SCM_OBJ(Scm_MakeInteger(ENAVAIL)));
#endif /* defined(ENAVAIL) */
#if defined(ENETDOWN)
  syslib_ENETDOWN__VAR = Scm_Intern(&syslib_ENETDOWN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENETDOWN__VAR)), SCM_OBJ(Scm_MakeInteger(ENETDOWN)));
#endif /* defined(ENETDOWN) */
#if defined(ENETRESET)
  syslib_ENETRESET__VAR = Scm_Intern(&syslib_ENETRESET__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENETRESET__VAR)), SCM_OBJ(Scm_MakeInteger(ENETRESET)));
#endif /* defined(ENETRESET) */
#if defined(ENETUNREACH)
  syslib_ENETUNREACH__VAR = Scm_Intern(&syslib_ENETUNREACH__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENETUNREACH__VAR)), SCM_OBJ(Scm_MakeInteger(ENETUNREACH)));
#endif /* defined(ENETUNREACH) */
#if defined(ENFILE)
  syslib_ENFILE__VAR = Scm_Intern(&syslib_ENFILE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENFILE__VAR)), SCM_OBJ(Scm_MakeInteger(ENFILE)));
#endif /* defined(ENFILE) */
#if defined(ENOANO)
  syslib_ENOANO__VAR = Scm_Intern(&syslib_ENOANO__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOANO__VAR)), SCM_OBJ(Scm_MakeInteger(ENOANO)));
#endif /* defined(ENOANO) */
#if defined(ENOBUFS)
  syslib_ENOBUFS__VAR = Scm_Intern(&syslib_ENOBUFS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOBUFS__VAR)), SCM_OBJ(Scm_MakeInteger(ENOBUFS)));
#endif /* defined(ENOBUFS) */
#if defined(ENOCSI)
  syslib_ENOCSI__VAR = Scm_Intern(&syslib_ENOCSI__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOCSI__VAR)), SCM_OBJ(Scm_MakeInteger(ENOCSI)));
#endif /* defined(ENOCSI) */
#if defined(ENODATA)
  syslib_ENODATA__VAR = Scm_Intern(&syslib_ENODATA__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENODATA__VAR)), SCM_OBJ(Scm_MakeInteger(ENODATA)));
#endif /* defined(ENODATA) */
#if defined(ENODEV)
  syslib_ENODEV__VAR = Scm_Intern(&syslib_ENODEV__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENODEV__VAR)), SCM_OBJ(Scm_MakeInteger(ENODEV)));
#endif /* defined(ENODEV) */
#if defined(ENOENT)
  syslib_ENOENT__VAR = Scm_Intern(&syslib_ENOENT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOENT__VAR)), SCM_OBJ(Scm_MakeInteger(ENOENT)));
#endif /* defined(ENOENT) */
#if defined(ENOEXEC)
  syslib_ENOEXEC__VAR = Scm_Intern(&syslib_ENOEXEC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOEXEC__VAR)), SCM_OBJ(Scm_MakeInteger(ENOEXEC)));
#endif /* defined(ENOEXEC) */
#if defined(ENOKEY)
  syslib_ENOKEY__VAR = Scm_Intern(&syslib_ENOKEY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOKEY__VAR)), SCM_OBJ(Scm_MakeInteger(ENOKEY)));
#endif /* defined(ENOKEY) */
#if defined(ENOLCK)
  syslib_ENOLCK__VAR = Scm_Intern(&syslib_ENOLCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOLCK__VAR)), SCM_OBJ(Scm_MakeInteger(ENOLCK)));
#endif /* defined(ENOLCK) */
#if defined(ENOLINK)
  syslib_ENOLINK__VAR = Scm_Intern(&syslib_ENOLINK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOLINK__VAR)), SCM_OBJ(Scm_MakeInteger(ENOLINK)));
#endif /* defined(ENOLINK) */
#if defined(ENOMEDIUM)
  syslib_ENOMEDIUM__VAR = Scm_Intern(&syslib_ENOMEDIUM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOMEDIUM__VAR)), SCM_OBJ(Scm_MakeInteger(ENOMEDIUM)));
#endif /* defined(ENOMEDIUM) */
#if defined(ENOMEM)
  syslib_ENOMEM__VAR = Scm_Intern(&syslib_ENOMEM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOMEM__VAR)), SCM_OBJ(Scm_MakeInteger(ENOMEM)));
#endif /* defined(ENOMEM) */
#if defined(ENOMSG)
  syslib_ENOMSG__VAR = Scm_Intern(&syslib_ENOMSG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOMSG__VAR)), SCM_OBJ(Scm_MakeInteger(ENOMSG)));
#endif /* defined(ENOMSG) */
#if defined(ENONET)
  syslib_ENONET__VAR = Scm_Intern(&syslib_ENONET__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENONET__VAR)), SCM_OBJ(Scm_MakeInteger(ENONET)));
#endif /* defined(ENONET) */
#if defined(ENOPKG)
  syslib_ENOPKG__VAR = Scm_Intern(&syslib_ENOPKG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOPKG__VAR)), SCM_OBJ(Scm_MakeInteger(ENOPKG)));
#endif /* defined(ENOPKG) */
#if defined(ENOPROTOOPT)
  syslib_ENOPROTOOPT__VAR = Scm_Intern(&syslib_ENOPROTOOPT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOPROTOOPT__VAR)), SCM_OBJ(Scm_MakeInteger(ENOPROTOOPT)));
#endif /* defined(ENOPROTOOPT) */
#if defined(ENOSPC)
  syslib_ENOSPC__VAR = Scm_Intern(&syslib_ENOSPC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOSPC__VAR)), SCM_OBJ(Scm_MakeInteger(ENOSPC)));
#endif /* defined(ENOSPC) */
#if defined(ENOSR)
  syslib_ENOSR__VAR = Scm_Intern(&syslib_ENOSR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOSR__VAR)), SCM_OBJ(Scm_MakeInteger(ENOSR)));
#endif /* defined(ENOSR) */
#if defined(ENOSTR)
  syslib_ENOSTR__VAR = Scm_Intern(&syslib_ENOSTR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOSTR__VAR)), SCM_OBJ(Scm_MakeInteger(ENOSTR)));
#endif /* defined(ENOSTR) */
#if defined(ENOSYS)
  syslib_ENOSYS__VAR = Scm_Intern(&syslib_ENOSYS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOSYS__VAR)), SCM_OBJ(Scm_MakeInteger(ENOSYS)));
#endif /* defined(ENOSYS) */
#if defined(ENOTBLK)
  syslib_ENOTBLK__VAR = Scm_Intern(&syslib_ENOTBLK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTBLK__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTBLK)));
#endif /* defined(ENOTBLK) */
#if defined(ENOTCONN)
  syslib_ENOTCONN__VAR = Scm_Intern(&syslib_ENOTCONN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTCONN__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTCONN)));
#endif /* defined(ENOTCONN) */
#if defined(ENOTDIR)
  syslib_ENOTDIR__VAR = Scm_Intern(&syslib_ENOTDIR__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTDIR__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTDIR)));
#endif /* defined(ENOTDIR) */
#if defined(ENOTEMPTY)
  syslib_ENOTEMPTY__VAR = Scm_Intern(&syslib_ENOTEMPTY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTEMPTY__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTEMPTY)));
#endif /* defined(ENOTEMPTY) */
#if defined(ENOTNAM)
  syslib_ENOTNAM__VAR = Scm_Intern(&syslib_ENOTNAM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTNAM__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTNAM)));
#endif /* defined(ENOTNAM) */
#if defined(ENOTSOCK)
  syslib_ENOTSOCK__VAR = Scm_Intern(&syslib_ENOTSOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTSOCK__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTSOCK)));
#endif /* defined(ENOTSOCK) */
#if defined(ENOTTY)
  syslib_ENOTTY__VAR = Scm_Intern(&syslib_ENOTTY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTTY__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTTY)));
#endif /* defined(ENOTTY) */
#if defined(ENOTUNIQ)
  syslib_ENOTUNIQ__VAR = Scm_Intern(&syslib_ENOTUNIQ__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENOTUNIQ__VAR)), SCM_OBJ(Scm_MakeInteger(ENOTUNIQ)));
#endif /* defined(ENOTUNIQ) */
#if defined(ENXIO)
  syslib_ENXIO__VAR = Scm_Intern(&syslib_ENXIO__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ENXIO__VAR)), SCM_OBJ(Scm_MakeInteger(ENXIO)));
#endif /* defined(ENXIO) */
#if defined(EOPNOTSUPP)
  syslib_EOPNOTSUPP__VAR = Scm_Intern(&syslib_EOPNOTSUPP__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EOPNOTSUPP__VAR)), SCM_OBJ(Scm_MakeInteger(EOPNOTSUPP)));
#endif /* defined(EOPNOTSUPP) */
#if defined(EOVERFLOW)
  syslib_EOVERFLOW__VAR = Scm_Intern(&syslib_EOVERFLOW__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EOVERFLOW__VAR)), SCM_OBJ(Scm_MakeInteger(EOVERFLOW)));
#endif /* defined(EOVERFLOW) */
#if defined(EPERM)
  syslib_EPERM__VAR = Scm_Intern(&syslib_EPERM__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPERM__VAR)), SCM_OBJ(Scm_MakeInteger(EPERM)));
#endif /* defined(EPERM) */
#if defined(EPFNOSUPPORT)
  syslib_EPFNOSUPPORT__VAR = Scm_Intern(&syslib_EPFNOSUPPORT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPFNOSUPPORT__VAR)), SCM_OBJ(Scm_MakeInteger(EPFNOSUPPORT)));
#endif /* defined(EPFNOSUPPORT) */
#if defined(EPIPE)
  syslib_EPIPE__VAR = Scm_Intern(&syslib_EPIPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPIPE__VAR)), SCM_OBJ(Scm_MakeInteger(EPIPE)));
#endif /* defined(EPIPE) */
#if defined(EPROTO)
  syslib_EPROTO__VAR = Scm_Intern(&syslib_EPROTO__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPROTO__VAR)), SCM_OBJ(Scm_MakeInteger(EPROTO)));
#endif /* defined(EPROTO) */
#if defined(EPROTONOSUPPORT)
  syslib_EPROTONOSUPPORT__VAR = Scm_Intern(&syslib_EPROTONOSUPPORT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPROTONOSUPPORT__VAR)), SCM_OBJ(Scm_MakeInteger(EPROTONOSUPPORT)));
#endif /* defined(EPROTONOSUPPORT) */
#if defined(EPROTOTYPE)
  syslib_EPROTOTYPE__VAR = Scm_Intern(&syslib_EPROTOTYPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EPROTOTYPE__VAR)), SCM_OBJ(Scm_MakeInteger(EPROTOTYPE)));
#endif /* defined(EPROTOTYPE) */
#if defined(ERANGE)
  syslib_ERANGE__VAR = Scm_Intern(&syslib_ERANGE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ERANGE__VAR)), SCM_OBJ(Scm_MakeInteger(ERANGE)));
#endif /* defined(ERANGE) */
#if defined(EREMCHG)
  syslib_EREMCHG__VAR = Scm_Intern(&syslib_EREMCHG__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EREMCHG__VAR)), SCM_OBJ(Scm_MakeInteger(EREMCHG)));
#endif /* defined(EREMCHG) */
#if defined(EREMOTE)
  syslib_EREMOTE__VAR = Scm_Intern(&syslib_EREMOTE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EREMOTE__VAR)), SCM_OBJ(Scm_MakeInteger(EREMOTE)));
#endif /* defined(EREMOTE) */
#if defined(EREMOTEIO)
  syslib_EREMOTEIO__VAR = Scm_Intern(&syslib_EREMOTEIO__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EREMOTEIO__VAR)), SCM_OBJ(Scm_MakeInteger(EREMOTEIO)));
#endif /* defined(EREMOTEIO) */
#if defined(ERESTART)
  syslib_ERESTART__VAR = Scm_Intern(&syslib_ERESTART__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ERESTART__VAR)), SCM_OBJ(Scm_MakeInteger(ERESTART)));
#endif /* defined(ERESTART) */
#if defined(EROFS)
  syslib_EROFS__VAR = Scm_Intern(&syslib_EROFS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EROFS__VAR)), SCM_OBJ(Scm_MakeInteger(EROFS)));
#endif /* defined(EROFS) */
#if defined(ESHUTDOWN)
  syslib_ESHUTDOWN__VAR = Scm_Intern(&syslib_ESHUTDOWN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESHUTDOWN__VAR)), SCM_OBJ(Scm_MakeInteger(ESHUTDOWN)));
#endif /* defined(ESHUTDOWN) */
#if defined(ESOCKTNOSUPPORT)
  syslib_ESOCKTNOSUPPORT__VAR = Scm_Intern(&syslib_ESOCKTNOSUPPORT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESOCKTNOSUPPORT__VAR)), SCM_OBJ(Scm_MakeInteger(ESOCKTNOSUPPORT)));
#endif /* defined(ESOCKTNOSUPPORT) */
#if defined(ESPIPE)
  syslib_ESPIPE__VAR = Scm_Intern(&syslib_ESPIPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESPIPE__VAR)), SCM_OBJ(Scm_MakeInteger(ESPIPE)));
#endif /* defined(ESPIPE) */
#if defined(ESRCH)
  syslib_ESRCH__VAR = Scm_Intern(&syslib_ESRCH__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESRCH__VAR)), SCM_OBJ(Scm_MakeInteger(ESRCH)));
#endif /* defined(ESRCH) */
#if defined(ESRMNT)
  syslib_ESRMNT__VAR = Scm_Intern(&syslib_ESRMNT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESRMNT__VAR)), SCM_OBJ(Scm_MakeInteger(ESRMNT)));
#endif /* defined(ESRMNT) */
#if defined(ESTALE)
  syslib_ESTALE__VAR = Scm_Intern(&syslib_ESTALE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESTALE__VAR)), SCM_OBJ(Scm_MakeInteger(ESTALE)));
#endif /* defined(ESTALE) */
#if defined(ESTRPIPE)
  syslib_ESTRPIPE__VAR = Scm_Intern(&syslib_ESTRPIPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ESTRPIPE__VAR)), SCM_OBJ(Scm_MakeInteger(ESTRPIPE)));
#endif /* defined(ESTRPIPE) */
#if defined(ETIME)
  syslib_ETIME__VAR = Scm_Intern(&syslib_ETIME__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ETIME__VAR)), SCM_OBJ(Scm_MakeInteger(ETIME)));
#endif /* defined(ETIME) */
#if defined(ETIMEDOUT)
  syslib_ETIMEDOUT__VAR = Scm_Intern(&syslib_ETIMEDOUT__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ETIMEDOUT__VAR)), SCM_OBJ(Scm_MakeInteger(ETIMEDOUT)));
#endif /* defined(ETIMEDOUT) */
#if defined(ETOOMANYREFS)
  syslib_ETOOMANYREFS__VAR = Scm_Intern(&syslib_ETOOMANYREFS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ETOOMANYREFS__VAR)), SCM_OBJ(Scm_MakeInteger(ETOOMANYREFS)));
#endif /* defined(ETOOMANYREFS) */
#if defined(ETXTBSY)
  syslib_ETXTBSY__VAR = Scm_Intern(&syslib_ETXTBSY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_ETXTBSY__VAR)), SCM_OBJ(Scm_MakeInteger(ETXTBSY)));
#endif /* defined(ETXTBSY) */
#if defined(EUCLEAN)
  syslib_EUCLEAN__VAR = Scm_Intern(&syslib_EUCLEAN__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EUCLEAN__VAR)), SCM_OBJ(Scm_MakeInteger(EUCLEAN)));
#endif /* defined(EUCLEAN) */
#if defined(EUNATCH)
  syslib_EUNATCH__VAR = Scm_Intern(&syslib_EUNATCH__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EUNATCH__VAR)), SCM_OBJ(Scm_MakeInteger(EUNATCH)));
#endif /* defined(EUNATCH) */
#if defined(EUSERS)
  syslib_EUSERS__VAR = Scm_Intern(&syslib_EUSERS__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EUSERS__VAR)), SCM_OBJ(Scm_MakeInteger(EUSERS)));
#endif /* defined(EUSERS) */
#if defined(EWOULDBLOCK)
  syslib_EWOULDBLOCK__VAR = Scm_Intern(&syslib_EWOULDBLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EWOULDBLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(EWOULDBLOCK)));
#endif /* defined(EWOULDBLOCK) */
#if defined(EXDEV)
  syslib_EXDEV__VAR = Scm_Intern(&syslib_EXDEV__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EXDEV__VAR)), SCM_OBJ(Scm_MakeInteger(EXDEV)));
#endif /* defined(EXDEV) */
#if defined(EXFULL)
  syslib_EXFULL__VAR = Scm_Intern(&syslib_EXFULL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_EXFULL__VAR)), SCM_OBJ(Scm_MakeInteger(EXFULL)));
#endif /* defined(EXFULL) */
  SCM_DEFINE(module, "sys-getgrgid", SCM_OBJ(&syslib_sys_getgrgid__STUB));
  SCM_DEFINE(module, "sys-getgrnam", SCM_OBJ(&syslib_sys_getgrnam__STUB));
  SCM_DEFINE(module, "sys-gid->group-name", SCM_OBJ(&syslib_sys_gid_TOgroup_name__STUB));
  SCM_DEFINE(module, "sys-group-name->gid", SCM_OBJ(&syslib_sys_group_name_TOgid__STUB));
  syslib_LC_ALL__VAR = Scm_Intern(&syslib_LC_ALL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_ALL__VAR)), SCM_OBJ(Scm_MakeInteger(LC_ALL)));
  syslib_LC_COLLATE__VAR = Scm_Intern(&syslib_LC_COLLATE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_COLLATE__VAR)), SCM_OBJ(Scm_MakeInteger(LC_COLLATE)));
  syslib_LC_CTYPE__VAR = Scm_Intern(&syslib_LC_CTYPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_CTYPE__VAR)), SCM_OBJ(Scm_MakeInteger(LC_CTYPE)));
  syslib_LC_MONETARY__VAR = Scm_Intern(&syslib_LC_MONETARY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_MONETARY__VAR)), SCM_OBJ(Scm_MakeInteger(LC_MONETARY)));
  syslib_LC_NUMERIC__VAR = Scm_Intern(&syslib_LC_NUMERIC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_NUMERIC__VAR)), SCM_OBJ(Scm_MakeInteger(LC_NUMERIC)));
  syslib_LC_TIME__VAR = Scm_Intern(&syslib_LC_TIME__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_TIME__VAR)), SCM_OBJ(Scm_MakeInteger(LC_TIME)));
  SCM_DEFINE(module, "sys-setlocale", SCM_OBJ(&syslib_sys_setlocale__STUB));
  SCM_DEFINE(module, "sys-getpwuid", SCM_OBJ(&syslib_sys_getpwuid__STUB));
  SCM_DEFINE(module, "sys-getpwnam", SCM_OBJ(&syslib_sys_getpwnam__STUB));
  SCM_DEFINE(module, "sys-uid->user-name", SCM_OBJ(&syslib_sys_uid_TOuser_name__STUB));
  SCM_DEFINE(module, "sys-user-name->uid", SCM_OBJ(&syslib_sys_user_name_TOuid__STUB));
  SCM_DEFINE(module, "sys-sigset-add!", SCM_OBJ(&syslib_sys_sigset_addX__STUB));
  SCM_DEFINE(module, "sys-sigset-delete!", SCM_OBJ(&syslib_sys_sigset_deleteX__STUB));
  SCM_DEFINE(module, "sys-sigset-fill!", SCM_OBJ(&syslib_sys_sigset_fillX__STUB));
  SCM_DEFINE(module, "sys-sigset-empty!", SCM_OBJ(&syslib_sys_sigset_emptyX__STUB));
  SCM_DEFINE(module, "sys-signal-name", SCM_OBJ(&syslib_sys_signal_name__STUB));
  SCM_DEFINE(module, "sys-kill", SCM_OBJ(&syslib_sys_kill__STUB));
  SCM_DEFINE(module, "set-signal-handler!", SCM_OBJ(&syslib_set_signal_handlerX__STUB));
  SCM_DEFINE(module, "get-signal-handler", SCM_OBJ(&syslib_get_signal_handler__STUB));
  SCM_DEFINE(module, "get-signal-handler-mask", SCM_OBJ(&syslib_get_signal_handler_mask__STUB));
  SCM_DEFINE(module, "get-signal-handlers", SCM_OBJ(&syslib_get_signal_handlers__STUB));
  SCM_DEFINE(module, "set-signal-pending-limit", SCM_OBJ(&syslib_set_signal_pending_limit__STUB));
  SCM_DEFINE(module, "get-signal-pending-limit", SCM_OBJ(&syslib_get_signal_pending_limit__STUB));
  syslib_SIG_SETMASK__VAR = Scm_Intern(&syslib_SIG_SETMASK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_SETMASK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_SETMASK)));
  syslib_SIG_BLOCK__VAR = Scm_Intern(&syslib_SIG_BLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_BLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_BLOCK)));
  syslib_SIG_UNBLOCK__VAR = Scm_Intern(&syslib_SIG_UNBLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_UNBLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_UNBLOCK)));
  SCM_DEFINE(module, "sys-sigmask", SCM_OBJ(&syslib_sys_sigmask__STUB));
  SCM_DEFINE(module, "sys-sigsuspend", SCM_OBJ(&syslib_sys_sigsuspend__STUB));
#if defined HAVE_SIGWAIT
  SCM_DEFINE(module, "sys-sigwait", SCM_OBJ(&syslib_sys_sigwait__STUB));
#endif /* defined HAVE_SIGWAIT */
#if defined HAVE_SIGWAIT
Scm_AddFeature("gauche.sys.sigwait", NULL);
#endif /* defined HAVE_SIGWAIT */
  SCM_DEFINE(module, "sys-remove", SCM_OBJ(&syslib_sys_remove__STUB));
  SCM_DEFINE(module, "sys-rename", SCM_OBJ(&syslib_sys_rename__STUB));
  SCM_DEFINE(module, "sys-tmpnam", SCM_OBJ(&syslib_sys_tmpnam__STUB));
  SCM_DEFINE(module, "sys-mkstemp", SCM_OBJ(&syslib_sys_mkstemp__STUB));
  SCM_DEFINE(module, "sys-exit", SCM_OBJ(&syslib_sys_exit__STUB));
  SCM_DEFINE(module, "sys-getenv", SCM_OBJ(&syslib_sys_getenv__STUB));
  SCM_DEFINE(module, "sys-system", SCM_OBJ(&syslib_sys_system__STUB));
  SCM_DEFINE(module, "sys-random", SCM_OBJ(&syslib_sys_random__STUB));
  SCM_DEFINE(module, "sys-srandom", SCM_OBJ(&syslib_sys_srandom__STUB));
  syslib_RAND_MAX__VAR = Scm_Intern(&syslib_RAND_MAX__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_RAND_MAX__VAR)), SCM_OBJ(Scm_MakeIntegerFromUI(RAND_MAX)));
  SCM_DEFINE(module, "sys-strerror", SCM_OBJ(&syslib_sys_strerror__STUB));
  SCM_DEFINE(module, "sys-stat", SCM_OBJ(&syslib_sys_stat__STUB));
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-lstat", SCM_OBJ(&syslib_sys_lstat__STUB));
#endif /* !defined(__MINGW32__) */
  SCM_DEFINE(module, "sys-fstat", SCM_OBJ(&syslib_sys_fstat__STUB));
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait", SCM_OBJ(&syslib_sys_wait__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-waitpid", SCM_OBJ(&syslib_sys_waitpid__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  KEYARG_nohang = Scm_MakeKeyword(&KEYARG_nohang__NAME);
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  KEYARG_untraced = Scm_MakeKeyword(&KEYARG_untraced__NAME);
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-exited?", SCM_OBJ(&syslib_sys_wait_exitedP__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-exit-status", SCM_OBJ(&syslib_sys_wait_exit_status__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-signaled?", SCM_OBJ(&syslib_sys_wait_signaledP__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-termsig", SCM_OBJ(&syslib_sys_wait_termsig__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-stopped?", SCM_OBJ(&syslib_sys_wait_stoppedP__STUB));
#endif /* !defined(__MINGW32__) */
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-stopsig", SCM_OBJ(&syslib_sys_wait_stopsig__STUB));
#endif /* !defined(__MINGW32__) */
  SCM_DEFINE(module, "sys-time", SCM_OBJ(&syslib_sys_time__STUB));
  SCM_DEFINE(module, "sys-gettimeofday", SCM_OBJ(&syslib_sys_gettimeofday__STUB));
  SCM_DEFINE(module, "current-time", SCM_OBJ(&syslib_current_time__STUB));
  SCM_DEFINE(module, "time?", SCM_OBJ(&syslib_timeP__STUB));
  SCM_DEFINE(module, "time->seconds", SCM_OBJ(&syslib_time_TOseconds__STUB));
  SCM_DEFINE(module, "seconds->time", SCM_OBJ(&syslib_seconds_TOtime__STUB));
  SCM_DEFINE(module, "sys-asctime", SCM_OBJ(&syslib_sys_asctime__STUB));
  SCM_DEFINE(module, "sys-ctime", SCM_OBJ(&syslib_sys_ctime__STUB));
  SCM_DEFINE(module, "sys-difftime", SCM_OBJ(&syslib_sys_difftime__STUB));
  SCM_DEFINE(module, "sys-strftime", SCM_OBJ(&syslib_sys_strftime__STUB));
  SCM_DEFINE(module, "sys-gmtime", SCM_OBJ(&syslib_sys_gmtime__STUB));
  SCM_DEFINE(module, "sys-localtime", SCM_OBJ(&syslib_sys_localtime__STUB));
  SCM_DEFINE(module, "sys-mktime", SCM_OBJ(&syslib_sys_mktime__STUB));
  syslib_R_OK__VAR = Scm_Intern(&syslib_R_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_R_OK__VAR)), SCM_OBJ(Scm_MakeInteger(R_OK)));
  syslib_W_OK__VAR = Scm_Intern(&syslib_W_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_W_OK__VAR)), SCM_OBJ(Scm_MakeInteger(W_OK)));
  syslib_X_OK__VAR = Scm_Intern(&syslib_X_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_X_OK__VAR)), SCM_OBJ(Scm_MakeInteger(X_OK)));
  syslib_F_OK__VAR = Scm_Intern(&syslib_F_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_F_OK__VAR)), SCM_OBJ(Scm_MakeInteger(F_OK)));
  SCM_DEFINE(module, "sys-access", SCM_OBJ(&syslib_sys_access__STUB));
  SCM_DEFINE(module, "sys-chdir", SCM_OBJ(&syslib_sys_chdir__STUB));
  SCM_DEFINE(module, "sys-chmod", SCM_OBJ(&syslib_sys_chmod__STUB));
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-fchmod", SCM_OBJ(&syslib_sys_fchmod__STUB));
#endif /* !defined(__MINGW32__) */
  SCM_DEFINE(module, "sys-fork", SCM_OBJ(&syslib_sys_fork__STUB));
  key_iomap = Scm_MakeKeyword(&key_iomap__NAME);
  key_sigmask = Scm_MakeKeyword(&key_sigmask__NAME);
  SCM_DEFINE(module, "sys-exec", SCM_OBJ(&syslib_sys_exec__STUB));
  SCM_DEFINE(module, "sys-fork-and-exec", SCM_OBJ(&syslib_sys_fork_and_exec__STUB));
  SCM_DEFINE(module, "sys-getcwd", SCM_OBJ(&syslib_sys_getcwd__STUB));
  SCM_DEFINE(module, "sys-getegid", SCM_OBJ(&syslib_sys_getegid__STUB));
  SCM_DEFINE(module, "sys-getgid", SCM_OBJ(&syslib_sys_getgid__STUB));
  SCM_DEFINE(module, "sys-geteuid", SCM_OBJ(&syslib_sys_geteuid__STUB));
  SCM_DEFINE(module, "sys-getuid", SCM_OBJ(&syslib_sys_getuid__STUB));
  SCM_DEFINE(module, "sys-getpid", SCM_OBJ(&syslib_sys_getpid__STUB));
  SCM_DEFINE(module, "sys-getppid", SCM_OBJ(&syslib_sys_getppid__STUB));
  SCM_DEFINE(module, "sys-link", SCM_OBJ(&syslib_sys_link__STUB));
  SCM_DEFINE(module, "sys-pause", SCM_OBJ(&syslib_sys_pause__STUB));
  SCM_DEFINE(module, "sys-alarm", SCM_OBJ(&syslib_sys_alarm__STUB));
  SCM_DEFINE(module, "sys-pipe", SCM_OBJ(&syslib_sys_pipe__STUB));
  KEYARG_name = Scm_MakeKeyword(&KEYARG_name__NAME);
  KEYARG_buffering = Scm_MakeKeyword(&KEYARG_buffering__NAME);
  KEYARG_bufferedP = Scm_MakeKeyword(&KEYARG_bufferedP__NAME);
  SCM_DEFINE(module, "sys-close", SCM_OBJ(&syslib_sys_close__STUB));
  SCM_DEFINE(module, "sys-mkdir", SCM_OBJ(&syslib_sys_mkdir__STUB));
  SCM_DEFINE(module, "sys-rmdir", SCM_OBJ(&syslib_sys_rmdir__STUB));
  SCM_DEFINE(module, "sys-umask", SCM_OBJ(&syslib_sys_umask__STUB));
  SCM_DEFINE(module, "sys-sleep", SCM_OBJ(&syslib_sys_sleep__STUB));
#if defined(HAVE_NANOSLEEP)
  SCM_DEFINE(module, "sys-nanosleep", SCM_OBJ(&syslib_sys_nanosleep__STUB));
#endif /* defined(HAVE_NANOSLEEP) */
#if defined(HAVE_NANOSLEEP)
Scm_AddFeature("gauche.sys.nanosleep", NULL);
#endif /* defined(HAVE_NANOSLEEP) */
  SCM_DEFINE(module, "sys-unlink", SCM_OBJ(&syslib_sys_unlink__STUB));
  SCM_DEFINE(module, "sys-isatty", SCM_OBJ(&syslib_sys_isatty__STUB));
  SCM_DEFINE(module, "sys-ttyname", SCM_OBJ(&syslib_sys_ttyname__STUB));
  SCM_DEFINE(module, "sys-truncate", SCM_OBJ(&syslib_sys_truncate__STUB));
  SCM_DEFINE(module, "sys-ftruncate", SCM_OBJ(&syslib_sys_ftruncate__STUB));
#if defined(HAVE_CRYPT)
  SCM_DEFINE(module, "sys-crypt", SCM_OBJ(&syslib_sys_crypt__STUB));
#endif /* defined(HAVE_CRYPT) */
#if defined(HAVE_CRYPT)
Scm_AddFeature("gauche.sys.crypt", NULL);
#endif /* defined(HAVE_CRYPT) */
#if defined(HAVE_SYMLINK)
  SCM_DEFINE(module, "sys-symlink", SCM_OBJ(&syslib_sys_symlink__STUB));
#endif /* defined(HAVE_SYMLINK) */
#if defined(HAVE_SYMLINK)
Scm_AddFeature("gauche.sys.symlink", NULL);
#endif /* defined(HAVE_SYMLINK) */
#if defined(HAVE_READLINK)
  SCM_DEFINE(module, "sys-readlink", SCM_OBJ(&syslib_sys_readlink__STUB));
#endif /* defined(HAVE_READLINK) */
#if defined(HAVE_READLINK)
Scm_AddFeature("gauche.sys.readlink", NULL);
#endif /* defined(HAVE_READLINK) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-ref", SCM_OBJ(&syslib_sys_fdset_ref__STUB));
  Scm_SetterSet(SCM_PROCEDURE(&syslib_sys_fdset_ref__STUB), SCM_PROCEDURE(&syslib_sys_fdset_setX__STUB), TRUE);
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-set!", SCM_OBJ(&syslib_sys_fdset_setX__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-max-fd", SCM_OBJ(&syslib_sys_fdset_max_fd__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-clear!", SCM_OBJ(&syslib_sys_fdset_clearX__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-copy!", SCM_OBJ(&syslib_sys_fdset_copyX__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-select", SCM_OBJ(&syslib_sys_select__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-select!", SCM_OBJ(&syslib_sys_selectX__STUB));
#endif /* defined(HAVE_SELECT) */
#if defined(HAVE_SELECT)
Scm_AddFeature("gauche.sys.select", NULL);
#endif /* defined(HAVE_SELECT) */
}
