/*
 * PC-Speaker driver for Linux
 *
 * Volume conversion tables, sine-based amplification.
 * Copyright (C) 2001-2004  Stas Sergeev
 */

#include <linux/kernel.h>
#include "pcsp_tabs.h"

const unsigned char pcsp_tabs[][256] = {
{	/* linear */
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
},
{	/* amp 1 */
  0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   2,   2,   2,
  2,   3,   3,   3,   4,   4,   5,   5,   6,   6,   6,   7,   7,   8,   9,   9,
 10,  10,  11,  12,  12,  13,  14,  14,  15,  16,  17,  17,  18,  19,  20,  21,
 22,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,
 37,  39,  40,  41,  42,  43,  44,  46,  47,  48,  49,  50,  52,  53,  54,  56,
 57,  58,  60,  61,  62,  64,  65,  66,  68,  69,  70,  72,  73,  75,  76,  78,
 79,  80,  82,  83,  85,  86,  88,  89,  91,  92,  94,  95,  97,  98, 100, 101,
103, 105, 106, 108, 109, 111, 112, 114, 115, 117, 119, 120, 122, 123, 125, 126,
128, 130, 131, 133, 134, 136, 137, 139, 141, 142, 144, 145, 147, 148, 150, 151,
153, 155, 156, 158, 159, 161, 162, 164, 165, 167, 168, 170, 171, 173, 174, 176,
177, 178, 180, 181, 183, 184, 186, 187, 188, 190, 191, 192, 194, 195, 196, 198,
199, 200, 202, 203, 204, 206, 207, 208, 209, 210, 212, 213, 214, 215, 216, 217,
219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234,
234, 235, 236, 237, 238, 239, 239, 240, 241, 242, 242, 243, 244, 244, 245, 246,
246, 247, 247, 248, 249, 249, 250, 250, 250, 251, 251, 252, 252, 253, 253, 253,
254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
},
{	/* amp 2 */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,
  1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3,   3,   3,   3,   4,   4,
  4,   5,   5,   6,   6,   7,   7,   8,   8,   9,   9,  10,  10,  11,  12,  13,
 13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  29,
 30,  31,  33,  34,  36,  37,  39,  40,  42,  43,  45,  47,  48,  50,  52,  54,
 56,  58,  59,  61,  63,  65,  67,  70,  72,  74,  76,  78,  80,  83,  85,  87,
 89,  92,  94,  96,  99, 101, 104, 106, 108, 111, 113, 116, 118, 121, 123, 126,
128, 130, 133, 135, 138, 140, 143, 145, 148, 150, 152, 155, 157, 160, 162, 164,
167, 169, 171, 173, 176, 178, 180, 182, 184, 186, 189, 191, 193, 195, 197, 198,
200, 202, 204, 206, 208, 209, 211, 213, 214, 216, 217, 219, 220, 222, 223, 225,
226, 227, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242,
243, 243, 244, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251,
252, 252, 252, 253, 253, 253, 253, 254, 254, 254, 254, 254, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
},
{	/* amp 3 */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   2,
  2,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,   6,   7,   7,   8,
  9,   9,  10,  11,  12,  13,  14,  15,  16,  18,  19,  20,  22,  23,  25,  27,
 29,  31,  33,  35,  37,  39,  41,  44,  46,  49,  52,  54,  57,  60,  63,  66,
 70,  73,  76,  80,  83,  87,  90,  94,  97, 101, 105, 109, 113, 116, 120, 124,
128, 132, 136, 140, 143, 147, 151, 155, 159, 162, 166, 169, 173, 176, 180, 183,
186, 190, 193, 196, 199, 202, 204, 207, 210, 212, 215, 217, 219, 221, 223, 225,
227, 229, 231, 233, 234, 236, 237, 238, 240, 241, 242, 243, 244, 245, 246, 247,
247, 248, 249, 249, 250, 251, 251, 252, 252, 252, 253, 253, 253, 254, 254, 254,
254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
},
{	/* amp 4 */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
  1,   1,   1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   5,   5,   6,   7,
  8,   9,  10,  11,  13,  14,  16,  18,  20,  22,  25,  28,  30,  33,  37,  40,
 44,  48,  52,  56,  61,  66,  71,  76,  81,  87,  92,  98, 104, 110, 116, 122,
128, 134, 140, 146, 152, 158, 164, 169, 175, 180, 185, 190, 195, 200, 204, 208,
212, 216, 219, 223, 226, 228, 231, 234, 236, 238, 240, 242, 243, 245, 246, 247,
248, 249, 250, 251, 251, 252, 253, 253, 253, 254, 254, 254, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
},
{	/* amp 5 */
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   1,   1,   1,   2,   2,   3,   3,   4,   5,   6,   7,   9,  11,  13,  15,
 18,  21,  25,  29,  34,  39,  45,  52,  58,  66,  74,  82,  91, 100, 109, 118,
128, 138, 147, 156, 165, 174, 182, 190, 198, 204, 211, 217, 222, 227, 231, 235,
238, 241, 243, 245, 247, 249, 250, 251, 252, 253, 253, 254, 254, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
}
};

const unsigned int pcsp_max_gain = (ARRAY_SIZE(pcsp_tabs) - 1);

/*
 * The tables were generated with this small program:

#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[]) {
  int i, j, amp;
  double val;
  if (argc==2)
    amp=atoi(argv[1]);
  else
    amp=0;
  for(i=0;i<256;i++) {
    val = i;
    for (j=0;j<amp;j++)
      val = (1 - cos(val * M_PI / 256)) * 128;
    if (val > 255)	// rounding errors :(((
      val = 255;
    printf("%3i", (int)round(val));
    if (i<255)
      printf(",");
    if (i%16 == 15)
      printf("\n");
    else
      printf(" ");
  }
  return 0;
}

*/
