/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-plugin-loader.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-plugin-loader
 * @title: IAnjutaPluginLoader
 * @short_description: Interface for loading other plugins
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-plugin-loader.h
 * 
 */

#include "ianjuta-plugin-loader.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_plugin_loader_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-plugin-loader-quark");
	}
	
	return quark;
}

/**
 * ianjuta_plugin_loader_glue_plugin_new:
 * @obj: Self
 * @err: Error propagation and reporting.
 * 
 * When called, should return the type of an object derivated from
 * AnjutaGluePlugin
 */
GType
ianjuta_plugin_loader_glue_plugin_get_type (IAnjutaPluginLoader *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PLUGIN_LOADER(obj), 0);
	return IANJUTA_PLUGIN_LOADER_GET_IFACE (obj)->glue_plugin_get_type (obj, err);
}

static void
ianjuta_plugin_loader_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_plugin_loader_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaPluginLoaderIface),
			ianjuta_plugin_loader_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaPluginLoader", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
