#ifndef MCS_KEY_H
#define MCS_KEY_H

#include <glibmm.h>
#include <boost/variant.hpp>

#include <mcs/types.h>
#include <mcs/subscriber.h>

namespace Mcs {

      class Key
      {
	public:

	  Key			(const std::string& domain,
				 const std::string& key,
				 const KeyVariant&  key_default,
				 KeyType	    key_type);
	  Key () {};
	  ~Key () {};
	
	  void 
	  add_subscriber	(const std::string& name,   //Must be unique
				 SubscriberNotify   notify);  

	  void 
	  remove_subscriber	(const std::string& name);

	  template <typename T> void 
	  set_value (const T& key_value)
	  {
	    this->key_value = key_value; 
	    for (Subscribers::iterator iter = subscribers. begin (); iter != subscribers. end (); iter++)
	    {
		(*iter). second. notify (domain, key, this->key_value);
	    }
	  }

	  template <typename T> void 
	  set_value_silent (const T& key_value)
	  {
	    this->key_value = key_value; 
	  }

	  KeyVariant 
	  get_value		() const;
	  KeyType
	  get_type		() const;

	  void 
	  unset			();

	  operator bool		 () { return boost::get<bool>(key_value); }
	  operator int		 () { return boost::get<int>(key_value); }
	  operator std::string   () { return boost::get<std::string>(key_value); }
	  operator double	 () { return boost::get<double>(key_value); }

	private:
	
	  typedef std::map<std::string, Subscriber> Subscribers;
  
  	  std::string	domain;
  	  std::string	key;

	  KeyVariant	key_default; 
	  KeyVariant	key_value;
	  KeyType	key_type;
	  Subscribers   subscribers;

      };
};

#endif // MCS_KEY_H
