//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LYRICS_DIALOG_HH
#define BMP_LYRICS_DIALOG_HH

#include <gtkmm.h>
#include <libglademm.h>

#include "playbacksource.hh"

namespace Bmp
{
  class Lyrics : public Gtk::Dialog
  {
    public:

      Lyrics (BaseObjectType                       * obj,
              Glib::RefPtr<Gnome::Glade::Xml> const& xml);
      static Lyrics* create ();
      ~Lyrics ();

      void run   ( SimpleTrackInfo const& sti );

    private:

      Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

      Gtk::TextView * m_widget_lyrics;
      Gtk::Label    * m_widget_label_artist;
      Gtk::Label    * m_widget_label_title;
      Gtk::Image    * m_widget_cover;
      Gtk::Notebook * m_widget_notebook;

  }; //class Lyrics
} //namespace Bmp 

#endif // !BMP_LYRICS_DIALOG_HH

