//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LIBRARY_UI_MOVE_ALBUM_HH 
#define BMP_LIBRARY_UI_MOVE_ALBUM_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/markup.h>
#include <gtkmm.h>
#include <libglademm.h>

namespace Bmp
{
  class LibraryUiRelocateAlbum : public Gtk::Dialog
  {
    public:

      LibraryUiRelocateAlbum (BaseObjectType                       *cobject,
                              const Glib::RefPtr<Gnome::Glade::Xml> &xml);
      static LibraryUiRelocateAlbum * create ();
      ~LibraryUiRelocateAlbum ();

      int run (Library::Album const& album);

      Gtk::FileChooserButton * m_widget_fcb_move;
      Gtk::CheckButton	     * m_widget_cb_append_albumname;

    private:

      void fcb_current_folder_changed ();

      Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

      Gtk::Image		                * m_widget_image_coverart;
      Gtk::Entry		                * m_widget_entry_album;
      Gtk::Entry		                * m_widget_entry_artist;
      Gtk::HBox                     * m_widget_hbox_warning;
      Gtk::Button                   * m_widget_ok;

      Glib::RefPtr<Gdk::Pixbuf>	      m_album_unknown;
  };
}
#endif
