//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_CDDA_HH
#define BMP_UI_PART_CDDA_HH

#include <gtkmm.h>
#include <libglademm.h>

#include "vfs.hh"
#include "mbxml.hh"

#include "playbacksource.hh"
#include "ui-part-base.hh"

namespace Bmp
{
  namespace UiPart
  {
    class CDDA : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      public:

        CDDA (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager);
        ~CDDA ();

        typedef sigc::signal<void, Bmp::VUri&> SignalRequestImport;

        SignalRequestImport&
        signal_request_import () { return s_request_import_; }

      protected:

        virtual guint
        add_ui ();
       
        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type () { return Glib::ustring(); }

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();
  
        virtual void
        play ();

        virtual void
        play_requested () {}

        virtual void
        restore_context ();

        virtual GHashTable*
        get_metadata ();

     private:

      SignalRequestImport s_request_import_;

      enum NotebookPage
      {
        PAGE_TOC,
        PAGE_LOADING,
        PAGE_CD_INSERT,
        PAGE_CD_BAD,
        PAGE_NO_SUPPORT
      };

      enum EncodeState
      {
        ES_UNPROCESSED,
        ES_WAITING,
        ES_RIPPING,
        ES_TAGGING,
        ES_DONE,
        ES_ERROR
      };

      enum ProcessorType
      {
        CDDA_MP3,
        CDDA_VORBIS,
        CDDA_FLAC,
      };

      class Processors : public Gtk::TreeModel::ColumnRecord
      {
        public:
          Gtk::TreeModelColumn<Glib::ustring> name; 
          Gtk::TreeModelColumn<ProcessorType> type;

          Processors ()
          {
            add (name);
            add (type);
          }
      };
      Processors processors; 

      Glib::RefPtr<Gtk::ListStore> cbox_processors_store;

#ifdef HAVE_HAL

      void on_hal_cdda_inserted     (std::string udi, std::string devicefile);
      void on_hal_device_removed    (std::string udi);
      void on_hal_ejected           (std::string udi);

      std::string m_current_udi;
      std::string m_current_device;

#else

      void refresh ();

#endif //HAVE_HAL

      // Receive shutdown request from Core
      bool on_shutdown_request ();

      void rip_start();
      void rip_stop();
      void stream_position(int position);
      void stream_eos();
      void stream_error(Glib::ustring);

      // playback
      bool                                      m_stream_eos;
      boost::optional<std::string>              m_cdindex;
      boost::optional<Gtk::TreeModel::iterator> m_current_row;

      // && ripping
      bool                        m_processing_cd;
      MusicBrainzXML::MBRelease   m_release;
      Gtk::TreeModel::iterator    m_current_iter;

      class AudioCD: public Gtk::TreeModel::ColumnRecord
      {
        public:

          Gtk::TreeModelColumn<unsigned int>  tracknumber;
          Gtk::TreeModelColumn<Glib::ustring> artist;
          Gtk::TreeModelColumn<Glib::ustring> title;
          Gtk::TreeModelColumn<unsigned int>  duration;
          Gtk::TreeModelColumn<int>           percentage;
          Gtk::TreeModelColumn<EncodeState>   state;
          Gtk::TreeModelColumn<MusicBrainzXML::MBTrack> track;
          Gtk::TreeModelColumn<Glib::ustring> location;
          Gtk::TreeModelColumn<bool>          audio;

          AudioCD ()
          {
            add (tracknumber);
            add (artist);
            add (title);
            add (duration);
            add (percentage);
            add (state);
            add (track);
            add (location);
            add (audio);
          }
      };
      AudioCD audiocd;

      void cell_data_func_state   (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& m_iter);
      void cell_data_func_playing (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& m_iter);
      void cell_data_func_numbers (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& m_iter);

      void selection_changed ();
      void send_title ();

      Gtk::TreeView                    *cdda_view;
      Glib::RefPtr<Gtk::ListStore>      cdda_store;

      Gtk::Button     * m_b_cdda_rip;
      Gtk::Button     * m_b_cdda_reload;
      Gtk::Button     * m_b_cdda_stop;

      Gtk::Notebook   * m_notebook_cdda;
      Gtk::ComboBox   * m_cdda_cbox_format;
      Gtk::ComboBox   * m_cdda_cbox_quality;

      Gtk::Image      * m_cover_image;

      Gtk::Label      * m_label_album;
      Gtk::Label      * m_label_artist;
      Gtk::Label      * m_label_date;

      Glib::Mutex       m_mutex_rip;

      Gtk::CellRendererPixbuf   * cell_playing;
      Glib::RefPtr<Gdk::Pixbuf>   m_playing;
      Glib::RefPtr<Gdk::Pixbuf>   m_album_unknown;

      bool m_anonymous_cd;

      void activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column);

    }; // class CDDA
  } // namespace UiPart
} // namespace Bmp

#endif // !BMP_UI_PART_CDDA_HH

