#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class CallableDefinitionImpl : TypeMember, INodeWithParameters
	{
		protected ParameterDeclarationCollection _parameters;

		protected TypeReference _returnType;

		protected AttributeCollection _returnTypeAttributes;

		protected CallableDefinitionImpl()
		{
			InitializeFields();
		}
		
		protected CallableDefinitionImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected CallableDefinitionImpl(TypeReference returnType)
		{
			InitializeFields();
			ReturnType = returnType;
		}
			
		protected CallableDefinitionImpl(LexicalInfo lexicalInfo, TypeReference returnType) : base(lexicalInfo)
		{
			InitializeFields();
			ReturnType = returnType;
		}

		new public CallableDefinition CloneNode()
		{
			return Clone() as CallableDefinition;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.CallableDefinition;
			}
		}
		
		override public bool Matches(Node node)
		{	
			CallableDefinition other = node as CallableDefinition;
			if (null == other) return false;
			if (_modifiers != other._modifiers) return false;
			if (_name != other._name) return false;
			if (!Node.Matches(_attributes, other._attributes)) return false;
			if (!Node.Matches(_parameters, other._parameters)) return false;
			if (!Node.Matches(_returnType, other._returnType)) return false;
			if (!Node.Matches(_returnTypeAttributes, other._returnTypeAttributes)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_attributes != null)
			{
				Attribute item = existing as Attribute;
				if (null != item)
				{
					Attribute newItem = (Attribute)newNode;
					if (_attributes.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_parameters != null)
			{
				ParameterDeclaration item = existing as ParameterDeclaration;
				if (null != item)
				{
					ParameterDeclaration newItem = (ParameterDeclaration)newNode;
					if (_parameters.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_returnType == existing)
			{
				this.ReturnType = (TypeReference)newNode;
				return true;
			}
			if (_returnTypeAttributes != null)
			{
				Attribute item = existing as Attribute;
				if (null != item)
				{
					Attribute newItem = (Attribute)newNode;
					if (_returnTypeAttributes.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			return false;
		}
		
		override public object Clone()
		{
			CallableDefinition clone = (CallableDefinition)FormatterServices.GetUninitializedObject(typeof(CallableDefinition));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._modifiers = _modifiers;
			clone._name = _name;
			if (null != _attributes)
			{
				clone._attributes = _attributes.Clone() as AttributeCollection;
				clone._attributes.InitializeParent(clone);
			}
			if (null != _parameters)
			{
				clone._parameters = _parameters.Clone() as ParameterDeclarationCollection;
				clone._parameters.InitializeParent(clone);
			}
			if (null != _returnType)
			{
				clone._returnType = _returnType.Clone() as TypeReference;
				clone._returnType.InitializeParent(clone);
			}
			if (null != _returnTypeAttributes)
			{
				clone._returnTypeAttributes = _returnTypeAttributes.Clone() as AttributeCollection;
				clone._returnTypeAttributes.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			if (null != _attributes)
			{
				_attributes.ClearTypeSystemBindings();
			}
			if (null != _parameters)
			{
				_parameters.ClearTypeSystemBindings();
			}
			if (null != _returnType)
			{
				_returnType.ClearTypeSystemBindings();
			}
			if (null != _returnTypeAttributes)
			{
				_returnTypeAttributes.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public ParameterDeclarationCollection Parameters
		{
			get
			{
				return _parameters;
			}

			set
			{
				if (_parameters != value)
				{
					OnReplace(_parameters, value);
					_parameters = value;
					if (null != _parameters)
					{
						_parameters.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public TypeReference ReturnType
		{
			get
			{
				return _returnType;
			}

			set
			{
				if (_returnType != value)
				{
					OnReplace(_returnType, value);
					_returnType = value;
					if (null != _returnType)
					{
						_returnType.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public AttributeCollection ReturnTypeAttributes
		{
			get
			{
				return _returnTypeAttributes;
			}

			set
			{
				if (_returnTypeAttributes != value)
				{
					OnReplace(_returnTypeAttributes, value);
					_returnTypeAttributes = value;
					if (null != _returnTypeAttributes)
					{
						_returnTypeAttributes.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

			_parameters = new ParameterDeclarationCollection(this);

			_returnTypeAttributes = new AttributeCollection(this);

		}
	}
}

